/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOProject
extends ExpressionOperator {
    private static final long serialVersionUID = 2L;
    private LogicalOperator mExp;
    private List<Integer> mProjection;
    private boolean mIsStar = false;
    private static Log log = LogFactory.getLog(LOProject.class);
    private boolean mSentinel;
    private boolean mOverloaded = false;
    private boolean sendEmptyBagOnEOP = false;

    public LOProject(LogicalPlan plan, OperatorKey key, LogicalOperator exp, List<Integer> projection) {
        super(plan, key);
        this.mExp = exp;
        this.mProjection = projection;
        this.mSentinel = !(this.mExp instanceof ExpressionOperator);
    }

    public LOProject(LogicalPlan plan, OperatorKey key, LogicalOperator exp, Integer projection) {
        super(plan, key);
        this.mExp = exp;
        this.mProjection = new ArrayList<Integer>(1);
        this.mProjection.add(projection);
        this.mSentinel = !(this.mExp instanceof ExpressionOperator);
    }

    public LogicalOperator getExpression() {
        return this.mExp;
    }

    public void setExpression(LogicalOperator exp) {
        this.mExp = exp;
    }

    public boolean isStar() {
        return this.mIsStar;
    }

    public List<Integer> getProjection() {
        return this.mProjection;
    }

    public void setProjection(List<Integer> proj) {
        this.mProjection = proj;
    }

    public int getCol() {
        if (this.mProjection.size() != 1) {
            throw new RuntimeException("Internal error: improper use of getCol in " + LOProject.class.getName());
        }
        return this.mProjection.get(0);
    }

    public void setStar(boolean b) {
        this.mIsStar = b;
    }

    public boolean getSentinel() {
        return this.mSentinel;
    }

    public void setSentinel(boolean b) {
        this.mSentinel = b;
    }

    public boolean getOverloaded() {
        return this.mOverloaded;
    }

    public void setOverloaded(boolean b) {
        this.mOverloaded = b;
    }

    @Override
    public String name() {
        return "Project " + this.mKey.scope + "-" + this.mKey.id + " Projections: " + (this.mIsStar ? " [*] " : this.mProjection) + " Overloaded: " + this.mOverloaded;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        LogicalOperator projectInput;
        log.debug((Object)"Inside getFieldSchemas");
        log.debug((Object)("Number of columns: " + this.mProjection.size()));
        for (int i : this.mProjection) {
            log.debug((Object)("Column: " + i));
        }
        if (this.mExp == null) {
            String msg = "The input for a projection operator cannot be null";
            int errCode = 2998;
            throw new FrontendException(msg, errCode, 4, false, null);
        }
        LogicalOperator expressionOperator = this.mExp;
        log.debug((Object)("expressionOperator = " + expressionOperator));
        log.debug((Object)("mIsStar: " + this.mIsStar));
        if (!this.mIsFieldSchemaComputed) {
            if (this.mIsStar) {
                log.debug((Object)"mIsStar is true");
                try {
                    if (!this.mSentinel) {
                        Schema.FieldSchema fs = ((ExpressionOperator)expressionOperator).getFieldSchema();
                        this.mFieldSchema = Schema.FieldSchema.copyAndLink(fs, expressionOperator);
                    } else {
                        log.debug((Object)("expression operator alias: " + expressionOperator.getAlias()));
                        log.debug((Object)("expression operator schema: " + expressionOperator.getSchema()));
                        log.debug((Object)("expression operator type: " + expressionOperator.getType()));
                        this.mFieldSchema = new Schema.FieldSchema(expressionOperator.getAlias(), expressionOperator.getSchema(), 110);
                        this.mFieldSchema.setParent(null, expressionOperator);
                    }
                    this.mIsFieldSchemaComputed = true;
                }
                catch (FrontendException fee) {
                    this.mFieldSchema = null;
                    this.mIsFieldSchemaComputed = false;
                    throw fee;
                }
            } else {
                ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>(this.mProjection.size());
                log.debug((Object)"expressionOperator is not null");
                if (this.mProjection.size() == 1) {
                    log.debug((Object)"Only one element");
                    if (!this.mSentinel) {
                        log.debug((Object)"Input is an expression operator");
                        Schema.FieldSchema expOpFs = ((ExpressionOperator)expressionOperator).getFieldSchema();
                        if (null != expOpFs) {
                            Schema s = expOpFs.schema;
                            if (null != s) {
                                Schema.FieldSchema fs;
                                if (s.isTwoLevelAccessRequired()) {
                                    if (s.getFields().size() != 1) {
                                        int errCode = 1008;
                                        String msg = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got a bag schema with multiple elements.";
                                        throw new FrontendException(msg, errCode, 2, false, null);
                                    }
                                    Schema.FieldSchema tupleFS = s.getField(0);
                                    if (tupleFS.type != 110) {
                                        int errCode = 1009;
                                        String msg = "Expected a bag schema with a single element of type " + DataType.findTypeName((byte)110) + " but got an element of type " + DataType.findTypeName(tupleFS.type);
                                        throw new FrontendException(msg, errCode, 2, false, null);
                                    }
                                    fs = tupleFS.schema.getField(this.mProjection.get(0));
                                } else {
                                    fs = s.getField(this.mProjection.get(0));
                                }
                                this.mFieldSchema = Schema.FieldSchema.copyAndLink(fs, expressionOperator);
                            } else {
                                this.mFieldSchema = new Schema.FieldSchema(null, 50);
                                this.mFieldSchema.setParent(expOpFs.canonicalName, expressionOperator);
                            }
                        } else {
                            this.mFieldSchema = new Schema.FieldSchema(null, 50);
                            this.mFieldSchema.setParent(null, expressionOperator);
                        }
                    } else {
                        log.debug((Object)"Input is a logical operator");
                        Schema s = expressionOperator.getSchema();
                        log.debug((Object)("s: " + s));
                        if (null != s) {
                            Schema.FieldSchema fs = s.getField(this.mProjection.get(0));
                            this.mFieldSchema = Schema.FieldSchema.copyAndLink(fs, expressionOperator);
                            log.debug((Object)("mFieldSchema alias: " + this.mFieldSchema.alias));
                            log.debug((Object)("mFieldSchema schema: " + this.mFieldSchema.schema));
                        } else {
                            this.mFieldSchema = new Schema.FieldSchema(null, 50);
                            this.mFieldSchema.setParent(null, expressionOperator);
                        }
                        this.mType = this.mFieldSchema.type;
                    }
                    this.mIsFieldSchemaComputed = true;
                    return this.mFieldSchema;
                }
                for (int colNum : this.mProjection) {
                    Schema.FieldSchema fs;
                    log.debug((Object)("Col: " + colNum));
                    if (!this.mSentinel) {
                        Schema.FieldSchema expOpFs = ((ExpressionOperator)expressionOperator).getFieldSchema();
                        if (null != expOpFs) {
                            Schema s = expOpFs.schema;
                            log.debug((Object)("Schema s: " + s));
                            if (null != s) {
                                if (colNum < s.size()) {
                                    Schema.FieldSchema parentFs = s.getField(colNum);
                                    fs = Schema.FieldSchema.copyAndLink(parentFs, expressionOperator);
                                    fss.add(fs);
                                    continue;
                                }
                                fs = new Schema.FieldSchema(null, 50);
                                fss.add(fs);
                                fs.setParent(expOpFs.canonicalName, expressionOperator);
                                continue;
                            }
                            fs = new Schema.FieldSchema(null, 50);
                            fss.add(fs);
                            fs.setParent(expOpFs.canonicalName, expressionOperator);
                            continue;
                        }
                        fs = new Schema.FieldSchema(null, 50);
                        fss.add(new Schema.FieldSchema(null, 50));
                        fs.setParent(null, expressionOperator);
                        continue;
                    }
                    Schema s = expressionOperator.getSchema();
                    if (null != s) {
                        Schema.FieldSchema parentFs = s.getField(colNum);
                        fs = Schema.FieldSchema.copyAndLink(parentFs, expressionOperator);
                        fss.add(fs);
                        continue;
                    }
                    fs = new Schema.FieldSchema(null, 50);
                    fss.add(fs);
                    fs.setParent(null, expressionOperator);
                }
                this.mFieldSchema = new Schema.FieldSchema(expressionOperator.getAlias(), new Schema(fss));
                Schema.FieldSchema expOpFs = ((ExpressionOperator)expressionOperator).getFieldSchema();
                this.mFieldSchema.setParent(expOpFs.canonicalName, expressionOperator);
                this.mIsFieldSchemaComputed = true;
            }
        }
        if (null != this.mFieldSchema) {
            this.mType = this.mFieldSchema.type;
        }
        List<LOProject> succList = this.mPlan.getSuccessors(this);
        List<LOProject> predList = this.mPlan.getPredecessors(this);
        if (null != succList && !(succList.get(0) instanceof ExpressionOperator)) {
            if (!DataType.isSchemaType(this.mType)) {
                Schema pjSchema = new Schema(this.mFieldSchema);
                this.mFieldSchema = new Schema.FieldSchema(this.getAlias(), pjSchema, 110);
                this.mFieldSchema.setParent(null, expressionOperator);
            } else if (null != this.mFieldSchema) {
                this.mFieldSchema.type = (byte)110;
            }
            this.setOverloaded(true);
            this.setType((byte)110);
        } else if (null != predList && ((projectInput = this.getExpression()) instanceof LOProject || !(predList.get(0) instanceof ExpressionOperator)) && projectInput.getType() == 120) {
            if (!DataType.isSchemaType(this.mType)) {
                Schema pjSchema = new Schema(this.mFieldSchema);
                this.mFieldSchema = new Schema.FieldSchema(this.getAlias(), pjSchema, 120);
                this.mFieldSchema.setParent(((LOProject)expressionOperator).mFieldSchema.canonicalName, expressionOperator);
            } else if (null != this.mFieldSchema) {
                this.mFieldSchema.type = (byte)120;
            }
            this.setType((byte)120);
        }
        log.debug((Object)"Exiting getFieldSchema");
        return this.mFieldSchema;
    }

    public boolean isSingleProjection() {
        return this.mProjection.size() == 1;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public Schema getSchema() throws FrontendException {
        this.getFieldSchema();
        if (this.mFieldSchema != null) {
            return this.mFieldSchema.schema;
        }
        return null;
    }

    public String toDetailString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOProject");
        sb.append(" Id=" + this.mKey.id);
        sb.append(" Projection=");
        boolean isFirst = true;
        for (int i = 0; i < this.mProjection.size(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(this.mProjection.get(i));
        }
        sb.append(" isStart=");
        sb.append(this.mIsStar);
        sb.append(" isSentinel=");
        sb.append(this.mSentinel);
        return sb.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOProject clone = (LOProject)super.clone();
        clone.mProjection = new ArrayList<Integer>();
        Iterator<Integer> it = this.mProjection.iterator();
        while (it.hasNext()) {
            clone.mProjection.add((int)it.next());
        }
        return clone;
    }

    public void setSendEmptyBagOnEOP(boolean sendEmptyBagOnEOP) {
        this.sendEmptyBagOnEOP = sendEmptyBagOnEOP;
    }

    public boolean isSendEmptyBagOnEOP() {
        return this.sendEmptyBagOnEOP;
    }
}

