/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.namedcluster.model;

import java.util.Comparator;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="NamedCluster", description="A NamedCluster")
public class NamedCluster
implements Cloneable,
VariableSpace {
    private VariableSpace variables = new Variables();
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String hdfsHost;
    @MetaStoreAttribute
    private String hdfsPort;
    @MetaStoreAttribute
    private String hdfsUsername;
    @MetaStoreAttribute(password=true)
    private String hdfsPassword;
    @MetaStoreAttribute
    private String jobTrackerHost;
    @MetaStoreAttribute
    private String jobTrackerPort;
    @MetaStoreAttribute
    private String zooKeeperHost;
    @MetaStoreAttribute
    private String zooKeeperPort;
    @MetaStoreAttribute
    private String oozieUrl;
    @MetaStoreAttribute
    private long lastModifiedDate = System.currentTimeMillis();
    public static final Comparator<NamedCluster> comparator = new Comparator<NamedCluster>(){

        @Override
        public int compare(NamedCluster c1, NamedCluster c2) {
            return c1.getName().compareToIgnoreCase(c2.getName());
        }
    };

    public NamedCluster() {
        this.initializeVariablesFrom(null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    @Override
    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    @Override
    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    @Override
    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    @Override
    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    @Override
    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty(variableName) && !Const.isEmpty(value = this.environmentSubstitute(variableName))) {
            return ValueMeta.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    @Override
    public String[] listVariables() {
        return this.variables.listVariables();
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    @Override
    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    @Override
    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void replaceMeta(NamedCluster nc) {
        this.setName(nc.getName());
        this.setHdfsHost(nc.getHdfsHost());
        this.setHdfsPort(nc.getHdfsPort());
        this.setHdfsUsername(nc.getHdfsUsername());
        this.setHdfsPassword(nc.getHdfsPassword());
        this.setJobTrackerHost(nc.getJobTrackerHost());
        this.setJobTrackerPort(nc.getJobTrackerPort());
        this.setZooKeeperHost(nc.getZooKeeperHost());
        this.setZooKeeperPort(nc.getZooKeeperPort());
        this.setOozieUrl(nc.getOozieUrl());
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public NamedCluster clone() {
        NamedCluster nc = new NamedCluster();
        nc.replaceMeta(this);
        return nc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCluster other = (NamedCluster)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getHdfsHost() {
        return this.hdfsHost;
    }

    public void setHdfsHost(String hdfsHost) {
        this.hdfsHost = hdfsHost;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getHdfsUsername() {
        return this.hdfsUsername;
    }

    public void setHdfsUsername(String hdfsUsername) {
        this.hdfsUsername = hdfsUsername;
    }

    public String getHdfsPassword() {
        return this.hdfsPassword;
    }

    public void setHdfsPassword(String hdfsPassword) {
        this.hdfsPassword = hdfsPassword;
    }

    public String getJobTrackerHost() {
        return this.jobTrackerHost;
    }

    public void setJobTrackerHost(String jobTrackerHost) {
        this.jobTrackerHost = jobTrackerHost;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getZooKeeperHost() {
        return this.zooKeeperHost;
    }

    public void setZooKeeperHost(String zooKeeperHost) {
        this.zooKeeperHost = zooKeeperHost;
    }

    public String getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public void setZooKeeperPort(String zooKeeperPort) {
        this.zooKeeperPort = zooKeeperPort;
    }

    public String getOozieUrl() {
        return this.oozieUrl;
    }

    public void setOozieUrl(String oozieUrl) {
        this.oozieUrl = oozieUrl;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

