/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import nl.cwi.monetdb.jdbc.MonetConnection;

public final class MonetDriver
implements Driver {
    private static final String MONETURL = "jdbc:monetdb://";
    private static final int DRIVERMAJOR = 2;
    private static final int DRIVERMINOR = 1;
    private static final String DRIVERVERSIONSUFFIX = "Liberica 20120224 based on MCL v1.7";
    private static final boolean MONETJDBCCOMPLIANT = false;
    private static final String PORT = "50000";
    static Map typeMap;

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith(MONETURL);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        URI uri;
        Properties props = new Properties();
        props.put("port", PORT);
        props.put("debug", "false");
        props.put("language", "sql");
        props.put("so_timeout", "0");
        props.putAll((Map<?, ?>)info);
        info = props;
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            uri = new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new SQLException(e.toString(), "08M26");
        }
        if (uri.getHost() == null) {
            throw new SQLException("Invalid URL: no hostname given or unparsable in '" + url + "'", "08M26");
        }
        info.put("host", uri.getHost());
        if (uri.getPort() > 0) {
            info.put("port", "" + uri.getPort());
        }
        if (uri.getPath() != null && uri.getPath().length() != 0 && !uri.getPath().substring(1).trim().equals("")) {
            info.put("database", uri.getPath().substring(1));
        }
        if (uri.getQuery() != null) {
            String[] args = uri.getQuery().split("&");
            for (int i = 0; i < args.length; ++i) {
                int tmp = args[i].indexOf("=");
                if (tmp <= 0) continue;
                info.put(args[i].substring(0, tmp), args[i].substring(tmp + 1));
            }
        }
        return new MonetConnection(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo prop = new DriverPropertyInfo("user", info.getProperty("user"));
        prop.required = true;
        prop.description = "The username to use when authenticating on the database";
        props.add(prop);
        prop = new DriverPropertyInfo("password", info.getProperty("password"));
        prop.required = true;
        prop.description = "The password to use when authenticating on the database";
        props.add(prop);
        prop = new DriverPropertyInfo("debug", "false");
        prop.required = false;
        prop.description = "Whether or not to create a log file for debugging purposes";
        props.add(prop);
        prop = new DriverPropertyInfo("logfile", "");
        prop.required = false;
        prop.description = "The filename to write the debug log to.  Only takes effect if debug is set to true.  If the file exists, an incrementing number is added, till the filename is unique.";
        props.add(prop);
        prop = new DriverPropertyInfo("language", "sql");
        prop.required = false;
        prop.description = "What language to use for MonetDB conversations (experts only)";
        props.add(prop);
        prop = new DriverPropertyInfo("hash", "");
        prop.required = false;
        prop.description = "Force the use of the given hash algorithm during challenge response (one of SHA1, MD5, plain)";
        props.add(prop);
        prop = new DriverPropertyInfo("follow_redirects", "true");
        prop.required = false;
        prop.description = "Whether redirects issued by the server should be followed";
        props.add(prop);
        prop = new DriverPropertyInfo("treat_blob_as_binary", "false");
        prop.required = false;
        prop.description = "Whether BLOBs on the server should be treated as BINARY types, thus mapped to byte[]";
        props.add(prop);
        prop = new DriverPropertyInfo("so_timeout", "0");
        prop.required = false;
        prop.description = "Defines the maximum time to wait in milliseconds on a blocking read socket call (this corresponds to the Connection.setNetworkTimeout() method introduced in JDBC 4.1)";
        props.add(prop);
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[props.size()];
        return props.toArray(dpi);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static int getJavaType(String type) {
        Integer tp = (Integer)typeMap.get(type.toLowerCase());
        if (tp != null) {
            return tp;
        }
        return 1111;
    }

    static String getSQLTypeMap(String column) {
        String ret = "CASE " + column + " ";
        for (String key : typeMap.keySet()) {
            ret = ret + "WHEN '" + key + "' THEN " + typeMap.get(key).toString() + " ";
        }
        ret = ret + "ELSE 1111 END";
        return ret;
    }

    public static String getDriverVersion() {
        return "2.1 (Liberica 20120224 based on MCL v1.7)";
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging not in use", "0A000");
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        typeMap = new HashMap();
        typeMap.put("bigint", new Integer(-5));
        typeMap.put("blob", new Integer(2004));
        typeMap.put("boolean", new Integer(16));
        typeMap.put("char", new Integer(1));
        typeMap.put("clob", new Integer(2005));
        typeMap.put("date", new Integer(91));
        typeMap.put("decimal", new Integer(3));
        typeMap.put("double", new Integer(8));
        typeMap.put("int", new Integer(4));
        typeMap.put("month_interval", new Integer(4));
        typeMap.put("oid", new Integer(1111));
        typeMap.put("real", new Integer(7));
        typeMap.put("sec_interval", new Integer(3));
        typeMap.put("smallint", new Integer(5));
        typeMap.put("table", new Integer(2003));
        typeMap.put("time", new Integer(92));
        typeMap.put("timestamp", new Integer(93));
        typeMap.put("timestamptz", new Integer(93));
        typeMap.put("timetz", new Integer(92));
        typeMap.put("tinyint", new Integer(-6));
        typeMap.put("varchar", new Integer(12));
        typeMap.put("wrd", new Integer(-5));
    }
}

