/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironmentMapping;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.PlainParameter;
import org.pentaho.reporting.engine.classic.core.states.datarow.ProcessingDataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReferences;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaRule;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeReferences;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DirectFieldSelectorRule;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.GlobalRule;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelectorRule;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataSchemaCompiler {
    private static final Log logger = LogFactory.getLog(ProcessingDataSchemaCompiler.class);
    private GenericDataAttributes environmentDataAttributes;
    private GenericDataAttributes tableDataAttributes;
    private ParameterDataAttributes parameterDataAttributes;
    private DefaultDataAttributes globalAttributes;
    private DefaultDataAttributeReferences globalReferences;
    private MetaSelectorRule[] indirectRules;
    private DirectFieldSelectorRule[] directRules;
    private DataAttributeContext context;
    private DataSchemaDefinition reportSchemaDefinition;
    private ResourceManager resourceManager;
    private boolean initialized;

    public DataSchemaCompiler(DataSchemaDefinition reportSchemaDefinition, DataAttributeContext context) {
        this(reportSchemaDefinition, context, DataSchemaCompiler.createDefaultResourceManager());
    }

    private static ResourceManager createDefaultResourceManager() {
        return new ResourceManager();
    }

    public DataSchemaCompiler(DataSchemaDefinition reportSchemaDefinition, DataAttributeContext context, ResourceManager resourceManager) {
        if (reportSchemaDefinition == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.reportSchemaDefinition = reportSchemaDefinition;
        this.resourceManager = resourceManager;
    }

    protected void init() {
        DefaultDataSchemaDefinition schemaDefinition = new DefaultDataSchemaDefinition();
        schemaDefinition.merge(this.parseGlobalDefaults(this.resourceManager));
        schemaDefinition.merge(this.reportSchemaDefinition);
        this.tableDataAttributes = new GenericDataAttributes();
        this.environmentDataAttributes = new GenericDataAttributes();
        this.parameterDataAttributes = new ParameterDataAttributes();
        this.globalAttributes = new DefaultDataAttributes();
        this.globalReferences = new DefaultDataAttributeReferences();
        GlobalRule[] globalRules = schemaDefinition.getGlobalRules();
        for (int i = 0; i < globalRules.length; ++i) {
            GlobalRule rule = globalRules[i];
            DataAttributes attributes = rule.getStaticAttributes();
            this.globalAttributes.merge(attributes, this.context);
            DataAttributeReferences mappedAttributes = rule.getMappedAttributes();
            this.globalReferences.merge(mappedAttributes);
        }
        this.indirectRules = schemaDefinition.getIndirectRules();
        this.directRules = schemaDefinition.getDirectRules();
        this.initialized = true;
    }

    protected DataSchemaDefinition parseGlobalDefaults(ResourceManager resourceManager) {
        return DataSchemaUtility.parseDefaults(resourceManager);
    }

    public DataSchema compile(TableModel data) throws ReportDataFactoryException {
        return this.compile(data, null, null, null, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public DataSchema compile(TableModel data, Expression[] expressions, ParameterDataRow parameters, ParameterDefinitionEntry[] parameterDefinitions, ReportEnvironment reportEnvironment) throws ReportDataFactoryException {
        DefaultDataAttributes computedParameterDataAttributes;
        if (!this.initialized) {
            this.init();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        DefaultDataSchema defaultDataSchema = new DefaultDataSchema();
        if (reportEnvironment != null) {
            this.processReportEnvironment(this.globalAttributes, this.indirectRules, this.directRules, defaultDataSchema);
        }
        if (parameters != null) {
            this.processParameters(parameters, parameterDefinitions, reportEnvironment, this.globalAttributes, this.indirectRules, this.directRules, defaultDataSchema);
        }
        if (expressions != null) {
            for (int i = 0; i < expressions.length; ++i) {
                Expression expression = expressions[i];
                String name = expression.getName();
                if (name == null) continue;
                computedParameterDataAttributes = new DefaultDataAttributes();
                computedParameterDataAttributes.merge(this.globalAttributes, this.context);
                computedParameterDataAttributes.merge(new ExpressionsDataAttributes(expression), this.context);
                this.applyRules(this.indirectRules, this.directRules, computedParameterDataAttributes);
                defaultDataSchema.setAttributes(name, computedParameterDataAttributes);
            }
        }
        if (!(data instanceof MetaTableModel)) {
            int count = data.getColumnCount();
            for (int i = 0; i < count; ++i) {
                String colName = data.getColumnName(i);
                if (colName == null) continue;
                this.tableDataAttributes.setup(colName, data.getColumnClass(i), "table", colName, this.globalAttributes);
                computedParameterDataAttributes = new DefaultDataAttributes();
                computedParameterDataAttributes.merge(this.tableDataAttributes, this.context);
                this.applyRules(this.indirectRules, this.directRules, computedParameterDataAttributes);
                defaultDataSchema.setAttributes(colName, computedParameterDataAttributes);
            }
        } else {
            MetaTableModel mt = (MetaTableModel)data;
            DefaultDataAttributes tableGlobalAttributes = new DefaultDataAttributes();
            tableGlobalAttributes.merge(this.globalAttributes, this.context);
            tableGlobalAttributes.merge(mt.getTableAttributes(), this.context);
            try {
                defaultDataSchema.setTableAttributes(tableGlobalAttributes);
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)"Unable to copy global data-attributes", (Throwable)e);
            }
            int count = data.getColumnCount();
            for (int i = 0; i < count; ++i) {
                String colName = data.getColumnName(i);
                if (colName == null) continue;
                DefaultDataAttributes computedParameterDataAttributes2 = new DefaultDataAttributes();
                computedParameterDataAttributes2.merge(tableGlobalAttributes, this.context);
                computedParameterDataAttributes2.merge(mt.getColumnAttributes(i), this.context);
                this.tableDataAttributes.setup(colName, data.getColumnClass(i), "table", null, EmptyDataAttributes.INSTANCE);
                computedParameterDataAttributes2.merge(this.tableDataAttributes, this.context);
                this.applyRules(this.indirectRules, this.directRules, computedParameterDataAttributes2);
                defaultDataSchema.setAttributes(colName, computedParameterDataAttributes2);
            }
        }
        return defaultDataSchema;
    }

    protected void applyRules(DataSchemaRule[] indirectRules, DataSchemaRule[] directRules, DefaultDataAttributes computedParameterDataAttributes) {
        DataAttributeReferences mappedAttributes;
        DataSchemaRule rule;
        int j;
        for (j = 0; j < indirectRules.length; ++j) {
            rule = indirectRules[j];
            if (!rule.isMatch(computedParameterDataAttributes, this.context)) continue;
            computedParameterDataAttributes.merge(rule.getStaticAttributes(), this.context);
        }
        for (j = 0; j < directRules.length; ++j) {
            rule = directRules[j];
            if (!rule.isMatch(computedParameterDataAttributes, this.context)) continue;
            computedParameterDataAttributes.merge(rule.getStaticAttributes(), this.context);
        }
        computedParameterDataAttributes.mergeReferences(this.globalReferences, this.context);
        for (j = 0; j < indirectRules.length; ++j) {
            rule = indirectRules[j];
            if (!rule.isMatch(computedParameterDataAttributes, this.context)) continue;
            mappedAttributes = rule.getMappedAttributes();
            computedParameterDataAttributes.mergeReferences(mappedAttributes, this.context);
        }
        for (j = 0; j < directRules.length; ++j) {
            rule = directRules[j];
            if (!rule.isMatch(computedParameterDataAttributes, this.context)) continue;
            mappedAttributes = rule.getMappedAttributes();
            computedParameterDataAttributes.mergeReferences(mappedAttributes, this.context);
        }
    }

    protected void processReportEnvironment(DefaultDataAttributes globalAttributes, DataSchemaRule[] indirectRules, DataSchemaRule[] directRules, DefaultDataSchema schema) {
        Map<String, String> names = DefaultReportEnvironmentMapping.INSTANCE.createEnvironmentMapping();
        String[] parameterNames = names.keySet().toArray(new String[names.size()]);
        for (int i = 0; i < parameterNames.length; ++i) {
            String envName = parameterNames[i];
            String name = names.get(envName);
            if (envName.endsWith("-array")) {
                this.environmentDataAttributes.setup(name, String[].class, "environment", name, globalAttributes);
            } else {
                this.environmentDataAttributes.setup(name, String.class, "environment", name, globalAttributes);
            }
            DefaultDataAttributes computedParameterDataAttributes = new DefaultDataAttributes();
            computedParameterDataAttributes.merge(this.environmentDataAttributes, this.context);
            this.applyRules(indirectRules, directRules, computedParameterDataAttributes);
            schema.setAttributes(name, computedParameterDataAttributes);
        }
    }

    protected void processParameters(ParameterDataRow parameters, ParameterDefinitionEntry[] parameterDefinitionEntries, ReportEnvironment reportEnvironment, DefaultDataAttributes globalAttributes, DataSchemaRule[] indirectRules, DataSchemaRule[] directRules, DefaultDataSchema schema) throws ReportDataFactoryException {
        Map<String, ParameterDefinitionEntry> map = this.normalizeParameterDefinitions(parameters, parameterDefinitionEntries);
        for (Map.Entry<String, ParameterDefinitionEntry> entry : map.entrySet()) {
            ParameterDefinitionEntry parameter = entry.getValue();
            this.parameterDataAttributes.setup(parameter, globalAttributes, reportEnvironment, this.resourceManager);
            DefaultDataAttributes computedParameterDataAttributes = new DefaultDataAttributes();
            computedParameterDataAttributes.merge(this.parameterDataAttributes, this.context);
            this.applyRules(indirectRules, directRules, computedParameterDataAttributes);
            schema.setAttributes(parameter.getName(), computedParameterDataAttributes);
        }
    }

    private Map<String, ParameterDefinitionEntry> normalizeParameterDefinitions(ParameterDataRow parameters, ParameterDefinitionEntry[] parameterDefinitionEntries) {
        int i;
        String[] parameterNames = parameters.getColumnNames();
        HashMap<String, ParameterDefinitionEntry> map = new HashMap<String, ParameterDefinitionEntry>();
        if (parameterDefinitionEntries != null) {
            for (i = 0; i < parameterDefinitionEntries.length; ++i) {
                ParameterDefinitionEntry entry = parameterDefinitionEntries[i];
                map.put(entry.getName(), entry);
            }
        }
        for (i = 0; i < parameterNames.length; ++i) {
            String name = parameterNames[i];
            if (map.containsKey(name)) continue;
            Object value = parameters.get(name);
            if (value != null) {
                map.put(name, new PlainParameter(name, value.getClass()));
                continue;
            }
            map.put(name, new PlainParameter(name, Object.class));
        }
        return map;
    }

    protected GenericDataAttributes getTableDataAttributes() {
        return this.tableDataAttributes;
    }

    protected ParameterDataAttributes getParameterDataAttributes() {
        return this.parameterDataAttributes;
    }

    protected DefaultDataAttributes getGlobalAttributes() {
        return this.globalAttributes;
    }

    protected DefaultDataAttributeReferences getGlobalReferences() {
        return this.globalReferences;
    }

    protected MetaSelectorRule[] getIndirectRules() {
        return this.indirectRules;
    }

    protected DirectFieldSelectorRule[] getDirectRules() {
        return this.directRules;
    }

    protected DataAttributeContext getContext() {
        return this.context;
    }

    protected static class ExpressionsDataAttributes
    implements DataAttributes {
        private static final String[] CORENAMES = new String[]{"name", "source", "value-type"};
        private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/expressions"};
        private static final String[] EXPRESSIONNAMES = new String[]{"class"};
        private ExpressionMetaData expressionMetaData;
        private Class expressionType;
        private Class resultType;
        private String expressionName;
        private BeanUtility beanUtility;
        private String[] expressionProperties;
        private static final String[] EMPTY_STRINGS = new String[0];

        public ExpressionsDataAttributes(Expression expression) {
            if (expression == null) {
                throw new NullPointerException();
            }
            if (expression.getName() == null) {
                throw new IllegalStateException();
            }
            this.expressionType = expression.getClass();
            if (ExpressionRegistry.getInstance().isExpressionRegistered(this.expressionType.getName())) {
                this.expressionMetaData = ExpressionRegistry.getInstance().getExpressionMetaData(this.expressionType.getName());
                this.resultType = this.expressionMetaData.getResultType();
                this.expressionProperties = StringUtils.merge((String[])this.expressionMetaData.getPropertyNames(), (String[])EXPRESSIONNAMES);
            } else {
                this.expressionMetaData = null;
                this.resultType = Object.class;
                this.expressionProperties = EXPRESSIONNAMES;
            }
            this.expressionName = expression.getName();
            try {
                this.beanUtility = new BeanUtility(expression);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }

        @Override
        public String[] getMetaAttributeDomains() {
            return (String[])NAMESPACES.clone();
        }

        @Override
        public String[] getMetaAttributeNames(String domainName) {
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName)) {
                return (String[])CORENAMES.clone();
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/expressions".equals(domainName)) {
                return (String[])this.expressionProperties.clone();
            }
            return EMPTY_STRINGS;
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
            return this.getMetaAttribute(domain, name, type, context, null);
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
            if (domain == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            if (context == null) {
                throw new NullPointerException();
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain)) {
                if ("name".equals(name)) {
                    return this.expressionName;
                }
                if ("source".equals(name)) {
                    return "expression";
                }
                if ("value-type".equals(name)) {
                    return this.resultType;
                }
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/expressions".equals(domain)) {
                ExpressionPropertyMetaData propertyMetaData;
                if ("class".equals(name)) {
                    return this.expressionType;
                }
                if (this.beanUtility != null && this.expressionMetaData != null && (propertyMetaData = this.expressionMetaData.getPropertyDescription(name)) != null) {
                    try {
                        return this.beanUtility.getProperty(name);
                    }
                    catch (BeanException e) {
                        // empty catch block
                    }
                }
            }
            return defaultValue;
        }

        @Override
        public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
            return DefaultConceptQueryMapper.INSTANCE;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("This is an internal class and should not have been leaked to the outside world");
        }
    }

    protected static class ParameterDataAttributes
    implements DataAttributes {
        private static final String[] NAMES = new String[]{"name", "source", "value-type"};
        private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/core"};
        private DataAttributes globalAttributes = new DefaultDataAttributes();
        private ParameterDefinitionEntry entry;
        private ParameterContext parameterContext;

        protected ParameterDataAttributes() {
        }

        public void setup(ParameterDefinitionEntry parameter, DataAttributes globalAttributes, ReportEnvironment reportEnvironment, ResourceManager resourceManager) throws ReportDataFactoryException {
            if (globalAttributes == null) {
                throw new NullPointerException();
            }
            if (parameter == null) {
                throw new NullPointerException();
            }
            this.globalAttributes = globalAttributes;
            this.entry = parameter;
            this.parameterContext = new DefaultParameterContext(new CompoundDataFactory(), new StaticDataRow(), ClassicEngineBoot.getInstance().getGlobalConfig(), new DefaultResourceBundleFactory(), resourceManager, null, reportEnvironment);
        }

        @Override
        public String[] getMetaAttributeDomains() {
            return StringUtils.merge((String[])this.globalAttributes.getMetaAttributeDomains(), (String[])StringUtils.merge((String[])NAMESPACES, (String[])this.entry.getParameterAttributeNamespaces()));
        }

        @Override
        public String[] getMetaAttributeNames(String domainName) {
            String[] metaNamess = this.globalAttributes.getMetaAttributeNames(domainName);
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName)) {
                return StringUtils.merge((String[])NAMES, (String[])metaNamess);
            }
            return StringUtils.merge((String[])metaNamess, (String[])this.entry.getParameterAttributeNames(domainName));
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
            return this.getMetaAttribute(domain, name, type, context, null);
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
            String override;
            if (domain == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            if (context == null) {
                throw new NullPointerException();
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain)) {
                if ("name".equals(name)) {
                    return this.entry.getName();
                }
                if ("source".equals(name)) {
                    return "parameter";
                }
                if ("value-type".equals(name)) {
                    return this.entry.getValueType();
                }
            }
            if ((override = this.entry.getParameterAttribute(domain, name, this.parameterContext)) != null) {
                return override;
            }
            return this.globalAttributes.getMetaAttribute(domain, name, type, context, defaultValue);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("This is an internal class and should not have been leaked to the outside world");
        }

        @Override
        public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
            return DefaultConceptQueryMapper.INSTANCE;
        }
    }

    protected static class GenericDataAttributes
    implements DataAttributes {
        private static final String[] CORE_NAMES = new String[]{"name", "source", "value-type"};
        private static final String[] FORMATTING_NAMES = new String[]{"label"};
        private static final String[] NAMESPACES = new String[]{"http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting"};
        private String parameterName;
        private Class parameterType;
        private String source;
        private String label;
        private DataAttributes globalAttributes = new DefaultDataAttributes();

        protected GenericDataAttributes() {
        }

        public void setup(String parameterName, Class parameterType, String source, String label, DataAttributes globalAttributes) {
            if (globalAttributes == null) {
                throw new NullPointerException();
            }
            if (parameterName == null) {
                throw new NullPointerException();
            }
            if (parameterType == null) {
                throw new NullPointerException();
            }
            if (source == null) {
                throw new NullPointerException();
            }
            this.parameterName = parameterName;
            this.parameterType = parameterType;
            this.source = source;
            this.label = label;
            this.globalAttributes = globalAttributes;
        }

        @Override
        public String[] getMetaAttributeDomains() {
            return StringUtils.merge((String[])this.globalAttributes.getMetaAttributeDomains(), (String[])NAMESPACES);
        }

        @Override
        public String[] getMetaAttributeNames(String domainName) {
            String[] metaNamess = this.globalAttributes.getMetaAttributeNames(domainName);
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domainName)) {
                return StringUtils.merge((String[])CORE_NAMES, (String[])metaNamess);
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domainName)) {
                return StringUtils.merge((String[])FORMATTING_NAMES, (String[])metaNamess);
            }
            return metaNamess;
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
            return this.getMetaAttribute(domain, name, type, context, null);
        }

        @Override
        public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
            Object result;
            if (domain == null) {
                throw new NullPointerException();
            }
            if (name == null) {
                throw new NullPointerException();
            }
            if (context == null) {
                throw new NullPointerException();
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core".equals(domain)) {
                if ("name".equals(name)) {
                    return this.parameterName;
                }
                if ("source".equals(name)) {
                    return this.source;
                }
                if ("value-type".equals(name)) {
                    return this.parameterType;
                }
            }
            if ((result = this.globalAttributes.getMetaAttribute(domain, name, type, context, defaultValue)) != null) {
                return result;
            }
            if ("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting".equals(domain) && "label".equals(name)) {
                return this.label;
            }
            return null;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("This is an internal class and should not have been leaked to the outside world");
        }

        @Override
        public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
            return DefaultConceptQueryMapper.INSTANCE;
        }
    }
}

