/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.StyleExpressionHandler;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractElementReadHandler
extends AbstractPropertyXmlReadHandler
implements ReportElementReadHandler {
    public static final String FONT_NAME_ATT = "fontname";
    public static final String FONT_STYLE_ATT = "fontstyle";
    public static final String FONT_SIZE_ATT = "fontsize";
    public static final String FS_BOLD = "fsbold";
    public static final String FS_ITALIC = "fsitalic";
    public static final String FS_UNDERLINE = "fsunderline";
    public static final String FS_STRIKETHR = "fsstrikethr";
    public static final String FS_EMBEDDED = "font-embedded";
    public static final String FS_ENCODING = "font-encoding";
    public static final String LINEHEIGHT = "line-height";
    public static final String NAME_ATT = "name";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";
    public static final String COLOR_ATT = "color";
    public static final String FIELDNAME_ATT = "fieldname";
    public static final String FUNCTIONNAME_ATT = "function";
    public static final String NULLSTRING_ATT = "nullstring";
    private static final String DYNAMIC_ATT = "dynamic";
    private static final String VISIBLE_ATT = "visible";
    private static final String HREF_ATT = "href";
    private static final String HREF_WINDOW_ATT = "href-window";
    public static final String STYLE_CLASS_ATT = "styleClass";
    private Element element;
    private String styleClass;
    private ArrayList<StyleExpressionHandler> styleExpressionHandlers = new ArrayList();

    protected AbstractElementReadHandler() {
    }

    protected abstract ElementFactory getElementFactory();

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        String borderBottomRightRadiusHeight;
        String borderBottomRightRadiusWidth;
        String borderBottomLeftRadiusHeight;
        String borderBottomLeftRadiusWidth;
        String borderTopRightRadiusHeight;
        String borderTopRightRadiusWidth;
        String borderTopLeftRadiusHeight;
        String borderTopLeftRadiusWidth;
        String borderRadiusHeight;
        String borderWidthBreak;
        String borderWidthRight;
        String borderWidthBottom;
        String borderWidthLeft;
        String borderWidthTop;
        String paddingRight;
        String paddingBottom;
        String paddingLeft;
        String paddingTop;
        String padding;
        String orphans;
        String widows;
        String overflowY;
        String overflowX;
        String avoidBreaks;
        String hrefTitle;
        String hrefWindow;
        String href;
        String visibleValue;
        String dynamicValue;
        String useMinChunkWidth;
        String height;
        String width;
        String posY;
        ElementFactory factory = this.getElementFactory();
        factory.setName(atts.getValue(this.getUri(), NAME_ATT));
        this.styleClass = atts.getValue(this.getUri(), STYLE_CLASS_ATT);
        Color color = ReportParserUtil.parseColor(atts.getValue(this.getUri(), COLOR_ATT), null);
        factory.setColor(color);
        String posX = atts.getValue(this.getUri(), "x");
        if (posX != null) {
            factory.setX(Float.valueOf(ReportParserUtil.parseRelativeFloat(posX, "Attribute 'x' not valid", this.getLocator())));
        }
        if ((posY = atts.getValue(this.getUri(), "y")) != null) {
            factory.setY(Float.valueOf(ReportParserUtil.parseRelativeFloat(posY, "Attribute 'y' not valid", this.getLocator())));
        }
        if ((width = atts.getValue(this.getUri(), "width")) != null) {
            factory.setMinimumWidth(Float.valueOf(ReportParserUtil.parseRelativeFloat(width, "Attribute 'width' not valid", this.getLocator())));
        }
        if ((height = atts.getValue(this.getUri(), "height")) != null) {
            factory.setMinimumHeight(Float.valueOf(ReportParserUtil.parseRelativeFloat(height, "Attribute 'height' not valid", this.getLocator())));
        }
        if ((useMinChunkWidth = atts.getValue(this.getUri(), "use-min-chunkwidth")) != null) {
            factory.setUseMinChunkWidth(ReportParserUtil.parseBoolean(useMinChunkWidth, this.getLocator()));
        }
        if ((dynamicValue = atts.getValue(this.getUri(), DYNAMIC_ATT)) != null) {
            Boolean dynamic = ParserUtil.parseBoolean((String)dynamicValue, (Locator)this.getLocator());
            factory.setDynamicHeight(dynamic);
        }
        if ((visibleValue = atts.getValue(this.getUri(), VISIBLE_ATT)) != null) {
            boolean value = ParserUtil.parseBoolean((String)visibleValue, (boolean)true);
            factory.setVisible(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((href = atts.getValue(this.getUri(), HREF_ATT)) != null) {
            factory.setHRefTarget(href);
        }
        if ((hrefWindow = atts.getValue(this.getUri(), HREF_WINDOW_ATT)) != null) {
            factory.setHRefWindow(hrefWindow);
        }
        if ((hrefTitle = atts.getValue(this.getUri(), "href-title")) != null) {
            factory.setHRefTitle(hrefTitle);
        }
        if ((avoidBreaks = atts.getValue(this.getUri(), "avoid-pagebreaks")) != null) {
            boolean value = ParserUtil.parseBoolean((String)avoidBreaks, (boolean)true);
            factory.setAvoidPagebreaks(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((overflowX = atts.getValue(this.getUri(), "overflow-x")) != null) {
            boolean value = ParserUtil.parseBoolean((String)overflowX, (boolean)false);
            factory.setOverflowX(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((overflowY = atts.getValue(this.getUri(), "overflow-y")) != null) {
            boolean value = ParserUtil.parseBoolean((String)overflowY, (boolean)false);
            factory.setOverflowY(value ? Boolean.TRUE : Boolean.FALSE);
        }
        if ((widows = atts.getValue(this.getUri(), "widows")) != null) {
            factory.setWidows(ReportParserUtil.parseInteger(widows, this.getLocator()));
        }
        if ((orphans = atts.getValue(this.getUri(), "orpans")) != null) {
            factory.setOrphans(ReportParserUtil.parseInteger(orphans, this.getLocator()));
        }
        if ((padding = atts.getValue(this.getUri(), "padding")) != null) {
            factory.setPadding(ReportParserUtil.parseFloat(padding, this.getLocator()));
        }
        if ((paddingTop = atts.getValue(this.getUri(), "padding-top")) != null) {
            factory.setPaddingTop(ReportParserUtil.parseFloat(paddingTop, this.getLocator()));
        }
        if ((paddingLeft = atts.getValue(this.getUri(), "padding-left")) != null) {
            factory.setPaddingLeft(ReportParserUtil.parseFloat(paddingLeft, this.getLocator()));
        }
        if ((paddingBottom = atts.getValue(this.getUri(), "padding-bottom")) != null) {
            factory.setPaddingBottom(ReportParserUtil.parseFloat(paddingBottom, this.getLocator()));
        }
        if ((paddingRight = atts.getValue(this.getUri(), "padding-right")) != null) {
            factory.setPaddingRight(ReportParserUtil.parseFloat(paddingRight, this.getLocator()));
        }
        String attr = atts.getValue(this.getUri(), "background-color");
        factory.setBackgroundColor(ReportParserUtil.parseColor(attr, null));
        String borderColor = atts.getValue(this.getUri(), "border-color");
        factory.setBorderColor(ReportParserUtil.parseColor(borderColor, null));
        String borderColorTop = atts.getValue(this.getUri(), "border-top-color");
        factory.setBorderTopColor(ReportParserUtil.parseColor(borderColorTop, null));
        String borderColorLeft = atts.getValue(this.getUri(), "border-left-color");
        factory.setBorderLeftColor(ReportParserUtil.parseColor(borderColorLeft, null));
        String borderColorBottom = atts.getValue(this.getUri(), "border-bottom-color");
        factory.setBorderBottomColor(ReportParserUtil.parseColor(borderColorBottom, null));
        String borderColorRight = atts.getValue(this.getUri(), "border-right-color");
        factory.setBorderRightColor(ReportParserUtil.parseColor(borderColorRight, null));
        String borderColorBreak = atts.getValue(this.getUri(), "border-break-color");
        factory.setBorderBreakColor(ReportParserUtil.parseColor(borderColorBreak, null));
        String borderWidth = atts.getValue(this.getUri(), "border-width");
        if (borderWidth != null) {
            factory.setBorderWidth(ReportParserUtil.parseFloat(borderWidth, this.getLocator()));
        }
        if ((borderWidthTop = atts.getValue(this.getUri(), "border-top-width")) != null) {
            factory.setBorderTopWidth(ReportParserUtil.parseFloat(borderWidthTop, this.getLocator()));
        }
        if ((borderWidthLeft = atts.getValue(this.getUri(), "border-left-width")) != null) {
            factory.setBorderLeftWidth(ReportParserUtil.parseFloat(borderWidthLeft, this.getLocator()));
        }
        if ((borderWidthBottom = atts.getValue(this.getUri(), "border-bottom-width")) != null) {
            factory.setBorderBottomWidth(ReportParserUtil.parseFloat(borderWidthBottom, this.getLocator()));
        }
        if ((borderWidthRight = atts.getValue(this.getUri(), "border-right-width")) != null) {
            factory.setBorderRightWidth(ReportParserUtil.parseFloat(borderWidthRight, this.getLocator()));
        }
        if ((borderWidthBreak = atts.getValue(this.getUri(), "border-break-width")) != null) {
            factory.setBorderBreakWidth(ReportParserUtil.parseFloat(borderWidthBreak, this.getLocator()));
        }
        String borderStyle = atts.getValue(this.getUri(), "border-style");
        factory.setBorderStyle(this.parseBorderStyle(borderStyle));
        String borderStyleTop = atts.getValue(this.getUri(), "border-top-style");
        factory.setBorderTopStyle(this.parseBorderStyle(borderStyleTop));
        String borderStyleLeft = atts.getValue(this.getUri(), "border-left-style");
        factory.setBorderLeftStyle(this.parseBorderStyle(borderStyleLeft));
        String borderStyleBottom = atts.getValue(this.getUri(), "border-bottom-style");
        factory.setBorderBottomStyle(this.parseBorderStyle(borderStyleBottom));
        String borderStyleRight = atts.getValue(this.getUri(), "border-right-style");
        factory.setBorderRightStyle(this.parseBorderStyle(borderStyleRight));
        String borderStyleBreak = atts.getValue(this.getUri(), "border-break-style");
        factory.setBorderBreakStyle(this.parseBorderStyle(borderStyleBreak));
        factory.setHorizontalAlignment(ReportParserUtil.parseHorizontalElementAlignment(atts.getValue(this.getUri(), ALIGNMENT_ATT), this.getLocator()));
        factory.setVerticalAlignment(ReportParserUtil.parseVerticalElementAlignment(atts.getValue(this.getUri(), VALIGNMENT_ATT), this.getLocator()));
        String borderRadiusWidth = atts.getValue(this.getUri(), "border-radius-width");
        if (borderRadiusWidth != null) {
            factory.setBorderRadiusWidth(ReportParserUtil.parseFloat(borderRadiusWidth, this.getLocator()));
        }
        if ((borderRadiusHeight = atts.getValue(this.getUri(), "border-radius-height")) != null) {
            factory.setBorderRadiusHeight(ReportParserUtil.parseFloat(borderRadiusHeight, this.getLocator()));
        }
        if ((borderTopLeftRadiusWidth = atts.getValue(this.getUri(), "border-top-left-radius-width")) != null) {
            factory.setBorderTopLeftRadiusWidth(ReportParserUtil.parseFloat(borderTopLeftRadiusWidth, this.getLocator()));
        }
        if ((borderTopLeftRadiusHeight = atts.getValue(this.getUri(), "border-top-left-radius-height")) != null) {
            factory.setBorderTopLeftRadiusHeight(ReportParserUtil.parseFloat(borderTopLeftRadiusHeight, this.getLocator()));
        }
        if ((borderTopRightRadiusWidth = atts.getValue(this.getUri(), "border-top-right-radius-width")) != null) {
            factory.setBorderTopRightRadiusWidth(ReportParserUtil.parseFloat(borderTopRightRadiusWidth, this.getLocator()));
        }
        if ((borderTopRightRadiusHeight = atts.getValue(this.getUri(), "border-top-right-radius-height")) != null) {
            factory.setBorderTopRightRadiusHeight(ReportParserUtil.parseFloat(borderTopRightRadiusHeight, this.getLocator()));
        }
        if ((borderBottomLeftRadiusWidth = atts.getValue(this.getUri(), "border-bottom-left-radius-width")) != null) {
            factory.setBorderBottomLeftRadiusWidth(ReportParserUtil.parseFloat(borderBottomLeftRadiusWidth, this.getLocator()));
        }
        if ((borderBottomLeftRadiusHeight = atts.getValue(this.getUri(), "border-bottom-left-radius-height")) != null) {
            factory.setBorderBottomLeftRadiusHeight(ReportParserUtil.parseFloat(borderBottomLeftRadiusHeight, this.getLocator()));
        }
        if ((borderBottomRightRadiusWidth = atts.getValue(this.getUri(), "border-bottom-right-radius-width")) != null) {
            factory.setBorderBottomRightRadiusWidth(ReportParserUtil.parseFloat(borderBottomRightRadiusWidth, this.getLocator()));
        }
        if ((borderBottomRightRadiusHeight = atts.getValue(this.getUri(), "border-bottom-right-radius-height")) != null) {
            factory.setBorderBottomRightRadiusHeight(ReportParserUtil.parseFloat(borderBottomRightRadiusHeight, this.getLocator()));
        }
    }

    private BorderStyle parseBorderStyle(String value) {
        if (BorderStyle.DASHED.toString().equals(value)) {
            return BorderStyle.DASHED;
        }
        if (BorderStyle.DOT_DASH.toString().equals(value)) {
            return BorderStyle.DOT_DASH;
        }
        if (BorderStyle.DOT_DOT_DASH.toString().equals(value)) {
            return BorderStyle.DOT_DOT_DASH;
        }
        if (BorderStyle.DOTTED.toString().equals(value)) {
            return BorderStyle.DOTTED;
        }
        if (BorderStyle.DOUBLE.toString().equals(value)) {
            return BorderStyle.DOUBLE;
        }
        if (BorderStyle.GROOVE.toString().equals(value)) {
            return BorderStyle.GROOVE;
        }
        if (BorderStyle.HIDDEN.toString().equals(value)) {
            return BorderStyle.HIDDEN;
        }
        if (BorderStyle.INSET.toString().equals(value)) {
            return BorderStyle.INSET;
        }
        if (BorderStyle.OUTSET.toString().equals(value)) {
            return BorderStyle.OUTSET;
        }
        if (BorderStyle.RIDGE.toString().equals(value)) {
            return BorderStyle.RIDGE;
        }
        if (BorderStyle.SOLID.toString().equals(value)) {
            return BorderStyle.SOLID;
        }
        if (BorderStyle.NONE.toString().equals(value)) {
            return BorderStyle.NONE;
        }
        return null;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("style-expression".equals(tagName)) {
            StyleExpressionHandler handler = new StyleExpressionHandler();
            this.styleExpressionHandlers.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.element = this.getElementFactory().createElement();
        this.element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", this.getRootHandler().getSource());
        this.handleInheritedStyle(this.styleClass);
        for (int i = 0; i < this.styleExpressionHandlers.size(); ++i) {
            StyleExpressionHandler handler = this.styleExpressionHandlers.get(i);
            StyleKey key = handler.getKey();
            if (handler.getKey() == null) continue;
            Expression expression = handler.getExpression();
            this.element.setStyleExpression(key, expression);
        }
        super.doneParsing();
    }

    protected void handleInheritedStyle(String styleClass) {
        ElementStyleSheet existingStyleSheet;
        HashMap report;
        if (styleClass != null && (report = (HashMap)this.getRootHandler().getHelperObject("::Legacy-Styles")) != null && (existingStyleSheet = (ElementStyleSheet)report.get(styleClass)) != null) {
            this.element.getStyle().addDefault(existingStyleSheet);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public Object getObject() {
        return this.element;
    }
}

