/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ResultSetTableModelFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DataTableException;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DefaultTableMetaData;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TypeMapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class ScrollableResultSetTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private ResultSet resultset;
    private ResultSetMetaData dbmd;
    private int rowCount;
    private final boolean columnNameMapping;
    private boolean closeStatement;
    private Class[] types;
    private DefaultTableMetaData metaData;

    public ScrollableResultSetTableModel(ResultSet resultset, boolean columnNameMapping, boolean closeStatement) throws SQLException {
        this.columnNameMapping = columnNameMapping;
        this.closeStatement = closeStatement;
        this.rowCount = -1;
        if (resultset != null) {
            this.updateResultSet(resultset);
        } else {
            this.close();
        }
    }

    public boolean isColumnNameMapping() {
        return this.columnNameMapping;
    }

    public void updateResultSet(ResultSet resultset) throws SQLException {
        if (this.resultset != null) {
            this.close();
        }
        this.resultset = resultset;
        this.dbmd = resultset.getMetaData();
        int colcount = this.dbmd.getColumnCount();
        this.metaData = new DefaultTableMetaData(colcount);
        for (int i = 0; i < colcount; ++i) {
            ResultSetTableModelFactory.updateMetaData(this.dbmd, this.metaData, i);
        }
        this.rowCount = resultset.last() ? resultset.getRow() : 0;
        this.fireTableStructureChanged();
    }

    @Override
    public void close() {
        if (this.resultset != null) {
            Statement statement = null;
            try {
                statement = this.resultset.getStatement();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                this.resultset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (this.closeStatement) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.resultset = null;
        this.dbmd = null;
        this.rowCount = 0;
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.rowCount > -1) {
            return this.rowCount;
        }
        try {
            if (this.resultset.last()) {
                this.rowCount = this.resultset.getRow();
                if (this.rowCount == -1) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        catch (SQLException sqle) {
            throw new DataTableException("Accessing the result set failed: ", sqle);
        }
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.dbmd != null) {
            try {
                return this.dbmd.getColumnCount();
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return 0;
    }

    @Override
    public String getColumnName(int column) {
        if (this.dbmd != null) {
            try {
                Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
                boolean useLegacyColumnMapping = "legacy".equalsIgnoreCase(globalConfig.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ColumnMappingMode", "legacy"));
                String columnLabel = this.dbmd.getColumnLabel(column + 1);
                if (useLegacyColumnMapping) {
                    if (columnLabel == null || columnLabel.isEmpty()) {
                        columnLabel = this.dbmd.getColumnName(column + 1);
                    }
                    return columnLabel;
                }
                if (this.isColumnNameMapping()) {
                    return this.dbmd.getColumnName(column + 1);
                }
                return columnLabel;
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.resultset != null) {
            try {
                this.resultset.absolute(row + 1);
                return this.resultset.getObject(column + 1);
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        if (this.types != null) {
            return this.types[column];
        }
        if (this.dbmd != null) {
            try {
                this.types = TypeMapper.mapTypes(this.dbmd);
                if (this.types != null) {
                    return this.types[column];
                }
            }
            catch (Exception e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return Object.class;
    }

    @Override
    public DataAttributes getCellDataAttributes(int row, int column) {
        if (this.metaData == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaData.getCellDataAttribute(row, column);
    }

    @Override
    public boolean isCellDataAttributesSupported() {
        return this.metaData.isCellDataAttributesSupported();
    }

    @Override
    public DataAttributes getColumnAttributes(int column) {
        if (this.metaData == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaData.getColumnAttribute(column);
    }

    @Override
    public DataAttributes getTableAttributes() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getTableAttribute();
    }
}

