/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ScrollableResultSetTableModel;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DefaultTableMetaData;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TypeMapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;

public final class ResultSetTableModelFactory {
    private static final Log logger = LogFactory.getLog(ResultSetTableModelFactory.class);
    public static final String COLUMN_NAME_MAPPING_KEY = "org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ColumnMappingMode";
    public static final String RESULTSET_FACTORY_MODE = "org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TableFactoryMode";
    private static ResultSetTableModelFactory defaultInstance;

    private ResultSetTableModelFactory() {
    }

    public CloseableTableModel createTableModel(ResultSet rs, boolean columnNameMapping, boolean closeStatement) throws SQLException {
        String prop = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(RESULTSET_FACTORY_MODE, "auto");
        if ("simple".equalsIgnoreCase(prop)) {
            return this.generateDefaultTableModel(rs, columnNameMapping);
        }
        int resultSetType = 1003;
        try {
            resultSetType = rs.getType();
        }
        catch (SQLException sqle) {
            logger.info((Object)"ResultSet type could not be determined, assuming default table model.");
        }
        if (resultSetType == 1003) {
            return this.generateDefaultTableModel(rs, columnNameMapping);
        }
        return new ScrollableResultSetTableModel(rs, columnNameMapping, closeStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableTableModel generateDefaultTableModel(ResultSet rs, boolean columnNameMapping) throws SQLException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int colcount = rsmd.getColumnCount();
            Object[] header = new Object[colcount];
            Class[] colTypes = TypeMapper.mapTypes(rsmd);
            DefaultTableMetaData metaData = new DefaultTableMetaData(colcount);
            Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
            boolean useLegacyColumnMapping = "legacy".equalsIgnoreCase(globalConfig.getConfigProperty(COLUMN_NAME_MAPPING_KEY, "legacy"));
            for (int columnIndex = 0; columnIndex < colcount; ++columnIndex) {
                String columnLabel = rsmd.getColumnLabel(columnIndex + 1);
                if (useLegacyColumnMapping) {
                    if (columnLabel == null || columnLabel.isEmpty()) {
                        columnLabel = rsmd.getColumnName(columnIndex + 1);
                    }
                    header[columnIndex] = columnLabel;
                } else {
                    header[columnIndex] = columnNameMapping ? rsmd.getColumnName(columnIndex + 1) : columnLabel;
                }
                ResultSetTableModelFactory.updateMetaData(rsmd, metaData, columnIndex);
            }
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] column = new Object[colcount];
                for (int i = 0; i < colcount; ++i) {
                    Object val = rs.getObject(i + 1);
                    try {
                        if (val instanceof Blob) {
                            column[i] = IOUtils.getInstance().readBlob((Blob)val);
                            continue;
                        }
                        if (val instanceof Clob) {
                            column[i] = IOUtils.getInstance().readClob((Clob)val);
                            continue;
                        }
                        column[i] = val;
                        continue;
                    }
                    catch (IOException ioe) {
                        logger.error((Object)"IO error while copying data.", (Throwable)ioe);
                        throw new SQLException("IO error while copying data: " + ioe.getMessage());
                    }
                }
                rows.add(column);
            }
            Object[] tempRows = rows.toArray();
            int tempRowCount = tempRows.length;
            Object[][] rowMap = new Object[tempRowCount][];
            for (int i = 0; i < tempRowCount; ++i) {
                rowMap[i] = (Object[])tempRows[i];
            }
            CloseableDefaultTableModel closeableDefaultTableModel = new CloseableDefaultTableModel(rowMap, header, colTypes, metaData);
            return closeableDefaultTableModel;
        }
        finally {
            Statement statement = null;
            try {
                statement = rs.getStatement();
            }
            catch (SQLException sqle) {
                logger.warn((Object)"Failed to close statement", (Throwable)sqle);
            }
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                logger.warn((Object)"Failed to close resultset", (Throwable)sqle);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sqle) {
                logger.warn((Object)"Failed to close statement", (Throwable)sqle);
            }
        }
    }

    public static void updateMetaData(ResultSetMetaData rsmd, DefaultTableMetaData metaData, int column) {
        try {
            String label;
            String catalogName;
            String schemaName;
            if (rsmd.isCurrency(column + 1)) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "currency", Boolean.TRUE);
            } else {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "currency", Boolean.FALSE);
            }
            if (rsmd.isSigned(column + 1)) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "signed", Boolean.TRUE);
            } else {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "signed", Boolean.FALSE);
            }
            String tableName = rsmd.getTableName(column + 1);
            if (tableName != null) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/database", "table", tableName);
            }
            if ((schemaName = rsmd.getSchemaName(column + 1)) != null) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/database", "schema", schemaName);
            }
            if ((catalogName = rsmd.getCatalogName(column + 1)) != null) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/database", "catalog", catalogName);
            }
            if ((label = rsmd.getColumnLabel(column + 1)) != null) {
                metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", label);
            }
            int displaySize = rsmd.getColumnDisplaySize(column + 1);
            metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "display-size", IntegerCache.getInteger(displaySize));
            int precision = rsmd.getPrecision(column + 1);
            metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "precision", IntegerCache.getInteger(precision));
            int scale = rsmd.getScale(column + 1);
            metaData.setColumnAttribute(column, "http://reporting.pentaho.org/namespaces/engine/meta-attributes/numeric", "scale", IntegerCache.getInteger(scale));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static synchronized ResultSetTableModelFactory getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new ResultSetTableModelFactory();
        }
        return defaultInstance;
    }

    private static final class CloseableDefaultTableModel
    extends DefaultTableModel
    implements CloseableTableModel,
    MetaTableModel {
        private DefaultTableMetaData metaData;
        private Class[] columnTypes;
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private static final Object[][] EMPTY_DATA_VECTOR = new Object[0][0];

        private CloseableDefaultTableModel(Object[][] rowData, Object[] columnNames, Class[] columnTypes, DefaultTableMetaData metaTableModel) {
            super(rowData, columnNames);
            this.columnTypes = columnTypes;
            this.metaData = metaTableModel;
        }

        public Class getColumnClass(int columnIndex) {
            if (this.columnTypes == null) {
                return Object.class;
            }
            if (columnIndex >= this.columnTypes.length) {
                return Object.class;
            }
            return this.columnTypes[columnIndex];
        }

        @Override
        public void close() {
            this.setDataVector(EMPTY_DATA_VECTOR, EMPTY_ARRAY);
        }

        @Override
        public DataAttributes getCellDataAttributes(int row, int column) {
            if (this.metaData == null) {
                return EmptyDataAttributes.INSTANCE;
            }
            return this.metaData.getCellDataAttribute(row, column);
        }

        @Override
        public boolean isCellDataAttributesSupported() {
            return this.metaData.isCellDataAttributesSupported();
        }

        @Override
        public DataAttributes getColumnAttributes(int column) {
            if (this.metaData == null) {
                return EmptyDataAttributes.INSTANCE;
            }
            return this.metaData.getColumnAttribute(column);
        }

        @Override
        public DataAttributes getTableAttributes() {
            if (this.metaData == null) {
                return null;
            }
            return this.metaData.getTableAttribute();
        }
    }
}

