/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportActionPlugin;

public class ExportAction
extends AbstractAction {
    private static final Log logger = LogFactory.getLog(ExportAction.class);
    private ExportActionPlugin actionPlugin;
    private PreviewPane previewPane;

    public ExportAction(ExportActionPlugin actionPlugin, PreviewPane previewPane) {
        if (actionPlugin == null) {
            throw new NullPointerException();
        }
        if (previewPane == null) {
            throw new NullPointerException();
        }
        this.actionPlugin = actionPlugin;
        this.previewPane = previewPane;
        this.putValue("Name", actionPlugin.getDisplayName());
        this.putValue("ShortDescription", actionPlugin.getShortDescription());
        this.putValue("AcceleratorKey", actionPlugin.getAcceleratorKey());
        this.putValue("MnemonicKey", actionPlugin.getMnemonicKey());
        this.putValue("SmallIcon", actionPlugin.getSmallIcon());
        this.putValue("Icon24", actionPlugin.getLargeIcon());
        this.actionPlugin.addPropertyChangeListener("enabled", new EnableChangeListener());
        this.setEnabled(actionPlugin.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.actionPlugin.isEnabled()) {
            return;
        }
        MasterReport reportJob = this.previewPane.getReportJob();
        if (reportJob == null) {
            return;
        }
        this.actionPlugin.performExport(reportJob.clone());
    }

    private class EnableChangeListener
    implements PropertyChangeListener {
        protected EnableChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ExportAction.this.setEnabled(ExportAction.this.actionPlugin.isEnabled());
        }
    }
}

