/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class CountDistinctFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private Sequence<HashSet<Object>> values = new Sequence();
    private transient int lastGroupSequenceNumber;
    private String group;
    private String field;
    private String crosstabFilterGroup;
    private boolean ignoreNullValues;

    public boolean isIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String name) {
        this.group = name;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    private void clear() {
        this.values.clear();
        this.lastGroupSequenceNumber = 0;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.getField() == null) {
            return;
        }
        Object o = event.getDataRow().get(this.getField());
        HashSet<Object> valueSet = this.values.get(this.lastGroupSequenceNumber);
        if (valueSet == null) {
            valueSet = new HashSet();
            this.values.set(this.lastGroupSequenceNumber, valueSet);
        }
        if (this.ignoreNullValues && o == null) {
            return;
        }
        valueSet.add(o);
    }

    @Override
    public Object getValue() {
        HashSet<Object> vals = this.values.get(this.lastGroupSequenceNumber);
        if (vals != null) {
            return vals.size();
        }
        return 0;
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Expression getInstance() {
        CountDistinctFunction expression = (CountDistinctFunction)super.getInstance();
        expression.values = this.values.clone();
        expression.lastGroupSequenceNumber = 0;
        return expression;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CountDistinctFunction o = (CountDistinctFunction)super.clone();
        o.values = this.values.clone();
        return o;
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

