/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabCellBodyType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class CrosstabCellBody
extends GroupBody {
    private static final CrosstabCell[] EMPTY_ARRAY = new CrosstabCell[0];
    private ArrayList<CrosstabCell> allElements;
    private transient CrosstabCell[] allElementsCached;
    private DetailsHeader detailsHeader;

    public CrosstabCellBody() {
        this.setElementType(CrosstabCellBodyType.INSTANCE);
        this.getStyle().setStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, Boolean.FALSE);
        this.detailsHeader = new DetailsHeader();
        this.registerAsChild(this.detailsHeader);
    }

    @Override
    public Group getGroup() {
        return null;
    }

    public DetailsHeader getHeader() {
        return this.detailsHeader;
    }

    public void setHeader(DetailsHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        DetailsHeader element = this.detailsHeader;
        this.detailsHeader.setParent(null);
        this.detailsHeader = header;
        this.detailsHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.detailsHeader);
    }

    public void addElement(CrosstabCell element) {
        this.addElement(this.getElementCount(), element);
    }

    public void addElement(int position, CrosstabCell element) {
        if (position < 1) {
            throw new IllegalArgumentException("Position < 1");
        }
        if (position > this.getElementCount()) {
            throw new IllegalArgumentException("Position > ElementCount");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        if (this.allElements == null) {
            this.allElements = new ArrayList();
        }
        this.allElements.add(position - 1, element);
        this.allElementsCached = null;
        this.registerAsChild(element);
        this.notifyNodeChildAdded(element);
    }

    public CrosstabCell findElement(String rowKeys, String colKeys) {
        for (CrosstabCell e : this.internalGetElementArray()) {
            if (e == null) continue;
            String cellColField = e.getColumnField();
            String cellRowField = e.getRowField();
            boolean colFieldMatch = this.equalString(cellColField, colKeys);
            boolean rowFieldMatch = this.equalString(cellRowField, rowKeys);
            if (!colFieldMatch || !rowFieldMatch) continue;
            return e;
        }
        return null;
    }

    private boolean equalString(String s1, String s2) {
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2 == null;
    }

    @Override
    public void removeElement(Element e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.getParentSection() != this) {
            return;
        }
        if (this.allElements == null) {
            return;
        }
        e.setParent(null);
        this.allElements.remove(e);
        this.allElementsCached = null;
        this.notifyNodeChildRemoved(e);
    }

    @Override
    public void setElementAt(int position, Element element) {
        if (position < 0) {
            throw new IllegalArgumentException("Position < 0");
        }
        if (position >= this.getElementCount()) {
            throw new IllegalArgumentException("Position >= size");
        }
        if (element == null) {
            throw new NullPointerException("Band.addElement(...): element is null.");
        }
        if (position == 0) {
            if (!(element instanceof DetailsHeader)) {
                throw new IllegalArgumentException();
            }
            this.setHeader((DetailsHeader)element);
            return;
        }
        if (!(element instanceof CrosstabCell)) {
            throw new IllegalArgumentException();
        }
        this.validateLooping(element);
        if (this.unregisterParent(element)) {
            return;
        }
        int insertPosition = position - 1;
        if (this.allElements == null) {
            throw new IllegalStateException("The throws above should have caught that state");
        }
        Element o = this.allElements.set(insertPosition, (CrosstabCell)element);
        o.setParent(null);
        this.allElementsCached = null;
        this.registerAsChild(element);
        this.notifyNodeChildRemoved(o);
        this.notifyNodeChildAdded(element);
    }

    public void clear() {
        CrosstabCell[] elements = this.internalGetElementArray();
        for (int i = 0; i < elements.length; ++i) {
            CrosstabCell element = elements[i];
            this.removeElement(element);
        }
    }

    @Override
    public int getElementCount() {
        if (this.allElements == null) {
            return 1;
        }
        return 1 + this.allElements.size();
    }

    private CrosstabCell[] internalGetElementArray() {
        if (this.allElementsCached == null) {
            if (this.allElements == null || this.allElements.isEmpty()) {
                this.allElementsCached = EMPTY_ARRAY;
            } else {
                CrosstabCell[] elements = new CrosstabCell[this.allElements.size()];
                elements = this.allElements.toArray(elements);
                this.allElementsCached = elements;
            }
        }
        return this.allElementsCached;
    }

    @Override
    public Element getElement(int index) {
        if (index == 0) {
            return this.detailsHeader;
        }
        if (this.allElements == null) {
            throw new IndexOutOfBoundsException("This index is invalid.");
        }
        return this.allElements.get(index - 1);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", size=\"");
        b.append(this.getElementCount());
        b.append("\", layout=\"");
        b.append(this.getStyle().getStyleProperty(BandStyleKeys.LAYOUT));
        b.append("\"}");
        return b.toString();
    }

    @Override
    public CrosstabCellBody clone() {
        CrosstabCellBody b;
        block4: {
            b = (CrosstabCellBody)super.clone();
            b.detailsHeader = (DetailsHeader)this.detailsHeader.clone();
            b.registerAsChild(b.detailsHeader);
            if (this.allElements == null) break block4;
            int elementSize = this.allElements.size();
            b.allElements = (ArrayList)this.allElements.clone();
            b.allElements.clear();
            b.allElementsCached = new CrosstabCell[elementSize];
            if (this.allElementsCached != null) {
                for (int i = 0; i < elementSize; ++i) {
                    CrosstabCell eC = (CrosstabCell)this.allElementsCached[i].clone();
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            } else {
                for (int i = 0; i < elementSize; ++i) {
                    CrosstabCell e = this.allElements.get(i);
                    CrosstabCell eC = (CrosstabCell)e.clone();
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            }
        }
        return b;
    }

    @Override
    public CrosstabCellBody derive(boolean preserveElementInstanceIds) {
        CrosstabCellBody b;
        block4: {
            b = (CrosstabCellBody)super.derive(preserveElementInstanceIds);
            b.detailsHeader = (DetailsHeader)this.detailsHeader.derive(preserveElementInstanceIds);
            b.registerAsChild(b.detailsHeader);
            if (this.allElements == null) break block4;
            int elementSize = this.allElements.size();
            b.allElements = (ArrayList)this.allElements.clone();
            b.allElements.clear();
            b.allElementsCached = new CrosstabCell[elementSize];
            if (this.allElementsCached != null) {
                for (int i = 0; i < elementSize; ++i) {
                    CrosstabCell eC = (CrosstabCell)this.allElementsCached[i].derive(preserveElementInstanceIds);
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            } else {
                for (int i = 0; i < elementSize; ++i) {
                    CrosstabCell e = this.allElements.get(i);
                    CrosstabCell eC = (CrosstabCell)e.derive(preserveElementInstanceIds);
                    b.allElements.add(eC);
                    b.allElementsCached[i] = eC;
                    eC.setParent(b);
                }
            }
        }
        return b;
    }
}

