/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class VisibilityScanDeleteTracker
extends ScanDeleteTracker {
    private Map<Long, List<Tag>> visibilityTagsDeleteFamily = new HashMap<Long, List<Tag>>();
    private Map<Long, List<Tag>> visibilityTagsDeleteFamilyVersion = new HashMap<Long, List<Tag>>();
    private List<List<Tag>> visibilityTagsDeleteColumns;
    private List<List<Tag>> visiblityTagsDeleteColumnVersion = new ArrayList<List<Tag>>();

    @Override
    public void add(Cell delCell) {
        long timestamp = delCell.getTimestamp();
        int qualifierOffset = delCell.getQualifierOffset();
        int qualifierLength = delCell.getQualifierLength();
        byte type = delCell.getTypeByte();
        if (type == KeyValue.Type.DeleteFamily.getCode()) {
            this.hasFamilyStamp = true;
            this.extractDeleteTags(delCell, KeyValue.Type.DeleteFamily);
            return;
        }
        if (type == KeyValue.Type.DeleteFamilyVersion.getCode()) {
            this.familyVersionStamps.add(timestamp);
            this.extractDeleteTags(delCell, KeyValue.Type.DeleteFamilyVersion);
            return;
        }
        if (this.deleteBuffer != null) {
            if (Bytes.compareTo((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])delCell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength) != 0) {
                this.visibilityTagsDeleteColumns = null;
                this.visiblityTagsDeleteColumnVersion = null;
            } else if (type == KeyValue.Type.Delete.getCode() && this.deleteTimestamp != timestamp) {
                this.visiblityTagsDeleteColumnVersion = null;
            }
        }
        this.deleteBuffer = delCell.getQualifierArray();
        this.deleteOffset = qualifierOffset;
        this.deleteLength = qualifierLength;
        this.deleteType = type;
        this.deleteTimestamp = timestamp;
        this.extractDeleteTags(delCell, KeyValue.Type.codeToType((byte)type));
    }

    private void extractDeleteTags(Cell delCell, KeyValue.Type type) {
        block20: {
            block19: {
                if (delCell.getTagsLengthUnsigned() <= 0) break block19;
                switch (type) {
                    case DeleteFamily: {
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        if (this.visibilityTagsDeleteFamily != null) {
                            VisibilityUtils.getVisibilityTags(delCell, delTags);
                            if (!delTags.isEmpty()) {
                                this.visibilityTagsDeleteFamily.put(delCell.getTimestamp(), delTags);
                                break;
                            }
                        }
                        break block20;
                    }
                    case DeleteFamilyVersion: {
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        VisibilityUtils.getVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visibilityTagsDeleteFamilyVersion.put(delCell.getTimestamp(), delTags);
                            break;
                        }
                        break block20;
                    }
                    case DeleteColumn: {
                        if (this.visibilityTagsDeleteColumns == null) {
                            this.visibilityTagsDeleteColumns = new ArrayList<List<Tag>>();
                        }
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        VisibilityUtils.getVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visibilityTagsDeleteColumns.add(delTags);
                            break;
                        }
                        break block20;
                    }
                    case Delete: {
                        if (this.visiblityTagsDeleteColumnVersion == null) {
                            this.visiblityTagsDeleteColumnVersion = new ArrayList<List<Tag>>();
                        }
                        ArrayList<Tag> delTags = new ArrayList<Tag>();
                        VisibilityUtils.getVisibilityTags(delCell, delTags);
                        if (!delTags.isEmpty()) {
                            this.visiblityTagsDeleteColumnVersion.add(delTags);
                            break;
                        }
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid delete type");
                    }
                }
                break block20;
            }
            switch (type) {
                case DeleteFamily: {
                    this.visibilityTagsDeleteFamily = null;
                    break;
                }
                case DeleteFamilyVersion: {
                    this.visibilityTagsDeleteFamilyVersion = null;
                    break;
                }
                case DeleteColumn: {
                    this.visibilityTagsDeleteColumns = null;
                    break;
                }
                case Delete: {
                    this.visiblityTagsDeleteColumnVersion = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid delete type");
                }
            }
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        boolean matchFound;
        List<Tag> tags;
        boolean matchFound2;
        long timestamp = cell.getTimestamp();
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        if (this.hasFamilyStamp) {
            if (this.visibilityTagsDeleteFamily != null) {
                Set<Map.Entry<Long, List<Tag>>> deleteFamilies = this.visibilityTagsDeleteFamily.entrySet();
                for (Map.Entry<Long, List<Tag>> entry : deleteFamilies) {
                    if (timestamp > entry.getKey() || !(matchFound2 = VisibilityUtils.checkForMatchingVisibilityTags(cell, entry.getValue()))) continue;
                    return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
                }
            } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
            }
        }
        if (this.familyVersionStamps.contains(timestamp) && (this.visibilityTagsDeleteFamilyVersion != null ? (tags = this.visibilityTagsDeleteFamilyVersion.get(timestamp)) != null && (matchFound = VisibilityUtils.checkForMatchingVisibilityTags(cell, tags)) : !VisibilityUtils.isVisibilityTagsPresent(cell))) {
            return DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED;
        }
        if (this.deleteBuffer != null) {
            int ret = Bytes.compareTo((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength, (byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength);
            if (ret == 0) {
                if (this.deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                    if (this.visibilityTagsDeleteColumns != null) {
                        for (List<Tag> tags2 : this.visibilityTagsDeleteColumns) {
                            matchFound2 = VisibilityUtils.checkForMatchingVisibilityTags(cell, tags2);
                            if (!matchFound2) continue;
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                        return DeleteTracker.DeleteResult.VERSION_DELETED;
                    }
                }
                if (timestamp == this.deleteTimestamp) {
                    if (this.visiblityTagsDeleteColumnVersion != null) {
                        for (List<Tag> tags2 : this.visiblityTagsDeleteColumnVersion) {
                            matchFound2 = VisibilityUtils.checkForMatchingVisibilityTags(cell, tags2);
                            if (!matchFound2) continue;
                            return DeleteTracker.DeleteResult.VERSION_DELETED;
                        }
                    } else if (!VisibilityUtils.isVisibilityTagsPresent(cell)) {
                        return DeleteTracker.DeleteResult.VERSION_DELETED;
                    }
                }
            } else if (ret < 0) {
                this.deleteBuffer = null;
                this.visibilityTagsDeleteColumns = null;
                this.visiblityTagsDeleteColumnVersion = null;
            } else {
                throw new IllegalStateException("isDeleted failed: deleteBuffer=" + Bytes.toStringBinary((byte[])this.deleteBuffer, (int)this.deleteOffset, (int)this.deleteLength) + ", qualifier=" + Bytes.toStringBinary((byte[])cell.getQualifierArray(), (int)qualifierOffset, (int)qualifierLength) + ", timestamp=" + timestamp + ", comparison result: " + ret);
            }
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public void reset() {
        super.reset();
        this.visibilityTagsDeleteColumns = null;
        this.visibilityTagsDeleteFamily = new HashMap<Long, List<Tag>>();
        this.visibilityTagsDeleteFamilyVersion = new HashMap<Long, List<Tag>>();
        this.visiblityTagsDeleteColumnVersion = null;
    }
}

