/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.scriptable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.bsf.BSFManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.ScriptableDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.scriptable.DataSetQuery;
import org.pentaho.reporting.ui.datasources.scriptable.Messages;

public class ScriptableDataSourceEditor
extends CommonDialog {
    private JList queryNameList;
    private JTextField queryNameTextField;
    private JList languageField;
    private RSyntaxTextArea queryTextArea;
    private RSyntaxTextArea initScriptTextArea;
    private RSyntaxTextArea shutdownScriptTextArea;
    private Map<String, DataSetQuery> queries;
    private boolean inQueryNameUpdate;
    private boolean inModifyingQueryNameList;
    private PreviewAction previewAction;
    private DesignTimeContext designTimeContext;

    public ScriptableDataSourceEditor(DesignTimeContext designTimeContext) {
        this.init(designTimeContext);
    }

    public ScriptableDataSourceEditor(DesignTimeContext designTimeContext, Dialog owner) {
        super(owner);
        this.init(designTimeContext);
    }

    public ScriptableDataSourceEditor(DesignTimeContext designTimeContext, Frame owner) {
        super(owner);
        this.init(designTimeContext);
    }

    private void init(DesignTimeContext designTimeContext) {
        if (designTimeContext == null) {
            throw new NullPointerException();
        }
        this.designTimeContext = designTimeContext;
        this.setTitle(Messages.getString("ScriptableDataSourceEditor.Title", new Object[0]));
        this.setModal(true);
        this.previewAction = new PreviewAction();
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener(new QueryNameTextFieldDocumentListener());
        this.queryTextArea = new RSyntaxTextArea();
        this.queryTextArea.setSyntaxEditingStyle("text/plain");
        this.queryTextArea.getDocument().addDocumentListener(new QueryDocumentListener());
        this.initScriptTextArea = new RSyntaxTextArea();
        this.initScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.shutdownScriptTextArea = new RSyntaxTextArea();
        this.shutdownScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.languageField = new JList<String>(new DefaultComboBoxModel<String>(InternalBSFManager.getRegisteredLanguages()));
        this.languageField.setSelectionMode(0);
        this.languageField.getSelectionModel().addListSelectionListener(new UpdateLanguageHandler());
        this.queryNameList = new JList();
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QueryNameListSelectionListener());
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        QueryRemoveAction removeQueryAction = new QueryRemoveAction();
        this.queryNameList.addListSelectionListener(removeQueryAction);
        super.init();
    }

    protected String getDialogId() {
        return "ScriptableDataSourceEditor";
    }

    protected Component createContentPane() {
        JPanel initScriptContentHolder = new JPanel(new BorderLayout());
        initScriptContentHolder.add("North", new JLabel(Messages.getString("ScriptableDataSourceEditor.InitScript", new Object[0])));
        initScriptContentHolder.add("Center", (Component)new RTextScrollPane(500, 600, (RTextArea)this.initScriptTextArea, true));
        JPanel shutdownScriptContentHolder = new JPanel(new BorderLayout());
        shutdownScriptContentHolder.add("North", new JLabel(Messages.getString("ScriptableDataSourceEditor.ShutdownScript", new Object[0])));
        shutdownScriptContentHolder.add("Center", (Component)new RTextScrollPane(500, 600, (RTextArea)this.shutdownScriptTextArea, true));
        JPanel queryDetailsNamePanel = new JPanel(new BorderLayout());
        queryDetailsNamePanel.add((Component)new JLabel(Messages.getString("ScriptableDataSourceEditor.QueryName", new Object[0])), "North");
        queryDetailsNamePanel.add((Component)this.queryNameTextField, "Center");
        JPanel queryContentHolder = new JPanel(new BorderLayout());
        queryContentHolder.add("North", new JLabel(Messages.getString("ScriptableDataSourceEditor.QueryLabel", new Object[0])));
        queryContentHolder.add("Center", (Component)new RTextScrollPane(500, 300, (RTextArea)this.queryTextArea, true));
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.setBorder(new EmptyBorder(0, 8, 8, 8));
        queryDetailsPanel.add("North", queryDetailsNamePanel);
        queryDetailsPanel.add("Center", queryContentHolder);
        JPanel previewButtonPanel = new JPanel(new FlowLayout(2));
        previewButtonPanel.add(new JButton(this.previewAction));
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", queryDetailsPanel);
        JTabbedPane scriptsTabPane = new JTabbedPane();
        scriptsTabPane.addTab(Messages.getString("ScriptableDataSourceEditor.QueryTab", new Object[0]), queryContentPanel);
        scriptsTabPane.addTab(Messages.getString("ScriptableDataSourceEditor.InitScriptTab", new Object[0]), initScriptContentHolder);
        scriptsTabPane.addTab(Messages.getString("ScriptableDataSourceEditor.ShutdownScriptTab", new Object[0]), shutdownScriptContentHolder);
        JLabel languageLabel = new JLabel(Messages.getString("ScriptableDataSourceEditor.Language", new Object[0]));
        languageLabel.setBorder(new EmptyBorder(0, 0, 3, 0));
        JPanel languagesPanel = new JPanel(new BorderLayout());
        languagesPanel.setBorder(new EmptyBorder(8, 8, 8, 0));
        languagesPanel.add("North", languageLabel);
        languagesPanel.add("Center", new JScrollPane(this.languageField));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add("West", languagesPanel);
        contentPanel.add("Center", scriptsTabPane);
        contentPanel.add("South", previewButtonPanel);
        return contentPanel;
    }

    private JPanel createQueryListPanel() {
        QueryRemoveAction queryRemoveAction = new QueryRemoveAction();
        this.queryNameList.addListSelectionListener(queryRemoveAction);
        JPanel theQueryButtonsPanel = new JPanel(new FlowLayout(2));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction()));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)queryRemoveAction));
        JPanel theQueryControlsPanel = new JPanel(new BorderLayout());
        theQueryControlsPanel.add("West", new JLabel(Messages.getString("ScriptableDataSourceEditor.AvailableQueries", new Object[0])));
        theQueryControlsPanel.add("East", theQueryButtonsPanel);
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", theQueryControlsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    public ScriptableDataFactory performConfiguration(ScriptableDataFactory dataFactory, String selectedQuery) {
        this.queries = new TreeMap<String, DataSetQuery>();
        if (dataFactory != null) {
            this.languageField.setSelectedValue(dataFactory.getLanguage(), true);
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query = dataFactory.getQuery(queryName);
                this.queries.put(queryName, new DataSetQuery(queryName, query));
            }
            this.initScriptTextArea.setText(dataFactory.getScript());
            this.shutdownScriptTextArea.setText(dataFactory.getShutdownScript());
        }
        this.updateComponents();
        this.updateQueryList();
        this.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        return this.produceFactory();
    }

    private ScriptableDataFactory produceFactory() {
        ScriptableDataFactory returnDataFactory = new ScriptableDataFactory();
        returnDataFactory.setLanguage((String)this.languageField.getSelectedValue());
        if (StringUtils.isEmpty((String)this.initScriptTextArea.getText())) {
            returnDataFactory.setScript(null);
        } else {
            returnDataFactory.setScript(this.initScriptTextArea.getText());
        }
        if (StringUtils.isEmpty((String)this.shutdownScriptTextArea.getText())) {
            returnDataFactory.setShutdownScript(null);
        } else {
            returnDataFactory.setShutdownScript(this.shutdownScriptTextArea.getText());
        }
        DataSetQuery[] queries = this.queries.values().toArray(new DataSetQuery[this.queries.size()]);
        for (int i = 0; i < queries.length; ++i) {
            DataSetQuery query = queries[i];
            returnDataFactory.setQuery(query.getQueryName(), query.getQuery());
        }
        return returnDataFactory;
    }

    protected void updateQueryList() {
        this.queryNameList.removeAll();
        this.queryNameList.setListData(this.queries.values().toArray(new DataSetQuery[this.queries.size()]));
    }

    private void setSelectedQuery(String aQuery) {
        ListModel theModel = this.queryNameList.getModel();
        for (int i = 0; i < theModel.getSize(); ++i) {
            DataSetQuery theDataSet = (DataSetQuery)theModel.getElementAt(i);
            if (!theDataSet.getQueryName().equals(aQuery)) continue;
            this.queryNameList.setSelectedValue(theDataSet, true);
            break;
        }
    }

    protected void updateComponents() {
        boolean querySelected = this.queryNameList.getSelectedIndex() != -1;
        boolean hasQueries = this.queryNameList.getModel().getSize() > 0;
        this.queryNameTextField.setEnabled(querySelected);
        this.queryTextArea.setEnabled(querySelected);
        this.getConfirmAction().setEnabled(hasQueries && this.languageField.getSelectedIndex() != -1);
        this.queryTextArea.setSyntaxEditingStyle(this.mapLanguageToSyntaxHighlighting((String)this.languageField.getSelectedValue()));
        this.initScriptTextArea.setSyntaxEditingStyle(this.mapLanguageToSyntaxHighlighting((String)this.languageField.getSelectedValue()));
        this.shutdownScriptTextArea.setSyntaxEditingStyle(this.mapLanguageToSyntaxHighlighting((String)this.languageField.getSelectedValue()));
        this.previewAction.setEnabled(querySelected);
    }

    private String mapLanguageToSyntaxHighlighting(String language) {
        if ("beanshell".equals(language)) {
            return "text/java";
        }
        if ("groovy".equals(language)) {
            return "text/groovy";
        }
        if ("javascript".equals(language)) {
            return "text/javascript";
        }
        if ("jython".equals(language)) {
            return "text/python";
        }
        if ("xslt".equals(language)) {
            return "text/xml";
        }
        return "text/plain";
    }

    private static class ScriptablePreviewWorker
    implements PreviewWorker {
        private ScriptableDataFactory dataFactory;
        private TableModel resultTableModel;
        private ReportDataFactoryException exception;
        private String query;

        private ScriptablePreviewWorker(ScriptableDataFactory dataFactory, String query) {
            if (dataFactory == null) {
                throw new NullPointerException();
            }
            this.query = query;
            this.dataFactory = dataFactory;
        }

        public ReportDataFactoryException getException() {
            return this.exception;
        }

        public TableModel getResultTableModel() {
            return this.resultTableModel;
        }

        public void close() {
        }

        public void cancelProcessing(CancelEvent event) {
            this.dataFactory.cancelRunningQuery();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.resultTableModel = this.dataFactory.queryData(this.query, (DataRow)new ReportParameterValues());
            }
            catch (ReportDataFactoryException e) {
                this.exception = e;
            }
            finally {
                this.dataFactory.close();
            }
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("ScriptableDataSourceEditor.Preview.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            try {
                ScriptableDataFactory dataFactory = ScriptableDataSourceEditor.this.produceFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)ScriptableDataSourceEditor.this.designTimeContext);
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)ScriptableDataSourceEditor.this));
                ScriptablePreviewWorker worker = new ScriptablePreviewWorker(dataFactory, ScriptableDataSourceEditor.this.queryNameTextField.getText());
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)ScriptableDataSourceEditor.this), (String)Messages.getString("ScriptableDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("ScriptableDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)((Object)factoryException));
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)ScriptableDataSourceEditor.this), (String)Messages.getString("ScriptableDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("ScriptableDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class QueryDocumentListener
    implements DocumentListener {
        private QueryDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            DataSetQuery currentQuery = (DataSetQuery)ScriptableDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            currentQuery.setQuery(ScriptableDataSourceEditor.this.queryTextArea.getText());
        }
    }

    private class QueryAddAction
    extends AbstractAction {
        private QueryAddAction() {
            URL resource = ScriptableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/scriptable/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ScriptableDataSourceEditor.AddQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ScriptableDataSourceEditor.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = Messages.getString("ScriptableDataSourceEditor.Query", new Object[0]);
            for (int i = 1; i < 1000; ++i) {
                String newQueryName = Messages.getString("ScriptableDataSourceEditor.Query", new Object[0]) + ' ' + i;
                if (ScriptableDataSourceEditor.this.queries.containsKey(newQueryName)) continue;
                queryName = newQueryName;
                break;
            }
            DataSetQuery newQuery = new DataSetQuery(queryName, "");
            ScriptableDataSourceEditor.this.queries.put(newQuery.getQueryName(), newQuery);
            ScriptableDataSourceEditor.this.inModifyingQueryNameList = true;
            ScriptableDataSourceEditor.this.updateQueryList();
            ScriptableDataSourceEditor.this.queryNameList.setSelectedValue(newQuery, true);
            ScriptableDataSourceEditor.this.inModifyingQueryNameList = false;
            ScriptableDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryNameListSelectionListener
    implements ListSelectionListener {
        private QueryNameListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!ScriptableDataSourceEditor.this.inQueryNameUpdate) {
                DataSetQuery query = (DataSetQuery)ScriptableDataSourceEditor.this.queryNameList.getSelectedValue();
                if (query != null) {
                    ScriptableDataSourceEditor.this.queryNameTextField.setText(query.getQueryName());
                    ScriptableDataSourceEditor.this.queryTextArea.setText(query.getQuery());
                    ScriptableDataSourceEditor.this.updateComponents();
                } else {
                    ScriptableDataSourceEditor.this.queryNameTextField.setText("");
                    ScriptableDataSourceEditor.this.queryTextArea.setText("");
                    ScriptableDataSourceEditor.this.updateComponents();
                }
            }
        }
    }

    private static class QueryNameListCellRenderer
    extends DefaultListCellRenderer {
        private QueryNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String queryName = ((DataSetQuery)value).getQueryName();
                if (!StringUtils.isEmpty((String)queryName)) {
                    listCellRendererComponent.setText(queryName);
                } else {
                    listCellRendererComponent.setText(" ");
                }
            }
            return listCellRendererComponent;
        }
    }

    private class QueryNameTextFieldDocumentListener
    implements DocumentListener {
        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (ScriptableDataSourceEditor.this.inModifyingQueryNameList) {
                return;
            }
            String queryName = ScriptableDataSourceEditor.this.queryNameTextField.getText();
            DataSetQuery currentQuery = (DataSetQuery)ScriptableDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            if (queryName.equals(currentQuery.getQueryName())) {
                return;
            }
            if (ScriptableDataSourceEditor.this.queries.containsKey(queryName)) {
                return;
            }
            ScriptableDataSourceEditor.this.inQueryNameUpdate = true;
            ScriptableDataSourceEditor.this.queries.remove(currentQuery.getQueryName());
            currentQuery.setQueryName(queryName);
            ScriptableDataSourceEditor.this.queries.put(currentQuery.getQueryName(), currentQuery);
            ScriptableDataSourceEditor.this.updateQueryList();
            ScriptableDataSourceEditor.this.queryNameList.setSelectedValue(currentQuery, true);
            ScriptableDataSourceEditor.this.inQueryNameUpdate = false;
        }
    }

    private class QueryRemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        private QueryRemoveAction() {
            URL resource = ScriptableDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/scriptable/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ScriptableDataSourceEditor.RemoveQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ScriptableDataSourceEditor.RemoveQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = (DataSetQuery)ScriptableDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                ScriptableDataSourceEditor.this.queries.remove(query.getQueryName());
            }
            ScriptableDataSourceEditor.this.inModifyingQueryNameList = true;
            ScriptableDataSourceEditor.this.updateQueryList();
            ScriptableDataSourceEditor.this.queryNameList.clearSelection();
            ScriptableDataSourceEditor.this.inModifyingQueryNameList = false;
            ScriptableDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ScriptableDataSourceEditor.this.queryNameList.isSelectionEmpty());
        }
    }

    private static class InternalBSFManager
    extends BSFManager {
        private InternalBSFManager() {
        }

        public static String[] getRegisteredLanguages() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : registeredEngines.entrySet()) {
                String lang = (String)entry.getKey();
                String className = (String)entry.getValue();
                try {
                    Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    list.add(lang);
                }
                catch (Throwable t) {}
            }
            return list.toArray(new String[list.size()]);
        }
    }

    private class UpdateLanguageHandler
    implements ActionListener,
    ListSelectionListener {
        private UpdateLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptableDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ScriptableDataSourceEditor.this.updateComponents();
        }
    }
}

