/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.openformula.ui.util.FunctionCategoryCellRenderer;
import org.pentaho.openformula.ui.util.FunctionDescriptionCellRenderer;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionCategory;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;

public class FunctionListPanel
extends JPanel {
    private JList formulaList;
    private JComboBox categoryComboBox;
    private FormulaContext formulaContext;
    private FunctionDescription selectedValue;
    private static final FunctionDescription[] EMPTY_DESCRIPTIONS = new FunctionDescription[0];

    public FunctionListPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.categoryComboBox = new JComboBox();
        this.categoryComboBox.addActionListener(new CategorySelectionAction());
        this.categoryComboBox.setRenderer(new FunctionCategoryCellRenderer());
        this.formulaList = new JList();
        this.formulaList.setCellRenderer(new FunctionDescriptionCellRenderer());
        this.formulaList.setSelectionMode(0);
        this.formulaList.addMouseListener(new FormulaListMouseHandler());
        this.formulaList.getSelectionModel().addListSelectionListener(new FormulaListSelectionHandler());
        this.add((Component)new JLabel(Messages.getInstance().getString("FunctionListPanel.Category")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.categoryComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        JScrollPane formulaListScrollPane = new JScrollPane(this.formulaList);
        this.add((Component)new JLabel(Messages.getInstance().getString("FunctionListPanel.Function")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)formulaListScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setFormulaContext(FormulaContext formulaContext) {
        FormulaContext old = this.formulaContext;
        this.formulaContext = formulaContext;
        if (formulaContext != null && formulaContext != old) {
            DefaultComboBoxModel<FunctionCategory> aModel = new DefaultComboBoxModel<FunctionCategory>();
            aModel.addElement(null);
            FunctionCategory[] functionCategories = formulaContext.getFunctionRegistry().getCategories();
            for (int i = 0; i < functionCategories.length; ++i) {
                aModel.addElement(functionCategories[i]);
            }
            this.categoryComboBox.setModel(aModel);
            this.categoryComboBox.setSelectedItem(null);
        }
    }

    protected void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, -1, null);
        ActionListener[] listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ActionListener listener = listeners[i];
            listener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected JList getFormulaList() {
        return this.formulaList;
    }

    protected FunctionCategory getSelectedCategoryName() {
        return (FunctionCategory)this.categoryComboBox.getSelectedItem();
    }

    protected FunctionDescription[] getDescriptionsForCategory(FunctionCategory category) {
        if (this.formulaContext == null) {
            return EMPTY_DESCRIPTIONS;
        }
        FunctionRegistry functionRegistry = this.formulaContext.getFunctionRegistry();
        Object[] functionNames = category == null ? functionRegistry.getFunctionNames() : functionRegistry.getFunctionNamesByCategory(category);
        Arrays.sort(functionNames);
        FunctionDescription[] fds = new FunctionDescription[functionNames.length];
        for (int i = 0; i < functionNames.length; ++i) {
            fds[i] = functionRegistry.getMetaData((String)functionNames[i]);
        }
        return fds;
    }

    public FunctionDescription getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(FunctionDescription selectedValue) {
        FunctionDescription old = this.selectedValue;
        this.selectedValue = selectedValue;
        this.firePropertyChange("selectedValue", old, selectedValue);
    }

    private class FormulaListSelectionHandler
    implements ListSelectionListener {
        private FormulaListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            FunctionListPanel.this.setSelectedValue((FunctionDescription)FunctionListPanel.this.getFormulaList().getSelectedValue());
        }
    }

    private class FormulaListMouseHandler
    extends MouseAdapter {
        protected FormulaListMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                FunctionListPanel.this.setSelectedValue((FunctionDescription)FunctionListPanel.this.getFormulaList().getSelectedValue());
                FunctionListPanel.this.fireActionPerformed();
            }
        }
    }

    private class CategorySelectionAction
    implements ActionListener {
        protected CategorySelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JList list = FunctionListPanel.this.getFormulaList();
            list.setListData(FunctionListPanel.this.getDescriptionsForCategory(FunctionListPanel.this.getSelectedCategoryName()));
            list.invalidate();
        }
    }
}

