/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.ByteBloomFilter;
import org.apache.hadoop.io.Writable;

public class DynamicByteBloomFilter
implements BloomFilter {
    public static final int VERSION = 2;
    protected final int keyInterval;
    protected final float errorRate;
    protected final int hashType;
    protected int curKeys;
    protected int readMatrixSize;
    protected ByteBloomFilter[] matrix;

    public DynamicByteBloomFilter(ByteBuffer meta) throws IllegalArgumentException {
        int version = meta.getInt();
        if (version != 2) {
            throw new IllegalArgumentException("Bad version");
        }
        this.keyInterval = meta.getInt();
        this.errorRate = meta.getFloat();
        this.hashType = meta.getInt();
        this.readMatrixSize = meta.getInt();
        this.curKeys = meta.getInt();
        this.readSanityCheck();
        this.matrix = new ByteBloomFilter[1];
        this.matrix[0] = new ByteBloomFilter(this.keyInterval, this.errorRate, this.hashType, 0);
    }

    public DynamicByteBloomFilter(int keyInterval, float errorRate, int hashType) throws IllegalArgumentException {
        this.keyInterval = keyInterval;
        this.errorRate = errorRate;
        this.hashType = hashType;
        this.curKeys = 0;
        if (keyInterval <= 0) {
            throw new IllegalArgumentException("keyCount must be > 0");
        }
        this.matrix = new ByteBloomFilter[1];
        this.matrix[0] = new ByteBloomFilter(keyInterval, errorRate, hashType, 0);
    }

    @Override
    public void allocBloom() {
        this.matrix[0].allocBloom();
    }

    void readSanityCheck() throws IllegalArgumentException {
        if (this.curKeys <= 0) {
            throw new IllegalArgumentException("last bloom's key count invalid");
        }
        if (this.readMatrixSize <= 0) {
            throw new IllegalArgumentException("matrix size must be known");
        }
    }

    @Override
    public void add(byte[] buf, int offset, int len) {
        BloomFilter bf = this.getCurBloom();
        if (bf == null) {
            this.addRow();
            bf = this.matrix[this.matrix.length - 1];
            this.curKeys = 0;
        }
        bf.add(buf, offset, len);
        ++this.curKeys;
    }

    @Override
    public void add(byte[] buf) {
        this.add(buf, 0, buf.length);
    }

    boolean contains(byte[] buf) {
        return this.contains(buf, 0, buf.length);
    }

    boolean contains(byte[] buf, int offset, int length) {
        for (int i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[i].contains(buf, offset, length)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(byte[] buf, ByteBuffer theBloom) {
        return this.contains(buf, 0, buf.length, theBloom);
    }

    @Override
    public boolean contains(byte[] buf, int offset, int length, ByteBuffer theBloom) {
        if (offset + length > buf.length) {
            return false;
        }
        int bytesPerBloom = this.matrix[0].getByteSize();
        if (theBloom.limit() != bytesPerBloom * this.readMatrixSize) {
            throw new IllegalArgumentException("Bloom does not match expected size");
        }
        ByteBuffer tmp = theBloom.duplicate();
        for (int m = 0; m < this.readMatrixSize; ++m) {
            tmp.position(m * bytesPerBloom);
            tmp.limit(tmp.position() + bytesPerBloom);
            boolean match = this.matrix[0].contains(buf, offset, length, tmp.slice());
            if (!match) continue;
            return true;
        }
        return false;
    }

    int bloomCount() {
        return Math.max(this.matrix.length, this.readMatrixSize);
    }

    @Override
    public int getKeyCount() {
        return (this.bloomCount() - 1) * this.keyInterval + this.curKeys;
    }

    @Override
    public int getMaxKeys() {
        return this.bloomCount() * this.keyInterval;
    }

    @Override
    public int getByteSize() {
        return this.bloomCount() * this.matrix[0].getByteSize();
    }

    @Override
    public void compactBloom() {
    }

    private void addRow() {
        ByteBloomFilter[] tmp = new ByteBloomFilter[this.matrix.length + 1];
        for (int i = 0; i < this.matrix.length; ++i) {
            tmp[i] = this.matrix[i];
        }
        tmp[tmp.length - 1] = new ByteBloomFilter(this.keyInterval, this.errorRate, this.hashType, 0);
        tmp[tmp.length - 1].allocBloom();
        this.matrix = tmp;
    }

    private BloomFilter getCurBloom() {
        if (this.curKeys >= this.keyInterval) {
            return null;
        }
        return this.matrix[this.matrix.length - 1];
    }

    @Override
    public Writable getMetaWriter() {
        return new MetaWriter();
    }

    @Override
    public Writable getDataWriter() {
        return new DataWriter();
    }

    private class DataWriter
    implements Writable {
        protected DataWriter() {
        }

        public void readFields(DataInput arg0) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < DynamicByteBloomFilter.this.matrix.length; ++i) {
                DynamicByteBloomFilter.this.matrix[i].writeBloom(out);
            }
        }
    }

    private class MetaWriter
    implements Writable {
        protected MetaWriter() {
        }

        public void readFields(DataInput arg0) throws IOException {
            throw new IOException("Cant read with this class.");
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(2);
            out.writeInt(DynamicByteBloomFilter.this.keyInterval);
            out.writeFloat(DynamicByteBloomFilter.this.errorRate);
            out.writeInt(DynamicByteBloomFilter.this.hashType);
            out.writeInt(DynamicByteBloomFilter.this.matrix.length);
            out.writeInt(DynamicByteBloomFilter.this.curKeys);
        }
    }
}

