/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ChainWALEntryFilter;
import org.apache.hadoop.hbase.replication.ClusterMarkingEntryFilter;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.SystemTableWALEntryFilter;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReaderThread;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationThrottler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class ReplicationSource
extends Thread
implements ReplicationSourceInterface {
    private static final Log LOG = LogFactory.getLog(ReplicationSource.class);
    private Map<String, PriorityBlockingQueue<Path>> queues = new HashMap<String, PriorityBlockingQueue<Path>>();
    private int queueSizePerGroup;
    private ReplicationQueues replicationQueues;
    private ReplicationPeers replicationPeers;
    private Configuration conf;
    private ReplicationQueueInfo replicationQueueInfo;
    private String peerId;
    private ReplicationSourceManager manager;
    private Stoppable stopper;
    private long sleepForRetries;
    private FileSystem fs;
    private UUID clusterId;
    private UUID peerClusterId;
    private AtomicLong totalReplicatedEdits = new AtomicLong(0L);
    private AtomicLong totalReplicatedOperations = new AtomicLong(0L);
    private String peerClusterZnode;
    private int maxRetriesMultiplier;
    private volatile boolean sourceRunning = false;
    private MetricsSource metrics;
    private int logQueueWarnThreshold;
    private ReplicationEndpoint replicationEndpoint;
    private WALEntryFilter walEntryFilter;
    private ReplicationThrottler throttler;
    private long defaultBandwidth;
    private long currentBandwidth;
    private ConcurrentHashMap<String, ReplicationSourceShipperThread> workerThreads = new ConcurrentHashMap();

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueues replicationQueues, ReplicationPeers replicationPeers, Stoppable stopper, String peerClusterZnode, UUID clusterId, ReplicationEndpoint replicationEndpoint, MetricsSource metrics) throws IOException {
        this.stopper = stopper;
        this.conf = HBaseConfiguration.create((Configuration)conf);
        this.decorateConf();
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.queueSizePerGroup = this.conf.getInt("hbase.regionserver.maxlogs", 32);
        this.replicationQueues = replicationQueues;
        this.replicationPeers = replicationPeers;
        this.manager = manager;
        this.fs = fs;
        this.metrics = metrics;
        this.clusterId = clusterId;
        this.peerClusterZnode = peerClusterZnode;
        this.replicationQueueInfo = new ReplicationQueueInfo(peerClusterZnode);
        this.peerId = this.replicationQueueInfo.getPeerId();
        this.logQueueWarnThreshold = this.conf.getInt("replication.source.log.queue.warn", 2);
        this.replicationEndpoint = replicationEndpoint;
        this.defaultBandwidth = this.conf.getLong("replication.source.per.peer.node.bandwidth", 0L);
        this.currentBandwidth = this.getCurrentBandwidth();
        this.throttler = new ReplicationThrottler((double)this.currentBandwidth / 10.0);
        LOG.info((Object)("peerClusterZnode=" + peerClusterZnode + ", ReplicationSource : " + this.peerId + ", currentBandwidth=" + this.currentBandwidth));
    }

    private void decorateConf() {
        String replicationCodec = this.conf.get("hbase.replication.rpc.codec");
        if (StringUtils.isNotEmpty((String)replicationCodec)) {
            this.conf.set("hbase.client.rpc.codec", replicationCodec);
        }
    }

    @Override
    public void enqueueLog(Path log) {
        String logPrefix = DefaultWALProvider.getWALPrefixFromWALName(log.getName());
        PriorityBlockingQueue<Path> queue = this.queues.get(logPrefix);
        if (queue == null) {
            queue = new PriorityBlockingQueue<Path>(this.queueSizePerGroup, new LogsComparator());
            this.queues.put(logPrefix, queue);
            if (this.sourceRunning) {
                ReplicationSourceShipperThread worker = new ReplicationSourceShipperThread(logPrefix, queue, this.replicationQueueInfo, this);
                ReplicationSourceShipperThread extant = this.workerThreads.putIfAbsent(logPrefix, worker);
                if (extant != null) {
                    LOG.debug((Object)("Someone has beat us to start a worker thread for wal group " + logPrefix));
                } else {
                    LOG.debug((Object)("Starting up worker for wal group " + logPrefix));
                    worker.startup();
                }
            }
        }
        queue.put(log);
        this.metrics.incrSizeOfLogQueue();
        int queueSize = queue.size();
        if (queueSize > this.logQueueWarnThreshold) {
            LOG.warn((Object)("WAL group " + logPrefix + " queue size: " + queueSize + " exceeds value of replication.source.log.queue.warn: " + this.logQueueWarnThreshold));
        }
    }

    @Override
    public void addHFileRefs(TableName tableName, byte[] family, List<Pair<Path, Path>> pairs) throws ReplicationException {
        Map tableCFMap;
        String peerId = this.peerClusterZnode;
        if (peerId.contains("-")) {
            peerId = this.peerClusterZnode.split("-")[0];
        }
        if ((tableCFMap = this.replicationPeers.getPeer(peerId).getTableCFs()) != null) {
            List tableCfs = (List)tableCFMap.get(tableName);
            if (tableCFMap.containsKey(tableName) && (tableCfs == null || tableCfs.contains(Bytes.toString((byte[])family)))) {
                this.replicationQueues.addHFileRefs(peerId, pairs);
                this.metrics.incrSizeOfHFileRefsQueue(pairs.size());
            } else {
                LOG.debug((Object)("HFiles will not be replicated belonging to the table " + tableName + " family " + Bytes.toString((byte[])family) + " to peer id " + peerId));
            }
        } else {
            this.replicationQueues.addHFileRefs(peerId, pairs);
            this.metrics.incrSizeOfHFileRefsQueue(pairs.size());
        }
    }

    private void uninitialize() {
        LOG.debug((Object)("Source exiting " + this.peerId));
        this.metrics.clear();
        if (this.replicationEndpoint.state() == Service.State.STARTING || this.replicationEndpoint.state() == Service.State.RUNNING) {
            this.replicationEndpoint.stopAndWait();
        }
    }

    @Override
    public void run() {
        this.sourceRunning = true;
        try {
            Service.State state = (Service.State)this.replicationEndpoint.start().get();
            if (state != Service.State.RUNNING) {
                LOG.warn((Object)"ReplicationEndpoint was not started. Exiting");
                this.uninitialize();
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error starting ReplicationEndpoint, exiting", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        ArrayList filters = Lists.newArrayList((Object[])new WALEntryFilter[]{new SystemTableWALEntryFilter()});
        WALEntryFilter filterFromEndpoint = this.replicationEndpoint.getWALEntryfilter();
        if (filterFromEndpoint != null) {
            filters.add(filterFromEndpoint);
        }
        this.walEntryFilter = new ChainWALEntryFilter(filters);
        int sleepMultiplier = 1;
        while (this.isSourceActive() && this.peerClusterId == null) {
            this.peerClusterId = this.replicationEndpoint.getPeerUUID();
            if (!this.isSourceActive() || this.peerClusterId != null || !this.sleepForRetries("Cannot contact the peer's zk ensemble", sleepMultiplier)) continue;
            ++sleepMultiplier;
        }
        if (this.clusterId.equals(this.peerClusterId) && !this.replicationEndpoint.canReplicateToSameCluster()) {
            this.terminate("ClusterId " + this.clusterId + " is replicating to itself: peerClusterId " + this.peerClusterId + " which is not allowed by ReplicationEndpoint:" + this.replicationEndpoint.getClass().getName(), null, false);
            this.manager.closeQueue(this);
            return;
        }
        LOG.info((Object)("Replicating " + this.clusterId + " -> " + this.peerClusterId));
        for (Map.Entry<String, PriorityBlockingQueue<Path>> entry : this.queues.entrySet()) {
            PriorityBlockingQueue<Path> queue;
            ReplicationSourceShipperThread worker;
            String walGroupId = entry.getKey();
            ReplicationSourceShipperThread extant = this.workerThreads.putIfAbsent(walGroupId, worker = new ReplicationSourceShipperThread(walGroupId, queue = entry.getValue(), this.replicationQueueInfo, this));
            if (extant != null) {
                LOG.debug((Object)("Someone has beat us to start a worker thread for wal group " + walGroupId));
                continue;
            }
            LOG.debug((Object)("Starting up worker for wal group " + walGroupId));
            worker.startup();
        }
    }

    protected boolean sleepForRetries(String msg, int sleepMultiplier) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(msg + ", sleeping " + this.sleepForRetries + " times " + sleepMultiplier));
            }
            Thread.sleep(this.sleepForRetries * (long)sleepMultiplier);
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Interrupted while sleeping between retries");
            Thread.currentThread().interrupt();
        }
        return sleepMultiplier < this.maxRetriesMultiplier;
    }

    protected boolean isPeerEnabled() {
        return this.replicationPeers.getStatusOfPeer(this.peerId);
    }

    @Override
    public void startup() {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error((Object)"Unexpected exception in ReplicationSource", e);
            }
        };
        Threads.setDaemonThreadRunning((Thread)this, (String)(n + ".replicationSource," + this.peerClusterZnode), (Thread.UncaughtExceptionHandler)handler);
    }

    @Override
    public void terminate(String reason) {
        this.terminate(reason, null);
    }

    @Override
    public void terminate(String reason, Exception cause) {
        this.terminate(reason, cause, true);
    }

    public void terminate(String reason, Exception cause, boolean join) {
        if (cause == null) {
            LOG.info((Object)("Closing source " + this.peerClusterZnode + " because: " + reason));
        } else {
            LOG.error((Object)("Closing source " + this.peerClusterZnode + " because an error occurred: " + reason), (Throwable)cause);
        }
        this.sourceRunning = false;
        Collection<ReplicationSourceShipperThread> workers = this.workerThreads.values();
        for (ReplicationSourceShipperThread worker : workers) {
            worker.setWorkerState(WorkerState.STOPPED);
            worker.entryReader.interrupt();
            worker.interrupt();
        }
        ListenableFuture future = null;
        if (this.replicationEndpoint != null) {
            future = this.replicationEndpoint.stop();
        }
        if (join) {
            for (ReplicationSourceShipperThread worker : workers) {
                Threads.shutdown((Thread)worker, (long)this.sleepForRetries);
                LOG.info((Object)("ReplicationSourceWorker " + worker.getName() + " terminated"));
            }
            if (future != null) {
                try {
                    future.get(this.sleepForRetries * (long)this.maxRetriesMultiplier, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Got exception while waiting for endpoint to shutdown for replication source :" + this.peerClusterZnode), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getPeerClusterZnode() {
        return this.peerClusterZnode;
    }

    @Override
    public String getPeerClusterId() {
        return this.peerId;
    }

    @Override
    public Path getCurrentPath() {
        for (ReplicationSourceShipperThread worker : this.workerThreads.values()) {
            if (worker.getCurrentPath() == null) continue;
            return worker.getCurrentPath();
        }
        return null;
    }

    private boolean isSourceActive() {
        return !this.stopper.isStopped() && this.sourceRunning;
    }

    @Override
    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total replicated edits: ").append(this.totalReplicatedEdits).append(", current progress: \n");
        for (Map.Entry<String, ReplicationSourceShipperThread> entry : this.workerThreads.entrySet()) {
            String walGroupId = entry.getKey();
            ReplicationSourceShipperThread worker = entry.getValue();
            long position = worker.getCurrentPosition();
            Path currentPath = worker.getCurrentPath();
            sb.append("walGroup [").append(walGroupId).append("]: ");
            if (currentPath != null) {
                sb.append("currently replicating from: ").append(currentPath).append(" at position: ").append(position).append("\n");
                continue;
            }
            sb.append("no replication ongoing, waiting for new log");
        }
        return sb.toString();
    }

    @Override
    public MetricsSource getSourceMetrics() {
        return this.metrics;
    }

    private long getCurrentBandwidth() {
        ReplicationPeer replicationPeer = this.replicationPeers.getPeer(this.peerId);
        long peerBandwidth = replicationPeer != null ? replicationPeer.getPeerBandwidth() : 0L;
        return peerBandwidth != 0L ? peerBandwidth : this.defaultBandwidth;
    }

    public class ReplicationSourceShipperThread
    extends Thread {
        ReplicationSourceInterface source;
        String walGroupId;
        PriorityBlockingQueue<Path> queue;
        ReplicationQueueInfo replicationQueueInfo;
        private long lastLoggedPosition = -1L;
        private volatile Path currentPath;
        private WorkerState state;
        ReplicationSourceWALReaderThread entryReader;

        public ReplicationSourceShipperThread(String walGroupId, PriorityBlockingQueue<Path> queue, ReplicationQueueInfo replicationQueueInfo, ReplicationSourceInterface source) {
            this.walGroupId = walGroupId;
            this.queue = queue;
            this.replicationQueueInfo = replicationQueueInfo;
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setWorkerState(WorkerState.RUNNING);
            while (this.isWorkerActive()) {
                int sleepMultiplier = 1;
                if (!ReplicationSource.this.isPeerEnabled()) {
                    if (!ReplicationSource.this.sleepForRetries("Replication is disabled", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                    continue;
                }
                while (this.entryReader == null) {
                    if (ReplicationSource.this.sleepForRetries("Replication WAL entry reader thread not initialized", sleepMultiplier)) {
                        ++sleepMultiplier;
                    }
                    if (sleepMultiplier != ReplicationSource.this.maxRetriesMultiplier) continue;
                    LOG.warn((Object)"Replication WAL entry reader thread not initialized");
                }
                try {
                    ReplicationSourceWALReaderThread.WALEntryBatch entryBatch = this.entryReader.take();
                    this.shipEdits(entryBatch);
                    if (!this.replicationQueueInfo.isQueueRecovered() || !entryBatch.getWalEntries().isEmpty() || !entryBatch.getLastSeqIds().isEmpty()) continue;
                    LOG.debug((Object)("Finished recovering queue for group " + this.walGroupId + " of peer " + ReplicationSource.this.peerClusterZnode));
                    ReplicationSource.this.metrics.incrCompletedRecoveryQueue();
                    this.setWorkerState(WorkerState.FINISHED);
                }
                catch (InterruptedException e) {
                    LOG.trace((Object)"Interrupted while waiting for next replication entry batch", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (this.replicationQueueInfo.isQueueRecovered() && this.getWorkerState() == WorkerState.FINISHED) {
                ReplicationSourceShipperThread replicationSourceShipperThread = this;
                synchronized (replicationSourceShipperThread) {
                    Threads.sleep((long)100L);
                    boolean allOtherTaskDone = true;
                    for (ReplicationSourceShipperThread worker : ReplicationSource.this.workerThreads.values()) {
                        if (worker.equals(this) || worker.getWorkerState() == WorkerState.FINISHED) continue;
                        allOtherTaskDone = false;
                        break;
                    }
                    if (allOtherTaskDone) {
                        ReplicationSource.this.manager.closeRecoveredQueue(this.source);
                        if (this.source instanceof ReplicationSource) {
                            ((ReplicationSource)this.source).replicationEndpoint.stop();
                        }
                        LOG.info((Object)("Finished recovering queue " + ReplicationSource.this.peerClusterZnode + " with the following stats: " + ReplicationSource.this.getStats()));
                    }
                }
            }
            if (this.state != WorkerState.FINISHED) {
                this.setWorkerState(WorkerState.STOPPED);
            }
        }

        private void cleanUpHFileRefs(WALEdit edit) throws IOException {
            String peerId = ReplicationSource.this.peerClusterZnode;
            if (peerId.contains("-")) {
                peerId = ReplicationSource.this.peerClusterZnode.split("-")[0];
            }
            ArrayList<Cell> cells = edit.getCells();
            int totalCells = cells.size();
            for (int i = 0; i < totalCells; ++i) {
                Cell cell = (Cell)cells.get(i);
                if (!CellUtil.matchingQualifier((Cell)cell, (byte[])WALEdit.BULK_LOAD)) continue;
                WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor(cell);
                List stores = bld.getStoresList();
                int totalStores = stores.size();
                for (int j = 0; j < totalStores; ++j) {
                    List storeFileList = ((WALProtos.StoreDescriptor)stores.get(j)).getStoreFileList();
                    ReplicationSource.this.manager.cleanUpHFileRefs(peerId, storeFileList);
                    ReplicationSource.this.metrics.decrSizeOfHFileRefsQueue(storeFileList.size());
                }
            }
        }

        private void checkBandwidthChangeAndResetThrottler() {
            long peerBandwidth = ReplicationSource.this.getCurrentBandwidth();
            if (peerBandwidth != ReplicationSource.this.currentBandwidth) {
                ReplicationSource.this.currentBandwidth = peerBandwidth;
                ReplicationSource.this.throttler.setBandwidth((double)ReplicationSource.this.currentBandwidth / 10.0);
                LOG.info((Object)("ReplicationSource : " + ReplicationSource.this.peerId + " bandwidth throttling changed, currentBandWidth=" + ReplicationSource.this.currentBandwidth));
            }
        }

        protected void shipEdits(ReplicationSourceWALReaderThread.WALEntryBatch entryBatch) {
            List<WAL.Entry> entries = entryBatch.getWalEntries();
            long lastReadPosition = entryBatch.getLastWalPosition();
            this.currentPath = entryBatch.getLastWalPath();
            int sleepMultiplier = 0;
            if (entries.isEmpty()) {
                if (this.lastLoggedPosition != lastReadPosition) {
                    this.updateLogPosition(lastReadPosition);
                    ReplicationSource.this.metrics.setAgeOfLastShippedOp(EnvironmentEdgeManager.currentTime(), this.walGroupId);
                }
                return;
            }
            int currentSize = (int)entryBatch.getHeapSize();
            while (this.isWorkerActive()) {
                try {
                    long sleepTicks;
                    this.checkBandwidthChangeAndResetThrottler();
                    if (ReplicationSource.this.throttler.isEnabled() && (sleepTicks = ReplicationSource.this.throttler.getNextSleepInterval(currentSize)) > 0L) {
                        try {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("To sleep " + sleepTicks + "ms for throttling control"));
                            }
                            Thread.sleep(sleepTicks);
                        }
                        catch (InterruptedException e) {
                            LOG.debug((Object)"Interrupted while sleeping for throttling control");
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        ReplicationSource.this.throttler.resetStartTick();
                    }
                    ReplicationEndpoint.ReplicateContext replicateContext = new ReplicationEndpoint.ReplicateContext();
                    replicateContext.setEntries(entries).setSize(currentSize);
                    replicateContext.setWalGroupId(this.walGroupId);
                    long startTimeNs = System.nanoTime();
                    boolean replicated = ReplicationSource.this.replicationEndpoint.replicate(replicateContext);
                    long endTimeNs = System.nanoTime();
                    if (!replicated) continue;
                    sleepMultiplier = Math.max(sleepMultiplier - 1, 0);
                    if (this.lastLoggedPosition != lastReadPosition) {
                        int size = entries.size();
                        for (int i = 0; i < size; ++i) {
                            this.cleanUpHFileRefs(entries.get(i).getEdit());
                        }
                        this.updateLogPosition(lastReadPosition);
                    }
                    if (ReplicationSource.this.throttler.isEnabled()) {
                        ReplicationSource.this.throttler.addPushSize(currentSize);
                    }
                    ReplicationSource.this.totalReplicatedEdits.addAndGet(entries.size());
                    ReplicationSource.this.totalReplicatedOperations.addAndGet(entryBatch.getNbOperations());
                    ReplicationSource.this.metrics.shipBatch(entryBatch.getNbOperations(), currentSize, entryBatch.getNbHFiles());
                    ReplicationSource.this.metrics.setAgeOfLastShippedOp(entries.get(entries.size() - 1).getKey().getWriteTime(), this.walGroupId);
                    if (!LOG.isTraceEnabled()) break;
                    LOG.trace((Object)("Replicated " + ReplicationSource.this.totalReplicatedEdits + " entries in total, or " + ReplicationSource.this.totalReplicatedOperations + " operations in " + (endTimeNs - startTimeNs) / 1000000L + " ms"));
                    break;
                }
                catch (Exception ex) {
                    LOG.warn((Object)(ReplicationSource.this.replicationEndpoint.getClass().getName() + " threw unknown exception:" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex)));
                    if (!ReplicationSource.this.sleepForRetries("ReplicationEndpoint threw exception", sleepMultiplier)) continue;
                    ++sleepMultiplier;
                }
            }
        }

        private void updateLogPosition(long lastReadPosition) {
            ReplicationSource.this.manager.logPositionAndCleanOldLogs(this.currentPath, ReplicationSource.this.peerClusterZnode, lastReadPosition, this.replicationQueueInfo.isQueueRecovered(), false);
            this.lastLoggedPosition = lastReadPosition;
        }

        public void startup() {
            String n = Thread.currentThread().getName();
            Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    RSRpcServices.exitIfOOME(e);
                    LOG.error((Object)("Unexpected exception in ReplicationSourceWorkerThread, currentPath=" + ReplicationSourceShipperThread.this.getCurrentPath()), e);
                    ReplicationSource.this.stopper.stop("Unexpected exception in ReplicationSourceWorkerThread");
                }
            };
            Threads.setDaemonThreadRunning((Thread)this, (String)(n + ".replicationSource." + this.walGroupId + "," + ReplicationSource.this.peerClusterZnode), (Thread.UncaughtExceptionHandler)handler);
            ReplicationSource.this.workerThreads.put(this.walGroupId, this);
            long startPosition = 0L;
            if (this.replicationQueueInfo.isQueueRecovered()) {
                startPosition = this.getRecoveredQueueStartPos(startPosition);
                for (int numRetries = 0; numRetries <= ReplicationSource.this.maxRetriesMultiplier; ++numRetries) {
                    try {
                        this.locateRecoveredPaths();
                        break;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Error while locating recovered queue paths, attempt #" + numRetries));
                        continue;
                    }
                }
            }
            this.startWALReaderThread(n, handler, startPosition);
        }

        private long getRecoveredQueueStartPos(long startPosition) {
            try {
                startPosition = ReplicationSource.this.replicationQueues.getLogPosition(ReplicationSource.this.peerClusterZnode, this.queue.peek().getName());
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recovered queue started with log " + this.queue.peek() + " at position " + startPosition));
                }
            }
            catch (ReplicationException e) {
                this.terminate("Couldn't get the position of this recovered queue " + ReplicationSource.this.peerClusterZnode, (Exception)((Object)e));
            }
            return startPosition;
        }

        private void startWALReaderThread(String threadName, Thread.UncaughtExceptionHandler handler, long startPosition) {
            ArrayList filters = Lists.newArrayList((Object[])new WALEntryFilter[]{ReplicationSource.this.walEntryFilter, new ClusterMarkingEntryFilter(ReplicationSource.this.clusterId, ReplicationSource.this.peerClusterId, ReplicationSource.this.replicationEndpoint)});
            ChainWALEntryFilter readerFilter = new ChainWALEntryFilter(filters);
            this.entryReader = new ReplicationSourceWALReaderThread(ReplicationSource.this.manager, this.replicationQueueInfo, this.queue, startPosition, ReplicationSource.this.fs, ReplicationSource.this.conf, readerFilter, ReplicationSource.this.metrics);
            Threads.setDaemonThreadRunning((Thread)this.entryReader, (String)(threadName + ".replicationSource.replicationWALReaderThread." + this.walGroupId + "," + ReplicationSource.this.peerClusterZnode), (Thread.UncaughtExceptionHandler)handler);
        }

        private void locateRecoveredPaths() throws IOException {
            boolean hasPathChanged = false;
            PriorityBlockingQueue<Path> newPaths = new PriorityBlockingQueue<Path>(ReplicationSource.this.queueSizePerGroup, new LogsComparator());
            block0: for (Path path : this.queue) {
                if (ReplicationSource.this.fs.exists(path)) {
                    newPaths.add(path);
                    continue;
                }
                hasPathChanged = true;
                if (ReplicationSource.this.stopper instanceof ReplicationSyncUp.DummyServer) {
                    Path newPath = this.getReplSyncUpPath(path);
                    newPaths.add(newPath);
                    continue;
                }
                List deadRegionServers = this.replicationQueueInfo.getDeadRegionServers();
                LOG.info((Object)("NB dead servers : " + deadRegionServers.size()));
                Path walDir = FSUtils.getWALRootDir(ReplicationSource.this.conf);
                for (String curDeadServerName : deadRegionServers) {
                    Path[] locs;
                    Path deadRsDirectory = new Path(walDir, DefaultWALProvider.getWALDirectoryName(curDeadServerName));
                    for (Path possibleLogLocation : locs = new Path[]{new Path(deadRsDirectory, path.getName()), new Path(deadRsDirectory.suffix("-splitting"), path.getName())}) {
                        LOG.info((Object)("Possible location " + possibleLogLocation.toUri().toString()));
                        if (!ReplicationSource.this.manager.getFs().exists(possibleLogLocation)) continue;
                        LOG.info((Object)("Log " + path + " still exists at " + possibleLogLocation));
                        newPaths.add(possibleLogLocation);
                        continue block0;
                    }
                }
                LOG.error((Object)String.format("WAL Path %s doesn't exist and couldn't find its new location", path));
                newPaths.add(path);
            }
            if (hasPathChanged) {
                if (newPaths.size() != this.queue.size()) {
                    LOG.error((Object)"Recovery queue size is incorrect");
                    throw new IOException("Recovery queue size error");
                }
                this.queue.clear();
                for (Path path : newPaths) {
                    this.queue.add(path);
                }
            }
        }

        private Path getReplSyncUpPath(Path path) throws IOException {
            FileStatus[] rss;
            for (FileStatus rs : rss = ReplicationSource.this.fs.listStatus(ReplicationSource.this.manager.getLogDir())) {
                FileStatus[] logs;
                Path p = rs.getPath();
                for (FileStatus log : logs = ReplicationSource.this.fs.listStatus(p)) {
                    if (!(p = new Path(p, log.getPath().getName())).getName().equals(path.getName())) continue;
                    LOG.info((Object)("Log " + p.getName() + " found at " + p));
                    return p;
                }
            }
            LOG.error((Object)("Didn't find path for: " + path.getName()));
            return path;
        }

        public Path getCurrentPath() {
            return this.entryReader.getCurrentPath();
        }

        public long getCurrentPosition() {
            return this.lastLoggedPosition;
        }

        private boolean isWorkerActive() {
            return !ReplicationSource.this.stopper.isStopped() && this.state == WorkerState.RUNNING && !this.isInterrupted();
        }

        private void terminate(String reason, Exception cause) {
            if (cause == null) {
                LOG.info((Object)("Closing worker for wal group " + this.walGroupId + " because: " + reason));
            } else {
                LOG.error((Object)("Closing worker for wal group " + this.walGroupId + " because an error occurred: " + reason), (Throwable)cause);
            }
            this.entryReader.interrupt();
            Threads.shutdown((Thread)this.entryReader, (long)ReplicationSource.this.sleepForRetries);
            this.setWorkerState(WorkerState.STOPPED);
            this.interrupt();
            Threads.shutdown((Thread)this, (long)ReplicationSource.this.sleepForRetries);
            LOG.info((Object)("ReplicationSourceWorker " + this.getName() + " terminated"));
        }

        public void setWorkerState(WorkerState state) {
            this.state = state;
            if (this.entryReader != null) {
                this.entryReader.setReaderRunning(state == WorkerState.RUNNING);
            }
        }

        public WorkerState getWorkerState() {
            return this.state;
        }
    }

    public static class LogsComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path o1, Path o2) {
            return Long.compare(LogsComparator.getTS(o1), LogsComparator.getTS(o2));
        }

        private static long getTS(Path p) {
            int tsIndex = p.getName().lastIndexOf(46) + 1;
            return Long.parseLong(p.getName().substring(tsIndex));
        }
    }

    public static enum WorkerState {
        RUNNING,
        STOPPED,
        FINISHED;

    }
}

