/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.StripeStoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class StripeStoreEngine
extends StoreEngine<StripeStoreFlusher, StripeCompactionPolicy, StripeCompactor, StripeStoreFileManager> {
    private static final Log LOG = LogFactory.getLog(StripeStoreEngine.class);
    private StripeStoreConfig config;

    @Override
    public boolean needsCompaction(List<StoreFile> filesCompacting) {
        return ((StripeCompactionPolicy)this.compactionPolicy).needsCompactions((StripeCompactionPolicy.StripeInformationProvider)((Object)this.storeFileManager), filesCompacting);
    }

    @Override
    public CompactionContext createCompaction() {
        return new StripeCompaction();
    }

    @Override
    protected void createComponents(Configuration conf, Store store, KeyValue.KVComparator comparator) throws IOException {
        this.config = new StripeStoreConfig(conf, store);
        this.compactionPolicy = new StripeCompactionPolicy(conf, store, this.config);
        this.storeFileManager = new StripeStoreFileManager(comparator, conf, this.config);
        this.storeFlusher = new StripeStoreFlusher(conf, store, (StripeCompactionPolicy)this.compactionPolicy, (StripeStoreFileManager)this.storeFileManager);
        this.compactor = new StripeCompactor(conf, store);
    }

    private class StripeCompaction
    extends CompactionContext {
        private StripeCompactionPolicy.StripeCompactionRequest stripeRequest = null;

        private StripeCompaction() {
        }

        @Override
        public List<StoreFile> preSelect(List<StoreFile> filesCompacting) {
            return ((StripeCompactionPolicy)StripeStoreEngine.this.compactionPolicy).preSelectFilesForCoprocessor((StripeCompactionPolicy.StripeInformationProvider)((Object)StripeStoreEngine.this.storeFileManager), filesCompacting);
        }

        @Override
        public boolean select(List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
            this.stripeRequest = ((StripeCompactionPolicy)StripeStoreEngine.this.compactionPolicy).selectCompaction((StripeCompactionPolicy.StripeInformationProvider)((Object)StripeStoreEngine.this.storeFileManager), filesCompacting, mayUseOffPeak);
            this.request = this.stripeRequest == null ? new CompactionRequest(new ArrayList<StoreFile>()) : this.stripeRequest.getRequest();
            return this.stripeRequest != null;
        }

        @Override
        public void forceSelect(CompactionRequest request) {
            super.forceSelect(request);
            if (this.stripeRequest != null) {
                this.stripeRequest.setRequest(this.request);
            } else {
                LOG.warn((Object)"Stripe store is forced to take an arbitrary file list and compact it.");
                this.stripeRequest = ((StripeCompactionPolicy)StripeStoreEngine.this.compactionPolicy).createEmptyRequest((StripeCompactionPolicy.StripeInformationProvider)((Object)StripeStoreEngine.this.storeFileManager), this.request);
            }
        }

        @Override
        public List<Path> compact(ThroughputController throughputController, User user) throws IOException {
            Preconditions.checkArgument((this.stripeRequest != null ? 1 : 0) != 0, (Object)"Cannot compact without selection");
            return this.stripeRequest.execute((StripeCompactor)StripeStoreEngine.this.compactor, throughputController, user);
        }
    }
}

