/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.util.Bytes;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

@InterfaceAudience.Private
public class BlockCacheUtil {
    private static final Log LOG = LogFactory.getLog(BlockCacheUtil.class);
    public static final long NANOS_PER_SECOND = 1000000000L;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toString(CachedBlock cb, long now) {
        return "filename=" + cb.getFilename() + ", " + BlockCacheUtil.toStringMinusFileName(cb, now);
    }

    public static String toJSON(String filename, NavigableSet<CachedBlock> blocks) throws JsonGenerationException, JsonMappingException, IOException {
        CachedBlockCountsPerFile counts = new CachedBlockCountsPerFile(filename);
        for (CachedBlock cb : blocks) {
            counts.count++;
            counts.size += cb.getSize();
            BlockType bt = cb.getBlockType();
            if (bt == null || !bt.isData()) continue;
            counts.countData++;
            counts.sizeData += cb.getSize();
        }
        return MAPPER.writeValueAsString((Object)counts);
    }

    public static String toJSON(CachedBlocksByFile cbsbf) throws JsonGenerationException, JsonMappingException, IOException {
        return MAPPER.writeValueAsString((Object)cbsbf);
    }

    public static String toJSON(BlockCache bc) throws JsonGenerationException, JsonMappingException, IOException {
        return MAPPER.writeValueAsString((Object)bc);
    }

    public static String toStringMinusFileName(CachedBlock cb, long now) {
        return "offset=" + cb.getOffset() + ", size=" + cb.getSize() + ", age=" + (now - cb.getCachedTime()) + ", type=" + cb.getBlockType() + ", priority=" + (Object)((Object)cb.getBlockPriority());
    }

    public static CachedBlocksByFile getLoadedCachedBlocksByFile(Configuration conf, BlockCache bc) {
        CachedBlocksByFile cbsbf = new CachedBlocksByFile(conf);
        for (CachedBlock cb : bc) {
            if (cbsbf.update(cb)) break;
        }
        return cbsbf;
    }

    private static int compareCacheBlock(Cacheable left, Cacheable right, boolean includeNextBlockOnDiskSize) {
        ByteBuffer l = ByteBuffer.allocate(left.getSerializedLength());
        left.serialize(l, includeNextBlockOnDiskSize);
        ByteBuffer r = ByteBuffer.allocate(right.getSerializedLength());
        right.serialize(r, includeNextBlockOnDiskSize);
        return Bytes.compareTo((byte[])l.array(), (int)l.arrayOffset(), (int)l.limit(), (byte[])r.array(), (int)r.arrayOffset(), (int)r.limit());
    }

    public static int validateBlockAddition(Cacheable existing, Cacheable newBlock, BlockCacheKey cacheKey) {
        int comparison = BlockCacheUtil.compareCacheBlock(existing, newBlock, false);
        if (comparison != 0) {
            throw new RuntimeException("Cached block contents differ, which should not have happened.cacheKey:" + cacheKey);
        }
        if (existing instanceof HFileBlock && newBlock instanceof HFileBlock) {
            comparison = ((HFileBlock)existing).getNextBlockOnDiskSize() - ((HFileBlock)newBlock).getNextBlockOnDiskSize();
        }
        return comparison;
    }

    public static boolean shouldReplaceExistingCacheBlock(BlockCache blockCache, BlockCacheKey cacheKey, Cacheable newBlock) {
        Cacheable existingBlock = blockCache.getBlock(cacheKey, false, false, false);
        int comparison = BlockCacheUtil.validateBlockAddition(existingBlock, newBlock, cacheKey);
        if (comparison < 0) {
            LOG.warn((Object)"Cached block contents differ by nextBlockOnDiskSize, the new block has nextBlockOnDiskSize set. Caching new block.");
            return true;
        }
        if (comparison > 0) {
            LOG.warn((Object)"Cached block contents differ by nextBlockOnDiskSize, the existing block has nextBlockOnDiskSize set, Keeping cached block.");
            return false;
        }
        LOG.warn((Object)("Caching an already cached block: " + cacheKey + ". This is harmless and can happen in rare " + "cases (see HBASE-8547)"));
        return false;
    }

    static {
        MAPPER.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE, true);
        MAPPER.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
    }

    @JsonIgnoreProperties(value={"cachedBlockStatsByFile"})
    public static class CachedBlocksByFile {
        private int count;
        private int dataBlockCount;
        private long size;
        private long dataSize;
        private final long now = System.nanoTime();
        private final int max;
        public static final int DEFAULT_MAX = 1000000;
        private NavigableMap<String, NavigableSet<CachedBlock>> cachedBlockByFile = new ConcurrentSkipListMap<String, NavigableSet<CachedBlock>>();
        FastLongHistogram hist = new FastLongHistogram();

        CachedBlocksByFile() {
            this(null);
        }

        CachedBlocksByFile(Configuration c) {
            this.max = c == null ? 1000000 : c.getInt("hbase.ui.blockcache.by.file.max", 1000000);
        }

        public boolean update(CachedBlock cb) {
            if (this.isFull()) {
                return true;
            }
            ConcurrentSkipListSet<CachedBlock> set = (ConcurrentSkipListSet<CachedBlock>)this.cachedBlockByFile.get(cb.getFilename());
            if (set == null) {
                set = new ConcurrentSkipListSet<CachedBlock>();
                this.cachedBlockByFile.put(cb.getFilename(), set);
            }
            set.add(cb);
            this.size += cb.getSize();
            ++this.count;
            BlockType bt = cb.getBlockType();
            if (bt != null && bt.isData()) {
                ++this.dataBlockCount;
                this.dataSize += cb.getSize();
            }
            long age = (this.now - cb.getCachedTime()) / 1000000000L;
            this.hist.add(age, 1L);
            return false;
        }

        public boolean isFull() {
            return this.count >= this.max;
        }

        public NavigableMap<String, NavigableSet<CachedBlock>> getCachedBlockStatsByFile() {
            return this.cachedBlockByFile;
        }

        public int getCount() {
            return this.count;
        }

        public int getDataCount() {
            return this.dataBlockCount;
        }

        public long getSize() {
            return this.size;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public AgeSnapshot getAgeInCacheSnapshot() {
            return new AgeSnapshot(this.hist);
        }

        public String toString() {
            AgeSnapshot snapshot = this.getAgeInCacheSnapshot();
            return "count=" + this.count + ", dataBlockCount=" + this.dataBlockCount + ", size=" + this.size + ", dataSize=" + this.getDataSize() + ", mean age=" + snapshot.getMean() + ", min age=" + snapshot.getMin() + ", max age=" + snapshot.getMax() + ", 75th percentile age=" + snapshot.get75thPercentile() + ", 95th percentile age=" + snapshot.get95thPercentile() + ", 98th percentile age=" + snapshot.get98thPercentile() + ", 99th percentile age=" + snapshot.get99thPercentile() + ", 99.9th percentile age=" + snapshot.get99thPercentile();
        }
    }

    static class CachedBlockCountsPerFile {
        private int count = 0;
        private long size = 0L;
        private int countData = 0;
        private long sizeData = 0L;
        private final String filename;

        CachedBlockCountsPerFile(String filename) {
            this.filename = filename;
        }

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }

        public int getCountData() {
            return this.countData;
        }

        public long getSizeData() {
            return this.sizeData;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

