/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.orc;

import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.format.IOrcInputField;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOrcInputFormat;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.S3NCredentialUtils;
import org.pentaho.hadoop.shim.common.format.orc.OrcMetaDataReader;
import org.pentaho.hadoop.shim.common.format.orc.OrcSchemaConverter;
import org.pentaho.hadoop.shim.common.format.orc.PentahoOrcRecordReader;

public class PentahoOrcInputFormat
extends HadoopFormatBase
implements IPentahoOrcInputFormat {
    private static final String NOT_NULL_MSG = "filename and inputfields must not be null";
    private String fileName;
    private List<? extends IOrcInputField> inputFields;
    private final Configuration conf;

    public PentahoOrcInputFormat(NamedCluster namedCluster) {
        this.conf = namedCluster == null ? new Configuration() : this.inClassloader(() -> {
            ConfigurationProxy confProxy = new ConfigurationProxy();
            confProxy.addResource("hive-site.xml");
            ShimConfigsLoader.addConfigsAsResources(namedCluster.getName(), arg_0 -> ((Configuration)confProxy).addResource(arg_0));
            return confProxy;
        });
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) {
        Objects.requireNonNull(this.fileName, NOT_NULL_MSG);
        Objects.requireNonNull(this.inputFields, NOT_NULL_MSG);
        return this.inClassloader(() -> new PentahoOrcRecordReader(this.fileName, this.conf, this.inputFields));
    }

    public List<IOrcInputField> readSchema() {
        return this.inClassloader(() -> this.readSchema(PentahoOrcRecordReader.getReader(Objects.requireNonNull(this.fileName, NOT_NULL_MSG), this.conf)));
    }

    private List<IOrcInputField> readSchema(Reader orcReader) {
        OrcSchemaConverter orcSchemaConverter = new OrcSchemaConverter();
        List<IOrcInputField> orcInputFields = orcSchemaConverter.buildInputFields(this.readTypeDescription(orcReader));
        OrcMetaDataReader orcMetaDataReader = new OrcMetaDataReader(orcReader);
        orcMetaDataReader.read(orcInputFields);
        return orcInputFields;
    }

    private TypeDescription readTypeDescription(Reader orcReader) {
        return orcReader.getSchema();
    }

    public void setSchema(List<IOrcInputField> inputFields) {
        this.inputFields = inputFields;
    }

    public void setInputFile(String fileName) {
        this.fileName = S3NCredentialUtils.scrubFilePathIfNecessary(fileName);
    }
}

