/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.api.internal.hbase;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.internal.hbase.HBaseBytesUtilShim;
import org.pentaho.hadoop.shim.api.internal.hbase.Mapping;

public class HBaseValueMeta
extends ValueMeta {
    private static Class<?> PKG = HBaseValueMeta.class;
    public static final String SEPARATOR = ",";
    protected String m_tableName;
    protected String m_mappingName;
    protected String m_columnFamily;
    protected String m_columnName;
    protected boolean m_isKey;
    protected boolean m_isLongOrDouble = true;

    public HBaseValueMeta(String name, int type, int length, int precision) throws IllegalArgumentException {
        super(name, type, length, precision);
        String[] parts = name.split(SEPARATOR);
        if (parts.length < 2) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.ConfigError", (String[])new String[0]));
        }
        if (parts.length > 3) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.ProblemParsingColumnDesc", (String[])new String[0]));
        }
        this.setColumnFamily(parts[0]);
        this.setColumnName(parts[1]);
        if (parts.length == 2) {
            this.setAlias(name);
        } else {
            this.setAlias(parts[2]);
        }
    }

    public void setTableName(String tableName) {
        this.m_tableName = tableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setMappingName(String mappingName) {
        this.m_mappingName = mappingName;
    }

    public String getMappingName() {
        return this.m_mappingName;
    }

    public void setColumnFamily(String family) {
        this.m_columnFamily = family;
    }

    public String getColumnFamily() {
        return this.m_columnFamily;
    }

    public void setAlias(String alias) {
        this.setName(alias);
    }

    public String getAlias() {
        return this.getName();
    }

    public void setColumnName(String columnName) {
        this.m_columnName = columnName;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public void setHBaseTypeFromString(String hbaseType) throws IllegalArgumentException {
        if (hbaseType.equalsIgnoreCase("Integer")) {
            this.setType(ValueMeta.getType((String)hbaseType));
            this.setIsLongOrDouble(false);
            return;
        }
        if (hbaseType.equalsIgnoreCase("Long")) {
            this.setType(ValueMeta.getType((String)"Integer"));
            this.setIsLongOrDouble(true);
            return;
        }
        if (hbaseType.equals("Float")) {
            this.setType(ValueMeta.getType((String)"Number"));
            this.setIsLongOrDouble(false);
            return;
        }
        if (hbaseType.equals("Double")) {
            this.setType(ValueMeta.getType((String)"Number"));
            this.setIsLongOrDouble(true);
            return;
        }
        int type = ValueMeta.getType((String)hbaseType);
        if (type == 0) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownType", (String[])new String[]{hbaseType}));
        }
        this.setType(type);
    }

    public String getHBaseTypeDesc() {
        if (this.isInteger()) {
            return this.getIsLongOrDouble() ? "Long" : "Integer";
        }
        if (this.isNumber()) {
            return this.getIsLongOrDouble() ? "Double" : "Float";
        }
        return ValueMeta.getTypeDesc((int)this.getType());
    }

    public void setIsLongOrDouble(boolean ld) {
        this.m_isLongOrDouble = ld;
    }

    public boolean getIsLongOrDouble() {
        return this.m_isLongOrDouble;
    }

    public void setKey(boolean key) {
        this.m_isKey = key;
    }

    public boolean isKey() {
        return this.m_isKey;
    }

    public static byte[] encodeKeyValue(Object keyValue, ValueMetaInterface keyMeta, Mapping.KeyType keyType, HBaseBytesUtilShim bytesUtil) throws KettleException {
        byte[] result = null;
        switch (keyType) {
            case STRING: {
                String stringKey = keyMeta.getString(keyValue);
                result = HBaseValueMeta.encodeKeyValue(stringKey, keyType, bytesUtil);
                break;
            }
            case DATE: 
            case UNSIGNED_DATE: {
                Date dateKey = keyMeta.getDate(keyValue);
                if (keyType == Mapping.KeyType.UNSIGNED_DATE && dateKey.getTime() < 0L) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnsignedDate", (String[])new String[0]));
                }
                result = HBaseValueMeta.encodeKeyValue(dateKey, keyType, bytesUtil);
                break;
            }
            case INTEGER: 
            case UNSIGNED_INTEGER: {
                int keyInt = keyMeta.getInteger(keyValue).intValue();
                if (keyType == Mapping.KeyType.UNSIGNED_INTEGER && keyInt < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnsignedIngteger", (String[])new String[0]));
                }
                result = HBaseValueMeta.encodeKeyValue(new Integer(keyInt), keyType, bytesUtil);
                break;
            }
            case LONG: 
            case UNSIGNED_LONG: {
                long keyLong = keyMeta.getInteger(keyValue);
                if (keyType == Mapping.KeyType.UNSIGNED_LONG && keyLong < 0L) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnsignedLong", (String[])new String[0]));
                }
                result = HBaseValueMeta.encodeKeyValue(new Long(keyLong), keyType, bytesUtil);
                break;
            }
            case BINARY: {
                byte[] keyBinary = keyMeta.getBinary(keyValue);
                result = HBaseValueMeta.encodeKeyValue(keyBinary, keyType, bytesUtil);
            }
        }
        if (result == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTableKeyType", (String[])new String[0]));
        }
        return result;
    }

    public static byte[] encodeKeyValue(Object keyValue, Mapping.KeyType keyType, HBaseBytesUtilShim bytesUtil) throws KettleException {
        if (keyType == Mapping.KeyType.STRING) {
            return HBaseValueMeta.encodeKeyValue((String)keyValue, keyType, bytesUtil);
        }
        if (keyType == Mapping.KeyType.BINARY && keyValue instanceof byte[]) {
            return (byte[])keyValue;
        }
        if (keyType == Mapping.KeyType.UNSIGNED_LONG || keyType == Mapping.KeyType.UNSIGNED_DATE) {
            if (keyValue == null) {
                return bytesUtil.toBytes(0L);
            }
            long longVal = keyType == Mapping.KeyType.UNSIGNED_LONG ? ((Number)keyValue).longValue() : ((Date)keyValue).getTime();
            if (longVal < 0L) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnsignedDateLong", (String[])new String[0]));
            }
            return bytesUtil.toBytes(longVal);
        }
        if (keyType == Mapping.KeyType.UNSIGNED_INTEGER) {
            if (keyValue == null) {
                return bytesUtil.toBytes(0);
            }
            if (((Number)keyValue).intValue() < 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnsignedIngteger", (String[])new String[0]));
            }
            return bytesUtil.toBytes(((Number)keyValue).intValue());
        }
        if (keyType == Mapping.KeyType.INTEGER) {
            if (keyValue == null) {
                return bytesUtil.toBytes(0);
            }
            int bound = ((Number)keyValue).intValue();
            return bytesUtil.toBytes(bound ^= Integer.MIN_VALUE);
        }
        if (keyType == Mapping.KeyType.LONG || keyType == Mapping.KeyType.DATE) {
            if (keyValue == null) {
                return bytesUtil.toBytes(0L);
            }
            long bound = keyType == Mapping.KeyType.DATE ? ((Date)keyValue).getTime() : ((Number)keyValue).longValue();
            return bytesUtil.toBytes(bound ^= Long.MIN_VALUE);
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTableKeyType", (String[])new String[0]));
    }

    public static byte[] encodeKeyValue(String keyValue, Mapping.KeyType keyType, HBaseBytesUtilShim bytesUtil) throws KettleException {
        if (keyType == Mapping.KeyType.STRING) {
            if (Const.isEmpty((String)keyValue)) {
                return bytesUtil.toBytes("");
            }
            return bytesUtil.toBytes(keyValue);
        }
        if (keyType == Mapping.KeyType.BINARY) {
            if (Const.isEmpty((String)keyValue)) {
                return new byte[1];
            }
            return bytesUtil.toBytesBinary(keyValue);
        }
        if (keyType == Mapping.KeyType.UNSIGNED_LONG || keyType == Mapping.KeyType.UNSIGNED_DATE) {
            if (Const.isEmpty((String)keyValue)) {
                return bytesUtil.toBytes(0L);
            }
            if (keyType == Mapping.KeyType.UNSIGNED_DATE) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.CantParseDateNoFormat", (String[])new String[0]));
            }
            return bytesUtil.toBytes(Long.parseLong(keyValue));
        }
        if (keyType == Mapping.KeyType.UNSIGNED_INTEGER) {
            if (Const.isEmpty((String)keyValue)) {
                return bytesUtil.toBytes(0);
            }
            return bytesUtil.toBytes(Integer.parseInt(keyValue));
        }
        if (keyType == Mapping.KeyType.INTEGER) {
            if (Const.isEmpty((String)keyValue)) {
                return bytesUtil.toBytes(0);
            }
            int bound = Integer.parseInt(keyValue);
            return bytesUtil.toBytes(bound ^= Integer.MIN_VALUE);
        }
        if (keyType == Mapping.KeyType.LONG || keyType == Mapping.KeyType.DATE) {
            if (Const.isEmpty((String)keyValue)) {
                return bytesUtil.toBytes(0L);
            }
            if (keyType == Mapping.KeyType.DATE) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.CantParseDateNoFormat", (String[])new String[0]));
            }
            long bound = Long.parseLong(keyValue);
            return bytesUtil.toBytes(bound ^= Long.MIN_VALUE);
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTableKeyType", (String[])new String[0]));
    }

    public static Object decodeKeyValue(byte[] rawKey, Mapping tableMapping, HBaseBytesUtilShim bytesUtil) throws KettleException {
        Mapping.KeyType keyType = tableMapping.getKeyType();
        if (rawKey == null) {
            return null;
        }
        if (keyType == Mapping.KeyType.BINARY) {
            return rawKey;
        }
        if (keyType == Mapping.KeyType.STRING) {
            return bytesUtil.toString(rawKey);
        }
        if (keyType == Mapping.KeyType.UNSIGNED_LONG || keyType == Mapping.KeyType.UNSIGNED_DATE) {
            if (keyType == Mapping.KeyType.UNSIGNED_DATE) {
                return new Date(bytesUtil.toLong(rawKey));
            }
            return new Long(bytesUtil.toLong(rawKey));
        }
        if (keyType == Mapping.KeyType.UNSIGNED_INTEGER) {
            return new Long(bytesUtil.toInt(rawKey));
        }
        if (keyType == Mapping.KeyType.INTEGER) {
            int tempInt = bytesUtil.toInt(rawKey);
            return new Long(tempInt ^= Integer.MIN_VALUE);
        }
        if (keyType == Mapping.KeyType.LONG || keyType == Mapping.KeyType.DATE) {
            long tempLong = bytesUtil.toLong(rawKey);
            tempLong ^= Long.MIN_VALUE;
            if (keyType == Mapping.KeyType.DATE) {
                return new Date(tempLong);
            }
            return new Long(tempLong);
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTableKeyType", (String[])new String[0]));
    }

    public static byte[] encodeColumnValue(Object columnValue, ValueMetaInterface colMeta, HBaseValueMeta mappingColMeta, HBaseBytesUtilShim bytesUtil) throws KettleException {
        byte[] encoded = null;
        switch (mappingColMeta.getType()) {
            case 2: {
                String toEncode = colMeta.getString(columnValue);
                encoded = bytesUtil.toBytes(toEncode);
                break;
            }
            case 5: {
                Long l = colMeta.getInteger(columnValue);
                if (mappingColMeta.getIsLongOrDouble()) {
                    encoded = bytesUtil.toBytes(l);
                    break;
                }
                encoded = bytesUtil.toBytes(l.intValue());
                break;
            }
            case 1: {
                Double d = colMeta.getNumber(columnValue);
                if (mappingColMeta.getIsLongOrDouble()) {
                    encoded = bytesUtil.toBytes(d);
                    break;
                }
                encoded = bytesUtil.toBytes(d.floatValue());
                break;
            }
            case 3: {
                Date date = colMeta.getDate(columnValue);
                encoded = bytesUtil.toBytes(date.getTime());
                break;
            }
            case 4: {
                Boolean b = colMeta.getBoolean(columnValue);
                String boolString = b != false ? "Y" : "N";
                encoded = bytesUtil.toBytes(boolString);
                break;
            }
            case 6: {
                BigDecimal bd = colMeta.getBigNumber(columnValue);
                String bds = bd.toString();
                encoded = bytesUtil.toBytes(bds);
                break;
            }
            case 7: {
                try {
                    encoded = HBaseValueMeta.encodeObject(columnValue);
                    break;
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnableToSerialize", (String[])new String[]{colMeta.getName()}), (Throwable)e);
                }
            }
            case 8: {
                encoded = colMeta.getBinary(columnValue);
            }
        }
        if (encoded == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTypeForColumn", (String[])new String[0]));
        }
        return encoded;
    }

    public static Object decodeColumnValue(byte[] rawColValue, HBaseValueMeta columnMeta, HBaseBytesUtilShim bytesUtil) throws KettleException {
        if (rawColValue == null) {
            return null;
        }
        if (columnMeta.isString()) {
            String convertedString = bytesUtil.toString(rawColValue);
            if (columnMeta.getStorageType() == 2) {
                Object[] legalVals = columnMeta.getIndex();
                int foundIndex = -1;
                for (int i = 0; i < legalVals.length; ++i) {
                    if (!legalVals[i].toString().trim().equals(convertedString.trim())) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex >= 0) {
                    return new Integer(foundIndex);
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.IllegalIndexedColumnValue", (String[])new String[]{convertedString, columnMeta.getAlias()}));
            }
            return convertedString;
        }
        if (columnMeta.isNumber()) {
            if (rawColValue.length == bytesUtil.getSizeOfFloat()) {
                float floatResult = bytesUtil.toFloat(rawColValue);
                return new Double(floatResult);
            }
            if (rawColValue.length == bytesUtil.getSizeOfDouble()) {
                return new Double(bytesUtil.toDouble(rawColValue));
            }
        }
        if (columnMeta.isInteger()) {
            if (rawColValue.length == bytesUtil.getSizeOfInt()) {
                int intResult = bytesUtil.toInt(rawColValue);
                return new Long(intResult);
            }
            if (rawColValue.length == bytesUtil.getSizeOfLong()) {
                return new Long(bytesUtil.toLong(rawColValue));
            }
            if (rawColValue.length == bytesUtil.getSizeOfShort()) {
                short tempShort = bytesUtil.toShort(rawColValue);
                return new Long(tempShort);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.IllegalIntegerLength", (String[])new String[0]));
        }
        if (columnMeta.isBoolean()) {
            Boolean result = HBaseValueMeta.decodeBoolFromString(rawColValue, bytesUtil);
            if (result == null) {
                result = HBaseValueMeta.decodeBoolFromNumber(rawColValue, bytesUtil);
            }
            if (result != null) {
                return result;
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnableToDecodeBoolean", (String[])new String[0]));
        }
        if (columnMeta.isBigNumber()) {
            BigDecimal result = HBaseValueMeta.decodeBigDecimal(rawColValue, bytesUtil);
            if (result == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnableToDecodeBigDecimal", (String[])new String[0]));
            }
            return result;
        }
        if (columnMeta.isSerializableType()) {
            Object result = HBaseValueMeta.decodeObject(rawColValue);
            if (result == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnableToDeserializeObject", (String[])new String[0]));
            }
            return result;
        }
        if (columnMeta.isBinary()) {
            return rawColValue;
        }
        if (columnMeta.isDate()) {
            if (rawColValue.length != bytesUtil.getSizeOfLong()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.DateValueLengthNotEqualToLong", (String[])new String[0]));
            }
            long millis = bytesUtil.toLong(rawColValue);
            Date d = new Date(millis);
            return d;
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.UnknownTypeForColumn", (String[])new String[0]));
    }

    public static Object decodeObject(byte[] rawEncoded) {
        if (rawEncoded == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(rawEncoded);
            BufferedInputStream buf = new BufferedInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(buf);
            Object result = ois.readObject();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static BigDecimal decodeBigDecimal(byte[] rawEncoded, HBaseBytesUtilShim bytesUtil) {
        String tempString = bytesUtil.toString(rawEncoded);
        try {
            BigDecimal result = new BigDecimal(tempString);
            return result;
        }
        catch (NumberFormatException result) {
            Object obj = HBaseValueMeta.decodeObject(rawEncoded);
            if (obj != null) {
                try {
                    BigDecimal result2 = (BigDecimal)obj;
                    return result2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static byte[] encodeObject(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream buf = new BufferedOutputStream(bos);
        ObjectOutputStream oos = new ObjectOutputStream(buf);
        oos.writeObject(obj);
        buf.flush();
        return bos.toByteArray();
    }

    public static byte[] encodeBigDecimal(BigDecimal decimal) throws IOException {
        return HBaseValueMeta.encodeObject(decimal);
    }

    public static Boolean decodeBoolFromString(byte[] rawEncoded, HBaseBytesUtilShim bytesUtil) {
        String tempString = bytesUtil.toString(rawEncoded);
        if (tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("N") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("NO") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("FALSE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("F") || tempString.equalsIgnoreCase("1") || tempString.equalsIgnoreCase("0")) {
            return tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("1");
        }
        return null;
    }

    public static Boolean decodeBoolFromNumber(byte[] rawEncoded, HBaseBytesUtilShim bytesUtil) {
        short tempShort;
        byte val;
        if (rawEncoded == null) {
            return null;
        }
        if (rawEncoded.length == bytesUtil.getSizeOfByte() && ((val = rawEncoded[0]) == 0 || val == 1)) {
            return new Boolean(val == 1);
        }
        if (rawEncoded.length == bytesUtil.getSizeOfShort() && ((tempShort = bytesUtil.toShort(rawEncoded)) == 0 || tempShort == 1)) {
            return new Boolean(tempShort == 1);
        }
        if (rawEncoded.length == bytesUtil.getSizeOfInt() || rawEncoded.length == bytesUtil.getSizeOfFloat()) {
            int tempInt = bytesUtil.toInt(rawEncoded);
            if (tempInt == 1 || tempInt == 0) {
                return new Boolean(tempInt == 1);
            }
            float tempFloat = bytesUtil.toFloat(rawEncoded);
            if (tempFloat == 0.0f || tempFloat == 1.0f) {
                return new Boolean(tempFloat == 1.0f);
            }
        }
        if (rawEncoded.length == bytesUtil.getSizeOfLong() || rawEncoded.length == bytesUtil.getSizeOfDouble()) {
            long tempLong = bytesUtil.toLong(rawEncoded);
            if (tempLong == 0L || tempLong == 1L) {
                return new Boolean(tempLong == 1L);
            }
            double tempDouble = bytesUtil.toDouble(rawEncoded);
            if (tempDouble == 0.0 || tempDouble == 1.0) {
                return new Boolean(tempDouble == 1.0);
            }
        }
        return null;
    }

    public static Object[] stringIndexListToObjects(String list) throws IllegalArgumentException {
        if (list == null) {
            return null;
        }
        Object[] labels = list.replace("{", "").replace("}", "").split(SEPARATOR);
        if (labels.length < 1) {
            throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)"HBaseValueMeta.Error.IndexedColumnZeroLabels", (String[])new String[0]));
        }
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = ((String)labels[i]).trim();
        }
        return labels;
    }

    public static String objectIndexValuesToString(Object[] values) {
        if (values == null) {
            return "{}";
        }
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < values.length; ++i) {
            if (i < values.length - 1) {
                result.append(values[i].toString().trim()).append(SEPARATOR);
                continue;
            }
            result.append(values[i].toString().trim()).append("}");
        }
        return result.toString();
    }
}

