/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hdfs;

import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileStatusImpl;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemCallable;
import com.pentaho.big.data.bundles.impl.shim.hdfs.HadoopFileSystemPathImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileStatus;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystem;
import org.pentaho.hadoop.shim.api.hdfs.HadoopFileSystemPath;

public class HadoopFileSystemImpl
implements HadoopFileSystem {
    protected HadoopFileSystemCallable hadoopFileSystemCallable;
    private NamedCluster namedCluster;

    public HadoopFileSystemImpl(HadoopFileSystemCallable hadoopFileSystemCallable) {
        this.hadoopFileSystemCallable = hadoopFileSystemCallable;
    }

    public OutputStream append(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().append(new Path(path.getPath()));
            }
        });
    }

    public OutputStream create(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<OutputStream>(){

            @Override
            public OutputStream call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().create(new Path(path.getPath()));
            }
        });
    }

    public boolean delete(final HadoopFileSystemPath path, final boolean arg1) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().delete(new Path(path.getPath()), arg1);
            }
        });
    }

    public HadoopFileStatus getFileStatus(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<HadoopFileStatus>(){

            @Override
            public HadoopFileStatus call() throws IOException {
                return new HadoopFileStatusImpl(HadoopFileSystemImpl.this.getFileSystem().getFileStatus(new Path(path.getPath())));
            }
        });
    }

    public boolean mkdirs(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().mkdirs(new Path(path.getPath()));
            }
        });
    }

    public InputStream open(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().open(new Path(path.getPath()));
            }
        });
    }

    public boolean rename(final HadoopFileSystemPath path, final HadoopFileSystemPath path2) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().rename(new Path(path.getPath()), new Path(path2.getPath()));
            }
        });
    }

    public void setTimes(final HadoopFileSystemPath path, final long mtime, final long atime) throws IOException {
        this.callAndWrapExceptions(new IOExceptionCallable<Void>(){

            @Override
            public Void call() throws IOException {
                HadoopFileSystemImpl.this.getFileSystem().setTimes(new Path(path.getPath()), mtime, atime);
                return null;
            }
        });
    }

    public HadoopFileStatus[] listStatus(final HadoopFileSystemPath path) throws IOException {
        FileStatus[] fileStatuses = this.callAndWrapExceptions(new IOExceptionCallable<FileStatus[]>(){

            @Override
            public FileStatus[] call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().listStatus(new Path(path.getPath()));
            }
        });
        if (fileStatuses == null) {
            return null;
        }
        HadoopFileStatus[] result = new HadoopFileStatus[fileStatuses.length];
        for (int i = 0; i < fileStatuses.length; ++i) {
            result[i] = new HadoopFileStatusImpl(fileStatuses[i]);
        }
        return result;
    }

    public HadoopFileSystemPath getPath(String path) {
        return new HadoopFileSystemPathImpl(new Path(path));
    }

    public HadoopFileSystemPath getHomeDirectory() {
        return new HadoopFileSystemPathImpl(this.getFileSystem().getHomeDirectory());
    }

    public HadoopFileSystemPath makeQualified(HadoopFileSystemPath hadoopFileSystemPath) {
        return new HadoopFileSystemPathImpl(this.getFileSystem().makeQualified(HadoopFileSystemPathImpl.toHadoopFileSystemPathImpl(hadoopFileSystemPath).getRawPath()));
    }

    public void chmod(final HadoopFileSystemPath hadoopFileSystemPath, int permissions) throws IOException {
        final int owner = permissions / 100;
        if (owner < 0 || owner > 7) {
            throw new IllegalArgumentException("Expected owner permissions between 0 and 7");
        }
        final int group = (permissions - owner * 100) / 10;
        if (group < 0 || group > 7) {
            throw new IllegalArgumentException("Expected group permissions between 0 and 7");
        }
        final int other = permissions - owner * 100 - group * 10;
        if (other < 0 || other > 7) {
            throw new IllegalArgumentException("Expected other permissions between 0 and 7");
        }
        this.callAndWrapExceptions(new IOExceptionCallable<Void>(){

            @Override
            public Void call() throws IOException {
                HadoopFileSystemImpl.this.getFileSystem().setPermission(HadoopFileSystemPathImpl.toHadoopFileSystemPathImpl(hadoopFileSystemPath).getRawPath(), new FsPermission(FsAction.values()[owner], FsAction.values()[group], FsAction.values()[other]));
                return null;
            }
        });
    }

    public boolean exists(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                return HadoopFileSystemImpl.this.getFileSystem().exists(HadoopFileSystemPathImpl.toHadoopFileSystemPathImpl(path).getRawPath());
            }
        });
    }

    public HadoopFileSystemPath resolvePath(final HadoopFileSystemPath path) throws IOException {
        return this.callAndWrapExceptions(new IOExceptionCallable<HadoopFileSystemPath>(){

            @Override
            public HadoopFileSystemPath call() throws IOException {
                return new HadoopFileSystemPathImpl(HadoopFileSystemImpl.this.getFileSystem().getFileStatus(HadoopFileSystemPathImpl.toHadoopFileSystemPathImpl(path).getRawPath()).getPath());
            }
        });
    }

    public String getFsDefaultName() {
        return this.getFileSystem().getConf().get("fs.defaultFS", this.getFileSystem().getConf().get("fs.default.name"));
    }

    public void setProperty(String name, String value) {
        this.getFileSystem().getConf().set(name, value);
    }

    public String getProperty(String name, String defaultValue) {
        return this.getFileSystem().getConf().get(name, defaultValue);
    }

    public <T> T callAndWrapExceptions(IOExceptionCallable<T> ioExceptionCallable) throws IOException {
        try {
            return ioExceptionCallable.call();
        }
        catch (AccessControlException e) {
            throw new org.pentaho.hadoop.shim.api.hdfs.exceptions.AccessControlException(e.getMessage(), (Throwable)e);
        }
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    protected FileSystem getFileSystem() {
        return this.hadoopFileSystemCallable.getFileSystem();
    }

    protected static interface IOExceptionCallable<T> {
        public T call() throws IOException;
    }
}

