/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.scoring;

import org.pentaho.di.scoring.WekaScoringModel;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.UpdateableClusterer;
import weka.core.BatchPredictor;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.Remove;

class WekaScoringClusterer
extends WekaScoringModel {
    private Clusterer m_model;
    private Remove m_ignoredAtts;
    private String m_ignoredString;

    public WekaScoringClusterer(Object model) {
        super(model);
    }

    public void setAttributesToIgnore(int[] attsToIgnore) throws Exception {
        Instances headerI = this.getHeader();
        this.m_ignoredAtts = new Remove();
        this.m_ignoredAtts.setAttributeIndicesArray(attsToIgnore);
        this.m_ignoredAtts.setInvertSelection(false);
        this.m_ignoredAtts.setInputFormat(headerI);
        StringBuffer temp = new StringBuffer();
        temp.append("Attributes ignored by clusterer:\n\n");
        for (int i = 0; i < attsToIgnore.length; ++i) {
            temp.append(headerI.attribute(attsToIgnore[i]).name() + "\n");
        }
        temp.append("\n\n");
        this.m_ignoredString = temp.toString();
    }

    @Override
    public void setModel(Object model) {
        this.m_model = (Clusterer)model;
    }

    @Override
    public Object getModel() {
        return this.m_model;
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        if (this.m_ignoredAtts != null) {
            inst = this.applyFilter(inst);
        }
        return this.m_model.clusterInstance(inst);
    }

    @Override
    public boolean update(Instance inst) throws Exception {
        if (this.isUpdateableModel()) {
            if (this.m_ignoredAtts != null) {
                inst = this.applyFilter(inst);
            }
            ((UpdateableClusterer)this.m_model).updateClusterer(inst);
            return true;
        }
        return false;
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (this.m_ignoredAtts != null) {
            inst = this.applyFilter(inst);
        }
        return this.m_model.distributionForInstance(inst);
    }

    private Instance applyFilter(Instance inputInstance) throws Exception {
        if (!this.m_ignoredAtts.input(inputInstance)) {
            throw new Exception("[WekaScoring] Filter didn't make the test instance immediately available!");
        }
        this.m_ignoredAtts.batchFinished();
        Instance newInstance = this.m_ignoredAtts.output();
        return newInstance;
    }

    @Override
    public boolean isSupervisedLearningModel() {
        return false;
    }

    @Override
    public boolean isUpdateableModel() {
        return this.m_model instanceof UpdateableClusterer;
    }

    public boolean canProduceProbabilities() {
        return this.m_model instanceof DensityBasedClusterer;
    }

    public int numberOfClusters() throws Exception {
        return this.m_model.numberOfClusters();
    }

    public String toString() {
        String ignored = this.m_ignoredString == null ? "" : this.m_ignoredString;
        return ignored + this.m_model.toString();
    }

    @Override
    public double[] classifyInstances(Instances insts) throws Exception {
        double[][] preds = this.distributionsForInstances(insts);
        double[] result = new double[preds.length];
        for (int i = 0; i < preds.length; ++i) {
            double[] p = preds[i];
            result[i] = Utils.sum((double[])p) <= 0.0 ? Utils.missingValue() : (double)Utils.maxIndex((double[])p);
        }
        return result;
    }

    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        if (!this.isBatchPredictor()) {
            throw new Exception("Weka model cannot produce batch predictions!");
        }
        return ((BatchPredictor)this.m_model).distributionsForInstances(insts);
    }

    @Override
    public boolean isBatchPredictor() {
        return this.m_model instanceof BatchPredictor;
    }
}

