/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import weka.associations.Associator;
import weka.associations.FPGrowth;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.clusterers.Clusterer;
import weka.clusterers.EM;
import weka.core.Utils;
import weka.filters.Filter;
import weka.gui.explorer.ClassifierErrorsPlotInstances;
import weka.gui.explorer.ClustererAssignmentsPlotInstances;

public class ExplorerDefaults
implements Serializable {
    private static final long serialVersionUID = 4954795757927524225L;
    public static final String PROPERTY_FILE = "weka/gui/explorer/Explorer.props";
    protected static Properties PROPERTIES;

    public static String get(String property, String defaultValue) {
        return PROPERTIES.getProperty(property, defaultValue);
    }

    public static void set(String property, String value) {
        PROPERTIES.setProperty(property, value);
    }

    public static final Properties getProperties() {
        return PROPERTIES;
    }

    protected static Object getObject(String property, String defaultValue) {
        return ExplorerDefaults.getObject(property, defaultValue, Object.class);
    }

    protected static Object getObject(String property, String defaultValue, Class cls) {
        Object result = null;
        try {
            String tmpStr = ExplorerDefaults.get(property, defaultValue);
            String[] tmpOptions = Utils.splitOptions(tmpStr);
            if (tmpOptions.length != 0) {
                tmpStr = tmpOptions[0];
                tmpOptions[0] = "";
                result = Utils.forName(cls, tmpStr, tmpOptions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static boolean getInitGenericObjectEditorFilter() {
        return Boolean.parseBoolean(ExplorerDefaults.get("InitGenericObjectEditorFilter", "false"));
    }

    public static String[] getTabs() {
        String tabs = ExplorerDefaults.get("Tabs", "weka.gui.explorer.ClassifierPanel,weka.gui.explorer.ClustererPanel,weka.gui.explorer.AssociationsPanel,weka.gui.explorer.AttributeSelectionPanel,weka.gui.explorer.VisualizePanel");
        String[] result = tabs.split(",");
        return result;
    }

    public static String getInitialDirectory() {
        String result = ExplorerDefaults.get("InitialDirectory", "%c");
        result = result.replaceAll("%t", System.getProperty("java.io.tmpdir"));
        result = result.replaceAll("%h", System.getProperty("user.home"));
        result = result.replaceAll("%c", System.getProperty("user.dir"));
        result = result.replaceAll("%%", System.getProperty("%"));
        return result;
    }

    public static Object getFilter() {
        return ExplorerDefaults.getObject("Filter", "", Filter.class);
    }

    public static Object getClassifier() {
        Object result = ExplorerDefaults.getObject("Classifier", ZeroR.class.getName(), Classifier.class);
        if (result == null) {
            result = new ZeroR();
        }
        return result;
    }

    public static int getClassifierTestMode() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierTestMode", "1"));
    }

    public static int getClassifierCrossvalidationFolds() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierCrossvalidationFolds", "10"));
    }

    public static int getClassifierPercentageSplit() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierPercentageSplit", "66"));
    }

    public static boolean getClassifierOutputModel() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputModel", "true"));
    }

    public static boolean getClassifierOutputPerClassStats() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputPerClassStats", "true"));
    }

    public static boolean getClassifierOutputEntropyEvalMeasures() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputEntropyEvalMeasures", "false"));
    }

    public static boolean getClassifierOutputConfusionMatrix() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputConfusionMatrix", "true"));
    }

    public static boolean getClassifierOutputPredictions() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputPredictions", "false"));
    }

    public static String getClassifierOutputAdditionalAttributes() {
        return ExplorerDefaults.get("ClassifierOutputAdditionalAttributes", "");
    }

    public static boolean getClassifierStorePredictionsForVis() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierStorePredictionsForVis", "true"));
    }

    public static boolean getClassifierCostSensitiveEval() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierCostSensitiveEval", "false"));
    }

    public static int getClassifierRandomSeed() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierRandomSeed", "1"));
    }

    public static boolean getClassifierPreserveOrder() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierPreserveOrder", "false"));
    }

    public static boolean getClassifierOutputSourceCode() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClassifierOutputSourceCode", "false"));
    }

    public static String getClassifierSourceCodeClass() {
        return ExplorerDefaults.get("ClassifierSourceCodeClass", "Foobar");
    }

    public static ClassifierErrorsPlotInstances getClassifierErrorsPlotInstances() {
        ClassifierErrorsPlotInstances result;
        try {
            String[] options = Utils.splitOptions(ExplorerDefaults.get("ClassifierErrorsPlotInstances", "weka.gui.explorer.ClassifierErrorsPlotInstances"));
            String classname = options[0];
            options[0] = "";
            result = (ClassifierErrorsPlotInstances)Utils.forName(ClassifierErrorsPlotInstances.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ClassifierErrorsPlotInstances();
        }
        return result;
    }

    public static int getClassifierErrorsMinimumPlotSizeNumeric() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierErrorsMinimumPlotSizeNumeric", "1"));
    }

    public static int getClassifierErrorsMaximumPlotSizeNumeric() {
        return Integer.parseInt(ExplorerDefaults.get("ClassifierErrorsMaximumPlotSizeNumeric", "20"));
    }

    public static Object getClusterer() {
        Object result = ExplorerDefaults.getObject("Clusterer", EM.class.getName(), Clusterer.class);
        if (result == null) {
            result = new EM();
        }
        return result;
    }

    public static int getClustererTestMode() {
        return Integer.parseInt(ExplorerDefaults.get("ClustererTestMode", "3"));
    }

    public static boolean getClustererStoreClustersForVis() {
        return Boolean.parseBoolean(ExplorerDefaults.get("ClustererStoreClustersForVis", "true"));
    }

    public static ClustererAssignmentsPlotInstances getClustererAssignmentsPlotInstances() {
        ClustererAssignmentsPlotInstances result;
        try {
            String[] options = Utils.splitOptions(ExplorerDefaults.get("ClustererAssignmentsPlotInstances", "weka.gui.explorer.ClustererAssignmentsPlotInstances"));
            String classname = options[0];
            options[0] = "";
            result = (ClustererAssignmentsPlotInstances)Utils.forName(ClustererAssignmentsPlotInstances.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ClustererAssignmentsPlotInstances();
        }
        return result;
    }

    public static Object getAssociator() {
        Object result = ExplorerDefaults.getObject("Associator", FPGrowth.class.getName(), Associator.class);
        if (result == null) {
            result = new FPGrowth();
        }
        return result;
    }

    public static Object getASEvaluator() {
        Object result = ExplorerDefaults.getObject("ASEvaluation", CfsSubsetEval.class.getName(), ASEvaluation.class);
        if (result == null) {
            result = new CfsSubsetEval();
        }
        return result;
    }

    public static Object getASSearch() {
        Object result = ExplorerDefaults.getObject("ASSearch", BestFirst.class.getName(), ASSearch.class);
        if (result == null) {
            result = new BestFirst();
        }
        return result;
    }

    public static int getASTestMode() {
        return Integer.parseInt(ExplorerDefaults.get("ASTestMode", "0"));
    }

    public static int getASCrossvalidationFolds() {
        return Integer.parseInt(ExplorerDefaults.get("ASCrossvalidationFolds", "10"));
    }

    public static int getASRandomSeed() {
        return Integer.parseInt(ExplorerDefaults.get("ASRandomSeed", "1"));
    }

    public static void main(String[] args) {
        System.out.println("\nExplorer defaults:");
        Enumeration<Object> names = PROPERTIES.propertyNames();
        Vector sorted = new Vector();
        while (names.hasMoreElements()) {
            sorted.add(names.nextElement());
        }
        Collections.sort(sorted);
        names = sorted.elements();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            System.out.println("- " + name + ": " + PROPERTIES.getProperty(name, ""));
        }
        System.out.println();
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception e) {
            System.err.println("Problem reading properties. Fix before continuing.");
            e.printStackTrace();
            PROPERTIES = new Properties();
        }
    }
}

