/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.RandomizableClusterer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ManhattanDistance;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SimpleKMeans
extends RandomizableClusterer
implements NumberOfClustersRequestable,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3235809600124455376L;
    private ReplaceMissingValues m_ReplaceMissingFilter;
    private int m_NumClusters = 2;
    private Instances m_ClusterCentroids;
    private Instances m_ClusterStdDevs;
    private int[][][] m_ClusterNominalCounts;
    private int[][] m_ClusterMissingCounts;
    private double[] m_FullMeansOrMediansOrModes;
    private double[] m_FullStdDevs;
    private int[][] m_FullNominalCounts;
    private int[] m_FullMissingCounts;
    private boolean m_displayStdDevs;
    private boolean m_dontReplaceMissing = false;
    private int[] m_ClusterSizes;
    private int m_MaxIterations = 500;
    private int m_Iterations = 0;
    private double[] m_squaredErrors;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();
    private boolean m_PreserveOrder = false;
    protected int[] m_Assignments = null;
    protected boolean m_FastDistanceCalc = false;
    protected boolean m_initializeWithKMeansPlusPlus = false;
    protected int m_executionSlots = 1;
    protected transient ExecutorService m_executorPool;
    protected int m_completed;
    protected int m_failed;

    public SimpleKMeans() {
        this.m_SeedDefault = 10;
        this.setSeed(this.m_SeedDefault);
    }

    protected void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = Executors.newFixedThreadPool(this.m_executionSlots);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "D. Arthur and S. Vassilvitskii");
        result.setValue(TechnicalInformation.Field.TITLE, "k-means++: the advantages of carefull seeding");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the eighteenth annual ACM-SIAM symposium on Discrete algorithms");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.PAGES, "1027-1035");
        return result;
    }

    public String globalInfo() {
        return "Cluster data using the k means algorithm. Can use either the Euclidean distance (default) or the Manhattan distance. If the Manhattan distance is used, then centroids are computed as the component-wise median rather than mean. For more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    protected int launchMoveCentroids(Instances[] clusters) {
        int emptyClusterCount = 0;
        ArrayList<Future<double[]>> results = new ArrayList<Future<double[]>>();
        for (int i = 0; i < this.m_NumClusters; ++i) {
            if (clusters[i].numInstances() == 0) {
                ++emptyClusterCount;
                continue;
            }
            Future<double[]> future = this.m_executorPool.submit(new KMeansComputeCentroidTask(i, clusters[i]));
            results.add(future);
        }
        try {
            for (Future future : results) {
                this.m_ClusterCentroids.add(new DenseInstance(1.0, (double[])future.get()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return emptyClusterCount;
    }

    protected boolean launchAssignToClusters(Instances insts, int[] clusterAssignments) throws Exception {
        int numPerTask = insts.numInstances() / this.m_executionSlots;
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < this.m_executionSlots; ++i) {
            int start = i * numPerTask;
            int n = start + numPerTask;
            if (i == this.m_executionSlots - 1) {
                n = insts.numInstances();
            }
            Future<Boolean> futureKM = this.m_executorPool.submit(new KMeansClusterTask(insts, start, n, clusterAssignments));
            results.add(futureKM);
        }
        boolean converged = true;
        for (Future future : results) {
            if (((Boolean)future.get()).booleanValue()) continue;
            converged = false;
        }
        return converged;
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        int i;
        this.getCapabilities().testWithFail(data);
        this.m_Iterations = 0;
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        Instances instances = new Instances(data);
        instances.setClassIndex(-1);
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_ReplaceMissingFilter);
        }
        this.m_FullMissingCounts = new int[instances.numAttributes()];
        if (this.m_displayStdDevs) {
            this.m_FullStdDevs = new double[instances.numAttributes()];
        }
        this.m_FullNominalCounts = new int[instances.numAttributes()][0];
        this.m_FullMeansOrMediansOrModes = this.moveCentroid(0, instances, false, false);
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            this.m_FullMissingCounts[i2] = instances.attributeStats((int)i2).missingCount;
            if (instances.attribute(i2).isNumeric()) {
                if (this.m_displayStdDevs) {
                    this.m_FullStdDevs[i2] = Math.sqrt(instances.variance(i2));
                }
                if (this.m_FullMissingCounts[i2] != instances.numInstances()) continue;
                this.m_FullMeansOrMediansOrModes[i2] = Double.NaN;
                continue;
            }
            this.m_FullNominalCounts[i2] = instances.attributeStats((int)i2).nominalCounts;
            if (this.m_FullMissingCounts[i2] <= this.m_FullNominalCounts[i2][Utils.maxIndex(this.m_FullNominalCounts[i2])]) continue;
            this.m_FullMeansOrMediansOrModes[i2] = -1.0;
        }
        this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
        int[] clusterAssignments = new int[instances.numInstances()];
        if (this.m_PreserveOrder) {
            this.m_Assignments = clusterAssignments;
        }
        this.m_DistanceFunction.setInstances(instances);
        Random RandomO = new Random(this.getSeed());
        HashMap initC = new HashMap();
        DecisionTableHashKey hk = null;
        Instances initInstances = null;
        initInstances = this.m_PreserveOrder ? new Instances(instances) : instances;
        if (this.m_initializeWithKMeansPlusPlus) {
            this.kMeansPlusPlusInit(initInstances);
        } else {
            for (int j = initInstances.numInstances() - 1; j >= 0; --j) {
                int instIndex = RandomO.nextInt(j + 1);
                hk = new DecisionTableHashKey(initInstances.instance(instIndex), initInstances.numAttributes(), true);
                if (!initC.containsKey(hk)) {
                    this.m_ClusterCentroids.add(initInstances.instance(instIndex));
                    initC.put(hk, null);
                }
                initInstances.swap(j, instIndex);
                if (this.m_ClusterCentroids.numInstances() == this.m_NumClusters) break;
            }
        }
        this.m_NumClusters = this.m_ClusterCentroids.numInstances();
        initInstances = null;
        boolean converged = false;
        Instances[] tempI = new Instances[this.m_NumClusters];
        this.m_squaredErrors = new double[this.m_NumClusters];
        this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        this.m_ClusterMissingCounts = new int[this.m_NumClusters][instances.numAttributes()];
        this.startExecutorPool();
        while (!converged) {
            int emptyClusterCount = 0;
            ++this.m_Iterations;
            converged = true;
            if (this.m_executionSlots <= 1 || instances.numInstances() < 2 * this.m_executionSlots) {
                for (i = 0; i < instances.numInstances(); ++i) {
                    Instance toCluster = instances.instance(i);
                    int newC = this.clusterProcessedInstance(toCluster, false, true);
                    if (newC != clusterAssignments[i]) {
                        converged = false;
                    }
                    clusterAssignments[i] = newC;
                }
            } else {
                converged = this.launchAssignToClusters(instances, clusterAssignments);
            }
            this.m_ClusterCentroids = new Instances(instances, this.m_NumClusters);
            for (i = 0; i < this.m_NumClusters; ++i) {
                tempI[i] = new Instances(instances, 0);
            }
            for (i = 0; i < instances.numInstances(); ++i) {
                tempI[clusterAssignments[i]].add(instances.instance(i));
            }
            if (this.m_executionSlots <= 1 || instances.numInstances() < 2 * this.m_executionSlots) {
                for (i = 0; i < this.m_NumClusters; ++i) {
                    if (tempI[i].numInstances() == 0) {
                        ++emptyClusterCount;
                        continue;
                    }
                    this.moveCentroid(i, tempI[i], true, true);
                }
            } else {
                emptyClusterCount = this.launchMoveCentroids(tempI);
            }
            if (this.m_Iterations == this.m_MaxIterations) {
                converged = true;
            }
            if (emptyClusterCount > 0) {
                this.m_NumClusters -= emptyClusterCount;
                if (converged) {
                    Instances[] t = new Instances[this.m_NumClusters];
                    int index = 0;
                    for (int k = 0; k < tempI.length; ++k) {
                        if (tempI[k].numInstances() <= 0) continue;
                        t[index++] = tempI[k];
                    }
                    tempI = t;
                } else {
                    tempI = new Instances[this.m_NumClusters];
                }
            }
            if (converged) continue;
            this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances.numAttributes()][0];
        }
        if (!this.m_FastDistanceCalc) {
            for (i = 0; i < instances.numInstances(); ++i) {
                this.clusterProcessedInstance(instances.instance(i), true, false);
            }
        }
        if (this.m_displayStdDevs) {
            this.m_ClusterStdDevs = new Instances(instances, this.m_NumClusters);
        }
        this.m_ClusterSizes = new int[this.m_NumClusters];
        for (i = 0; i < this.m_NumClusters; ++i) {
            if (this.m_displayStdDevs) {
                double[] vals2 = new double[instances.numAttributes()];
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    vals2[j] = instances.attribute(j).isNumeric() ? Math.sqrt(tempI[i].variance(j)) : Utils.missingValue();
                }
                this.m_ClusterStdDevs.add(new DenseInstance(1.0, vals2));
            }
            this.m_ClusterSizes[i] = tempI[i].numInstances();
        }
        this.m_executorPool.shutdown();
    }

    protected void kMeansPlusPlusInit(Instances data) throws Exception {
        Random randomO = new Random(this.getSeed());
        HashMap initC = new HashMap();
        int index = randomO.nextInt(data.numInstances());
        this.m_ClusterCentroids.add(data.instance(index));
        DecisionTableHashKey hk = new DecisionTableHashKey(data.instance(index), data.numAttributes(), true);
        initC.put(hk, null);
        int iteration = 0;
        int remainingInstances = data.numInstances() - 1;
        if (this.m_NumClusters > 1) {
            int i;
            double[] distances = new double[data.numInstances()];
            double[] cumProbs = new double[data.numInstances()];
            for (i = 0; i < data.numInstances(); ++i) {
                distances[i] = this.m_DistanceFunction.distance(data.instance(i), this.m_ClusterCentroids.instance(iteration));
            }
            for (i = 1; i < this.m_NumClusters; ++i) {
                int k;
                double[] weights = new double[data.numInstances()];
                System.arraycopy(distances, 0, weights, 0, distances.length);
                Utils.normalize(weights);
                double sumOfProbs = 0.0;
                for (int k2 = 0; k2 < data.numInstances(); ++k2) {
                    cumProbs[k2] = sumOfProbs += weights[k2];
                }
                cumProbs[data.numInstances() - 1] = 1.0;
                double prob = randomO.nextDouble();
                for (k = 0; k < cumProbs.length; ++k) {
                    if (!(prob < cumProbs[k])) continue;
                    Instance candidateCenter = data.instance(k);
                    hk = new DecisionTableHashKey(candidateCenter, data.numAttributes(), true);
                    if (!initC.containsKey(hk)) {
                        initC.put(hk, null);
                        this.m_ClusterCentroids.add(candidateCenter);
                    } else {
                        System.err.println("We shouldn't get here....");
                    }
                    --remainingInstances;
                    break;
                }
                ++iteration;
                if (remainingInstances == 0) break;
                for (k = 0; k < data.numInstances(); ++k) {
                    double newDist;
                    if (!(distances[k] > 0.0) || !((newDist = this.m_DistanceFunction.distance(data.instance(k), this.m_ClusterCentroids.instance(iteration))) < distances[k])) continue;
                    distances[k] = newDist;
                }
            }
        }
    }

    protected double[] moveCentroid(int centroidIndex, Instances members, boolean updateClusterInfo, boolean addToCentroidInstances) {
        double[] vals = new double[members.numAttributes()];
        Instances sortedMembers = null;
        int middle = 0;
        boolean dataIsEven = false;
        if (this.m_DistanceFunction instanceof ManhattanDistance) {
            middle = (members.numInstances() - 1) / 2;
            dataIsEven = members.numInstances() % 2 == 0;
            sortedMembers = this.m_PreserveOrder ? members : new Instances(members);
        }
        for (int j = 0; j < members.numAttributes(); ++j) {
            if (this.m_DistanceFunction instanceof EuclideanDistance || members.attribute(j).isNominal()) {
                vals[j] = members.meanOrMode(j);
            } else if (this.m_DistanceFunction instanceof ManhattanDistance) {
                if (members.numInstances() == 1) {
                    vals[j] = members.instance(0).value(j);
                } else {
                    vals[j] = sortedMembers.kthSmallestValue(j, middle + 1);
                    if (dataIsEven) {
                        vals[j] = (vals[j] + sortedMembers.kthSmallestValue(j, middle + 2)) / 2.0;
                    }
                }
            }
            if (!updateClusterInfo) continue;
            this.m_ClusterMissingCounts[centroidIndex][j] = members.attributeStats((int)j).missingCount;
            this.m_ClusterNominalCounts[centroidIndex][j] = members.attributeStats((int)j).nominalCounts;
            if (members.attribute(j).isNominal()) {
                if (this.m_ClusterMissingCounts[centroidIndex][j] <= this.m_ClusterNominalCounts[centroidIndex][j][Utils.maxIndex(this.m_ClusterNominalCounts[centroidIndex][j])]) continue;
                vals[j] = Utils.missingValue();
                continue;
            }
            if (this.m_ClusterMissingCounts[centroidIndex][j] != members.numInstances()) continue;
            vals[j] = Utils.missingValue();
        }
        if (addToCentroidInstances) {
            this.m_ClusterCentroids.add(new DenseInstance(1.0, vals));
        }
        return vals;
    }

    private int clusterProcessedInstance(Instance instance, boolean updateErrors, boolean useFastDistCalc) {
        double minDist = 2.147483647E9;
        int bestCluster = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double dist = useFastDistCalc ? this.m_DistanceFunction.distance(instance, this.m_ClusterCentroids.instance(i), minDist) : this.m_DistanceFunction.distance(instance, this.m_ClusterCentroids.instance(i));
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = i;
        }
        if (updateErrors) {
            if (this.m_DistanceFunction instanceof EuclideanDistance) {
                minDist *= minDist;
            }
            int n = bestCluster;
            this.m_squaredErrors[n] = this.m_squaredErrors[n] + minDist;
        }
        return bestCluster;
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        Instance inst = null;
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.input(instance);
            this.m_ReplaceMissingFilter.batchFinished();
            inst = this.m_ReplaceMissingFilter.output();
        } else {
            inst = instance;
        }
        return this.clusterProcessedInstance(inst, false, true);
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        result.addElement(new Option("\tInitialize using the k-means++ method.\n", "P", 0, "-P"));
        result.addElement(new Option("\tDisplay std. deviations for centroids.\n", "V", 0, "-V"));
        result.addElement(new Option("\tDon't replace missing values with mean/mode.\n", "M", 0, "-M"));
        result.add(new Option("\tDistance function to use.\n\t(default: weka.core.EuclideanDistance)", "A", 1, "-A <classname and options>"));
        result.add(new Option("\tMaximum number of iterations.\n", "I", 1, "-I <num>"));
        result.addElement(new Option("\tPreserve order of instances.\n", "O", 0, "-O"));
        result.addElement(new Option("\tEnables faster distance calculations, using cut-off values.\n\tDisables the calculation/output of squared errors/distances.\n", "fast", 0, "-fast"));
        result.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    @Override
    public void setNumClusters(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String initializeUsingKMeansPlusPlusMethodTipText() {
        return "Initialize cluster centers using the probabilistic  farthest first method of the k-means++ algorithm";
    }

    public void setInitializeUsingKMeansPlusPlusMethod(boolean k) {
        this.m_initializeWithKMeansPlusPlus = k;
    }

    public boolean getInitializeUsingKMeansPlusPlusMethod() {
        return this.m_initializeWithKMeansPlusPlus;
    }

    public String maxIterationsTipText() {
        return "set maximum number of iterations";
    }

    public void setMaxIterations(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Maximum number of iterations must be > 0");
        }
        this.m_MaxIterations = n;
    }

    public int getMaxIterations() {
        return this.m_MaxIterations;
    }

    public String displayStdDevsTipText() {
        return "Display std deviations of numeric attributes and counts of nominal attributes.";
    }

    public void setDisplayStdDevs(boolean stdD) {
        this.m_displayStdDevs = stdD;
    }

    public boolean getDisplayStdDevs() {
        return this.m_displayStdDevs;
    }

    public String dontReplaceMissingValuesTipText() {
        return "Replace missing values globally with mean/mode.";
    }

    public void setDontReplaceMissingValues(boolean r) {
        this.m_dontReplaceMissing = r;
    }

    public boolean getDontReplaceMissingValues() {
        return this.m_dontReplaceMissing;
    }

    public String distanceFunctionTipText() {
        return "The distance function to use for instances comparison (default: weka.core.EuclideanDistance). ";
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction df) throws Exception {
        if (!(df instanceof EuclideanDistance) && !(df instanceof ManhattanDistance)) {
            throw new Exception("SimpleKMeans currently only supports the Euclidean and Manhattan distances.");
        }
        this.m_DistanceFunction = df;
    }

    public String preserveInstancesOrderTipText() {
        return "Preserve order of instances.";
    }

    public void setPreserveInstancesOrder(boolean r) {
        this.m_PreserveOrder = r;
    }

    public boolean getPreserveInstancesOrder() {
        return this.m_PreserveOrder;
    }

    public String fastDistanceCalcTipText() {
        return "Uses cut-off values for speeding up distance calculation, but suppresses also the calculation and output of the within cluster sum of squared errors/sum of distances.";
    }

    public void setFastDistanceCalc(boolean value) {
        this.m_FastDistanceCalc = value;
    }

    public boolean getFastDistanceCalc() {
        return this.m_FastDistanceCalc;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use. Set equal to the number of available cpu/cores";
    }

    public void setNumExecutionSlots(int slots) {
        this.m_executionSlots = slots;
    }

    public int getNumExecutionSlots() {
        return this.m_executionSlots;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String distFunctionClass;
        this.m_displayStdDevs = Utils.getFlag("V", options);
        this.m_dontReplaceMissing = Utils.getFlag("M", options);
        this.m_initializeWithKMeansPlusPlus = Utils.getFlag('P', options);
        String optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            this.setNumClusters(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption("I", options)).length() != 0) {
            this.setMaxIterations(Integer.parseInt(optionString));
        }
        if ((distFunctionClass = Utils.getOption('A', options)).length() != 0) {
            String[] distFunctionClassSpec = Utils.splitOptions(distFunctionClass);
            if (distFunctionClassSpec.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String className = distFunctionClassSpec[0];
            distFunctionClassSpec[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, className, distFunctionClassSpec));
        } else {
            this.setDistanceFunction(new EuclideanDistance());
        }
        this.m_PreserveOrder = Utils.getFlag("O", options);
        this.m_FastDistanceCalc = Utils.getFlag("fast", options);
        String slotsS = Utils.getOption("num-slots", options);
        if (slotsS.length() > 0) {
            this.setNumExecutionSlots(Integer.parseInt(slotsS));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_initializeWithKMeansPlusPlus) {
            result.add("-P");
        }
        if (this.m_displayStdDevs) {
            result.add("-V");
        }
        if (this.m_dontReplaceMissing) {
            result.add("-M");
        }
        result.add("-N");
        result.add("" + this.getNumClusters());
        result.add("-A");
        result.add((this.m_DistanceFunction.getClass().getName() + " " + Utils.joinOptions(this.m_DistanceFunction.getOptions())).trim());
        result.add("-I");
        result.add("" + this.getMaxIterations());
        if (this.m_PreserveOrder) {
            result.add("-O");
        }
        if (this.m_FastDistanceCalc) {
            result.add("-fast");
        }
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        int i;
        int i2;
        if (this.m_ClusterCentroids == null) {
            return "No clusterer built yet!";
        }
        int maxWidth = 0;
        int maxAttWidth = 0;
        boolean containsNumeric = false;
        for (i2 = 0; i2 < this.m_NumClusters; ++i2) {
            for (int j = 0; j < this.m_ClusterCentroids.numAttributes(); ++j) {
                if (this.m_ClusterCentroids.attribute(j).name().length() > maxAttWidth) {
                    maxAttWidth = this.m_ClusterCentroids.attribute(j).name().length();
                }
                if (!this.m_ClusterCentroids.attribute(j).isNumeric()) continue;
                containsNumeric = true;
                double width = Math.log(Math.abs(this.m_ClusterCentroids.instance(i2).value(j))) / Math.log(10.0);
                if (width < 0.0) {
                    width = 1.0;
                }
                if ((int)(width += 6.0) <= maxWidth) continue;
                maxWidth = (int)width;
            }
        }
        for (i2 = 0; i2 < this.m_ClusterCentroids.numAttributes(); ++i2) {
            String val;
            int j;
            if (!this.m_ClusterCentroids.attribute(i2).isNominal()) continue;
            Attribute a = this.m_ClusterCentroids.attribute(i2);
            for (j = 0; j < this.m_ClusterCentroids.numInstances(); ++j) {
                val = a.value((int)this.m_ClusterCentroids.instance(j).value(i2));
                if (val.length() <= maxWidth) continue;
                maxWidth = val.length();
            }
            for (j = 0; j < a.numValues(); ++j) {
                val = a.value(j) + " ";
                if (val.length() <= maxAttWidth) continue;
                maxAttWidth = val.length();
            }
        }
        if (this.m_displayStdDevs) {
            for (i2 = 0; i2 < this.m_ClusterCentroids.numAttributes(); ++i2) {
                if (!this.m_ClusterCentroids.attribute(i2).isNominal()) continue;
                int maxV = Utils.maxIndex(this.m_FullNominalCounts[i2]);
                int percent = 6;
                String nomV = "" + this.m_FullNominalCounts[i2][maxV];
                if (nomV.length() + percent <= maxWidth) continue;
                maxWidth = nomV.length() + 1;
            }
        }
        for (i2 = 0; i2 < this.m_ClusterSizes.length; ++i2) {
            String size = "(" + this.m_ClusterSizes[i2] + ")";
            if (size.length() <= maxWidth) continue;
            maxWidth = size.length();
        }
        if (this.m_displayStdDevs && maxAttWidth < "missing".length()) {
            maxAttWidth = "missing".length();
        }
        String plusMinus = "+/-";
        maxAttWidth += 2;
        if (this.m_displayStdDevs && containsNumeric) {
            maxWidth += plusMinus.length();
        }
        if (maxAttWidth < "Attribute".length() + 2) {
            maxAttWidth = "Attribute".length() + 2;
        }
        if (maxWidth < "Full Data".length()) {
            maxWidth = "Full Data".length() + 1;
        }
        if (maxWidth < "missing".length()) {
            maxWidth = "missing".length() + 1;
        }
        StringBuffer temp = new StringBuffer();
        temp.append("\nkMeans\n======\n");
        temp.append("\nNumber of iterations: " + this.m_Iterations);
        if (!this.m_FastDistanceCalc) {
            temp.append("\n");
            if (this.m_DistanceFunction instanceof EuclideanDistance) {
                temp.append("Within cluster sum of squared errors: " + Utils.sum(this.m_squaredErrors));
            } else {
                temp.append("Sum of within cluster distances: " + Utils.sum(this.m_squaredErrors));
            }
        }
        if (!this.m_dontReplaceMissing) {
            temp.append("\nMissing values globally replaced with mean/mode");
        }
        temp.append("\n\nCluster centroids:\n");
        temp.append(this.pad("Cluster#", " ", maxAttWidth + (maxWidth * 2 + 2) - "Cluster#".length(), true));
        temp.append("\n");
        temp.append(this.pad("Attribute", " ", maxAttWidth - "Attribute".length(), false));
        temp.append(this.pad("Full Data", " ", maxWidth + 1 - "Full Data".length(), true));
        for (int i3 = 0; i3 < this.m_NumClusters; ++i3) {
            String clustNum = "" + i3;
            temp.append(this.pad(clustNum, " ", maxWidth + 1 - clustNum.length(), true));
        }
        temp.append("\n");
        String cSize = "(" + Utils.sum(this.m_ClusterSizes) + ")";
        temp.append(this.pad(cSize, " ", maxAttWidth + maxWidth + 1 - cSize.length(), true));
        for (i = 0; i < this.m_NumClusters; ++i) {
            cSize = "(" + this.m_ClusterSizes[i] + ")";
            temp.append(this.pad(cSize, " ", maxWidth + 1 - cSize.length(), true));
        }
        temp.append("\n");
        temp.append(this.pad("", "=", maxAttWidth + (maxWidth * (this.m_ClusterCentroids.numInstances() + 1) + this.m_ClusterCentroids.numInstances() + 1), true));
        temp.append("\n");
        for (i = 0; i < this.m_ClusterCentroids.numAttributes(); ++i) {
            String valMeanMode;
            String attName = this.m_ClusterCentroids.attribute(i).name();
            temp.append(attName);
            for (int j = 0; j < maxAttWidth - attName.length(); ++j) {
                temp.append(" ");
            }
            if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                if (this.m_FullMeansOrMediansOrModes[i] == -1.0) {
                    valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                } else {
                    String strVal = this.m_ClusterCentroids.attribute(i).value((int)this.m_FullMeansOrMediansOrModes[i]);
                    valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
            } else if (Double.isNaN(this.m_FullMeansOrMediansOrModes[i])) {
                valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
            } else {
                String strVal = Utils.doubleToString(this.m_FullMeansOrMediansOrModes[i], maxWidth, 4).trim();
                valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
            }
            temp.append(valMeanMode);
            for (int j = 0; j < this.m_NumClusters; ++j) {
                if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                    if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                        valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                    } else {
                        String strVal = this.m_ClusterCentroids.attribute(i).value((int)this.m_ClusterCentroids.instance(j).value(i));
                        valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                    }
                } else if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                    valMeanMode = this.pad("missing", " ", maxWidth + 1 - "missing".length(), true);
                } else {
                    String strVal = Utils.doubleToString(this.m_ClusterCentroids.instance(j).value(i), maxWidth, 4).trim();
                    valMeanMode = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
                temp.append(valMeanMode);
            }
            temp.append("\n");
            if (!this.m_displayStdDevs) continue;
            String stdDevVal = "";
            if (this.m_ClusterCentroids.attribute(i).isNominal()) {
                Attribute a = this.m_ClusterCentroids.attribute(i);
                for (int j = 0; j < a.numValues(); ++j) {
                    String val = "  " + a.value(j);
                    temp.append(this.pad(val, " ", maxAttWidth + 1 - val.length(), false));
                    int count = this.m_FullNominalCounts[i][j];
                    int percent = (int)((double)this.m_FullNominalCounts[i][j] / (double)Utils.sum(this.m_ClusterSizes) * 100.0);
                    String percentS = "" + percent + "%)";
                    percentS = this.pad(percentS, " ", 5 - percentS.length(), true);
                    stdDevVal = "" + count + " (" + percentS;
                    stdDevVal = this.pad(stdDevVal, " ", maxWidth + 1 - stdDevVal.length(), true);
                    temp.append(stdDevVal);
                    for (int k = 0; k < this.m_NumClusters; ++k) {
                        count = this.m_ClusterNominalCounts[k][i][j];
                        percent = (int)((double)this.m_ClusterNominalCounts[k][i][j] / (double)this.m_ClusterSizes[k] * 100.0);
                        percentS = "" + percent + "%)";
                        percentS = this.pad(percentS, " ", 5 - percentS.length(), true);
                        stdDevVal = "" + count + " (" + percentS;
                        stdDevVal = this.pad(stdDevVal, " ", maxWidth + 1 - stdDevVal.length(), true);
                        temp.append(stdDevVal);
                    }
                    temp.append("\n");
                }
                if (this.m_FullMissingCounts[i] > 0) {
                    temp.append(this.pad("  missing", " ", maxAttWidth + 1 - "  missing".length(), false));
                    int count = this.m_FullMissingCounts[i];
                    int percent = (int)((double)this.m_FullMissingCounts[i] / (double)Utils.sum(this.m_ClusterSizes) * 100.0);
                    String percentS = "" + percent + "%)";
                    percentS = this.pad(percentS, " ", 5 - percentS.length(), true);
                    stdDevVal = "" + count + " (" + percentS;
                    stdDevVal = this.pad(stdDevVal, " ", maxWidth + 1 - stdDevVal.length(), true);
                    temp.append(stdDevVal);
                    for (int k = 0; k < this.m_NumClusters; ++k) {
                        count = this.m_ClusterMissingCounts[k][i];
                        percent = (int)((double)this.m_ClusterMissingCounts[k][i] / (double)this.m_ClusterSizes[k] * 100.0);
                        percentS = "" + percent + "%)";
                        percentS = this.pad(percentS, " ", 5 - percentS.length(), true);
                        stdDevVal = "" + count + " (" + percentS;
                        stdDevVal = this.pad(stdDevVal, " ", maxWidth + 1 - stdDevVal.length(), true);
                        temp.append(stdDevVal);
                    }
                    temp.append("\n");
                }
                temp.append("\n");
                continue;
            }
            if (Double.isNaN(this.m_FullMeansOrMediansOrModes[i])) {
                stdDevVal = this.pad("--", " ", maxAttWidth + maxWidth + 1 - 2, true);
            } else {
                String strVal = plusMinus + Utils.doubleToString(this.m_FullStdDevs[i], maxWidth, 4).trim();
                stdDevVal = this.pad(strVal, " ", maxWidth + maxAttWidth + 1 - strVal.length(), true);
            }
            temp.append(stdDevVal);
            for (int j = 0; j < this.m_NumClusters; ++j) {
                if (this.m_ClusterCentroids.instance(j).isMissing(i)) {
                    stdDevVal = this.pad("--", " ", maxWidth + 1 - 2, true);
                } else {
                    String strVal = plusMinus + Utils.doubleToString(this.m_ClusterStdDevs.instance(j).value(i), maxWidth, 4).trim();
                    stdDevVal = this.pad(strVal, " ", maxWidth + 1 - strVal.length(), true);
                }
                temp.append(stdDevVal);
            }
            temp.append("\n\n");
        }
        temp.append("\n\n");
        return temp.toString();
    }

    private String pad(String source, String padChar, int length, boolean leftPad) {
        StringBuffer temp = new StringBuffer();
        if (leftPad) {
            for (int i = 0; i < length; ++i) {
                temp.append(padChar);
            }
            temp.append(source);
        } else {
            temp.append(source);
            for (int i = 0; i < length; ++i) {
                temp.append(padChar);
            }
        }
        return temp.toString();
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    public Instances getClusterStandardDevs() {
        return this.m_ClusterStdDevs;
    }

    public int[][][] getClusterNominalCounts() {
        return this.m_ClusterNominalCounts;
    }

    public double getSquaredError() {
        if (this.m_FastDistanceCalc) {
            return Double.NaN;
        }
        return Utils.sum(this.m_squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.m_ClusterSizes;
    }

    public int[] getAssignments() throws Exception {
        if (!this.m_PreserveOrder) {
            throw new Exception("The assignments are only available when order of instances is preserved (-O)");
        }
        if (this.m_Assignments == null) {
            throw new Exception("No assignments made.");
        }
        return this.m_Assignments;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9757 $");
    }

    public static void main(String[] args) {
        SimpleKMeans.runClusterer(new SimpleKMeans(), args);
    }

    private class KMeansClusterTask
    implements Callable<Boolean> {
        protected int m_start;
        protected int m_end;
        protected Instances m_inst;
        protected int[] m_clusterAssignments;

        public KMeansClusterTask(Instances inst, int start, int end, int[] clusterAssignments) {
            this.m_start = start;
            this.m_end = end;
            this.m_inst = inst;
            this.m_clusterAssignments = clusterAssignments;
        }

        @Override
        public Boolean call() {
            boolean converged = true;
            for (int i = this.m_start; i < this.m_end; ++i) {
                Instance toCluster = this.m_inst.instance(i);
                int newC = this.clusterInstance(toCluster);
                if (newC != this.m_clusterAssignments[i]) {
                    converged = false;
                }
                this.m_clusterAssignments[i] = newC;
            }
            return converged;
        }

        protected int clusterInstance(Instance inst) {
            double minDist = 2.147483647E9;
            int bestCluster = 0;
            for (int i = 0; i < SimpleKMeans.this.m_NumClusters; ++i) {
                double dist = SimpleKMeans.this.m_DistanceFunction.distance(inst, SimpleKMeans.this.m_ClusterCentroids.instance(i), minDist);
                if (!(dist < minDist)) continue;
                minDist = dist;
                bestCluster = i;
            }
            return bestCluster;
        }
    }

    private class KMeansComputeCentroidTask
    implements Callable<double[]> {
        protected Instances m_cluster;
        protected int m_centroidIndex;

        public KMeansComputeCentroidTask(int centroidIndex, Instances cluster) {
            this.m_cluster = cluster;
            this.m_centroidIndex = centroidIndex;
        }

        @Override
        public double[] call() {
            return SimpleKMeans.this.moveCentroid(this.m_centroidIndex, this.m_cluster, true, false);
        }
    }
}

