/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class FileOpenSaveDialog
extends ThinDialog {
    public static final String STATE_SAVE = "save";
    public static final String STATE_OPEN = "open";
    public static final String SELECT_FOLDER = "selectFolder";
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final int OPTIONS = 68720;
    private static final String THIN_CLIENT_HOST = "THIN_CLIENT_HOST";
    private static final String THIN_CLIENT_PORT = "THIN_CLIENT_PORT";
    private static final String LOCALHOST = "localhost";
    public static final String PATH = "path";
    public static final String CONNECTION = "connection";
    public static final String PROVIDER = "provider";
    public static final String FILTER = "filter";
    public static final String ORIGIN = "origin";
    public static final String FILENAME = "filename";
    public static final String FILE_TYPE = "fileType";
    private String objectId;
    private String name;
    private String path;
    private String parentPath;
    private String type;
    private String connection;
    private String provider;

    public FileOpenSaveDialog(Shell shell, int width, int height) {
        super(shell, width, height);
    }

    public void open(String path, String connection, String provider, String state, String title, String filter, String origin) {
        this.open(path, state, title, filter, origin, null, "");
    }

    private void addParameter(String path, List<NameValuePair> parameters, String name, String value) {
        if (!Utils.isEmpty((CharSequence)path) && !Utils.isEmpty((CharSequence)value)) {
            parameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    public void open(String path, String connection, String provider, String state, String title, String filter, String origin, String filename, String fileType) {
        try {
            path = URLEncoder.encode(path, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder clientPath = new StringBuilder();
        clientPath.append(FileOpenSaveDialog.getClientPath());
        clientPath.append(!Utils.isEmpty((CharSequence)state) ? "#/" + state : "");
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        this.addParameter(path, parameters, PATH, path);
        this.addParameter(path, parameters, CONNECTION, connection);
        this.addParameter(path, parameters, PROVIDER, provider);
        this.addParameter(path, parameters, FILTER, filter);
        this.addParameter(path, parameters, ORIGIN, origin);
        this.addParameter(path, parameters, FILENAME, filename);
        this.addParameter(path, parameters, FILE_TYPE, fileType);
        String queryParams = URLEncodedUtils.format(parameters, (String)"UTF-8");
        clientPath.append("?").append(queryParams);
        super.createDialog(title != null ? title : StringUtils.capitalize((String)state), FileOpenSaveDialog.getRepoURL(clientPath.toString()), 68720, LOGO);
        this.dialog.setMinimumSize(545, 458);
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                FileOpenSaveDialog.this.browser.dispose();
                FileOpenSaveDialog.this.dialog.close();
                FileOpenSaveDialog.this.dialog.dispose();
                return true;
            }
        };
        new BrowserFunction(this.browser, "select"){

            public Object function(Object[] arguments) {
                FileOpenSaveDialog.this.setProperties(arguments);
                FileOpenSaveDialog.this.browser.dispose();
                FileOpenSaveDialog.this.dialog.close();
                FileOpenSaveDialog.this.dialog.dispose();
                return true;
            }
        };
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void setProperties(Object[] arguments) {
        this.objectId = (String)arguments[0];
        this.name = (String)arguments[1];
        this.path = (String)arguments[2];
        this.parentPath = (String)arguments[3];
        this.connection = (String)arguments[4];
        this.provider = (String)arguments[5];
        this.type = (String)arguments[6];
    }

    private static String getClientPath() {
        Properties properties = new Properties();
        try (InputStream inputStream = FileOpenSaveDialog.class.getClassLoader().getResourceAsStream("project.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("CLIENT_PATH");
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getRepoURL(String path) {
        Integer port;
        String host;
        try {
            host = FileOpenSaveDialog.getKettleProperty(THIN_CLIENT_HOST);
            port = Integer.valueOf(FileOpenSaveDialog.getKettleProperty(THIN_CLIENT_PORT));
        }
        catch (Exception e) {
            host = LOCALHOST;
            port = FileOpenSaveDialog.getOsgiServicePort();
        }
        return "http://" + host + ":" + port + path;
    }

    private static String getKettleProperty(String propertyName) throws KettleException {
        return System.getProperty(propertyName);
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

