/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class MetricsSource {
    public static final Log LOG = LogFactory.getLog(MetricsSource.class);
    private long lastTimestamp = 0L;
    private int lastQueueSize = 0;
    private String id;
    private final MetricsReplicationSourceSource singleSourceSource;
    private final MetricsReplicationSourceSource globalSourceSource;

    public MetricsSource(String id) {
        this.id = id;
        this.singleSourceSource = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getSource(id);
        this.globalSourceSource = ((MetricsReplicationSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class)).getGlobalSource();
    }

    public void setAgeOfLastShippedOp(long timestamp) {
        long age = EnvironmentEdgeManager.currentTime() - timestamp;
        this.singleSourceSource.setLastShippedAge(age);
        this.globalSourceSource.setLastShippedAge(Math.max(age, this.globalSourceSource.getLastShippedAge()));
        this.lastTimestamp = timestamp;
    }

    public void refreshAgeOfLastShippedOp() {
        if (this.lastTimestamp > 0L) {
            this.setAgeOfLastShippedOp(this.lastTimestamp);
        }
    }

    public void setSizeOfLogQueue(int size) {
        this.singleSourceSource.setSizeOfLogQueue(size);
        this.globalSourceSource.incrSizeOfLogQueue(size - this.lastQueueSize);
        this.lastQueueSize = size;
    }

    private void incrLogEditsRead(long delta) {
        this.singleSourceSource.incrLogReadInEdits(delta);
        this.globalSourceSource.incrLogReadInEdits(delta);
    }

    public void incrLogEditsRead() {
        this.incrLogEditsRead(1L);
    }

    public void incrLogEditsFiltered(long delta) {
        this.singleSourceSource.incrLogEditsFiltered(delta);
        this.globalSourceSource.incrLogEditsFiltered(delta);
    }

    public void incrLogEditsFiltered() {
        this.incrLogEditsFiltered(1L);
    }

    public void shipBatch(long batchSize, int sizeInKB) {
        this.singleSourceSource.incrBatchesShipped(1);
        this.globalSourceSource.incrBatchesShipped(1);
        this.singleSourceSource.incrOpsShipped(batchSize);
        this.globalSourceSource.incrOpsShipped(batchSize);
        this.singleSourceSource.incrShippedKBs((long)sizeInKB);
        this.globalSourceSource.incrShippedKBs((long)sizeInKB);
    }

    public void incrLogReadInBytes(long readInBytes) {
        this.singleSourceSource.incrLogReadInBytes(readInBytes);
        this.globalSourceSource.incrLogReadInBytes(readInBytes);
    }

    public void clear() {
        this.singleSourceSource.clear();
        this.globalSourceSource.decrSizeOfLogQueue(this.lastQueueSize);
        this.lastQueueSize = 0;
    }

    public Long getAgeOfLastShippedOp() {
        return this.singleSourceSource.getLastShippedAge();
    }

    public int getSizeOfLogQueue() {
        return this.lastQueueSize;
    }

    public long getTimeStampOfLastShippedOp() {
        return this.lastTimestamp;
    }

    public String getPeerID() {
        return this.id;
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.singleSourceSource.incrUnknownFileLengthForClosedWAL();
        this.globalSourceSource.incrUnknownFileLengthForClosedWAL();
    }

    public void incrUncleanlyClosedWALs() {
        this.singleSourceSource.incrUncleanlyClosedWALs();
        this.globalSourceSource.incrUncleanlyClosedWALs();
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.singleSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
        this.globalSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
    }

    public void incrRestartedWALReading() {
        this.singleSourceSource.incrRestartedWALReading();
        this.globalSourceSource.incrRestartedWALReading();
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.singleSourceSource.incrRepeatedFileBytes(bytes);
        this.globalSourceSource.incrRepeatedFileBytes(bytes);
    }

    public void incrCompletedWAL() {
        this.singleSourceSource.incrCompletedWAL();
        this.globalSourceSource.incrCompletedWAL();
    }

    public void incrCompletedRecoveryQueue() {
        this.singleSourceSource.incrCompletedRecoveryQueue();
        this.globalSourceSource.incrCompletedRecoveryQueue();
    }
}

