/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionForNominalTimeJPAExecutor
implements JPAExecutor<CoordinatorActionBean> {
    private String jobId = null;
    private Date nominalTime = null;

    public CoordJobGetActionForNominalTimeJPAExecutor(String jobId, Date nominalTime) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.nominalTime = nominalTime;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionForNominalTimeJPAExecutor";
    }

    @Override
    public CoordinatorActionBean execute(EntityManager em) throws JPAExecutorException {
        Query q = em.createNamedQuery("GET_ACTION_FOR_NOMINALTIME");
        q.setParameter("jobId", (Object)this.jobId);
        q.setParameter("nominalTime", (Object)new Timestamp(this.nominalTime.getTime()));
        List actions = q.getResultList();
        CoordinatorActionBean action = null;
        if (actions.size() <= 0) {
            throw new JPAExecutorException(ErrorCode.E0605, DateUtils.formatDateOozieTZ(this.nominalTime));
        }
        action = (CoordinatorActionBean)actions.get(0);
        return action;
    }
}

