/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.SQLStatementsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.SharedObjectSyncUtil;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.dialog.GetJobSQLProgressDialog;
import org.pentaho.di.ui.spoon.dialog.GetSQLProgressDialog;
import org.pentaho.di.ui.spoon.tree.provider.DBConnectionFolderProvider;

public class SpoonDBDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private DatabaseDialog databaseDialog;
    private SharedObjectSyncUtil sharedObjectSyncUtil;

    public SpoonDBDelegate(Spoon spoon) {
        super(spoon);
    }

    public void setSharedObjectSyncUtil(SharedObjectSyncUtil sharedObjectSyncUtil) {
        this.sharedObjectSyncUtil = sharedObjectSyncUtil;
    }

    public void sqlConnection(DatabaseMeta databaseMeta) {
        SQLEditor sql = new SQLEditor((VariableSpace)databaseMeta, this.spoon.getShell(), 0, databaseMeta, DBCache.getInstance(), "");
        sql.open();
    }

    public void editConnection(DatabaseMeta databaseMeta) {
        HasDatabasesInterface hasDatabasesInterface = this.spoon.getActiveHasDatabasesInterface();
        if (hasDatabasesInterface == null) {
            return;
        }
        String originalName = databaseMeta.getName();
        this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
        this.getDatabaseDialog().setDatabases(hasDatabasesInterface.getDatabases());
        String newname = this.getDatabaseDialog().open();
        if (!Utils.isEmpty((CharSequence)newname)) {
            databaseMeta.setName(originalName);
            databaseMeta = this.getDatabaseDialog().getDatabaseMeta();
            if (!newname.equals(originalName)) {
                if (DatabaseMeta.findDatabase((List)hasDatabasesInterface.getDatabases(), (String)newname) != null) {
                    databaseMeta.setName(newname.trim());
                    DatabaseDialog.showDatabaseExistsDialog(this.spoon.getShell(), databaseMeta);
                    databaseMeta.setName(originalName);
                    databaseMeta.setDisplayName(originalName);
                    return;
                }
            }
            databaseMeta.setName(newname.trim());
            databaseMeta.setDisplayName(newname.trim());
            this.saveConnection(databaseMeta, "Modification by user");
            if (databaseMeta.isShared()) {
                this.sharedObjectSyncUtil.synchronizeConnections(databaseMeta, originalName);
            }
            this.saveConnection(databaseMeta, "Modification by user");
            if (databaseMeta.isShared()) {
                this.sharedObjectSyncUtil.synchronizeConnections(databaseMeta, originalName);
            }
            this.refreshTree();
        }
        this.spoon.setShellText();
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.spoon.getShell());
        return this.databaseDialog;
    }

    public void dupeConnection(HasDatabasesInterface hasDatabasesInterface, DatabaseMeta databaseMeta) {
        String name = databaseMeta.getName();
        int pos = hasDatabasesInterface.indexOfDatabase(databaseMeta);
        if (databaseMeta != null) {
            DatabaseMeta databaseMetaCopy = (DatabaseMeta)databaseMeta.clone();
            String dupename = BaseMessages.getString(PKG, (String)"Spoon.Various.DupeName", (String[])new String[0]) + name;
            databaseMetaCopy.setName(dupename);
            this.getDatabaseDialog().setDatabaseMeta(databaseMetaCopy);
            String newname = this.getDatabaseDialog().open();
            if (newname != null) {
                databaseMetaCopy.verifyAndModifyDatabaseName(hasDatabasesInterface.getDatabases(), name);
                hasDatabasesInterface.addDatabase(pos + 1, databaseMetaCopy);
                this.spoon.addUndoNew((UndoInterface)hasDatabasesInterface, new DatabaseMeta[]{(DatabaseMeta)databaseMetaCopy.clone()}, new int[]{pos + 1});
                this.saveConnection(databaseMetaCopy, "Modification by user");
                this.refreshTree();
            }
        }
    }

    public void clipConnection(DatabaseMeta databaseMeta) {
        String xml = XMLHandler.getXMLHeader() + databaseMeta.getXML();
        GUIResource.getInstance().toClipboard(xml);
    }

    public void delConnection(HasDatabasesInterface hasDatabasesInterface, DatabaseMeta db) {
        int pos = hasDatabasesInterface.indexOfDatabase(db);
        boolean worked = false;
        Repository rep = this.spoon.getRepository();
        if (rep != null) {
            if (!rep.getSecurityProvider().isReadOnly()) {
                try {
                    rep.deleteDatabaseMeta(db.getName());
                    worked = true;
                }
                catch (KettleException dbe) {
                    new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingConnection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingConnection.Message", (String[])new String[]{db.getName()}), (Exception)((Object)dbe));
                }
            } else {
                new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingConnection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingConnection.Message", (String[])new String[]{db.getName()}), (Exception)((Object)new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyUser", (String[])new String[0]))));
            }
        }
        if (this.spoon.getRepository() == null || worked) {
            this.spoon.addUndoDelete((UndoInterface)hasDatabasesInterface, new DatabaseMeta[]{(DatabaseMeta)db.clone()}, new int[]{pos});
            hasDatabasesInterface.removeDatabase(pos);
            DBCache.getInstance().clear(db.getName());
        }
        this.refreshTree();
        this.spoon.setShellText();
    }

    public String[] exploreDB(DatabaseMeta databaseMeta, boolean aLook) {
        List databases = null;
        HasDatabasesInterface activeHasDatabasesInterface = this.spoon.getActiveHasDatabasesInterface();
        if (activeHasDatabasesInterface != null) {
            databases = activeHasDatabasesInterface.getDatabases();
        }
        DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.spoon.getShell(), 0, databaseMeta, databases, aLook);
        std.open();
        return new String[]{std.getSchemaName(), std.getTableName()};
    }

    public void clearDBCache(DatabaseMeta databaseMeta) {
        if (databaseMeta != null) {
            DBCache.getInstance().clear(databaseMeta.getName());
        } else {
            DBCache.getInstance().clear(null);
        }
    }

    public void getSQL() {
        JobMeta jobMeta;
        TransMeta transMeta = this.spoon.getActiveTransformation();
        if (transMeta != null) {
            this.getTransSQL(transMeta);
        }
        if ((jobMeta = this.spoon.getActiveJob()) != null) {
            this.getJobSQL(jobMeta);
        }
    }

    public void getTransSQL(TransMeta transMeta) {
        GetSQLProgressDialog pspd = new GetSQLProgressDialog(this.spoon.getShell(), transMeta);
        List<SQLStatement> stats = pspd.open();
        if (stats != null) {
            if (stats.size() > 0) {
                StepMeta esi;
                SQLStatementsDialog ssd = new SQLStatementsDialog(this.spoon.getShell(), Variables.getADefaultVariableSpace(), 0, stats);
                String sn = ssd.open();
                if (sn != null && (esi = transMeta.findStep(sn)) != null) {
                    this.spoon.delegates.steps.editStep(transMeta, esi);
                }
            } else {
                MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoSQLNeedEexecuted.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoSQLNeedEexecuted.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public void getJobSQL(JobMeta jobMeta) {
        GetJobSQLProgressDialog pspd = new GetJobSQLProgressDialog(this.spoon.getShell(), jobMeta, this.spoon.getRepository());
        List<SQLStatement> stats = pspd.open();
        if (stats != null) {
            if (stats.size() > 0) {
                SQLStatementsDialog ssd = new SQLStatementsDialog(this.spoon.getShell(), (VariableSpace)jobMeta, 0, stats);
                ssd.open();
            } else {
                MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobNoSQLNeedEexecuted.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobNoSQLNeedEexecuted.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTable(DatabaseMeta sourceDBInfo, DatabaseMeta targetDBInfo, String tablename) {
        try {
            TransMeta meta = new TransMeta();
            meta.addDatabase(sourceDBInfo);
            meta.addDatabase(targetDBInfo);
            String note = BaseMessages.getString(PKG, (String)"Spoon.Message.Note.ReadInformationFromTableOnDB", (String[])new String[]{tablename, sourceDBInfo.getDatabaseName()}) + Const.CR;
            note = note + BaseMessages.getString(PKG, (String)"Spoon.Message.Note.WriteInformationToTableOnDB", (String[])new String[]{tablename, targetDBInfo.getDatabaseName()});
            NotePadMeta ni = new NotePadMeta(note, 150, 10, -1, -1);
            meta.addNote(ni);
            String fromstepname = BaseMessages.getString(PKG, (String)"Spoon.Message.Note.ReadFromTable", (String[])new String[]{tablename});
            TableInputMeta tii = new TableInputMeta();
            tii.setDatabaseMeta(sourceDBInfo);
            tii.setSQL("SELECT * FROM " + tablename);
            PluginRegistry registry = PluginRegistry.getInstance();
            String fromstepid = registry.getPluginId(StepPluginType.class, (Object)tii);
            StepMeta fromstep = new StepMeta(fromstepid, fromstepname, (StepMetaInterface)tii);
            fromstep.setLocation(150, 100);
            fromstep.setDraw(true);
            fromstep.setDescription(BaseMessages.getString(PKG, (String)"Spoon.Message.Note.ReadInformationFromTableOnDB", (String[])new String[]{tablename, sourceDBInfo.getDatabaseName()}));
            meta.addStep(fromstep);
            Database sourceDB = new Database(loggingObject, sourceDBInfo);
            sourceDB.shareVariablesWith((VariableSpace)meta);
            sourceDB.connect();
            try {
                String name;
                RowMetaInterface fields = sourceDB.getTableFields(tablename);
                int nrReserved = targetDBInfo.getNrReservedWords(fields);
                if (nrReserved > 0) {
                    SelectValuesMeta svi = new SelectValuesMeta();
                    svi.allocate(0, 0, nrReserved);
                    int nr = 0;
                    for (int i = 0; i < fields.size(); ++i) {
                        ValueMetaInterface v = fields.getValueMeta(i);
                        if (!targetDBInfo.isReservedWord(v.getName())) continue;
                        if (svi.getMeta()[nr] == null) {
                            svi.getMeta()[nr] = new SelectMetadataChange((StepAttributesInterface)svi);
                        }
                        svi.getMeta()[nr].setName(v.getName());
                        svi.getMeta()[nr].setRename(targetDBInfo.quoteField(v.getName()));
                        ++nr;
                    }
                    String selstepname = BaseMessages.getString(PKG, (String)"Spoon.Message.Note.HandleReservedWords", (String[])new String[0]);
                    String selstepid = registry.getPluginId(StepPluginType.class, (Object)svi);
                    StepMeta selstep = new StepMeta(selstepid, selstepname, (StepMetaInterface)svi);
                    selstep.setLocation(350, 100);
                    selstep.setDraw(true);
                    selstep.setDescription(BaseMessages.getString(PKG, (String)"Spoon.Message.Note.RenamesReservedWords", (String[])new String[]{targetDBInfo.getPluginId()}));
                    meta.addStep(selstep);
                    TransHopMeta shi = new TransHopMeta(fromstep, selstep);
                    meta.addTransHop(shi);
                    fromstep = selstep;
                }
                String tostepname = BaseMessages.getString(PKG, (String)"Spoon.Message.Note.WriteToTable", (String[])new String[]{tablename});
                TableOutputMeta toi = new TableOutputMeta();
                toi.setDatabaseMeta(targetDBInfo);
                toi.setTableName(tablename);
                toi.setCommitSize(200);
                toi.setTruncateTable(true);
                String tostepid = registry.getPluginId(StepPluginType.class, (Object)toi);
                StepMeta tostep = new StepMeta(tostepid, tostepname, (StepMetaInterface)toi);
                tostep.setLocation(550, 100);
                tostep.setDraw(true);
                tostep.setDescription(BaseMessages.getString(PKG, (String)"Spoon.Message.Note.WriteInformationToTableOnDB2", (String[])new String[]{tablename, targetDBInfo.getDatabaseName()}));
                meta.addStep(tostep);
                TransHopMeta hi = new TransHopMeta(fromstep, tostep);
                meta.addTransHop(hi);
                String transName = name = "Copy table from [" + sourceDBInfo.getName() + "] to [" + targetDBInfo.getName() + "]";
                int nr = 1;
                if (this.spoon.delegates.trans.getTransformation(transName) != null) {
                    transName = name + " " + ++nr;
                }
                meta.setName(transName);
                this.spoon.delegates.trans.addTransGraph(meta);
                this.spoon.refreshGraph();
                this.refreshTree();
            }
            finally {
                sourceDB.disconnect();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)new KettleException(e.getMessage(), (Throwable)e)));
            return false;
        }
        return true;
    }

    public void saveConnection(DatabaseMeta db, String versionComment) {
        Repository rep = this.spoon.getRepository();
        if (rep != null) {
            if (!rep.getSecurityProvider().isReadOnly()) {
                try {
                    if (Utils.isEmpty((CharSequence)versionComment)) {
                        rep.insertLogEntry("Saving database '" + db.getName() + "'");
                    } else {
                        rep.insertLogEntry("Save database : " + versionComment);
                    }
                    rep.save((RepositoryElementInterface)db, versionComment, null);
                    this.spoon.getLog().logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.SavedDatabaseConnection", (String[])new String[]{db.getDatabaseName()}));
                    db.setChanged(false);
                }
                catch (KettleException ke) {
                    new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Message", (String[])new String[]{db.getDatabaseName()}), (Exception)((Object)ke));
                }
            } else {
                new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableSave.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Message", (String[])new String[]{db.getDatabaseName()}), (Exception)((Object)new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]))));
            }
        }
    }

    public void newConnection() {
        HasDatabasesInterface hasDatabasesInterface = this.spoon.getActiveHasDatabasesInterface();
        if (hasDatabasesInterface == null && this.spoon.rep == null) {
            return;
        }
        this.newConnection(hasDatabasesInterface);
    }

    public void newConnection(HasDatabasesInterface hasDatabasesInterface) {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        if (hasDatabasesInterface instanceof VariableSpace) {
            databaseMeta.shareVariablesWith((VariableSpace)hasDatabasesInterface);
        } else {
            databaseMeta.initializeVariablesFrom(null);
        }
        this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
        String con_name = this.getDatabaseDialog().open();
        if (!Utils.isEmpty((CharSequence)con_name)) {
            con_name = con_name.trim();
            databaseMeta.setName(con_name);
            databaseMeta.setDisplayName(con_name);
            databaseMeta = this.getDatabaseDialog().getDatabaseMeta();
            if (DatabaseMeta.findDatabase((List)hasDatabasesInterface.getDatabases(), (String)con_name) == null) {
                hasDatabasesInterface.addDatabase(databaseMeta);
                this.spoon.addUndoNew((UndoInterface)hasDatabasesInterface, new DatabaseMeta[]{(DatabaseMeta)databaseMeta.clone()}, new int[]{hasDatabasesInterface.indexOfDatabase(databaseMeta)});
                if (this.spoon.rep != null) {
                    try {
                        if (this.spoon.rep.getSecurityProvider().isReadOnly()) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                        }
                        this.spoon.rep.save((RepositoryElementInterface)databaseMeta, "Creation of initial version", null);
                    }
                    catch (KettleException e) {
                        new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Message", (String[])new String[]{databaseMeta.getName()}), (Exception)((Object)e));
                    }
                }
                this.refreshTree();
            } else {
                DatabaseDialog.showDatabaseExistsDialog(this.spoon.getShell(), databaseMeta);
            }
        }
    }

    private void refreshTree() {
        this.spoon.refreshTree(DBConnectionFolderProvider.STRING_CONNECTIONS);
    }
}

