/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import java.util.ArrayList;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterValueDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ConditionEditor
extends Composite {
    private static Class<?> PKG = ConditionEditor.class;
    private static final int X_PADDING = 18;
    private static final String STRING_NOT = BaseMessages.getString(PKG, (String)"ConditionEditor.StringNot", (String[])new String[0]);
    private static final String STRING_UP = BaseMessages.getString(PKG, (String)"ConditionEditor.StringUp", (String[])new String[0]);
    private static final int AREA_NONE = 0;
    private static final int AREA_BACKGROUND = 1;
    private static final int AREA_NOT = 2;
    private static final int AREA_CONDITION = 3;
    private static final int AREA_SUBCONDITION = 4;
    private static final int AREA_OPERATOR = 5;
    private static final int AREA_UP = 6;
    private static final int AREA_LEFT = 7;
    private static final int AREA_FUNCTION = 8;
    private static final int AREA_RIGHT_VALUE = 9;
    private static final int AREA_RIGHT_EXACT = 10;
    private static final int AREA_ICON_ADD = 11;
    protected Composite widget = this;
    private Shell shell;
    private Display display;
    private Condition active_condition;
    private Color bg;
    private Color white;
    private Color black;
    private Color red;
    private Color green;
    private Color blue;
    private Color gray;
    private Font fixed;
    private Image imageAdd;
    private Rectangle size_not;
    private Rectangle size_widget;
    private Rectangle size_and_not;
    private Rectangle size_up;
    private Rectangle size_left;
    private Rectangle size_fn;
    private Rectangle size_rightval;
    private Rectangle size_rightex;
    private Rectangle[] size_cond;
    private Rectangle[] size_oper;
    private Rectangle size_add;
    private Rectangle maxdrawn;
    private int hover_condition;
    private int hover_operator;
    private boolean hover_not;
    private boolean hover_up;
    private boolean hover_left;
    private boolean hover_fn;
    private boolean hover_rightval;
    private boolean hover_rightex;
    private int previous_area;
    private int previous_area_nr;
    private ArrayList<Condition> parents;
    private RowMetaInterface fields;
    private int max_field_length;
    private ScrollBar sbVertical;
    private ScrollBar sbHorizontal;
    private int offsetx;
    private int offsety;
    private ArrayList<ModifyListener> modListeners;
    private String messageString;
    private Menu mPop;

    public ConditionEditor(Composite composite, int arg1, Condition co, RowMetaInterface inputFields) {
        super(composite, arg1 | 0x40000 | 0x200 | 0x100);
        this.active_condition = co;
        this.fields = inputFields;
        this.imageAdd = GUIResource.getInstance().getImage("ui/images/Add.svg");
        this.modListeners = new ArrayList();
        this.sbVertical = this.getVerticalBar();
        this.sbHorizontal = this.getHorizontalBar();
        this.offsetx = 0;
        this.offsety = 0;
        this.maxdrawn = null;
        this.size_not = null;
        this.size_widget = null;
        this.size_cond = null;
        this.previous_area = -1;
        this.previous_area_nr = -1;
        this.parents = new ArrayList();
        this.hover_condition = -1;
        this.hover_operator = -1;
        this.hover_not = false;
        this.hover_up = false;
        this.hover_left = false;
        this.hover_fn = false;
        this.hover_rightval = false;
        this.hover_rightex = false;
        this.getMaxFieldLength();
        this.shell = composite.getShell();
        this.display = this.shell.getDisplay();
        this.bg = GUIResource.getInstance().getColorBackground();
        this.fixed = GUIResource.getInstance().getFontFixed();
        this.white = GUIResource.getInstance().getColorWhite();
        this.black = GUIResource.getInstance().getColorBlack();
        this.red = GUIResource.getInstance().getColorRed();
        this.green = GUIResource.getInstance().getColorGreen();
        this.blue = GUIResource.getInstance().getColorBlue();
        this.gray = GUIResource.getInstance().getColorDarkGray();
        this.widget.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Rectangle r = ConditionEditor.this.widget.getBounds();
                if (r.width > 0 && r.height > 0) {
                    ConditionEditor.this.repaint(pe.gc, r.width, r.height);
                }
            }
        });
        this.widget.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point screen = new Point(e.x, e.y);
                int area = ConditionEditor.this.getAreaCode(screen);
                int nr = 0;
                boolean need_redraw = false;
                ConditionEditor.this.hover_condition = -1;
                ConditionEditor.this.hover_operator = -1;
                ConditionEditor.this.hover_not = false;
                ConditionEditor.this.hover_up = false;
                ConditionEditor.this.hover_left = false;
                ConditionEditor.this.hover_fn = false;
                ConditionEditor.this.hover_rightval = false;
                ConditionEditor.this.hover_rightex = false;
                if (area != 11) {
                    ConditionEditor.this.setToolTipText(null);
                } else {
                    ConditionEditor.this.setToolTipText(BaseMessages.getString((Class)PKG, (String)"ConditionEditor.AddCondition.Label", (String[])new String[0]));
                }
                switch (area) {
                    case 2: {
                        ConditionEditor.this.hover_not = true;
                        nr = 1;
                        break;
                    }
                    case 6: {
                        ConditionEditor.this.hover_up = ConditionEditor.this.getLevel() > 0;
                        nr = 1;
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 4: {
                        ConditionEditor.this.hover_condition = ConditionEditor.this.getNrSubcondition(screen);
                        nr = ConditionEditor.this.hover_condition;
                        break;
                    }
                    case 5: {
                        ConditionEditor.this.hover_operator = ConditionEditor.this.getNrOperator(screen);
                        nr = ConditionEditor.this.hover_operator;
                        break;
                    }
                    case 7: {
                        ConditionEditor.this.hover_left = true;
                        nr = 1;
                        break;
                    }
                    case 8: {
                        ConditionEditor.this.hover_fn = true;
                        nr = 1;
                        break;
                    }
                    case 9: {
                        ConditionEditor.this.hover_rightval = true;
                        nr = 1;
                        break;
                    }
                    case 10: {
                        ConditionEditor.this.hover_rightex = true;
                        nr = 1;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
                if (area != ConditionEditor.this.previous_area || nr != ConditionEditor.this.previous_area_nr) {
                    need_redraw = true;
                }
                if (need_redraw) {
                    ConditionEditor.this.offsetx = -ConditionEditor.this.sbHorizontal.getSelection();
                    ConditionEditor.this.offsety = -ConditionEditor.this.sbVertical.getSelection();
                    ConditionEditor.this.widget.redraw();
                }
                ConditionEditor.this.previous_area = area;
                ConditionEditor.this.previous_area_nr = nr;
            }
        });
        this.widget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point screen = new Point(e.x, e.y);
                int area = ConditionEditor.this.getAreaCode(screen);
                if (e.button == 1) {
                    switch (area) {
                        case 2: {
                            ConditionEditor.this.active_condition.negate();
                            ConditionEditor.this.setModified();
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 5: {
                            int operator = ConditionEditor.this.getNrOperator(screen);
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, Condition.getRealOperators(), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Operator.Label", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.SelectOperator.Label", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            Condition selcond = ConditionEditor.this.active_condition.getCondition(operator);
                            String def = selcond.getOperatorDesc();
                            int defnr = esd.getSelectionNr(Const.trim((String)def));
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                int opnr = Condition.getOperator((String)selection);
                                ConditionEditor.this.active_condition.getCondition(operator).setOperator(opnr);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 4: {
                            int nr = ConditionEditor.this.getNrSubcondition(screen);
                            ConditionEditor.this.editCondition(nr);
                            ConditionEditor.this.setMessageString(BaseMessages.getString((Class)PKG, (String)"ConditionEditor.GoUpOneLevel.Label", (String[])new String[]{"" + ConditionEditor.this.getLevel()}));
                            ConditionEditor.this.redraw();
                            break;
                        }
                        case 6: {
                            ConditionEditor.this.goUp();
                            break;
                        }
                        case 8: {
                            if (!ConditionEditor.this.active_condition.isAtomic()) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, Condition.functions, BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Functions.Label", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.SelectFunction.Label", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.active_condition.getFunctionDesc();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                int fnnr = Condition.getFunction((String)selection);
                                ConditionEditor.this.active_condition.setFunction(fnnr);
                                if (ConditionEditor.this.active_condition.getFunction() == 8 || ConditionEditor.this.active_condition.getFunction() == 7) {
                                    ConditionEditor.this.active_condition.setRightValuename(null);
                                    ConditionEditor.this.active_condition.setRightExact(null);
                                }
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 7: {
                            if (!ConditionEditor.this.active_condition.isAtomic() || ConditionEditor.this.fields == null) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, ConditionEditor.this.fields.getFieldNamesAndTypes(ConditionEditor.this.max_field_length), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Fields", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.SelectAField", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.active_condition.getLeftValuename();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                ValueMetaInterface v = ConditionEditor.this.fields.getValueMeta(esd.getSelectionNr());
                                ConditionEditor.this.active_condition.setLeftValuename(v.getName());
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 9: {
                            if (!ConditionEditor.this.active_condition.isAtomic() || ConditionEditor.this.fields == null) break;
                            EnterSelectionDialog esd = new EnterSelectionDialog(ConditionEditor.this.shell, ConditionEditor.this.fields.getFieldNamesAndTypes(ConditionEditor.this.max_field_length), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Fields", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.SelectAField", (String[])new String[0]));
                            esd.setAvoidQuickSearch();
                            String def = ConditionEditor.this.active_condition.getLeftValuename();
                            int defnr = esd.getSelectionNr(def);
                            String selection = esd.open(defnr);
                            if (selection != null) {
                                ValueMetaInterface v = ConditionEditor.this.fields.getValueMeta(esd.getSelectionNr());
                                ConditionEditor.this.active_condition.setRightValuename(v.getName());
                                ConditionEditor.this.active_condition.setRightExact(null);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 10: {
                            if (!ConditionEditor.this.active_condition.isAtomic()) break;
                            ValueMetaAndData v = ConditionEditor.this.active_condition.getRightExact();
                            if (v == null) {
                                ValueMetaInterface leftval;
                                ValueMetaInterface valueMetaInterface = leftval = ConditionEditor.this.fields != null ? ConditionEditor.this.fields.searchValueMeta(ConditionEditor.this.active_condition.getLeftValuename()) : null;
                                if (leftval != null) {
                                    try {
                                        v = new ValueMetaAndData(ValueMetaFactory.createValueMeta((String)"constant", (int)leftval.getType()), null);
                                    }
                                    catch (Exception exception) {
                                        new ErrorDialog(ConditionEditor.this.shell, "Error", "Error creating value meta object", exception);
                                    }
                                } else {
                                    v = new ValueMetaAndData((ValueMetaInterface)new ValueMetaString("constant"), null);
                                }
                            }
                            EnterValueDialog evd = new EnterValueDialog(ConditionEditor.this.shell, 0, v.getValueMeta(), v.getValueData());
                            evd.setModalDialog(true);
                            ValueMetaAndData newval = evd.open();
                            if (newval != null) {
                                ConditionEditor.this.active_condition.setRightValuename(null);
                                ConditionEditor.this.active_condition.setRightExact(newval);
                                ConditionEditor.this.setModified();
                            }
                            ConditionEditor.this.widget.redraw();
                            break;
                        }
                        case 11: {
                            ConditionEditor.this.addCondition();
                            break;
                        }
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.widget.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Point screen = new Point(e.x, e.y);
                Point widgetScreen = ConditionEditor.this.widget.toDisplay(1, 1);
                Point wRel = new Point(screen.x - widgetScreen.x, screen.y - widgetScreen.y);
                int area = ConditionEditor.this.getAreaCode(wRel);
                ConditionEditor.this.setMenu(area, wRel);
            }
        });
        this.sbVertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditor.this.offsety = -ConditionEditor.this.sbVertical.getSelection();
                ConditionEditor.this.widget.redraw();
            }
        });
        this.sbHorizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConditionEditor.this.offsetx = -ConditionEditor.this.sbHorizontal.getSelection();
                ConditionEditor.this.widget.redraw();
            }
        });
        this.widget.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                ConditionEditor.this.size_widget = ConditionEditor.this.widget.getBounds();
                ConditionEditor.this.setBars();
            }
        });
    }

    private void getMaxFieldLength() {
        this.max_field_length = 5;
        if (this.fields != null) {
            for (int i = 0; i < this.fields.size(); ++i) {
                int len;
                ValueMetaInterface value = this.fields.getValueMeta(i);
                if (value == null || value.getName() == null || (len = this.fields.getValueMeta(i).getName().length()) <= this.max_field_length) continue;
                this.max_field_length = len;
            }
        }
    }

    public int getLevel() {
        return this.parents.size();
    }

    public void goUp() {
        if (this.parents.size() > 0) {
            int last = this.parents.size() - 1;
            this.active_condition = this.parents.get(last);
            this.parents.remove(last);
            this.redraw();
        }
        if (this.getLevel() > 0) {
            this.setMessageString(BaseMessages.getString(PKG, (String)"ConditionEditor.GoUpOneLevel.Label", (String[])new String[]{"" + this.getLevel()}));
        } else {
            this.setMessageString(BaseMessages.getString(PKG, (String)"ConditionEditor.EditSubCondition", (String[])new String[0]));
        }
    }

    private void setMenu(int area, Point screen) {
        final int cond_nr = this.getNrSubcondition(screen);
        if (this.mPop != null && !this.mPop.isDisposed()) {
            this.mPop.dispose();
        }
        switch (area) {
            case 2: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miNegate = new MenuItem(this.mPop, 64);
                miNegate.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.NegateCondition", (String[])new String[0]));
                miNegate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.active_condition.negate();
                        ConditionEditor.this.widget.redraw();
                        ConditionEditor.this.setModified();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 1: 
            case 11: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miAdd = new MenuItem(this.mPop, 64);
                miAdd.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.AddCondition.Label", (String[])new String[0]));
                miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.addCondition();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 4: {
                this.mPop = new Menu((Control)this.widget);
                MenuItem miEdit = new MenuItem(this.mPop, 64);
                miEdit.setText("Edit condition");
                miEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.editCondition(cond_nr);
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miDel = new MenuItem(this.mPop, 64);
                miDel.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.DeleteCondition.Label", (String[])new String[0]));
                miDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.removeCondition(cond_nr);
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                final Condition sub = this.active_condition.getCondition(cond_nr);
                if (sub.getLeftValuename() != null) {
                    MenuItem miAdd = new MenuItem(this.mPop, 64);
                    miAdd.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.AddSubCondition.Label", (String[])new String[0]));
                    miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Condition c = new Condition();
                            c.setOperator(2);
                            sub.addCondition(c);
                            ConditionEditor.this.setModified();
                            ConditionEditor.this.widget.redraw();
                        }
                    });
                }
                new MenuItem(this.mPop, 2);
                MenuItem miCopy = new MenuItem(this.mPop, 64);
                miCopy.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.CopyToClipboard", (String[])new String[0]));
                miCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition c = ConditionEditor.this.active_condition.getCondition(cond_nr);
                        try {
                            String xml = c.getXML();
                            GUIResource.getInstance().toClipboard(xml);
                            ConditionEditor.this.widget.redraw();
                        }
                        catch (Exception ex) {
                            new ErrorDialog(ConditionEditor.this.shell, "Error", "Error encoding to XML", ex);
                        }
                    }
                });
                MenuItem miPasteBef = new MenuItem(this.mPop, 64);
                miPasteBef.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.PasteFromClipboardBeforeCondition", (String[])new String[0]));
                miPasteBef.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String xml = GUIResource.getInstance().fromClipboard();
                        try {
                            Document d = XMLHandler.loadXMLString((String)xml);
                            Node condNode = XMLHandler.getSubNode((Node)d, (String)"condition");
                            if (condNode != null) {
                                Condition c = new Condition(condNode);
                                ConditionEditor.this.active_condition.addCondition(cond_nr, c);
                                ConditionEditor.this.widget.redraw();
                            } else {
                                new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.NoConditionFoundXML", (String[])new String[0]), (Exception)((Object)new KettleXMLException(BaseMessages.getString((Class)PKG, (String)"ConditionEditor.NoConditionFoundXML.Exception", (String[])new String[]{Const.CR + Const.CR + xml}))));
                            }
                        }
                        catch (KettleXMLException ex) {
                            new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.ErrorParsingCondition", (String[])new String[0]), (Exception)((Object)ex));
                        }
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miPasteAft = new MenuItem(this.mPop, 64);
                miPasteAft.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.PasteFromClipboardAfterCondition", (String[])new String[0]));
                miPasteAft.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String xml = GUIResource.getInstance().fromClipboard();
                        try {
                            Document d = XMLHandler.loadXMLString((String)xml);
                            Node condNode = XMLHandler.getSubNode((Node)d, (String)"condition");
                            if (condNode != null) {
                                Condition c = new Condition(condNode);
                                ConditionEditor.this.active_condition.addCondition(cond_nr + 1, c);
                                ConditionEditor.this.widget.redraw();
                            } else {
                                new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.NoConditionFoundXML", (String[])new String[0]), (Exception)((Object)new KettleXMLException(BaseMessages.getString((Class)PKG, (String)"ConditionEditor.NoConditionFoundXML.Exception", (String[])new String[]{Const.CR + Const.CR + xml}))));
                            }
                        }
                        catch (KettleXMLException ex) {
                            new ErrorDialog(ConditionEditor.this.shell, BaseMessages.getString((Class)PKG, (String)"ConditionEditor.Error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ConditionEditor.ErrorParsingCondition", (String[])new String[0]), (Exception)((Object)ex));
                        }
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miMoveSub = new MenuItem(this.mPop, 64);
                miMoveSub.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionToSubCondition", (String[])new String[0]));
                miMoveSub.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition down = ConditionEditor.this.active_condition.getCondition(cond_nr);
                        Condition c = new Condition();
                        c.setOperator(down.getOperator());
                        down.setOperator(0);
                        ConditionEditor.this.active_condition.setCondition(cond_nr, c);
                        c.addCondition(down);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miMoveParent = new MenuItem(this.mPop, 64);
                miMoveParent.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionToParentCondition", (String[])new String[0]));
                if (this.getLevel() == 0) {
                    miMoveParent.setEnabled(false);
                }
                miMoveParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition up = ConditionEditor.this.active_condition.getCondition(cond_nr);
                        ConditionEditor.this.active_condition.removeCondition(cond_nr);
                        Condition parent = (Condition)ConditionEditor.this.parents.get(ConditionEditor.this.getLevel() - 1);
                        parent.addCondition(up);
                        ConditionEditor.this.goUp();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                new MenuItem(this.mPop, 2);
                MenuItem miMoveDown = new MenuItem(this.mPop, 64);
                miMoveDown.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionDown", (String[])new String[0]));
                if (cond_nr >= this.active_condition.nrConditions() - 1) {
                    miMoveDown.setEnabled(false);
                }
                miMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition down = ConditionEditor.this.active_condition.getCondition(cond_nr);
                        ConditionEditor.this.active_condition.removeCondition(cond_nr);
                        ConditionEditor.this.active_condition.addCondition(cond_nr + 1, down);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                MenuItem miMoveUp = new MenuItem(this.mPop, 64);
                miMoveUp.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveConditionUp", (String[])new String[0]));
                if (cond_nr == 0) {
                    miMoveUp.setEnabled(false);
                }
                miMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Condition up = ConditionEditor.this.active_condition.getCondition(cond_nr);
                        ConditionEditor.this.active_condition.removeCondition(cond_nr);
                        ConditionEditor.this.active_condition.addCondition(cond_nr - 1, up);
                        ConditionEditor.this.widget.redraw();
                    }
                });
                this.setMenu(this.mPop);
                break;
            }
            case 5: {
                Menu mPop = new Menu((Control)this.widget);
                MenuItem miDown = new MenuItem(mPop, 64);
                miDown.setText(BaseMessages.getString(PKG, (String)"ConditionEditor.MoveDown", (String[])new String[0]));
                miDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConditionEditor.this.setModified();
                        ConditionEditor.this.widget.redraw();
                    }
                });
                this.setMenu(mPop);
                break;
            }
            default: {
                this.setMenu(null);
            }
        }
    }

    public void repaint(GC dgc, int width, int height) {
        Image im = new Image((Device)this.display, width, height);
        GC gc = new GC((Drawable)im);
        this.size_not = this.getNotSize(gc);
        this.size_widget = this.getWidgetSize(gc);
        this.size_and_not = this.getAndNotSize(gc);
        this.size_up = this.getUpSize(gc);
        this.size_add = this.getAddSize(gc);
        this.size_left = null;
        this.size_fn = null;
        this.size_rightval = null;
        this.size_rightex = null;
        gc.setBackground(this.white);
        gc.setForeground(this.black);
        gc.fillRectangle(0, 0, width, height);
        gc.setFont(this.fixed);
        if (this.active_condition.isAtomic()) {
            this.size_cond = null;
            this.drawNegated(gc, 0, 0, this.active_condition);
            this.drawAtomic(gc, 0, 0, this.active_condition);
        } else {
            this.drawNegated(gc, 0, 0, this.active_condition);
            this.size_cond = new Rectangle[this.active_condition.nrConditions()];
            this.size_oper = new Rectangle[this.active_condition.nrConditions()];
            int basex = 10;
            int basey = this.size_not.y + 5;
            for (int i = 0; i < this.active_condition.nrConditions(); ++i) {
                Point to = this.drawCondition(gc, basex, basey, i, this.active_condition.getCondition(i));
                basey += this.size_and_not.height + to.y + 15;
            }
        }
        gc.drawImage(this.imageAdd, this.size_add.x, this.size_add.y);
        if (this.parents.size() > 0) {
            this.drawUp(gc);
        }
        if (this.messageString != null) {
            this.drawMessage(gc);
        }
        this.getMaxSize();
        this.setBars();
        dgc.drawImage(im, 0, 0);
        im.dispose();
    }

    private Rectangle getNotSize(GC gc) {
        Point p = gc.textExtent(STRING_NOT);
        return new Rectangle(0, 0, p.x + 10, p.y + 4);
    }

    private Rectangle getWidgetSize(GC gc) {
        return this.widget.getBounds();
    }

    private Rectangle getAndNotSize(GC gc) {
        Point p = gc.textExtent(Condition.operators[5]);
        return new Rectangle(0, 0, p.x, p.y);
    }

    private Rectangle getUpSize(GC gc) {
        Point p = gc.textExtent(STRING_UP);
        return new Rectangle(this.size_not.x + this.size_not.width + 40, this.size_not.y, p.x + 20, this.size_not.height);
    }

    private Rectangle getAddSize(GC gc) {
        Rectangle is = this.imageAdd.getBounds();
        Rectangle cs = this.getBounds();
        return new Rectangle(cs.width - is.width - 5 - 18, 5, is.width, is.height);
    }

    private void drawNegated(GC gc, int x, int y, Condition condition) {
        Color color = gc.getForeground();
        if (this.hover_not) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.Real2Screen(this.size_not));
        gc.drawRectangle(this.Real2Screen(this.size_not));
        if (condition.isNegated()) {
            if (this.hover_not) {
                gc.setForeground(this.green);
            }
            gc.drawText(STRING_NOT, this.size_not.x + 5 + this.offsetx, this.size_not.y + 2 + this.offsety, 1);
            gc.drawText(STRING_NOT, this.size_not.x + 6 + this.offsetx, this.size_not.y + 2 + this.offsety, 1);
            if (this.hover_not) {
                gc.setForeground(color);
            }
        } else if (this.hover_not) {
            gc.setForeground(this.red);
            gc.drawText(STRING_NOT, this.size_not.x + 5 + this.offsetx, this.size_not.y + 2 + this.offsety, 1);
            gc.drawText(STRING_NOT, this.size_not.x + 6 + this.offsetx, this.size_not.y + 2 + this.offsety, 1);
            gc.setForeground(color);
        }
        if (this.hover_not) {
            gc.setBackground(this.bg);
        }
    }

    private void drawAtomic(GC gc, int x, int y, Condition condition) {
        String rightex;
        String left = Const.rightPad((String)condition.getLeftValuename(), (int)this.max_field_length);
        Point ext_left = gc.textExtent(left);
        if (condition.getLeftValuename() == null) {
            ext_left = gc.textExtent("<field>");
        }
        String fn_max = Condition.functions[8];
        String fn = condition.getFunctionDesc();
        Point ext_fn = gc.textExtent(fn_max);
        String rightval = Const.rightPad((String)condition.getRightValuename(), (int)this.max_field_length);
        Point ext_rval = gc.textExtent(rightval);
        if (condition.getLeftValuename() == null) {
            ext_rval = gc.textExtent("<field>");
        }
        String rightex_max = rightex = condition.getRightExactString();
        if (rightex == null) {
            rightex_max = Const.rightPad((String)" ", (int)10);
        } else if (rightex.length() < 10) {
            rightex_max = Const.rightPad((String)rightex, (int)10);
        }
        Point ext_rex = gc.textExtent(rightex_max);
        this.size_left = new Rectangle(x + 5, y + this.size_not.height + 5, ext_left.x + 5, ext_left.y + 5);
        this.size_fn = new Rectangle(this.size_left.x + this.size_left.width + 15, y + this.size_not.height + 5, ext_fn.x + 5, ext_fn.y + 5);
        this.size_rightval = new Rectangle(this.size_fn.x + this.size_fn.width + 15, y + this.size_not.height + 5, ext_rval.x + 5, ext_rval.y + 5);
        this.size_rightex = new Rectangle(this.size_fn.x + this.size_fn.width + 15, y + this.size_not.height + 5 + this.size_rightval.height + 5, ext_rex.x + 5, ext_rex.y + 5);
        if (this.hover_left) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.Real2Screen(this.size_left));
        gc.drawRectangle(this.Real2Screen(this.size_left));
        gc.setBackground(this.bg);
        if (this.hover_fn) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.Real2Screen(this.size_fn));
        gc.drawRectangle(this.Real2Screen(this.size_fn));
        gc.setBackground(this.bg);
        if (this.hover_rightval) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.Real2Screen(this.size_rightval));
        gc.drawRectangle(this.Real2Screen(this.size_rightval));
        gc.setBackground(this.bg);
        if (this.hover_rightex) {
            gc.setBackground(this.gray);
        }
        gc.fillRectangle(this.Real2Screen(this.size_rightex));
        gc.drawRectangle(this.Real2Screen(this.size_rightex));
        gc.setBackground(this.bg);
        if (condition.getLeftValuename() != null) {
            gc.drawText(left, this.size_left.x + 1 + this.offsetx, this.size_left.y + 1 + this.offsety, 1);
        } else {
            gc.setForeground(this.gray);
            gc.drawText("<field>", this.size_left.x + 1 + this.offsetx, this.size_left.y + 1 + this.offsety, 1);
            gc.setForeground(this.black);
        }
        gc.drawText(fn, this.size_fn.x + 1 + this.offsetx, this.size_fn.y + 1 + this.offsety, 1);
        if (condition.getFunction() != 8 && condition.getFunction() != 7) {
            String nothing;
            String re = rightex == null ? "" : rightex;
            String stype = "";
            ValueMetaAndData v = condition.getRightExact();
            if (v != null) {
                stype = " (" + v.getValueMeta().getTypeDesc() + ")";
            }
            if (condition.getRightValuename() != null) {
                gc.drawText(rightval, this.size_rightval.x + 1 + this.offsetx, this.size_rightval.y + 1 + this.offsety, 1);
            } else {
                nothing = rightex == null ? "<field>" : "";
                gc.setForeground(this.gray);
                gc.drawText(nothing, this.size_rightval.x + 1 + this.offsetx, this.size_rightval.y + 1 + this.offsety, 1);
                if (condition.getRightValuename() == null) {
                    gc.setForeground(this.black);
                }
            }
            if (rightex != null) {
                gc.drawText(re, this.size_rightex.x + 1 + this.offsetx, this.size_rightex.y + 1 + this.offsety, 1);
            } else {
                nothing = condition.getRightValuename() == null ? "<value>" : "";
                gc.setForeground(this.gray);
                gc.drawText(nothing, this.size_rightex.x + 1 + this.offsetx, this.size_rightex.y + 1 + this.offsety, 1);
                gc.setForeground(this.black);
            }
            gc.drawText(stype, this.size_rightex.x + 1 + this.size_rightex.width + 10 + this.offsetx, this.size_rightex.y + 1 + this.offsety, 1);
        } else {
            gc.drawText("-", this.size_rightval.x + 1 + this.offsetx, this.size_rightval.y + 1 + this.offsety, 1);
            gc.drawText("-", this.size_rightex.x + 1 + this.offsetx, this.size_rightex.y + 1 + this.offsety, 1);
        }
    }

    private Point drawCondition(GC gc, int x, int y, int nr, Condition condition) {
        int opx = x;
        int opy = y;
        int opw = this.size_and_not.width + 6;
        int oph = this.size_and_not.height + 2;
        if (nr > 0) {
            String operator = condition.getOperatorDesc();
            this.size_oper[nr] = new Rectangle(opx, opy, opw, oph);
            if (nr == this.hover_operator) {
                gc.setBackground(this.gray);
                gc.fillRectangle(this.Real2Screen(this.size_oper[nr]));
                gc.drawRectangle(this.Real2Screen(this.size_oper[nr]));
                gc.setBackground(this.bg);
            }
            gc.drawText(operator, this.size_oper[nr].x + 2 + this.offsetx, this.size_oper[nr].y + 2 + this.offsety, 1);
        }
        String str = condition.toString(0, true, false);
        Point p = gc.textExtent(str);
        int cx = opx + 23;
        int cy = opy + oph + 10;
        int cw = p.x + 5;
        int ch = p.y + 5;
        this.size_cond[nr] = new Rectangle(cx, cy, cw, ch);
        if (nr == this.hover_condition) {
            gc.setBackground(this.gray);
            gc.fillRectangle(this.Real2Screen(this.size_cond[nr]));
            gc.drawRectangle(this.Real2Screen(this.size_cond[nr]));
            gc.setBackground(this.bg);
        }
        gc.drawText(str, this.size_cond[nr].x + 2 + this.offsetx, this.size_cond[nr].y + 5 + this.offsety, 15);
        p.x += 0;
        p.y += 5;
        return p;
    }

    public void drawUp(GC gc) {
        if (this.hover_up) {
            gc.setBackground(this.gray);
            gc.fillRectangle(this.size_up);
        }
        gc.drawRectangle(this.size_up);
        gc.drawText(STRING_UP, this.size_up.x + 1 + this.offsetx, this.size_up.y + 1 + this.offsety, 1);
    }

    public void drawMessage(GC gc) {
        gc.setForeground(this.blue);
        gc.drawText(this.getMessageString(), this.size_up.x + this.size_up.width + this.offsetx + 40, this.size_up.y + 1 + this.offsety, 1);
    }

    private boolean isInNot(Point screen) {
        if (this.size_not == null) {
            return false;
        }
        return this.Real2Screen(this.size_not).contains(screen);
    }

    private boolean isInUp(Point screen) {
        if (this.size_up == null || this.parents.isEmpty()) {
            return false;
        }
        return this.Real2Screen(this.size_up).contains(screen);
    }

    private boolean isInAdd(Point screen) {
        if (this.size_add == null || screen == null) {
            return false;
        }
        return this.size_add.contains(screen);
    }

    private boolean isInWidget(Point screen) {
        if (this.size_widget == null) {
            return false;
        }
        return this.Real2Screen(this.size_widget).contains(screen);
    }

    private int getNrSubcondition(Point screen) {
        if (this.size_cond == null) {
            return -1;
        }
        for (int i = 0; i < this.size_cond.length; ++i) {
            if (this.size_cond[i] == null || !this.Screen2Real(this.size_cond[i]).contains(screen)) continue;
            return i;
        }
        return -1;
    }

    private boolean isInSubcondition(Point screen) {
        return this.getNrSubcondition(screen) >= 0;
    }

    private int getNrOperator(Point screen) {
        if (this.size_oper == null) {
            return -1;
        }
        for (int i = 0; i < this.size_oper.length; ++i) {
            if (this.size_oper[i] == null || !this.Screen2Real(this.size_oper[i]).contains(screen)) continue;
            return i;
        }
        return -1;
    }

    private boolean isInOperator(Point screen) {
        return this.getNrOperator(screen) >= 0;
    }

    private boolean isInLeft(Point screen) {
        if (this.size_left == null) {
            return false;
        }
        return this.Real2Screen(this.size_left).contains(screen);
    }

    private boolean isInFunction(Point screen) {
        if (this.size_fn == null) {
            return false;
        }
        return this.Real2Screen(this.size_fn).contains(screen);
    }

    private boolean isInRightValue(Point screen) {
        if (this.size_rightval == null) {
            return false;
        }
        return this.Real2Screen(this.size_rightval).contains(screen);
    }

    private boolean isInRightExact(Point screen) {
        if (this.size_rightex == null) {
            return false;
        }
        return this.Real2Screen(this.size_rightex).contains(screen);
    }

    private int getAreaCode(Point screen) {
        if (this.isInNot(screen)) {
            return 2;
        }
        if (this.isInUp(screen)) {
            return 6;
        }
        if (this.isInAdd(screen)) {
            return 11;
        }
        if (this.active_condition.isAtomic()) {
            if (this.isInLeft(screen)) {
                return 7;
            }
            if (this.isInFunction(screen)) {
                return 8;
            }
            if (this.isInRightExact(screen)) {
                return 10;
            }
            if (this.isInRightValue(screen)) {
                return 9;
            }
        } else {
            if (this.isInSubcondition(screen)) {
                return 4;
            }
            if (this.isInOperator(screen)) {
                return 5;
            }
        }
        if (this.isInWidget(screen)) {
            return 1;
        }
        return 0;
    }

    private void editCondition(int nr) {
        if (this.active_condition.isComposite()) {
            this.parents.add(this.active_condition);
            this.active_condition = this.active_condition.getCondition(nr);
        }
    }

    private void addCondition() {
        Condition c = new Condition();
        c.setOperator(2);
        this.addCondition(c);
        this.setModified();
        this.widget.redraw();
    }

    private void addCondition(Condition condition) {
        this.active_condition.addCondition(condition);
    }

    private void removeCondition(int nr) {
        this.active_condition.removeCondition(nr);
    }

    public void setMessageString(String messageString) {
        this.messageString = messageString;
    }

    public String getMessageString() {
        return this.messageString;
    }

    private Rectangle Real2Screen(Rectangle r) {
        return new Rectangle(r.x + this.offsetx, r.y + this.offsety, r.width, r.height);
    }

    private Rectangle Screen2Real(Rectangle r) {
        return new Rectangle(r.x - this.offsetx, r.y - this.offsety, r.width, r.height);
    }

    private void getMaxSize() {
        this.maxdrawn = this.size_not.union(this.size_up);
        if (this.active_condition.isAtomic()) {
            this.maxdrawn = this.maxdrawn.union(this.size_left);
            this.maxdrawn = this.maxdrawn.union(this.size_fn);
            this.maxdrawn = this.maxdrawn.union(this.size_rightval);
            this.maxdrawn = this.maxdrawn.union(this.size_rightex);
            this.maxdrawn.width += 100;
        } else {
            int i;
            if (this.size_cond != null) {
                for (i = 0; i < this.size_cond.length; ++i) {
                    if (this.size_cond[i] == null) continue;
                    this.maxdrawn = this.maxdrawn.union(this.size_cond[i]);
                }
            }
            if (this.size_oper != null) {
                for (i = 0; i < this.size_oper.length; ++i) {
                    if (this.size_oper[i] == null) continue;
                    this.maxdrawn = this.maxdrawn.union(this.size_oper[i]);
                }
            }
        }
        this.maxdrawn.width += 10;
        this.maxdrawn.height += 10;
    }

    private void setBars() {
        if (this.size_widget == null || this.maxdrawn == null) {
            return;
        }
        if (this.size_widget.width > this.maxdrawn.width) {
            this.offsetx = 0;
            this.sbHorizontal.setSelection(0);
            this.sbHorizontal.setVisible(false);
        } else {
            this.offsetx = -this.sbHorizontal.getSelection();
            this.sbHorizontal.setVisible(true);
            this.sbHorizontal.setMaximum(this.maxdrawn.width);
            this.sbHorizontal.setMinimum(0);
            this.sbHorizontal.setPageIncrement(this.size_widget.width);
            this.sbHorizontal.setIncrement(10);
        }
        if (this.size_widget.height > this.maxdrawn.height) {
            this.offsety = 0;
            this.sbVertical.setSelection(0);
            this.sbVertical.setVisible(false);
        } else {
            this.offsety = this.sbVertical.getSelection();
            this.sbVertical.setVisible(true);
            this.sbVertical.setMaximum(this.maxdrawn.height);
            this.sbVertical.setMinimum(0);
            this.sbVertical.setPageIncrement(this.size_widget.height);
            this.sbVertical.setIncrement(10);
        }
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.modListeners.add(lsMod);
    }

    public void setModified() {
        for (int i = 0; i < this.modListeners.size(); ++i) {
            ModifyListener lsMod = this.modListeners.get(i);
            if (lsMod == null) continue;
            Event e = new Event();
            e.widget = this;
            lsMod.modifyText(new ModifyEvent(e));
        }
    }
}

