/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.columnexists;

import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsData;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsMeta;

public class ColumnExists
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ColumnExistsMeta.class;
    private ColumnExistsMeta meta;
    private ColumnExistsData data;

    public ColumnExists(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block15: {
            this.meta = (ColumnExistsMeta)smi;
            this.data = (ColumnExistsData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean columnexists = false;
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                if (Utils.isEmpty((CharSequence)this.meta.getDynamicColumnnameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Error.ColumnnameFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExists.Error.ColumnnameFieldMissing", (String[])new String[0]));
                }
                if (this.meta.isTablenameInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getDynamicTablenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Error.TablenameFieldMissing", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExists.Error.TablenameFieldMissing", (String[])new String[0]));
                    }
                    if (this.data.indexOfTablename < 0) {
                        this.data.indexOfTablename = this.getInputRowMeta().indexOfValue(this.meta.getDynamicTablenameField());
                        if (this.data.indexOfTablename < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getDynamicTablenameField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExists.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicTablenameField()}));
                        }
                    }
                } else {
                    this.data.tablename = !Utils.isEmpty((CharSequence)this.data.schemaname) ? this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.schemaname, this.data.tablename) : this.data.db.getDatabaseMeta().quoteField(this.data.tablename);
                }
                if (this.data.indexOfColumnname < 0) {
                    this.data.indexOfColumnname = this.getInputRowMeta().indexOfValue(this.meta.getDynamicColumnnameField());
                    if (this.data.indexOfColumnname < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getDynamicColumnnameField() + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ColumnExists.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicColumnnameField()}));
                    }
                }
            }
            try {
                if (this.meta.isTablenameInField()) {
                    this.data.tablename = this.getInputRowMeta().getString(r, this.data.indexOfTablename);
                    this.data.tablename = !Utils.isEmpty((CharSequence)this.data.schemaname) ? this.data.db.getDatabaseMeta().getQuotedSchemaTableCombination(this.data.schemaname, this.data.tablename) : this.data.db.getDatabaseMeta().quoteField(this.data.tablename);
                }
                String columnname = this.getInputRowMeta().getString(r, this.data.indexOfColumnname);
                columnname = this.data.db.getDatabaseMeta().quoteField(columnname);
                columnexists = this.data.db.checkColumnExists(columnname, this.data.tablename);
                Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)columnexists);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"ColumnExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)("ColumnExists.ErrorInStepRunning : " + e.getMessage()), (String[])new String[0]));
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ColumnExists.Log.ErrorInStep", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block15;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "ColumnExists001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block13: {
            this.meta = (ColumnExistsMeta)smi;
            this.data = (ColumnExistsData)sdi;
            if (super.init(smi, sdi)) {
                if (!this.meta.isTablenameInField()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getTablename())) {
                        this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Error.TablenameMissing", (String[])new String[0]));
                        return false;
                    }
                    this.data.tablename = this.environmentSubstitute(this.meta.getTablename());
                }
                this.data.schemaname = this.meta.getSchemaname();
                if (!Utils.isEmpty((CharSequence)this.data.schemaname)) {
                    this.data.schemaname = this.environmentSubstitute(this.data.schemaname);
                }
                if (Utils.isEmpty((CharSequence)this.meta.getResultFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Error.ResultFieldMissing", (String[])new String[0]));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ColumnExists.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ColumnExists.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (this.data.db == null) break block13;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ColumnExistsMeta)smi;
        this.data = (ColumnExistsData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

