/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.analyticquery;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.analyticquery.AnalyticQueryData;
import org.pentaho.di.trans.steps.analyticquery.AnalyticQueryMeta;

public class AnalyticQuery
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AnalyticQuery.class;
    private AnalyticQueryMeta meta = (AnalyticQueryMeta)this.getStepMeta().getStepMetaInterface();
    private AnalyticQueryData data;

    public AnalyticQuery(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (AnalyticQueryData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AnalyticQueryMeta)smi;
        this.data = (AnalyticQueryData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            this.data.inputRowMeta = this.getInputRowMeta();
            if (this.data.inputRowMeta == null) {
                this.data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            }
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (int i = 0; i < this.meta.getGroupField().length; ++i) {
                this.data.groupnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i]);
                if (this.data.groupnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"AnalyticQuery.Log.GroupFieldCouldNotFound", (String[])new String[]{this.meta.getGroupField()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            int max_offset = 0;
            for (int i = 0; i < this.meta.getNumberOfFields(); ++i) {
                if (this.meta.getValueField()[i] <= max_offset) continue;
                max_offset = this.meta.getValueField()[i];
            }
            this.data.window_size = max_offset;
            this.data.queue_size = max_offset * 2 + 1;
            this.first = false;
        }
        if (r == null) {
            this.clearQueue();
            this.setOutputDone();
            return false;
        }
        if (!this.sameGroup(this.data.previous, r)) {
            this.clearQueue();
            this.resetGroup();
        }
        this.data.data.add(r);
        while (this.data.data.size() > this.data.queue_size) {
            this.data.data.poll();
        }
        this.data.previous = (Object[])r.clone();
        this.processQueue();
        if (this.log.isBasic() && this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"LineNr", (Object[])new Object[]{this.getLinesRead()}));
        }
        return true;
    }

    public void processQueue() throws KettleStepException {
        if (this.data.data.size() == this.data.queue_size) {
            if (this.data.queue_cursor <= this.data.window_size) {
                while (this.data.queue_cursor <= this.data.window_size) {
                    this.processQueueObjectAt(this.data.queue_cursor + 1);
                    ++this.data.queue_cursor;
                }
            } else {
                this.processQueueObjectAt(this.data.window_size + 1);
            }
        }
    }

    public void clearQueue() throws KettleStepException {
        if (this.data.data == null) {
            return;
        }
        int number_of_rows = this.data.data.size();
        for (int i = this.data.queue_cursor; i < number_of_rows; ++i) {
            this.processQueueObjectAt(i + 1);
        }
    }

    public void processQueueObjectAt(int i) throws KettleStepException {
        int index = i - 1;
        Object[] rows = this.data.data.toArray();
        Object[] fields = new Object[this.meta.getNumberOfFields()];
        for (int j = 0; j < this.meta.getNumberOfFields(); ++j) {
            int field_index = this.data.inputRowMeta.indexOfValue(this.meta.getSubjectField()[j]);
            int row_index = 0;
            switch (this.meta.getAggregateType()[j]) {
                case 1: {
                    row_index = index - this.meta.getValueField()[j];
                    break;
                }
                case 0: {
                    row_index = index + this.meta.getValueField()[j];
                    break;
                }
            }
            if (row_index < rows.length && row_index >= 0) {
                Object[] singleRow = (Object[])rows[row_index];
                if (singleRow != null && singleRow[field_index] != null) {
                    fields[j] = ((Object[])rows[row_index])[field_index];
                    continue;
                }
                fields[j] = null;
                continue;
            }
            fields[j] = null;
        }
        Object[] newRow = RowDataUtil.addRowData((Object[])((Object[])rows[index]), (int)this.data.inputRowMeta.size(), (Object[])fields);
        this.putRow(this.data.outputRowMeta, newRow);
    }

    public void resetGroup() {
        this.data.data = new ConcurrentLinkedQueue();
        this.data.queue_cursor = 0;
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws KettleValueException {
        if (r == null && previous != null || previous == null && r != null) {
            return false;
        }
        return this.data.inputRowMeta.compare(previous, r, this.data.groupnrs) == 0;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AnalyticQueryMeta)smi;
        this.data = (AnalyticQueryData)sdi;
        return super.init(smi, sdi);
    }
}

