/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;

public class RelBuilder {
    private static final Function<RexNode, String> FN_TYPE = new Function<RexNode, String>(){

        public String apply(RexNode input) {
            return input + ": " + input.getType();
        }
    };
    protected final RelOptCluster cluster;
    protected final RelOptSchema relOptSchema;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SortFactory sortFactory;
    private final RelFactories.SetOpFactory setOpFactory;
    private final RelFactories.JoinFactory joinFactory;
    private final RelFactories.SemiJoinFactory semiJoinFactory;
    private final RelFactories.CorrelateFactory correlateFactory;
    private final RelFactories.ValuesFactory valuesFactory;
    private final RelFactories.TableScanFactory scanFactory;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();
    private final boolean simplify;
    private final RexSimplify simplifier;
    private final RexSimplify simplifierUnknownAsFalse;

    protected RelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.simplify = Hook.REL_BUILDER_SIMPLIFY.get(true);
        this.aggregateFactory = Util.first(context.unwrap(RelFactories.AggregateFactory.class), RelFactories.DEFAULT_AGGREGATE_FACTORY);
        this.filterFactory = Util.first(context.unwrap(RelFactories.FilterFactory.class), RelFactories.DEFAULT_FILTER_FACTORY);
        this.projectFactory = Util.first(context.unwrap(RelFactories.ProjectFactory.class), RelFactories.DEFAULT_PROJECT_FACTORY);
        this.sortFactory = Util.first(context.unwrap(RelFactories.SortFactory.class), RelFactories.DEFAULT_SORT_FACTORY);
        this.setOpFactory = Util.first(context.unwrap(RelFactories.SetOpFactory.class), RelFactories.DEFAULT_SET_OP_FACTORY);
        this.joinFactory = Util.first(context.unwrap(RelFactories.JoinFactory.class), RelFactories.DEFAULT_JOIN_FACTORY);
        this.semiJoinFactory = Util.first(context.unwrap(RelFactories.SemiJoinFactory.class), RelFactories.DEFAULT_SEMI_JOIN_FACTORY);
        this.correlateFactory = Util.first(context.unwrap(RelFactories.CorrelateFactory.class), RelFactories.DEFAULT_CORRELATE_FACTORY);
        this.valuesFactory = Util.first(context.unwrap(RelFactories.ValuesFactory.class), RelFactories.DEFAULT_VALUES_FACTORY);
        this.scanFactory = Util.first(context.unwrap(RelFactories.TableScanFactory.class), RelFactories.DEFAULT_TABLE_SCAN_FACTORY);
        RexExecutor executor = Util.first(context.unwrap(RexExecutor.class), Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR));
        this.simplifier = new RexSimplify(cluster.getRexBuilder(), false, executor);
        this.simplifierUnknownAsFalse = new RexSimplify(cluster.getRexBuilder(), true, executor);
    }

    public static RelBuilder create(FrameworkConfig config) {
        final RelOptCluster[] clusters = new RelOptCluster[]{null};
        final RelOptSchema[] relOptSchemas = new RelOptSchema[]{null};
        Frameworks.withPrepare(new Frameworks.PrepareAction<Void>(config){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                clusters[0] = cluster;
                relOptSchemas[0] = relOptSchema;
                return null;
            }
        });
        return new RelBuilder(config.getContext(), clusters[0], relOptSchemas[0]);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public static RelBuilderFactory proto(final Context context) {
        return new RelBuilderFactory(){

            @Override
            public RelBuilder create(RelOptCluster cluster, RelOptSchema schema) {
                return new RelBuilder(context, cluster, schema);
            }
        };
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return RelBuilder.proto(Contexts.of(factories));
    }

    public RelBuilder push(RelNode node) {
        this.stack.push(new Frame(node));
        return this;
    }

    private void replaceTop(RelNode node) {
        Frame frame = this.stack.pop();
        this.stack.push(new Frame(node, frame.fields));
    }

    public RelBuilder pushAll(Iterable<? extends RelNode> nodes) {
        for (RelNode relNode : nodes) {
            this.push(relNode);
        }
        return this;
    }

    public RelNode build() {
        return this.stack.pop().rel;
    }

    public RelNode peek() {
        return this.peek_().rel;
    }

    private Frame peek_() {
        return this.stack.peek();
    }

    public RelNode peek(int n) {
        return this.peek_((int)n).rel;
    }

    private Frame peek_(int n) {
        return (Frame)Iterables.get(this.stack, (int)n);
    }

    public RelNode peek(int inputCount, int inputOrdinal) {
        return this.peek_((int)inputCount, (int)inputOrdinal).rel;
    }

    private Frame peek_(int inputCount, int inputOrdinal) {
        return this.peek_(inputCount - 1 - inputOrdinal);
    }

    private int inputOffset(int inputCount, int inputOrdinal) {
        int offset = 0;
        for (int i = 0; i < inputOrdinal; ++i) {
            offset += this.peek(inputCount, i).getRowType().getFieldCount();
        }
        return offset;
    }

    public RexNode literal(Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            return rexBuilder.constantNull();
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    public RelBuilder variable(Holder<RexCorrelVariable> v) {
        v.set((RexCorrelVariable)this.getRexBuilder().makeCorrel(this.peek().getRowType(), this.cluster.createCorrel()));
        return this;
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        List fieldNames = Pair.left(frame.fields());
        int i = fieldNames.indexOf(fieldName);
        if (i >= 0) {
            return this.field(inputCount, inputOrdinal, i);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + fieldNames);
    }

    public RexInputRef field(int fieldOrdinal) {
        return (RexInputRef)this.field(1, 0, fieldOrdinal, false);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        return (RexInputRef)this.field(inputCount, inputOrdinal, fieldOrdinal, false);
    }

    private RexNode field(int inputCount, int inputOrdinal, int fieldOrdinal, boolean alias) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        RelNode input = frame.rel;
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        RelDataTypeField field = rowType.getFieldList().get(fieldOrdinal);
        int offset = this.inputOffset(inputCount, inputOrdinal);
        RexInputRef ref = this.cluster.getRexBuilder().makeInputRef(field.getType(), offset + fieldOrdinal);
        RelDataTypeField aliasField = frame.fields().get(fieldOrdinal);
        if (!alias || field.getName().equals(aliasField.getName())) {
            return ref;
        }
        return this.alias(ref, aliasField.getName());
    }

    public RexNode field(String alias, String fieldName) {
        return this.field(1, alias, fieldName);
    }

    public RexNode field(int inputCount, String alias, String fieldName) {
        Preconditions.checkNotNull((Object)alias);
        Preconditions.checkNotNull((Object)fieldName);
        ArrayList<String> fields = new ArrayList<String>();
        for (int inputOrdinal = 0; inputOrdinal < inputCount; ++inputOrdinal) {
            Frame frame = this.peek_(inputOrdinal);
            for (Ord p : Ord.zip(frame.fields)) {
                if (((ImmutableSet)((Field)p.e).left).contains((Object)alias) && ((RelDataTypeField)((Field)p.e).right).getName().equals(fieldName)) {
                    return this.field(inputCount, inputCount - 1 - inputOrdinal, p.i);
                }
                fields.add(String.format(Locale.ROOT, "{aliases=%s,fieldName=%s}", ((Field)p.e).left, ((RelDataTypeField)((Field)p.e).right).getName()));
            }
        }
        throw new IllegalArgumentException("no aliased field found; fields are: " + fields);
    }

    public RexNode field(RexNode e, String name) {
        return this.getRexBuilder().makeFieldAccess(e, name, false);
    }

    public ImmutableList<RexNode> fields() {
        return this.fields(1, 0);
    }

    public ImmutableList<RexNode> fields(int inputCount, int inputOrdinal) {
        RelNode input = this.peek(inputCount, inputOrdinal);
        RelDataType rowType = input.getRowType();
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int fieldOrdinal : Util.range(rowType.getFieldCount())) {
            nodes.add((Object)this.field(inputCount, inputOrdinal, fieldOrdinal));
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(RelCollation collation) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RexNode node = this.field(fieldCollation.getFieldIndex());
            switch (fieldCollation.direction) {
                case DESCENDING: {
                    node = this.desc(node);
                }
            }
            switch (fieldCollation.nullDirection) {
                case FIRST: {
                    node = this.nullsFirst(node);
                    break;
                }
                case LAST: {
                    node = this.nullsLast(node);
                }
            }
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(List<? extends Number> ordinals) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (Number number : ordinals) {
            RexNode node = this.field(1, 0, number.intValue(), false);
            nodes.add((Object)node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(Iterable<String> fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add((Object)this.field(fieldName));
        }
        return builder.build();
    }

    public ImmutableList<RexNode> fields(Mappings.TargetMapping mapping) {
        return this.fields(Mappings.asList(mapping));
    }

    public RexNode dot(RexNode node, String fieldName) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldName, true);
    }

    public RexNode dot(RexNode node, int fieldOrdinal) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldOrdinal);
    }

    public RexNode call(SqlOperator operator, RexNode ... operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    private RexNode call(SqlOperator operator, List<RexNode> operandList) {
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList);
        if (type == null) {
            throw new IllegalArgumentException("cannot derive type: " + operator + "; operands: " + Lists.transform(operandList, FN_TYPE));
        }
        return builder.makeCall(type, operator, operandList);
    }

    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    public RexNode and(RexNode ... operands) {
        return this.and((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return this.simplifier.simplifyAnds(operands);
    }

    public RexNode or(RexNode ... operands) {
        return this.or((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction(this.cluster.getRexBuilder(), operands);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias) {
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, this.literal(alias));
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public GroupKey groupKey() {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), false, null, null);
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes, boolean indicator, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<? extends RexNode> iterable : nodeLists) {
            builder.add((Object)ImmutableList.copyOf(iterable));
        }
        return new GroupKeyImpl((ImmutableList<RexNode>)ImmutableList.copyOf(nodes), indicator, (ImmutableList<ImmutableList<RexNode>>)builder.build(), null);
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields(ImmutableIntList.of(fieldOrdinals)));
    }

    public GroupKey groupKey(String ... fieldNames) {
        return this.groupKey((Iterable<? extends RexNode>)this.fields((Iterable<String>)ImmutableList.copyOf((Object[])fieldNames)));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, boolean indicator, ImmutableList<ImmutableBitSet> groupSets) {
        if (groupSet.length() > this.peek().getRowType().getFieldCount()) {
            throw new IllegalArgumentException("out of bounds: " + groupSet);
        }
        if (groupSets == null) {
            groupSets = ImmutableList.of((Object)groupSet);
        }
        ImmutableList<RexNode> nodes = this.fields(ImmutableIntList.of(groupSet.toArray()));
        List nodeLists = Lists.transform((List)groupSets, (Function)new Function<ImmutableBitSet, ImmutableList<RexNode>>(){

            public ImmutableList<RexNode> apply(ImmutableBitSet input) {
                return RelBuilder.this.fields(ImmutableIntList.of(input.toArray()));
            }
        });
        return this.groupKey((Iterable<? extends RexNode>)nodes, indicator, nodeLists);
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, filter, alias, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, Iterable<? extends RexNode> operands) {
        if (filter != null) {
            if (filter.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                throw Static.RESOURCE.filterMustBeBoolean().ex();
            }
            if (filter.getType().isNullable()) {
                filter = this.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, filter);
            }
        }
        return new AggCallImpl(aggFunction, distinct, filter, alias, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public AggCall count(boolean distinct, String alias, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, null, alias, operands);
    }

    public AggCall countStar(String alias) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, false, null, alias, new RexNode[0]);
    }

    public AggCall sum(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, null, alias, operand);
    }

    public AggCall avg(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, null, alias, operand);
    }

    public AggCall min(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, null, alias, operand);
    }

    public AggCall max(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, null, alias, operand);
    }

    public RelBuilder scan(Iterable<String> tableNames) {
        ImmutableList names = ImmutableList.copyOf(tableNames);
        RelOptTable relOptTable = this.relOptSchema.getTableForMember((List<String>)names);
        if (relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(Joiner.on((String)".").join((Iterable)names)).ex();
        }
        RelNode scan = this.scanFactory.createScan(this.cluster, relOptTable);
        this.push(scan);
        return this;
    }

    public RelBuilder scan(String ... tableNames) {
        return this.scan((Iterable<String>)ImmutableList.copyOf((Object[])tableNames));
    }

    public RelBuilder filter(RexNode ... predicates) {
        return this.filter((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])predicates));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        RexNode x = this.simplifierUnknownAsFalse.simplifyAnds(predicates);
        if (x.isAlwaysFalse()) {
            return this.empty();
        }
        if (!x.isAlwaysTrue()) {
            Frame frame = this.stack.pop();
            RelNode filter = this.filterFactory.createFilter(frame.rel, x);
            this.stack.push(new Frame(filter, frame.fields));
        }
        return this;
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project(nodes, (Iterable<String>)ImmutableList.of());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames) {
        return this.project(nodes, fieldNames, false);
    }

    /*
     * WARNING - void declaration
     */
    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        Iterator<String> nameIterator = fieldNames.iterator();
        for (RexNode rexNode : nodes) {
            void var8_8;
            if (this.simplify) {
                RexNode rexNode2 = this.simplifier.simplifyPreservingType(rexNode);
            }
            exprList.add((RexNode)var8_8);
            String name = nameIterator.hasNext() ? nameIterator.next() : null;
            names.add(name != null ? name : this.inferAlias(exprList, (RexNode)var8_8));
        }
        Frame frame = this.stack.peek();
        ImmutableList.Builder builder = ImmutableList.builder();
        AbstractSet uniqueNameList = this.getTypeFactory().getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < names.size(); ++i) {
            Field field;
            RexNode node = (RexNode)exprList.get(i);
            String name = (String)names.get(i);
            if (name == null || uniqueNameList.contains(name)) {
                int j = 0;
                if (name == null) {
                    j = i;
                }
                while (uniqueNameList.contains(name = SqlValidatorUtil.F_SUGGESTER.apply(name, j, j++))) {
                }
                names.set(i, name);
            }
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i, node.getType());
            switch (node.getKind()) {
                case INPUT_REF: {
                    int index = ((RexInputRef)node).getIndex();
                    field = new Field((ImmutableSet<String>)((ImmutableSet)((Field)frame.fields.get((int)index)).left), fieldType);
                    break;
                }
                default: {
                    field = new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType);
                }
            }
            uniqueNameList.add(name);
            builder.add((Object)field);
        }
        RelDataType inputRowType = this.peek().getRowType();
        if (!force && RexUtil.isIdentity(exprList, inputRowType)) {
            if (names.equals(inputRowType.getFieldNames())) {
                return this;
            }
            this.stack.pop();
            this.stack.push(new Frame(frame.rel, builder.build()));
            return this;
        }
        RelNode project = this.projectFactory.createProject(frame.rel, (List<? extends RexNode>)ImmutableList.copyOf(exprList), names);
        this.stack.pop();
        this.stack.push(new Frame(project, builder.build()));
        return this;
    }

    public RelBuilder project(RexNode ... nodes) {
        return this.project((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    private String inferAlias(List<RexNode> exprList, RexNode expr) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return ((RelDataTypeField)((Field)this.stack.peek().fields.get(ref.getIndex())).getValue()).getName();
            }
            case CAST: {
                return this.inferAlias(exprList, ((RexCall)expr).getOperands().get(0));
            }
            case AS: {
                int i;
                RexCall call = (RexCall)expr;
                while ((i = exprList.indexOf(expr)) >= 0) {
                    exprList.set(i, call.getOperands().get(0));
                }
                return ((NlsString)((RexLiteral)call.getOperands().get(1)).getValue()).getValue();
            }
        }
        return null;
    }

    public RelBuilder distinct() {
        return this.aggregate(this.groupKey((Iterable<? extends RexNode>)this.fields()), new AggCall[0]);
    }

    public RelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate(groupKey, (Iterable<AggCall>)ImmutableList.copyOf((Object[])aggCalls));
    }

    public RelBuilder aggregate(GroupKey groupKey, Iterable<AggCall> aggCalls) {
        RelDataTypeFieldImpl fieldType;
        ImmutableList groupSets;
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        GroupKeyImpl groupKey_ = (GroupKeyImpl)groupKey;
        ImmutableBitSet groupSet = ImmutableBitSet.of(RelBuilder.registerExpressions(extraNodes, groupKey_.nodes));
        if (Iterables.isEmpty(aggCalls) && !groupKey_.indicator) {
            Double minRowCount;
            RelMetadataQuery mq = RelMetadataQuery.instance();
            if (!groupSet.isEmpty() || (minRowCount = mq.getMinRowCount(this.peek())) != null && !(minRowCount < 1.0)) {
                Boolean unique = mq.areColumnsUnique(this.peek(), groupSet);
                if (unique != null && unique.booleanValue()) {
                    return this;
                }
                Double maxRowCount = mq.getMaxRowCount(this.peek());
                if (maxRowCount != null && maxRowCount <= 1.0) {
                    return this;
                }
            }
        }
        if (groupKey_.nodeLists != null) {
            int sizeBefore = extraNodes.size();
            TreeSet<ImmutableBitSet> groupSetSet = new TreeSet<ImmutableBitSet>((Comparator<ImmutableBitSet>)ImmutableBitSet.ORDERING);
            for (Object nodeList : groupKey_.nodeLists) {
                ImmutableBitSet groupSet2 = ImmutableBitSet.of(RelBuilder.registerExpressions(extraNodes, (Iterable<? extends RexNode>)nodeList));
                if (!groupSet.contains(groupSet2)) {
                    throw new IllegalArgumentException("group set element " + nodeList + " must be a subset of group key");
                }
                groupSetSet.add(groupSet2);
            }
            groupSets = ImmutableList.copyOf(groupSetSet);
            if (extraNodes.size() > sizeBefore) {
                throw new IllegalArgumentException("group sets contained expressions not in group key: " + extraNodes.subList(sizeBefore, extraNodes.size()));
            }
        } else {
            groupSets = ImmutableList.of((Object)groupSet);
        }
        for (AggCall aggCall : aggCalls) {
            if (!(aggCall instanceof AggCallImpl)) continue;
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            RelBuilder.registerExpressions(extraNodes, (Iterable<? extends RexNode>)aggCall1.operands);
            if (aggCall1.filter == null) continue;
            RelBuilder.registerExpression(extraNodes, aggCall1.filter);
        }
        if (extraNodes.size() > inputRowType.getFieldCount()) {
            this.project(extraNodes);
        }
        Frame frame = this.stack.pop();
        RelNode r = frame.rel;
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCall aggCall : aggCalls) {
            AggregateCall aggregateCall;
            if (aggCall instanceof AggCallImpl) {
                AggCallImpl aggCall1 = (AggCallImpl)aggCall;
                List<Integer> args = RelBuilder.registerExpressions(extraNodes, (Iterable<? extends RexNode>)aggCall1.operands);
                int filterArg = aggCall1.filter == null ? -1 : RelBuilder.registerExpression(extraNodes, aggCall1.filter);
                aggregateCall = AggregateCall.create(aggCall1.aggFunction, aggCall1.distinct, args, filterArg, groupSet.cardinality(), r, null, aggCall1.alias);
            } else {
                aggregateCall = ((AggCallImpl2)aggCall).aggregateCall;
            }
            aggregateCalls.add(aggregateCall);
        }
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered((Iterable)groupSets)) : groupSets;
        for (ImmutableBitSet set : groupSets) {
            assert (groupSet.contains(set));
        }
        RelNode aggregate = this.aggregateFactory.createAggregate(r, groupKey_.indicator, groupSet, (ImmutableList<ImmutableBitSet>)groupSets, aggregateCalls);
        ImmutableList.Builder fields = ImmutableList.builder();
        List<RelDataTypeField> aggregateFields = aggregate.getRowType().getFieldList();
        int i = 0;
        for (Integer groupField : groupSet.asList()) {
            RexNode node = extraNodes.get(groupField);
            SqlKind kind = node.getKind();
            switch (kind) {
                case INPUT_REF: {
                    fields.add(frame.fields.get(((RexInputRef)node).getIndex()));
                    break;
                }
                default: {
                    String name = aggregateFields.get(i).getName();
                    RelDataTypeFieldImpl fieldType2 = new RelDataTypeFieldImpl(name, i, node.getType());
                    fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType2));
                }
            }
            ++i;
        }
        if (groupKey_.indicator) {
            for (int j = 0; j < groupSet.cardinality(); ++j) {
                RelDataTypeField field = aggregateFields.get(i);
                fieldType = new RelDataTypeFieldImpl(field.getName(), i, field.getType());
                fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
                ++i;
            }
        }
        for (int j = 0; j < aggregateCalls.size(); ++j) {
            AggregateCall call = (AggregateCall)aggregateCalls.get(j);
            fieldType = new RelDataTypeFieldImpl(aggregateFields.get(i + j).getName(), i + j, call.getType());
            fields.add((Object)new Field((ImmutableSet<String>)ImmutableSet.of(), fieldType));
        }
        this.stack.push(new Frame(aggregate, fields.build()));
        return this;
    }

    private List<RexNode> projects(RelDataType inputRowType) {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (RelDataTypeField field : inputRowType.getFieldList()) {
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            exprList.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return exprList;
    }

    private static int registerExpression(List<RexNode> exprList, RexNode node) {
        int i = exprList.indexOf(node);
        if (i < 0) {
            i = exprList.size();
            exprList.add(node);
        }
        return i;
    }

    private static List<Integer> registerExpressions(List<RexNode> extraNodes, Iterable<? extends RexNode> nodes) {
        ArrayList<Integer> builder = new ArrayList<Integer>();
        for (RexNode rexNode : nodes) {
            builder.add(RelBuilder.registerExpression(extraNodes, rexNode));
        }
        return builder;
    }

    private RelBuilder setOp(boolean all, SqlKind kind, int n) {
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < n; ++i) {
            inputs.add(0, this.build());
        }
        switch (kind) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                if (n >= 1) break;
                throw new IllegalArgumentException("bad INTERSECT/UNION/EXCEPT input count");
            }
            default: {
                throw new AssertionError((Object)("bad setOp " + (Object)((Object)kind)));
            }
        }
        switch (n) {
            case 1: {
                return this.push((RelNode)inputs.get(0));
            }
        }
        return this.push(this.setOpFactory.createSetOp(kind, inputs, all));
    }

    public RelBuilder union(boolean all) {
        return this.union(all, 2);
    }

    public RelBuilder union(boolean all, int n) {
        return this.setOp(all, SqlKind.UNION, n);
    }

    public RelBuilder intersect(boolean all) {
        return this.intersect(all, 2);
    }

    public RelBuilder intersect(boolean all, int n) {
        return this.setOp(all, SqlKind.INTERSECT, n);
    }

    public RelBuilder minus(boolean all) {
        return this.minus(all, 2);
    }

    public RelBuilder minus(boolean all, int n) {
        return this.setOp(all, SqlKind.EXCEPT, n);
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition0, RexNode ... conditions) {
        return this.join(joinType, Lists.asList((Object)condition0, (Object[])conditions));
    }

    public RelBuilder join(JoinRelType joinType, Iterable<? extends RexNode> conditions) {
        return this.join(joinType, this.and(conditions), (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition) {
        return this.join(joinType, condition, (Set<CorrelationId>)ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode join;
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        boolean correlate = variablesSet.size() == 1;
        RexNode postCondition = this.literal(true);
        if (correlate) {
            CorrelationId id = (CorrelationId)Iterables.getOnlyElement(variablesSet);
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns(id, right.rel);
            if (!RelOptUtil.notContainsCorrelation(left.rel, id, Litmus.IGNORE)) {
                throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
            }
            switch (joinType) {
                case LEFT: {
                    this.stack.push(right);
                    this.filter(condition.accept(new Shifter(left.rel, id, right.rel)));
                    right = this.stack.pop();
                    break;
                }
                default: {
                    postCondition = condition;
                }
            }
            join = this.correlateFactory.createCorrelate(left.rel, right.rel, id, requiredColumns, SemiJoinType.of(joinType));
        } else {
            join = this.joinFactory.createJoin(left.rel, right.rel, condition, variablesSet, joinType, false);
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(join, fields.build()));
        this.filter(postCondition);
        return this;
    }

    public RelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.call((SqlOperator)SqlStdOperatorTable.EQUALS, this.field(2, 0, fieldName), this.field(2, 1, fieldName)));
        }
        return this.join(joinType, conditions);
    }

    public RelBuilder semiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode semiJoin = this.semiJoinFactory.createSemiJoin(this.peek(), right.rel, this.and(conditions));
        this.replaceTop(semiJoin);
        return this;
    }

    public RelBuilder semiJoin(RexNode ... conditions) {
        return this.semiJoin((Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])conditions));
    }

    public RelBuilder as(final String alias) {
        Frame pair = this.stack.pop();
        List newFields = Lists.transform(pair.fields, (Function)new Function<Field, Field>(){

            public Field apply(Field field) {
                return new Field((ImmutableSet<String>)ImmutableSet.builder().addAll((Iterable)field.left).add((Object)alias).build(), (RelDataTypeField)field.right);
            }
        });
        this.stack.push(new Frame(pair.rel, ImmutableList.copyOf((Collection)newFields)));
        return this;
    }

    public RelBuilder values(String[] fieldNames, Object ... values) {
        if (fieldNames == null || fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        final int rowCount = values.length / fieldNames.length;
        for (Ord fieldName : Ord.zip((Object[])fieldNames)) {
            if (!this.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' are null; cannot deduce type");
        }
        final ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        RelDataTypeFactory.FieldInfoBuilder rowTypeBuilder = this.cluster.getTypeFactory().builder();
        for (final Ord fieldName : Ord.zip((Object[])fieldNames)) {
            String name = fieldName.e != null ? (String)fieldName.e : "expr$" + fieldName.i;
            RelDataType type = this.cluster.getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((ImmutableList)tupleList.get(index)).get(fieldName.i)).getType();
                }

                @Override
                public int size() {
                    return rowCount;
                }
            });
            rowTypeBuilder.add(name, type);
        }
        RelDataType rowType = rowTypeBuilder.build();
        return this.values((Iterable<? extends List<RexLiteral>>)tupleList, rowType);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add((RexLiteral)this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add((Object)ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private boolean allNull(Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public RelBuilder empty() {
        Frame frame = this.stack.pop();
        return this.values(frame.rel.getRowType());
    }

    public RelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(Iterable<? extends List<RexLiteral>> tupleList, RelDataType rowType) {
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, (List<ImmutableList<RexLiteral>>)RelBuilder.copy(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(RelDataType rowType) {
        return this.values((Iterable<? extends List<RexLiteral>>)ImmutableList.of(), rowType);
    }

    private static <E> ImmutableList<ImmutableList<E>> copy(Iterable<? extends List<E>> tupleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int changeCount = 0;
        for (List<E> literals : tupleList) {
            ImmutableList literals2 = ImmutableList.copyOf(literals);
            builder.add((Object)literals2);
            if (literals == literals2) continue;
            ++changeCount;
        }
        if (changeCount == 0) {
            return (ImmutableList)tupleList;
        }
        return builder.build();
    }

    public RelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.of());
    }

    public RelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add((Object)(field < 0 ? this.desc(this.field(-field - 1)) : this.field(field)));
        }
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)builder.build());
    }

    public RelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public RelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, (Iterable<? extends RexNode>)ImmutableList.copyOf((Object[])nodes));
    }

    public RelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        boolean addedFields;
        RexNode rexNode;
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        ImmutableList originalExtraNodes = ImmutableList.copyOf(extraNodes);
        for (RexNode rexNode2 : nodes) {
            fieldCollations.add(RelBuilder.collation(rexNode2, RelFieldCollation.Direction.ASCENDING, null, extraNodes));
        }
        RexNode offsetNode = offset <= 0 ? null : this.literal(offset);
        RexNode rexNode3 = rexNode = fetch < 0 ? null : this.literal(fetch);
        if (offsetNode == null && fetch == 0) {
            return this.empty();
        }
        if (offsetNode == null && rexNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        boolean bl = addedFields = extraNodes.size() > originalExtraNodes.size();
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (!addedFields);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    this.replaceTop(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.peek(), sort2.collation, offsetNode, rexNode);
                    this.replaceTop(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    RelNode sort = this.sortFactory.createSort(sort2.getInput(), sort2.collation, offsetNode, rexNode);
                    this.replaceTop(this.projectFactory.createProject(sort, project.getProjects(), Pair.right(project.getNamedProjects())));
                    return this;
                }
            }
        }
        if (addedFields) {
            this.project(extraNodes);
        }
        RelNode sort = this.sortFactory.createSort(this.peek(), RelCollations.of(fieldCollations), offsetNode, rexNode);
        this.replaceTop(sort);
        if (addedFields) {
            this.project((Iterable<? extends RexNode>)originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, Util.first(nullDirection, direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, Util.first(nullDirection, direction.defaultNullDirection()));
    }

    public RelBuilder convert(RelDataType castRowType, boolean rename) {
        RelNode r = this.build();
        RelNode r2 = RelOptUtil.createCastRel(r, castRowType, rename, this.projectFactory);
        this.push(r2);
        return this;
    }

    public RelBuilder permute(Mapping mapping) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return this;
        }
        ArrayList exprList = Lists.newArrayList();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            exprList.add(this.field(mapping.getSource(i)));
        }
        return this.project(exprList);
    }

    public RelBuilder aggregate(GroupKey groupKey, List<AggregateCall> aggregateCalls) {
        return this.aggregate(groupKey, Lists.transform(aggregateCalls, (Function)new Function<AggregateCall, AggCall>(){

            public AggCall apply(AggregateCall input) {
                return new AggCallImpl2(input);
            }
        }));
    }

    public void clear() {
        this.stack.clear();
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = RelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }

    private static class Field
    extends Pair<ImmutableSet<String>, RelDataTypeField> {
        public Field(ImmutableSet<String> left, RelDataTypeField right) {
            super(left, right);
        }
    }

    private static class Frame {
        final RelNode rel;
        final ImmutableList<Field> fields;

        private Frame(RelNode rel, ImmutableList<Field> fields) {
            this.rel = rel;
            this.fields = fields;
        }

        private Frame(RelNode rel) {
            String tableAlias = Frame.deriveAlias(rel);
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableSet aliases = tableAlias == null ? ImmutableSet.of() : ImmutableSet.of((Object)tableAlias);
            for (RelDataTypeField field : rel.getRowType().getFieldList()) {
                builder.add((Object)new Field((ImmutableSet<String>)aliases, field));
            }
            this.rel = rel;
            this.fields = builder.build();
        }

        private static String deriveAlias(RelNode rel) {
            List<String> names;
            if (rel instanceof TableScan && !(names = rel.getTable().getQualifiedName()).isEmpty()) {
                return Util.last(names);
            }
            return null;
        }

        List<RelDataTypeField> fields() {
            return Pair.right(this.fields);
        }
    }

    private static class AggCallImpl2
    implements AggCall {
        private final AggregateCall aggregateCall;

        AggCallImpl2(AggregateCall aggregateCall) {
            this.aggregateCall = (AggregateCall)Preconditions.checkNotNull((Object)aggregateCall);
        }
    }

    private static class AggCallImpl
    implements AggCall {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final RexNode filter;
        private final String alias;
        private final ImmutableList<RexNode> operands;

        AggCallImpl(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, ImmutableList<RexNode> operands) {
            this.aggFunction = aggFunction;
            this.distinct = distinct;
            this.filter = filter;
            this.alias = alias;
            this.operands = operands;
        }
    }

    protected static class GroupKeyImpl
    implements GroupKey {
        final ImmutableList<RexNode> nodes;
        final boolean indicator;
        final ImmutableList<ImmutableList<RexNode>> nodeLists;
        final String alias;

        GroupKeyImpl(ImmutableList<RexNode> nodes, boolean indicator, ImmutableList<ImmutableList<RexNode>> nodeLists, String alias) {
            this.nodes = (ImmutableList)Preconditions.checkNotNull(nodes);
            this.indicator = indicator;
            this.nodeLists = nodeLists;
            this.alias = alias;
        }

        public String toString() {
            return this.alias == null ? this.nodes.toString() : this.nodes + " as " + this.alias;
        }

        @Override
        public GroupKey alias(String alias) {
            return Objects.equals(this.alias, alias) ? this : new GroupKeyImpl(this.nodes, this.indicator, this.nodeLists, alias);
        }
    }

    public static interface GroupKey {
        public GroupKey alias(String var1);
    }

    public static interface AggCall {
    }
}

