/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import org.apache.hadoop.conf.Configuration;
import org.jdom.Element;
import org.jdom.Namespace;

class LauncherConfigHandler {
    private static final String LAUNCHER_MEMORY_MB = "memory.mb";
    private static final String LAUNCHER_VCORES = "vcores";
    private static final String LAUNCHER_PRIORITY = "priority";
    private static final String LAUNCHER_JAVAOPTS = "java-opts";
    private static final String LAUNCHER_ENV = "env";
    private static final String LAUNCHER_SHARELIB = "sharelib";
    private static final String LAUNCHER_QUEUE = "queue";
    private static final String LAUNCHER_VIEW_ACL = "view-acl";
    private static final String LAUNCHER_MODIFY_ACL = "modify-acl";
    private final Configuration entries;
    private final Element xmlLauncherElement;
    private final Namespace ns;

    public LauncherConfigHandler(Configuration entries, Element globalLauncherElement, Namespace ns) {
        this.entries = entries;
        this.xmlLauncherElement = globalLauncherElement;
        this.ns = ns;
    }

    private void setStringCfgSetting(String xmlTag, String configKey) {
        Element launcherSetting = this.xmlLauncherElement.getChild(xmlTag, this.ns);
        if (launcherSetting != null) {
            this.entries.set(configKey, launcherSetting.getText());
        }
    }

    private void setIntCfgSetting(String xmlTag, String configKey) {
        Element launcherSetting = this.xmlLauncherElement.getChild(xmlTag, this.ns);
        if (launcherSetting != null) {
            this.entries.setInt(configKey, Integer.parseInt(launcherSetting.getText()));
        }
    }

    public void processSettings() {
        this.setIntCfgSetting(LAUNCHER_MEMORY_MB, "oozie.launcher.memory.mb");
        this.setIntCfgSetting(LAUNCHER_VCORES, "oozie.launcher.vcores");
        this.setIntCfgSetting(LAUNCHER_PRIORITY, "oozie.launcher.priority");
        this.setStringCfgSetting(LAUNCHER_JAVAOPTS, "oozie.launcher.javaopts");
        this.setStringCfgSetting(LAUNCHER_ENV, "oozie.launcher.env");
        this.setStringCfgSetting(LAUNCHER_QUEUE, "oozie.launcher.queue");
        this.setStringCfgSetting(LAUNCHER_SHARELIB, "oozie.launcher.sharelib");
        this.setStringCfgSetting(LAUNCHER_VIEW_ACL, "oozie.launcher.view.acl");
        this.setStringCfgSetting(LAUNCHER_MODIFY_ACL, "oozie.launcher.modify.acl");
    }
}

