/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.graph.GraphRenderer;
import org.apache.oozie.util.graph.OutputFormat;
import org.apache.oozie.util.graph.WorkflowGraphHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class GraphGenerator {
    public static final String SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String SAX_FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private final GraphRenderer graphRenderer;
    private final String xml;
    private final WorkflowJob job;
    private final boolean showKill;

    public GraphGenerator(String xml, WorkflowJob job, boolean showKill, GraphRenderer graphRenderer) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)xml) ? 1 : 0) != 0, (Object)"xml can't be empty");
        Preconditions.checkArgument((job != null ? 1 : 0) != 0, (Object)"WorkflowJob can't be null");
        this.xml = xml;
        this.job = job;
        this.showKill = showKill;
        this.graphRenderer = graphRenderer;
    }

    public void write(OutputStream out, OutputFormat outputFormat) throws ParserConfigurationException, SAXException, IOException {
        XMLReader xmlReader = this.newXmlReader();
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setContentHandler(new WorkflowGraphHandler(out, outputFormat, this.job, this.showKill, this.graphRenderer));
        try (StringReader stringReader = new StringReader(this.xml);){
            xmlReader.parse(new InputSource(stringReader));
        }
    }

    private XMLReader newXmlReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature(SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        spf.setFeature(SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        spf.setFeature(SAX_FEATURE_DISALLOW_DOCTYPE_DECL, true);
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return xmlReader;
    }
}

