/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.XLogUserFilterParam;

public class XLogErrorStreamer
extends XLogStreamer {
    public static final String STREAM_BUFFER_LEN = "oozie.service.XLogStreamingService.error.buffer.len";

    public XLogErrorStreamer(XLogFilter logFilter, Map<String, String[]> requestParameters) {
        super(logFilter, Services.get().get(XLogService.class).getOozieErrorLogPath(), Services.get().get(XLogService.class).getOozieErrorLogName(), Services.get().get(XLogService.class).getOozieErrorLogRotation());
        this.requestParam = requestParameters;
        this.bufferLen = ConfigurationService.getInt(STREAM_BUFFER_LEN, 2048);
    }

    public XLogErrorStreamer(Map<String, String[]> requestParameters) throws CommandException {
        this(new XLogFilter(new XLogUserFilterParam(requestParameters)), requestParameters);
    }

    @Override
    protected void calculateAndValidateDateRange(Date startTime, Date endTime) throws IOException {
        this.logFilter.calculateAndCheckDates(startTime, endTime);
    }

    @Override
    public boolean isLogEnabled() {
        return Services.get().get(XLogService.class).isErrorLogEnabled();
    }

    @Override
    public String getLogType() {
        return "errorlog";
    }

    @Override
    public String getLogDisableMessage() {
        return "Error Log is disabled!!";
    }
}

