/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class FSUtils {
    public static final String FILE_SCHEME_PREFIX = "file:";

    public static Path getSymLinkTarget(FileSystem fs, Path p) throws IOException {
        try {
            Path tempPath = new URI(p.toString()).getFragment() == null ? p : new Path(new URI(p.toString()).getPath());
            return fs.getFileLinkStatus(tempPath).getSymlink();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static boolean isSymlink(FileSystem fs, Path p) throws IOException {
        try {
            Path tempPath = new URI(p.toString()).getFragment() == null ? p : new Path(new URI(p.toString()).getPath());
            return fs.getFileLinkStatus(tempPath).isSymlink();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static void createSymlink(FileSystem fs, Path target, Path link, boolean createParent) throws IOException {
        fs.createSymlink(target, link, createParent);
    }

    public static boolean isLocalFile(String fileName) {
        return fileName.startsWith("file:/");
    }

    public static boolean isLocalFile(Path filePath) {
        return FSUtils.isLocalFile(filePath.toString());
    }

    public static boolean isNotLocalFile(String fileName) {
        return !FSUtils.isLocalFile(fileName);
    }
}

