/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetRecordsOnRestartJPAExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.SLAXCommandFactory;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XLog;

public class SLACalculatorMemory
implements SLACalculator {
    private static XLog LOG = XLog.getLog(SLACalculatorMemory.class);
    private Map<String, SLACalcStatus> slaMap;
    protected Set<String> historySet;
    private static int capacity;
    private static JPAService jpaService;
    protected EventHandlerService eventHandler;
    private static int modifiedAfter;
    private static long jobEventLatency;
    private Instrumentation instrumentation;
    public static final String INSTRUMENTATION_GROUP = "sla-calculator";
    public static final String SLA_MAP = "sla-map";
    private int maxRetryCount;

    @Override
    public void init(Configuration conf) throws ServiceException {
        capacity = ConfigurationService.getInt(conf, "oozie.sla.service.SLAService.capacity");
        jobEventLatency = ConfigurationService.getInt(conf, "oozie.sla.service.SLAService.job.event.latency");
        this.maxRetryCount = ConfigurationService.getInt(conf, "oozie.sla.service.SLAService.maximum.retry.count");
        this.slaMap = new ConcurrentHashMap<String, SLACalcStatus>();
        this.historySet = Collections.synchronizedSet(new HashSet());
        jpaService = Services.get().get(JPAService.class);
        this.eventHandler = Services.get().get(EventHandlerService.class);
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
        modifiedAfter = conf.getInt("oozie.sla.service.SLAService.events.modified.after", 7);
        this.loadOnRestart();
        HistoryPurgeWorker purgeThread = new HistoryPurgeWorker();
        Services.get().get(SchedulerService.class).schedule(purgeThread, 3600L, (long)Services.get().getConf().getInt("oozie.sla.service.SLAService.history.purge.interval", 3600), SchedulerService.Unit.SEC);
    }

    private void loadOnRestart() {
        try {
            List<SLASummaryBean> summaryBeans = jpaService.execute(new SLASummaryGetRecordsOnRestartJPAExecutor(modifiedAfter));
            for (SLASummaryBean summaryBean : summaryBeans) {
                String jobId = summaryBean.getId();
                this.putAndIncrement(jobId, new SLACalcStatus(summaryBean));
            }
            LOG.info("Loaded {0} SLASummary object after restart", this.slaMap.size());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to retrieve SLASummary records on restart", e);
        }
    }

    @Override
    public int size() {
        return this.slaMap.size();
    }

    @VisibleForTesting
    public Set<String> getHistorySet() {
        return this.historySet;
    }

    @Override
    public SLACalcStatus get(String jobId) throws JPAExecutorException {
        SLACalcStatus memObj = this.slaMap.get(jobId);
        if (memObj == null && this.historySet.contains(jobId)) {
            memObj = new SLACalcStatus(SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId), SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, jobId));
        }
        return memObj;
    }

    private SLACalcStatus getOrCreateSLACalcStatus(String jobId) throws JPAExecutorException {
        SLACalcStatus memObj = this.slaMap.get(jobId);
        if (memObj == null || memObj.getSLARegistrationBean() == null) {
            SLARegistrationBean registrationBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, jobId);
            SLASummaryBean summaryBean = memObj == null ? SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId) : memObj.getSLASummaryBean();
            return new SLACalcStatus(summaryBean, registrationBean);
        }
        return memObj;
    }

    @Override
    public Iterator<String> iterator() {
        return this.slaMap.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.slaMap.isEmpty();
    }

    @Override
    public void clear() {
        int originalSize = this.slaMap.size();
        this.slaMap.clear();
        this.historySet.clear();
        this.instrumentation.decr(INSTRUMENTATION_GROUP, SLA_MAP, originalSize);
    }

    void updateJobSla(String jobId) throws Exception {
        block12: {
            SLACalcStatus slaCalc = this.slaMap.get(jobId);
            if (slaCalc == null) {
                return;
            }
            boolean firstCheckAfterRetstart = this.checkAndUpdateSLACalcAfterRestart(slaCalc);
            SLASummaryBean summaryBean = null;
            try {
                summaryBean = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED, jobId);
                this.resetRetryCount(jobId);
            }
            catch (JPAExecutorException e) {
                if (e.getErrorCode().equals((Object)ErrorCode.E0603) || e.getErrorCode().equals((Object)ErrorCode.E0604) || e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                    LOG.debug("job [{0}] is not in DB, removing from Memory", jobId);
                    this.incrementRetryCountAndRemove(jobId);
                    return;
                }
                throw e;
            }
            byte eventProc = summaryBean.getEventProcessed();
            slaCalc.setEventProcessed(eventProc);
            if (eventProc >= 7) {
                if (eventProc == 7) {
                    this.historySet.add(jobId);
                }
                this.removeAndDecrement(jobId);
                LOG.trace("Removed Job [{0}] from map as SLA processed", jobId);
            } else {
                if (!slaCalc.getLastModifiedTime().equals(summaryBean.getLastModifiedTime())) {
                    slaCalc.setLastModifiedTime(summaryBean.getLastModifiedTime());
                    this.reloadExpectedTimeAndConfig(slaCalc);
                    LOG.debug("Last modified time has changed for job " + jobId + " reloading config from DB");
                }
                if (firstCheckAfterRetstart || this.isChanged(slaCalc)) {
                    LOG.debug("{0} job has SLA event change. EventProc = {1}, status = {2}", slaCalc.getId(), slaCalc.getEventProcessed(), slaCalc.getJobStatus());
                    try {
                        SLAXCommandFactory.getSLAEventXCommand(slaCalc).call();
                        this.checkEventProc(slaCalc);
                    }
                    catch (XException e) {
                        if (e.getErrorCode().equals((Object)ErrorCode.E0604) || e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                            LOG.debug("job [{0}] is is not in DB, removing from Memory", slaCalc.getId());
                            this.removeAndDecrement(jobId);
                        }
                        if (!firstCheckAfterRetstart) break block12;
                        slaCalc.setSLARegistrationBean(null);
                    }
                }
            }
        }
    }

    private boolean isChanged(SLACalcStatus slaCalc) {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc & 1) == 0) {
            if (reg.getExpectedStart() != null) {
                if (reg.getExpectedStart().getTime() + jobEventLatency < System.currentTimeMillis()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (eventProc != 8 && (eventProc >> 1 & 1) == 0) {
            if (reg.getExpectedDuration() == -1L) {
                return true;
            }
            if (slaCalc.getActualStart() != null && reg.getExpectedDuration() + jobEventLatency < System.currentTimeMillis() - slaCalc.getActualStart().getTime()) {
                return true;
            }
        }
        return eventProc < 4 && reg.getExpectedEnd().getTime() + jobEventLatency < System.currentTimeMillis();
    }

    private void updateDBSlaConfig(SLACalcStatus slaCalc, List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_CONFIG, slaCalc.getSLARegistrationBean()));
        slaCalc.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_LAST_MODIFIED_TIME, new SLASummaryBean(slaCalc)));
    }

    private void updateDBSlaExpectedValues(SLACalcStatus slaCalc, List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        slaCalc.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_EXPECTED_VALUE, slaCalc.getSLARegistrationBean()));
        updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES, new SLASummaryBean(slaCalc)));
    }

    private void executeBatchQuery(List<BatchQueryExecutor.UpdateEntry> updateList) throws JPAExecutorException {
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, updateList, null);
    }

    @Override
    public void updateAllSlaStatus() {
        LOG.info("Running periodic SLA check");
        for (String jobId : this.slaMap.keySet()) {
            try {
                LOG.trace("Processing SLA for jobid={0}", jobId);
                this.updateJobSla(jobId);
            }
            catch (Exception e) {
                this.setLogPrefix(jobId);
                LOG.error("Exception in SLA processing for job [{0}]", jobId, e);
                LogUtils.clearLogPrefix();
            }
        }
    }

    @Override
    public boolean addRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (this.slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            ArrayList<JsonBean> insertList = new ArrayList<JsonBean>();
            SLASummaryBean summaryBean = new SLASummaryBean(slaCalc);
            Timestamp currentTime = DateUtils.convertDateToTimestamp(new Date());
            reg.setCreatedTimestamp(currentTime);
            summaryBean.setCreatedTimestamp(currentTime);
            insertList.add(reg);
            insertList.add(summaryBean);
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
            this.putAndIncrement(jobId, slaCalc);
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        this.setLogPrefix(reg.getId());
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        LogUtils.clearLogPrefix();
        return false;
    }

    private String getJobStatus(AppType appType) {
        String status = null;
        switch (appType) {
            case COORDINATOR_ACTION: {
                status = CoordinatorAction.Status.WAITING.name();
                break;
            }
            case WORKFLOW_ACTION: {
                status = WorkflowAction.Status.PREP.name();
                break;
            }
            case WORKFLOW_JOB: {
                status = WorkflowJob.Status.PREP.name();
                break;
            }
        }
        return status;
    }

    @Override
    public boolean updateRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (this.slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
            updateList.add(new BatchQueryExecutor.UpdateEntry<SLARegistrationQueryExecutor.SLARegQuery>(SLARegistrationQueryExecutor.SLARegQuery.UPDATE_SLA_REG_ALL, reg));
            updateList.add(new BatchQueryExecutor.UpdateEntry<SLASummaryQueryExecutor.SLASummaryQuery>(SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, new SLASummaryBean(slaCalc)));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, updateList, null);
            this.putAndIncrement(jobId, slaCalc);
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        this.setLogPrefix(reg.getId());
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        LogUtils.clearLogPrefix();
        return false;
    }

    @Override
    public void removeRegistration(String jobId) {
        if (!this.removeAndDecrement(jobId)) {
            this.historySet.remove(jobId);
        }
    }

    @Override
    public boolean addJobStatus(String jobId, String jobStatus, JobEvent.EventStatus jobEventStatus, Date startTime, Date endTime) throws JPAExecutorException, ServiceException {
        LOG.debug("Received addJobStatus request for job  [{0}] jobStatus = [{1}], jobEventStatus = [{2}], startTime = [{3}], endTime = [{4}] ", jobId, jobStatus, jobEventStatus, startTime, endTime);
        SLACalcStatus slaCalc = this.slaMap.get(jobId);
        boolean firstCheckAfterRetstart = this.checkAndUpdateSLACalcAfterRestart(slaCalc);
        if (slaCalc == null) {
            SLARegistrationBean slaRegBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, jobId);
            if (slaRegBean != null) {
                SLASummaryBean slaSummaryBean = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, jobId);
                slaCalc = new SLACalcStatus(slaSummaryBean, slaRegBean);
                this.putAndIncrement(jobId, slaCalc);
            }
        } else {
            SLASummaryBean summaryBean = ((SLASummaryQueryExecutor)SLASummaryQueryExecutor.getInstance()).get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED_LAST_MODIFIED, jobId);
            byte eventProc = summaryBean.getEventProcessed();
            if (!slaCalc.getLastModifiedTime().equals(summaryBean.getLastModifiedTime())) {
                slaCalc.setLastModifiedTime(summaryBean.getLastModifiedTime());
                this.reloadExpectedTimeAndConfig(slaCalc);
                LOG.debug("Last modified time has changed for job " + jobId + " reloading config from DB");
            }
            slaCalc.setEventProcessed(eventProc);
        }
        if (slaCalc != null) {
            try {
                SLAXCommandFactory.getSLAEventXCommand(slaCalc, ConfigurationService.getLong("oozie.sla.service.SLAService.oozie.sla.calc.default.lock.timeout", 20000L)).call();
                this.checkEventProc(slaCalc);
            }
            catch (XException e) {
                if (firstCheckAfterRetstart) {
                    slaCalc.setSLARegistrationBean(null);
                }
                LOG.error(e);
                throw new ServiceException(e);
            }
            return true;
        }
        return false;
    }

    private void checkEventProc(SLACalcStatus slaCalc) {
        byte eventProc = slaCalc.getEventProcessed();
        if (slaCalc.getEventProcessed() >= 8) {
            this.removeAndDecrement(slaCalc.getId());
            LOG.debug("Removed Job [{0}] from map after Event-processed=8", slaCalc.getId());
        }
        if (eventProc == 7) {
            this.historySet.add(slaCalc.getId());
            this.removeAndDecrement(slaCalc.getId());
            LOG.debug("Removed Job [{0}] from map after Event-processed=7", slaCalc.getId());
        }
    }

    public void reloadExpectedTimeAndConfig(SLACalcStatus slaCalc) throws JPAExecutorException {
        SLARegistrationBean regBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_EXPECTED_VALUE_CONFIG, slaCalc.getId());
        if (regBean.getExpectedDuration() > 0L) {
            slaCalc.getSLARegistrationBean().setExpectedDuration(regBean.getExpectedDuration());
        }
        if (regBean.getExpectedEnd() != null) {
            slaCalc.getSLARegistrationBean().setExpectedEnd(regBean.getExpectedEnd());
        }
        if (regBean.getExpectedStart() != null) {
            slaCalc.getSLARegistrationBean().setExpectedStart(regBean.getExpectedStart());
        }
        if (regBean.getSLAConfigMap().containsKey("oozie.sla.disable.alerts")) {
            slaCalc.getSLARegistrationBean().addToSLAConfigMap("oozie.sla.disable.alerts", regBean.getSLAConfigMap().get("oozie.sla.disable.alerts"));
        }
        if (regBean.getNominalTime() != null) {
            slaCalc.getSLARegistrationBean().setNominalTime(regBean.getNominalTime());
        }
    }

    @VisibleForTesting
    public boolean isJobIdInSLAMap(String jobId) {
        return this.slaMap.containsKey(jobId);
    }

    @VisibleForTesting
    public boolean isJobIdInHistorySet(String jobId) {
        return this.historySet.contains(jobId);
    }

    private void setLogPrefix(String jobId) {
        LOG = LogUtils.setLogInfo(LOG, jobId, null, null);
    }

    @Override
    public boolean enableAlert(List<String> jobIds) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (String jobId : jobIds) {
            SLACalcStatus slaCalc = this.getOrCreateSLACalcStatus(jobId);
            slaCalc.getSLARegistrationBean().removeFromSLAConfigMap("oozie.sla.disable.alerts");
            this.updateDBSlaConfig(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    @Override
    public boolean enableChildJobAlert(List<String> parentJobIds) throws JPAExecutorException, ServiceException {
        return this.enableAlert(this.getSLAJobsforParents(parentJobIds));
    }

    @Override
    public boolean disableAlert(List<String> jobIds) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (String jobId : jobIds) {
            SLACalcStatus slaCalc = this.getOrCreateSLACalcStatus(jobId);
            slaCalc.getSLARegistrationBean().addToSLAConfigMap("oozie.sla.disable.alerts", Boolean.toString(true));
            this.updateDBSlaConfig(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    @Override
    public boolean disableChildJobAlert(List<String> parentJobIds) throws JPAExecutorException, ServiceException {
        return this.disableAlert(this.getSLAJobsforParents(parentJobIds));
    }

    @Override
    public boolean changeDefinition(List<Pair<String, Map<String, String>>> jobIdsSLAPair) throws JPAExecutorException, ServiceException {
        boolean isJobFound = false;
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        for (Pair<String, Map<String, String>> jobIdSLAPair : jobIdsSLAPair) {
            SLACalcStatus slaCalc = this.getOrCreateSLACalcStatus(jobIdSLAPair.getFirst());
            this.updateParams(slaCalc, jobIdSLAPair.getSecond());
            this.updateDBSlaExpectedValues(slaCalc, updateList);
            isJobFound = true;
        }
        this.executeBatchQuery(updateList);
        return isJobFound;
    }

    private void updateParams(SLACalcStatus slaCalc, Map<String, String> newParams) throws ServiceException {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        if (newParams != null) {
            try {
                Date newNominal = SLAOperations.setNominalTime(newParams.get("sla-nominal-time"), reg);
                SLAOperations.setExpectedStart(newParams.get("sla-should-start"), newNominal, reg);
                SLAOperations.setExpectedEnd(newParams.get("sla-should-end"), newNominal, reg);
                SLAOperations.setExpectedDuration(newParams.get("sla-max-duration"), reg);
            }
            catch (CommandException ce) {
                throw new ServiceException(ce);
            }
        }
    }

    private List<String> getSLAJobsforParents(List<String> parentJobIds) throws JPAExecutorException {
        ArrayList<String> childJobIds = new ArrayList<String>();
        for (String jobId : parentJobIds) {
            List<SLARegistrationBean> registrationBeanList = SLARegistrationQueryExecutor.getInstance().getList(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_FOR_PARENT_ID, jobId);
            for (SLARegistrationBean bean : registrationBeanList) {
                childJobIds.add(bean.getId());
            }
        }
        return childJobIds;
    }

    private boolean checkAndUpdateSLACalcAfterRestart(SLACalcStatus slaCalc) throws JPAExecutorException {
        if (slaCalc != null && slaCalc.getSLARegistrationBean() == null) {
            return this.updateSLARegistartion(slaCalc);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSLARegistartion(SLACalcStatus slaCalc) throws JPAExecutorException {
        if (slaCalc.getSLARegistrationBean() == null) {
            SLACalcStatus sLACalcStatus = slaCalc;
            synchronized (sLACalcStatus) {
                if (slaCalc.getSLARegistrationBean() == null) {
                    SLARegistrationBean slaRegBean = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, slaCalc.getId());
                    slaCalc.updateSLARegistrationBean(slaRegBean);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean putAndIncrement(String jobId, SLACalcStatus newStatus) {
        if (this.slaMap.put(jobId, newStatus) == null) {
            LOG.trace("Added a new item to SLA map. [jobId={0}]", jobId);
            this.instrumentation.incr(INSTRUMENTATION_GROUP, SLA_MAP, 1L);
            return true;
        }
        LOG.trace("Updated an existing item in SLA map. [jobId={0}]", jobId);
        return false;
    }

    private boolean removeAndDecrement(String jobId) {
        if (this.slaMap.remove(jobId) != null) {
            LOG.trace("Removed an existing item from SLA map. [jobId={0}]", jobId);
            this.instrumentation.decr(INSTRUMENTATION_GROUP, SLA_MAP, 1L);
            return true;
        }
        LOG.trace("Tried to remove a non-existing item from SLA map. [jobId={0}]", jobId);
        return false;
    }

    private void resetRetryCount(String jobId) {
        if (this.slaMap.containsKey(jobId)) {
            LOG.debug("Resetting retry count on [{0}]", jobId);
            SLACalcStatus existingStatus = this.slaMap.get(jobId);
            existingStatus.resetRetryCount();
            this.putAndIncrement(jobId, existingStatus);
        }
    }

    private void incrementRetryCountAndRemove(String jobId) {
        LOG.debug("Checking SLA calculator status [{0}] for retry count", jobId);
        if (this.slaMap.containsKey(jobId)) {
            SLACalcStatus existingStatus = this.slaMap.get(jobId);
            if (existingStatus.getRetryCount() < this.maxRetryCount) {
                existingStatus.incrementRetryCount();
                LOG.debug("Retrying with SLA calculator status [{0}] retry count [{1}]", jobId, existingStatus.getRetryCount());
                this.putAndIncrement(jobId, existingStatus);
            } else {
                LOG.debug("Removing [{0}] from SLA map as maximum retry count reached", jobId);
                this.removeAndDecrement(jobId);
            }
        }
    }

    public class HistoryPurgeWorker
    extends Thread {
        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Iterator<String> jobItr = SLACalculatorMemory.this.historySet.iterator();
            while (jobItr.hasNext()) {
                String jobId = jobItr.next();
                LOG.debug(" Running HistoryPurgeWorker for " + jobId);
                try {
                    boolean isDone = (Boolean)SLAXCommandFactory.getSLAJobHistoryXCommand(jobId).call();
                    if (!isDone) continue;
                    LOG.debug("[{0}] job is finished and processed. Removing from history");
                    jobItr.remove();
                }
                catch (CommandException e) {
                    if (e.getErrorCode().equals((Object)ErrorCode.E0604) || e.getErrorCode().equals((Object)ErrorCode.E0605)) {
                        LOG.warn((Object)("Job is not found in db: " + jobId), e);
                        jobItr.remove();
                        continue;
                    }
                    LOG.error((Object)("Failed to fetch the job: " + jobId), e);
                }
            }
        }
    }
}

