/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FilterParser;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetForFilterJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.SLAServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class V2SLAServlet
extends SLAServlet {
    private static final String INSTRUMENTATION_NAME = "v2sla";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public V2SLAServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        XLog.getLog(((Object)((Object)this)).getClass()).debug("Got SLA GET request: {0}", request.getQueryString());
        try {
            this.stopCron();
            JSONObject json = this.getSLASummaryList(request);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        }
        catch (CommandException ce) {
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Command exception ", ce);
            throw new XServletException(500, ce);
        }
        catch (RuntimeException re) {
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)"Runtime error ", re);
            throw new XServletException(500, ErrorCode.E0307, re.getMessage());
        }
    }

    private JSONObject getSLASummaryList(HttpServletRequest request) throws ServletException, CommandException {
        String timeZoneId = request.getParameter("timezone");
        String filterString = request.getParameter("filter");
        String orderString = request.getParameter("order");
        String sortbyString = request.getParameter("sortby");
        String maxResults = request.getParameter("len");
        int numMaxResults = 1000;
        boolean isDescendingOrder = false;
        if (maxResults != null) {
            numMaxResults = Integer.parseInt(maxResults);
        }
        if (Strings.isNullOrEmpty((String)filterString)) {
            throw new XServletException(400, ErrorCode.E0305, "filter");
        }
        if (!Strings.isNullOrEmpty((String)orderString)) {
            isDescendingOrder = this.getOrder(orderString);
        }
        try {
            ListMultimap<String, String> filterParams = FilterParser.parseFilter(filterString);
            return this.getSLASummaryListByFilterParams(timeZoneId, numMaxResults, filterParams, sortbyString, isDescendingOrder);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new XServletException(400, ErrorCode.E0303, filterString, e);
        }
    }

    private boolean getOrder(String orderString) throws XServletException {
        switch (orderString) {
            case "desc": {
                return true;
            }
            case "asc": {
                return false;
            }
        }
        throw new XServletException(400, ErrorCode.E0303, "order", orderString);
    }

    @VisibleForTesting
    JSONObject getSLASummaryListByFilterParams(String timeZoneId, int numMaxResults, ListMultimap<String, String> filterList, String sortbyColumn, boolean isDescendingOrder) throws ServletException, ParseException, IllegalArgumentException, JPAExecutorException {
        SLASummaryGetForFilterJPAExecutor slaSummaryGetForFilterJPAExecutor = this.createSlaSummaryGetForFilterJPAExecutor(numMaxResults, filterList, sortbyColumn, isDescendingOrder);
        List<SLASummaryBean> slaSummaryList = this.filterForSlaSummaryBeans(slaSummaryGetForFilterJPAExecutor);
        ArrayList<String> jobIds = new ArrayList<String>();
        if (slaSummaryList != null) {
            for (SLASummaryBean summaryBean : slaSummaryList) {
                jobIds.add(summaryBean.getId());
            }
        }
        List<SLARegistrationBean> SLARegistrationList = SLARegistrationQueryExecutor.getInstance().getList(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_CONFIGS, jobIds);
        HashMap<String, Map<String, String>> jobIdSLAConfigMap = new HashMap<String, Map<String, String>>();
        for (SLARegistrationBean registrationBean : SLARegistrationList) {
            jobIdSLAConfigMap.put(registrationBean.getId(), registrationBean.getSLAConfigMap());
        }
        return SLASummaryBean.toJSONObject(slaSummaryList, jobIdSLAConfigMap, timeZoneId);
    }

    private List<SLASummaryBean> filterForSlaSummaryBeans(SLASummaryGetForFilterJPAExecutor slaSummaryGetForFilterJPAExecutor) throws JPAExecutorException, IllegalArgumentException {
        JPAService jpaService = Services.get().get(JPAService.class);
        List<SLASummaryBean> slaSummaryList = null;
        if (jpaService != null) {
            slaSummaryList = jpaService.execute(slaSummaryGetForFilterJPAExecutor);
        } else {
            XLog.getLog(((Object)((Object)this)).getClass()).error((Object)ErrorCode.E0610);
        }
        return slaSummaryList;
    }

    private SLASummaryGetForFilterJPAExecutor createSlaSummaryGetForFilterJPAExecutor(int numMaxResults, ListMultimap<String, String> filterList, String sortbyColumn, boolean isDescendingOrder) throws ServletException, ParseException {
        SLASummaryGetForFilterJPAExecutor slaSummaryGetForFilterJPAExecutor = new SLASummaryGetForFilterJPAExecutor(numMaxResults);
        slaSummaryGetForFilterJPAExecutor.setSortbyColumn(sortbyColumn);
        slaSummaryGetForFilterJPAExecutor.setDescendingOrder(isDescendingOrder);
        for (String filterName : filterList.keySet()) {
            String filterValue = (String)filterList.get((Object)filterName).get(0);
            slaSummaryGetForFilterJPAExecutor.checkAndSetFilterField(filterName, filterValue);
        }
        return slaSummaryGetForFilterJPAExecutor;
    }

    static {
        V2SLAServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("order", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("sortby", String.class, false, Arrays.asList("GET"))));
    }
}

