/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorWfActionBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.Pair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class V2JobServlet
extends V1JobServlet {
    private static final String INSTRUMENTATION_NAME = "v2job";

    public V2JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JsonBean getWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = super.getWorkflowJobBean(request, response);
        return jobBean;
    }

    @Override
    protected JsonBean getWorkflowAction(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean actionBean = super.getWorkflowActionBean(request, response);
        return actionBean;
    }

    @Override
    protected int getCoordinatorJobLength(int defaultLen, int len) {
        return len < 0 ? defaultLen : len;
    }

    @Override
    protected String getJMSTopicName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String topicName;
        String jobId = this.getResourceName(request);
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
        try {
            topicName = dagEngine.getJMSTopicName(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return topicName;
    }

    @Override
    protected JSONObject getJobsByParentId(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        return super.getJobsByParentId(request, response);
    }

    @Override
    protected JSONObject updateJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        JSONObject json = new JSONObject();
        try {
            String jobId = this.getResourceName(request);
            boolean dryrun = StringUtils.isEmpty((String)request.getParameter("dryrun")) ? false : Boolean.parseBoolean(request.getParameter("dryrun"));
            boolean showDiff = StringUtils.isEmpty((String)request.getParameter("diff")) ? true : Boolean.parseBoolean(request.getParameter("diff"));
            String diff = coordEngine.updateJob(conf, jobId, dryrun, showDiff);
            JSONObject diffJson = new JSONObject();
            diffJson.put((Object)"diff", (Object)diff);
            json.put((Object)"update", (Object)diffJson);
        }
        catch (CoordinatorEngineException e) {
            throw new XServletException(400, e);
        }
        return json;
    }

    @Override
    protected JSONObject ignoreJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            throw new XServletException(400, ErrorCode.E0302, "Workflow Ignore Not supported");
        }
        if (jobId.endsWith("-B")) {
            throw new XServletException(400, ErrorCode.E0302, "Bundle Ignore Not supported");
        }
        return this.ignoreCoordinatorJob(request, response);
    }

    @Override
    protected void slaEnableAlert(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        String actions = request.getParameter("action-list");
        String dates = request.getParameter("date");
        String childIds = request.getParameter("coordinators");
        try {
            this.getBaseEngine(jobId, this.getUser(request)).enableSLAAlert(jobId, actions, dates, childIds);
        }
        catch (BaseEngineException e) {
            throw new XServletException(400, e);
        }
    }

    @Override
    protected void slaDisableAlert(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        String actions = request.getParameter("action-list");
        String dates = request.getParameter("date");
        String childIds = request.getParameter("coordinators");
        try {
            this.getBaseEngine(jobId, this.getUser(request)).disableSLAAlert(jobId, actions, dates, childIds);
        }
        catch (BaseEngineException e) {
            throw new XServletException(400, e);
        }
    }

    @Override
    protected void slaChange(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        String actions = request.getParameter("action-list");
        String dates = request.getParameter("date");
        String newParams = request.getParameter("value");
        String coords = request.getParameter("coordinators");
        try {
            this.getBaseEngine(jobId, this.getUser(request)).changeSLA(jobId, actions, dates, coords, newParams);
        }
        catch (BaseEngineException e) {
            throw new XServletException(400, e);
        }
    }

    private JSONObject ignoreCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JSONObject json = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String type = request.getParameter("type");
        String scope = request.getParameter("scope");
        String changeValue = "status=" + CoordinatorAction.Status.IGNORED;
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList();
        try {
            if (type != null && !type.equals("action")) {
                throw new CommandException(ErrorCode.E1024, "Currently ignore only support -action option");
            }
            CoordinatorActionInfo coordInfo = null;
            if (scope == null || scope.isEmpty()) {
                coordEngine.change(jobId, changeValue);
            } else {
                coordInfo = coordEngine.ignore(jobId, type, scope);
            }
            if (coordInfo != null) {
                coordActions = coordInfo.getCoordActions();
                json = new JSONObject();
                json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(coordActions, "GMT"));
            }
            return json;
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected String getJobStatus(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String status;
        String jobId = this.getResourceName(request);
        try {
            if (jobId.endsWith("-B") || jobId.endsWith("-W")) {
                status = this.getBaseEngine(jobId, this.getUser(request)).getJobStatus(jobId);
            } else if (jobId.contains("C@")) {
                CoordinatorEngine engine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
                status = engine.getActionStatus(jobId);
            } else {
                status = this.getBaseEngine(jobId, this.getUser(request)).getJobStatus(jobId);
            }
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return status;
    }

    @Override
    protected void streamJobErrorLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        try {
            this.getBaseEngine(jobId, this.getUser(request)).streamErrorLog(jobId, response.getWriter(), request.getParameterMap());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (BaseEngineException e) {
            throw new XServletException(400, e);
        }
    }

    @Override
    protected void streamJobAuditLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        try {
            this.getBaseEngine(jobId, this.getUser(request)).streamAuditLog(jobId, response.getWriter(), request.getParameterMap());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (BaseEngineException e) {
            throw new XServletException(400, e);
        }
    }

    @Override
    JSONArray getActionRetries(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        JSONArray jsonArray = new JSONArray();
        String jobId = this.getResourceName(request);
        try {
            jsonArray.addAll(Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request)).getWorkflowActionRetries(jobId));
            return jsonArray;
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    @Override
    protected JSONObject getCoordActionMissingDependencies(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        String actions = request.getParameter("action-list");
        String dates = request.getParameter("date");
        try {
            List<Pair<CoordinatorActionBean, Map<String, ActionDependency>>> dependenciesList = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request)).getCoordActionMissingDependencies(jobId, actions, dates);
            JSONArray dependenciesArray = new JSONArray();
            for (Pair<CoordinatorActionBean, Map<String, ActionDependency>> dependencies : dependenciesList) {
                JSONObject json = new JSONObject();
                JSONArray parentJsonArray = new JSONArray();
                for (String key : dependencies.getSecond().keySet()) {
                    JSONObject dependencyList = new JSONObject();
                    JSONArray jsonArray = new JSONArray();
                    jsonArray.addAll(dependencies.getSecond().get(key).getMissingDependencies());
                    dependencyList.put((Object)"missingDependencies", (Object)jsonArray);
                    dependencyList.put((Object)"dataSet", (Object)key);
                    parentJsonArray.add((Object)dependencyList);
                }
                json.put((Object)"blockedOn", (Object)CoordCommandUtils.getFirstMissingDependency(dependencies.getFirst()));
                json.put((Object)"id", (Object)dependencies.getFirst().getActionNumber());
                json.put((Object)"dataSets", (Object)parentJsonArray);
                dependenciesArray.add((Object)json);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"missingDependencies", (Object)dependenciesArray);
            return jsonObject;
        }
        catch (CommandException e) {
            throw new XServletException(400, e);
        }
    }

    public final BaseEngine getBaseEngine(String jobId, String user) {
        if (jobId.endsWith("-W")) {
            return Services.get().get(DagEngineService.class).getDagEngine(user);
        }
        if (jobId.endsWith("-B")) {
            return Services.get().get(BundleEngineService.class).getBundleEngine(user);
        }
        if (jobId.contains("-C")) {
            return Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(user);
        }
        throw new RuntimeException("Unknown job Type");
    }

    @Override
    protected JSONObject getWfActionByJobIdAndName(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request));
        String jobId = this.getResourceName(request);
        String action = request.getParameter("action-name");
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        String timeZoneId = request.getParameter("timezone");
        String string = timeZoneId = timeZoneId == null ? "GMT" : timeZoneId;
        if (action == null) {
            throw new XServletException(400, ErrorCode.E0305, "action-name");
        }
        int offset = startStr != null ? Integer.parseInt(startStr) : 1;
        offset = offset < 1 ? 1 : offset;
        int defaultLen = ConfigurationService.getInt("oozie.coord.actions.default.length");
        int len = lenStr != null ? Integer.parseInt(lenStr) : 0;
        len = this.getCoordinatorJobLength(defaultLen, len);
        try {
            JSONObject json = new JSONObject();
            List<CoordinatorWfActionBean> coordWfActions = coordEngine.getWfActionByJobIdAndName(jobId, action, offset, len);
            JSONArray array = new JSONArray();
            for (CoordinatorWfActionBean coordWfAction : coordWfActions) {
                array.add((Object)coordWfAction.toJSONObject(timeZoneId));
            }
            json.put((Object)"coordJobId", (Object)jobId);
            json.put((Object)"actions", (Object)array);
            return json;
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }
}

