/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Date;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.SchemaCheckXCommand;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class SchemaCheckerService
implements Service,
Instrumentable {
    private XLog LOG = XLog.getLog(SchemaCheckerService.class);
    public static final String CONF_PREFIX = "oozie.service.SchemaCheckerService.";
    public static final String CONF_INTERVAL = "oozie.service.SchemaCheckerService.check.interval";
    public static final String CONF_IGNORE_EXTRAS = "oozie.service.SchemaCheckerService.ignore.extras";
    private String status = "N/A (not yet run)";
    private String lastCheck = "N/A";

    @Override
    public void init(Services services) throws ServiceException {
        String url = ConfigurationService.get("oozie.service.JPAService.jdbc.url");
        String dbType = url.substring("jdbc:".length());
        dbType = dbType.substring(0, dbType.indexOf(":"));
        int interval = ConfigurationService.getInt(CONF_INTERVAL);
        if (dbType.equals("derby") || dbType.equals("hsqldb") || dbType.equals("sqlserver") || interval <= 0) {
            this.LOG.debug("SchemaCheckerService is disabled: not supported for {0}", dbType);
            this.status = "DISABLED (" + dbType + " not supported)";
        } else {
            String driver = ConfigurationService.get("oozie.service.JPAService.jdbc.driver");
            String user = ConfigurationService.get("oozie.service.JPAService.jdbc.username");
            String pass = ConfigurationService.getPassword("oozie.service.JPAService.jdbc.password", "");
            boolean ignoreExtras = ConfigurationService.getBoolean(CONF_IGNORE_EXTRAS);
            try {
                Class.forName(driver).newInstance();
            }
            catch (Exception ex) {
                throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), ex);
            }
            SchemaCheckerRunnable schemaCheckerRunnable = new SchemaCheckerRunnable(dbType, url, user, pass, ignoreExtras);
            services.get(SchedulerService.class).schedule(schemaCheckerRunnable, 0L, (long)interval, SchedulerService.Unit.HOUR);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SchemaCheckerService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("schema-checker", "status", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return SchemaCheckerService.this.status;
            }
        });
        instr.addVariable("schema-checker", "last-check", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return SchemaCheckerService.this.lastCheck;
            }
        });
    }

    public void updateInstrumentation(boolean problem, Date time) {
        this.status = problem ? "BAD (check log for details)" : "GOOD";
        this.lastCheck = time.toString();
    }

    private class SchemaCheckerRunnable
    implements Runnable {
        private String dbType;
        private String url;
        private String user;
        private String pass;
        private boolean ignoreExtras;

        public SchemaCheckerRunnable(String dbType, String url, String user, String pass, boolean ignoreExtras) {
            this.dbType = dbType;
            this.url = url;
            this.user = user;
            this.pass = pass;
            this.ignoreExtras = ignoreExtras;
        }

        @Override
        public void run() {
            if (Services.get().get(JobsConcurrencyService.class).isLeader()) {
                Services.get().get(CallableQueueService.class).queue(new SchemaCheckXCommand(this.dbType, this.url, this.user, this.pass, this.ignoreExtras));
            } else {
                SchemaCheckerService.this.status = "DISABLED (not leader in HA)";
                SchemaCheckerService.this.lastCheck = "N/A";
            }
        }
    }
}

