/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa.sla;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.servlet.ServletException;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.persistence.QueryImpl;

public class SLASummaryGetForFilterJPAExecutor
implements JPAExecutor<List<SLASummaryBean>> {
    private static final String DBFIELD_EXPECTED_START_TS = "expectedStartTS";
    private static final String DBFIELD_ACTUAL_START_TS = "actualStartTS";
    private static final String DBFIELD_EXPECTED_DURATION = "expectedDuration";
    private static final String DBFIELD_ACTUAL_DURATION = "actualDuration";
    private static final String DBFIELD_EXPECTED_END_TS = "expectedEndTS";
    private static final String DBFIELD_ACTUAL_END_TS = "actualEndTS";
    private static final String DBFIELD_EVENT_STATUS = "eventStatus";
    private static final String DBFIELD_CREATED_TIME_TS = "createdTimeTS";
    private static final String DBFIELD_NOMINAL_TIME_TS = "nominalTimeTS";
    private static final String DBFIELD_JOB_STATUS = "jobStatus";
    private static final String DBFIELD_USER = "user";
    private static final String DBFIELD_APP_TYPE = "appType";
    private static final String DBFIELD_APP_NAME = "appName";
    private static final String DBFIELD_SLA_STATUS = "slaStatus";
    private static final String DBFIELD_JOB_ID = "jobId";
    private static final String DBFIELD_PARENT_ID = "parentId";
    private static final String DBFIELD_BUNDLE_ID = "bundleId";
    private static final String DBFIELD_ID = "id";
    private static final String DBFIELD_COORD_ID = "coordId";
    private static final String DEFAULT_SORTBY_COLUMN = "nominalTimeTS";
    @VisibleForTesting
    final FilterCollection filterCollection = new FilterCollection();
    private int numMaxResults;
    private List<String> possibleSortbyColumns;
    private String sortbyColumn;
    private boolean isDescendingOrder;
    private static XLog LOG = XLog.getLog(SLASummaryGetForFilterJPAExecutor.class);
    private CriteriaBuilder criteriaBuilder;
    private CriteriaQuery<SLASummaryBean> criteriaQuery;
    private Root<SLASummaryBean> root;
    private List<Predicate> preds;
    private static final String multiValueSeparator = ",";
    private static final Pattern BUNDLE_ID_PATTERN = Pattern.compile("\\d{7}-\\d{15}-.{1,10}-B$");

    public SLASummaryGetForFilterJPAExecutor(int numMaxResults) {
        this.numMaxResults = numMaxResults;
    }

    @Override
    public String getName() {
        return SLASummaryGetForFilterJPAExecutor.class.getSimpleName();
    }

    @Override
    public List<SLASummaryBean> execute(EntityManager em) throws JPAExecutorException {
        this.initPossibleSortbyColumnList(em);
        this.createCriteriaQuery(em);
        TypedQuery typedQuery = em.createQuery(this.criteriaQuery);
        typedQuery.setMaxResults(this.numMaxResults);
        LOG.debug("Query string: {0}", ((QueryImpl)typedQuery.unwrap(QueryImpl.class)).getQueryString());
        return typedQuery.getResultList();
    }

    private void initPossibleSortbyColumnList(EntityManager em) {
        Metamodel metamodel = em.getMetamodel();
        EntityType slaSummaryBeanEntityType = metamodel.entity(SLASummaryBean.class);
        Set slaSummaryBeanAttributes = slaSummaryBeanEntityType.getDeclaredAttributes();
        this.possibleSortbyColumns = new ArrayList<String>();
        for (Attribute attribute : slaSummaryBeanAttributes) {
            this.possibleSortbyColumns.add(attribute.getName());
        }
    }

    private void createCriteriaQuery(EntityManager em) throws JPAExecutorException {
        this.ensureCriteriaFields(em);
        this.createSelectFrom();
        this.createWhereCondition();
        this.createOrderByClause();
    }

    private void createOrderByClause() throws JPAExecutorException {
        if (Strings.isNullOrEmpty((String)this.sortbyColumn)) {
            this.sortbyColumn = "nominalTimeTS";
        }
        if (!this.possibleSortbyColumns.contains(this.sortbyColumn)) {
            String errorMessage = String.format("invalid sortby column: %s", this.sortbyColumn);
            LOG.error(errorMessage);
            throw new JPAExecutorException(ErrorCode.E0303, errorMessage);
        }
        Path sortbyColumnPath = this.root.get(this.sortbyColumn);
        Path nominalTimeTSPath = this.root.get("nominalTimeTS");
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (this.isDescendingOrder) {
            orderList.add(this.criteriaBuilder.desc((Expression)sortbyColumnPath));
        } else {
            orderList.add(this.criteriaBuilder.asc((Expression)sortbyColumnPath));
        }
        if (!"nominalTimeTS".equals(this.sortbyColumn)) {
            orderList.add(this.criteriaBuilder.asc((Expression)nominalTimeTSPath));
        }
        this.criteriaQuery.orderBy(orderList);
    }

    private void ensureCriteriaFields(EntityManager em) {
        this.criteriaBuilder = em.getCriteriaBuilder();
        this.criteriaQuery = this.criteriaBuilder.createQuery(SLASummaryBean.class);
    }

    private void createSelectFrom() {
        this.root = this.criteriaQuery.from(SLASummaryBean.class);
        this.criteriaQuery.select(this.root);
    }

    private void createWhereCondition() throws JPAExecutorException {
        this.preds = new ArrayList<Predicate>();
        for (Map.Entry entry : this.filterCollection.filterValues.entrySet()) {
            FilterField filterField = (FilterField)((Object)entry.getKey());
            Object value = entry.getValue();
            if (filterField.filterComparator == null) continue;
            switch (filterField.filterComparator) {
                case LIKE: {
                    this.preds.add(this.criteriaBuilder.like((Expression)this.root.get(filterField.dbFieldName), (String)value));
                    break;
                }
                case EQUALS: {
                    this.preds.add(this.criteriaBuilder.equal((Expression)this.root.get(filterField.dbFieldName), value));
                    break;
                }
                case GREATER_OR_EQUALS: {
                    this.preds.add(this.criteriaBuilder.greaterThanOrEqualTo((Expression)this.root.get(filterField.dbFieldName), (Comparable)value));
                    break;
                }
                case LESSTHAN_OR_EQUALS: {
                    this.preds.add(this.criteriaBuilder.lessThanOrEqualTo((Expression)this.root.get(filterField.dbFieldName), (Comparable)value));
                    break;
                }
                case IN: {
                    this.preds.add(this.root.get(filterField.dbFieldName).in((Collection)((List)value)));
                }
            }
        }
        this.createAndAddSpecialCriterias();
        this.criteriaQuery.where(this.preds.toArray(new Predicate[0]));
    }

    private void createAndAddSpecialCriterias() throws JPAExecutorException {
        this.createAndAddIdAndParentIdCriteria();
        this.createAndAddBundleFilterCriteria();
        this.createAndAddEventStatusCriteria();
    }

    private void createAndAddIdAndParentIdCriteria() {
        String jobId = (String)this.getFilterField(DBFIELD_ID);
        String parentId = (String)this.getFilterField(FilterField.PARENT_ID.getColumnName());
        if (jobId != null && parentId != null) {
            this.preds.add(this.criteriaBuilder.or((Expression)this.criteriaBuilder.equal((Expression)this.root.get(FilterField.ID.dbFieldName), (Object)jobId), (Expression)this.criteriaBuilder.equal((Expression)this.root.get(FilterField.PARENT_ID.dbFieldName), (Object)parentId)));
        } else if (jobId != null && parentId == null) {
            this.preds.add(this.criteriaBuilder.equal((Expression)this.root.get(FilterField.ID.dbFieldName), (Object)jobId));
        } else if (jobId == null && parentId != null) {
            this.preds.add(this.criteriaBuilder.equal((Expression)this.root.get(FilterField.PARENT_ID.dbFieldName), (Object)parentId));
        }
    }

    private void createAndAddBundleFilterCriteria() {
        String bundle = (String)this.getFilterField(FilterField.BUNDLE.getColumnName());
        if (bundle == null) {
            return;
        }
        Subquery subquery = this.criteriaQuery.subquery(BundleActionBean.class);
        Root subJobBeanRoot = subquery.from(BundleJobBean.class);
        Root subActionBeanRoot = subquery.from(BundleActionBean.class);
        subquery.select((Expression)subActionBeanRoot.get(DBFIELD_COORD_ID));
        Predicate bundleJoinPredicate = this.criteriaBuilder.equal((Expression)subActionBeanRoot.get(DBFIELD_BUNDLE_ID), (Expression)subJobBeanRoot.get(DBFIELD_ID));
        if (this.isBundleId(bundle)) {
            subquery.where(new Predicate[]{bundleJoinPredicate, this.criteriaBuilder.equal((Expression)subActionBeanRoot.get(DBFIELD_BUNDLE_ID), (Object)bundle)});
        } else {
            subquery.where(new Predicate[]{bundleJoinPredicate, this.criteriaBuilder.equal((Expression)subJobBeanRoot.get(DBFIELD_APP_NAME), (Object)bundle)});
        }
        this.preds.add((Predicate)this.criteriaBuilder.in((Expression)this.root.get(DBFIELD_PARENT_ID)).value((Expression)subquery));
    }

    private void createAndAddEventStatusCriteria() throws JPAExecutorException {
        String eventStatusFilterFieldName = FilterField.EVENT_STATUS.getColumnName();
        List eventStatusFilterValues = (List)this.getFilterField(eventStatusFilterFieldName);
        if (eventStatusFilterValues != null) {
            ArrayList<Predicate> eventStatusPreds = new ArrayList<Predicate>();
            for (String statusStr : eventStatusFilterValues) {
                SLAEvent.EventStatus status;
                try {
                    status = SLAEvent.EventStatus.valueOf((String)statusStr);
                }
                catch (IllegalArgumentException e) {
                    throw new JPAExecutorException(ErrorCode.E0303, eventStatusFilterFieldName, statusStr);
                }
                eventStatusPreds.addAll(EventStatusFilter.createFilterConditionForEventStatus(status, this.criteriaBuilder, (Root<SLASummaryBean>)this.root));
            }
            this.addEventStatusCriteria(eventStatusPreds);
        }
    }

    private void addEventStatusCriteria(List<Predicate> eventStatusPreds) {
        this.preds.add(this.criteriaBuilder.or(eventStatusPreds.toArray(new Predicate[0])));
    }

    public void checkAndSetFilterField(String name, String value) throws ServletException, ParseException {
        this.filterCollection.checkAndSetFilterField(name, value);
    }

    public void setDescendingOrder(boolean isDescendingOrder) {
        this.isDescendingOrder = isDescendingOrder;
    }

    public void setSortbyColumn(String sortbyColumn) {
        this.sortbyColumn = sortbyColumn;
    }

    @VisibleForTesting
    Object getFilterField(String name) {
        return this.filterCollection.getFilterField(name);
    }

    private boolean isBundleId(String id) {
        return BUNDLE_ID_PATTERN.matcher(id).matches();
    }

    private static enum EventStatusFilter {
        START_MET_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                return Collections.singletonList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS)), criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_START_TS)), criteriaBuilder.ge((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_START_TS))}));
            }
        }
        ,
        START_MISS_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                Timestamp currentTime = new Timestamp(new Date().getTime());
                return Arrays.asList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS)), criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_START_TS)), criteriaBuilder.lessThanOrEqualTo((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_START_TS))}), criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS)), criteriaBuilder.isNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_START_TS)), criteriaBuilder.lessThanOrEqualTo((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_START_TS), (Comparable)currentTime)}));
            }
        }
        ,
        DURATION_MET_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                return Collections.singletonList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_DURATION), (Object)-1), criteriaBuilder.notEqual((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_DURATION), (Object)-1), criteriaBuilder.ge((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_DURATION), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_DURATION))}));
            }
        }
        ,
        DURATION_MISS_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                return Arrays.asList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.notEqual((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_DURATION), (Object)-1), criteriaBuilder.notEqual((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_DURATION), (Object)-1), criteriaBuilder.lessThan((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_DURATION), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_DURATION))}), criteriaBuilder.equal((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EVENT_STATUS), (Object)SLAEvent.EventStatus.DURATION_MISS.name()));
            }
        }
        ,
        END_MET_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                return Collections.singletonList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS)), criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_END_TS)), criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_END_TS))}));
            }
        }
        ,
        END_MISS_FILTER{

            @Override
            public List<Predicate> createFilterCondition(CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) {
                Timestamp currentTime = new Timestamp(new Date().getTime());
                return Arrays.asList(criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS)), criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_END_TS)), criteriaBuilder.lessThanOrEqualTo((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS), (Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_END_TS))}), criteriaBuilder.and(new Predicate[]{criteriaBuilder.isNotNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS)), criteriaBuilder.isNull((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_ACTUAL_END_TS)), criteriaBuilder.lessThanOrEqualTo((Expression)root.get(SLASummaryGetForFilterJPAExecutor.DBFIELD_EXPECTED_END_TS), (Comparable)currentTime)}));
            }
        };


        abstract List<Predicate> createFilterCondition(CriteriaBuilder var1, Root<SLASummaryBean> var2);

        private static List<Predicate> createFilterConditionForEventStatus(SLAEvent.EventStatus eventStatus, CriteriaBuilder criteriaBuilder, Root<SLASummaryBean> root) throws JPAExecutorException {
            try {
                EventStatusFilter eventStatusFilter = EventStatusFilter.valueOf(eventStatus.name() + "_FILTER");
                return eventStatusFilter.createFilterCondition(criteriaBuilder, root);
            }
            catch (IllegalArgumentException e) {
                throw new JPAExecutorException(ErrorCode.E0303, FilterField.EVENT_STATUS.getColumnName(), eventStatus.name());
            }
        }
    }

    @VisibleForTesting
    static class FilterCollection {
        private final Map<FilterField, Object> filterValues = new LinkedHashMap<FilterField, Object>();

        FilterCollection() {
        }

        @VisibleForTesting
        void checkAndSetFilterField(String name, String value) throws ServletException, ParseException {
            FilterField field = FilterField.findByName(name);
            if (field == null) {
                this.throwNewXServletException(ErrorCode.E0401, String.format("Invalid/unsupported names in filter: %s", name));
            } else {
                this.validateAndSetFilterField(this.findNonDeprecatedFilterField(field), FilterField.convertFromString(field, value));
            }
        }

        @VisibleForTesting
        FilterField findNonDeprecatedFilterField(FilterField maybeDeprecatedFilterField) {
            for (Pair pair : FilterField.deprecatedFieldPairs) {
                if (!((FilterField)((Object)pair.getFirst())).equals((Object)maybeDeprecatedFilterField)) continue;
                return (FilterField)((Object)pair.getSecond());
            }
            return maybeDeprecatedFilterField;
        }

        private void validateAndSetFilterField(FilterField field, Object value) throws ServletException {
            for (Pair pair : FilterField.intervalFieldPairs) {
                String firstColumnName = ((FilterField)((Object)pair.getFirst())).getColumnName();
                String secondColumnName = ((FilterField)((Object)pair.getSecond())).getColumnName();
                boolean fieldConstraintViolated = ((FilterField)((Object)pair.getFirst())).equals((Object)field) ? this.checkFieldConstrantViolation((Comparable)value, (Comparable)this.getFilterField(secondColumnName)) : (((FilterField)((Object)pair.getSecond())).equals((Object)field) ? this.checkFieldConstrantViolation((Comparable)this.getFilterField(firstColumnName), (Comparable)value) : false);
                if (!fieldConstraintViolated) continue;
                String errorMessage = String.format("should be: field %s <= field %s", firstColumnName, secondColumnName);
                this.throwNewXServletException(ErrorCode.E0302, errorMessage);
            }
            this.filterValues.put(field, value);
        }

        private void throwNewXServletException(ErrorCode errorCode, String message) throws ServletException {
            LOG.error(message);
            throw new XServletException(400, errorCode, message);
        }

        private boolean checkFieldConstrantViolation(Comparable minValue, Comparable maxValue) {
            return minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0;
        }

        @VisibleForTesting
        Object getFilterField(String name) {
            FilterField field = FilterField.findByName(name);
            if (field != null) {
                return this.filterValues.get((Object)field);
            }
            return null;
        }
    }

    private static enum FilterField {
        APP_NAME(String.class, "appName", FilterComparator.LIKE),
        APP_TYPE(String.class, "appType", FilterComparator.LIKE),
        USER_NAME(String.class, "user", FilterComparator.LIKE),
        JOB_STATUS(String.class, "jobStatus", FilterComparator.LIKE),
        NOMINAL_START(Timestamp.class, "nominalTimeTS", FilterComparator.GREATER_OR_EQUALS),
        NOMINAL_END(Timestamp.class, "nominalTimeTS", FilterComparator.LESSTHAN_OR_EQUALS),
        NOMINAL_AFTER(Timestamp.class, "nominalTimeTS", FilterComparator.GREATER_OR_EQUALS),
        NOMINAL_BEFORE(Timestamp.class, "nominalTimeTS", FilterComparator.LESSTHAN_OR_EQUALS),
        CREATED_AFTER(Timestamp.class, "createdTimeTS", FilterComparator.GREATER_OR_EQUALS),
        CREATED_BEFORE(Timestamp.class, "createdTimeTS", FilterComparator.LESSTHAN_OR_EQUALS),
        EXPECTEDSTART_AFTER(Timestamp.class, "expectedStartTS", FilterComparator.GREATER_OR_EQUALS),
        EXPECTEDSTART_BEFORE(Timestamp.class, "expectedStartTS", FilterComparator.LESSTHAN_OR_EQUALS),
        EXPECTEDEND_AFTER(Timestamp.class, "expectedEndTS", FilterComparator.GREATER_OR_EQUALS),
        EXPECTEDEND_BEFORE(Timestamp.class, "expectedEndTS", FilterComparator.LESSTHAN_OR_EQUALS),
        ACTUALSTART_AFTER(Timestamp.class, "actualStartTS", FilterComparator.GREATER_OR_EQUALS),
        ACTUALSTART_BEFORE(Timestamp.class, "actualStartTS", FilterComparator.LESSTHAN_OR_EQUALS),
        ACTUALEND_AFTER(Timestamp.class, "actualEndTS", FilterComparator.GREATER_OR_EQUALS),
        ACTUALEND_BEFORE(Timestamp.class, "actualEndTS", FilterComparator.LESSTHAN_OR_EQUALS),
        ACTUAL_DURATION_MIN(Integer.class, "actualDuration", FilterComparator.GREATER_OR_EQUALS),
        ACTUAL_DURATION_MAX(Integer.class, "actualDuration", FilterComparator.LESSTHAN_OR_EQUALS),
        EXPECTED_DURATION_MIN(Integer.class, "expectedDuration", FilterComparator.GREATER_OR_EQUALS),
        EXPECTED_DURATION_MAX(Integer.class, "expectedDuration", FilterComparator.LESSTHAN_OR_EQUALS),
        SLA_STATUS(SLAEvent.SLAStatus.class, "slaStatus", FilterComparator.IN),
        EVENT_STATUS(SLAEvent.EventStatus.class, null, null),
        ID(String.class, "jobId", null),
        PARENT_ID(String.class, "parentId", null),
        BUNDLE(String.class, null, null);

        private final Class type;
        private final String dbFieldName;
        private final FilterComparator filterComparator;
        private static final List<Pair<FilterField, FilterField>> intervalFieldPairs;
        private static final List<Pair<FilterField, FilterField>> deprecatedFieldPairs;

        private FilterField(Class type, String dbFieldName, FilterComparator filterComparator) {
            this.type = type;
            this.dbFieldName = dbFieldName;
            this.filterComparator = filterComparator;
        }

        private static Object convertFromString(FilterField field, String valueStr) throws ParseException {
            if (String.class.equals((Object)field.type)) {
                return valueStr;
            }
            if (Timestamp.class.equals((Object)field.type)) {
                Date date = DateUtils.parseDateUTC(valueStr);
                return new Timestamp(date.getTime());
            }
            if (Integer.class.equals((Object)field.type)) {
                return Integer.parseInt(valueStr);
            }
            if (field.type.isEnum()) {
                String[] statusArr;
                ArrayList<String> list = new ArrayList<String>();
                for (String s : statusArr = valueStr.split(SLASummaryGetForFilterJPAExecutor.multiValueSeparator)) {
                    list.add(((Enum)Enum.valueOf(field.type, s)).toString());
                }
                return list;
            }
            return null;
        }

        private static FilterField findByName(String name) {
            if (name == null || !name.equals(name.toLowerCase(Locale.US))) {
                return null;
            }
            try {
                return FilterField.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private String getColumnName() {
            return this.name().toLowerCase(Locale.US);
        }

        static {
            intervalFieldPairs = new ArrayList<Pair<FilterField, FilterField>>(){
                {
                    this.add(new Pair<FilterField, FilterField>(NOMINAL_AFTER, NOMINAL_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(CREATED_AFTER, CREATED_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(EXPECTEDSTART_AFTER, EXPECTEDSTART_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(EXPECTEDEND_AFTER, EXPECTEDEND_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(ACTUALSTART_AFTER, ACTUALSTART_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(ACTUALEND_AFTER, ACTUALEND_BEFORE));
                    this.add(new Pair<FilterField, FilterField>(ACTUAL_DURATION_MIN, ACTUAL_DURATION_MAX));
                    this.add(new Pair<FilterField, FilterField>(EXPECTED_DURATION_MIN, EXPECTED_DURATION_MAX));
                }
            };
            deprecatedFieldPairs = new ArrayList<Pair<FilterField, FilterField>>(){
                {
                    this.add(new Pair<FilterField, FilterField>(NOMINAL_START, NOMINAL_AFTER));
                    this.add(new Pair<FilterField, FilterField>(NOMINAL_END, NOMINAL_BEFORE));
                }
            };
        }
    }

    private static enum FilterComparator {
        LIKE,
        EQUALS,
        GREATER_OR_EQUALS,
        LESSTHAN_OR_EQUALS,
        IN;

    }
}

