/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.SharelibNameProvider;
import org.apache.oozie.util.XConfiguration;

class SharelibResolver {
    private final String[] defaultValue;
    private final List<SharelibNameProvider> configProviders;

    SharelibResolver(String sharelibPropertyName, Configuration actionConf, XConfiguration workflowConf, Configuration oozieServerConfiguration, String defaultValue) {
        this.defaultValue = defaultValue == null ? new String[0] : new String[]{defaultValue};
        this.configProviders = Lists.newArrayList((Object[])new SharelibNameProvider[]{() -> actionConf.getStrings("oozie.launcher.sharelib"), () -> actionConf.getStrings(sharelibPropertyName), () -> workflowConf.getStrings("oozie.launcher.sharelib"), () -> workflowConf.getStrings(sharelibPropertyName), () -> oozieServerConfiguration.getStrings(sharelibPropertyName)});
    }

    public String[] resolve() {
        for (SharelibNameProvider cp : this.configProviders) {
            if (!this.isValidSharelibProperty(cp.getSharelibNames())) continue;
            return cp.getSharelibNames();
        }
        return this.defaultValue;
    }

    private boolean isValidSharelibProperty(String[] value) {
        return value != null && value.length > 0;
    }
}

