/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.AMLocalityHelper;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.CredentialsProviderFactory;
import org.apache.oozie.action.hadoop.JavaMain;
import org.apache.oozie.action.hadoop.LauncherAM;
import org.apache.oozie.action.hadoop.LauncherAMCallbackNotifier;
import org.apache.oozie.action.hadoop.LauncherConfigurationInjector;
import org.apache.oozie.action.hadoop.LauncherHelper;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.OozieJobInfo;
import org.apache.oozie.action.hadoop.SharelibResolver;
import org.apache.oozie.action.hadoop.YarnACLHandler;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.ClasspathUtils;
import org.apache.oozie.util.ELEvaluationException;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.FSUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class JavaActionExecutor
extends ActionExecutor {
    public static final String RUNNING = "RUNNING";
    public static final String SUCCEEDED = "SUCCEEDED";
    public static final String KILLED = "KILLED";
    public static final String FAILED = "FAILED";
    public static final String FAILED_KILLED = "FAILED/KILLED";
    public static final String HADOOP_YARN_RM = "yarn.resourcemanager.address";
    public static final String HADOOP_NAME_NODE = "fs.default.name";
    public static final String OOZIE_COMMON_LIBDIR = "oozie";
    public static final String DEFAULT_LAUNCHER_VCORES = "oozie.launcher.default.vcores";
    public static final String DEFAULT_LAUNCHER_MEMORY_MB = "oozie.launcher.default.memory.mb";
    public static final String DEFAULT_LAUNCHER_PRIORITY = "oozie.launcher.default.priority";
    public static final String DEFAULT_LAUNCHER_QUEUE = "oozie.launcher.default.queue";
    public static final String DEFAULT_LAUNCHER_MAX_ATTEMPTS = "oozie.launcher.default.max.attempts";
    public static final String LAUNCER_MODIFY_ACL = "oozie.launcher.modify.acl";
    public static final String LAUNCER_VIEW_ACL = "oozie.launcher.view.acl";
    public static final String MAPREDUCE_TO_CLASSPATH = "mapreduce.needed.for";
    public static final String OOZIE_LAUNCHER_ADD_MAPREDUCE_TO_CLASSPATH_PROPERTY = "oozie.action.mapreduce.needed.for";
    public static final String MAX_EXTERNAL_STATS_SIZE = "oozie.external.stats.max.size";
    public static final String ACL_VIEW_JOB = "mapreduce.job.acl-view-job";
    public static final String ACL_MODIFY_JOB = "mapreduce.job.acl-modify-job";
    public static final String HADOOP_YARN_TIMELINE_SERVICE_ENABLED = "yarn.timeline-service.enabled";
    public static final String HADOOP_YARN_UBER_MODE = "mapreduce.job.ubertask.enable";
    public static final String OOZIE_ACTION_LAUNCHER_PREFIX = "oozie.action.launcher.";
    public static final String HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART = "oozie.action.launcher.am.restart.kill.childjobs";
    public static final String HADOOP_MAP_MEMORY_MB = "mapreduce.map.memory.mb";
    public static final String HADOOP_CHILD_JAVA_OPTS = "mapred.child.java.opts";
    public static final String HADOOP_MAP_JAVA_OPTS = "mapreduce.map.java.opts";
    public static final String HADOOP_REDUCE_JAVA_OPTS = "mapreduce.reduce.java.opts";
    public static final String HADOOP_CHILD_JAVA_ENV = "mapred.child.env";
    public static final String HADOOP_MAP_JAVA_ENV = "mapreduce.map.env";
    public static final String HADOOP_JOB_CLASSLOADER = "mapreduce.job.classloader";
    public static final String HADOOP_USER_CLASSPATH_FIRST = "mapreduce.user.classpath.first";
    public static final String OOZIE_CREDENTIALS_SKIP = "oozie.credentials.skip";
    public static final String YARN_AM_RESOURCE_MB = "yarn.app.mapreduce.am.resource.mb";
    public static final String YARN_AM_COMMAND_OPTS = "yarn.app.mapreduce.am.command-opts";
    public static final String YARN_AM_ENV = "yarn.app.mapreduce.am.env";
    public static final int YARN_MEMORY_MB_MIN = 512;
    private static final String JAVA_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.JavaMain";
    private static final String HADOOP_JOB_NAME = "mapred.job.name";
    static final Set<String> DISALLOWED_PROPERTIES = ImmutableSet.of((Object)"user.name", (Object)"mapreduce.job.user.name", (Object)"fs.default.name", (Object)"yarn.resourcemanager.address");
    private static final String OOZIE_ACTION_NAME = "oozie.action.name";
    private static final String ACTION_SHARELIB_FOR = "oozie.action.sharelib.for.";
    private static int maxActionOutputLen;
    private static int maxExternalStatsSize;
    private static int maxFSGlobMax;
    protected static final String HADOOP_USER = "user.name";
    protected XLog LOG = XLog.getLog(this.getClass());
    private static final String JAVA_TMP_DIR_SETTINGS = "-Djava.io.tmpdir=";
    public XConfiguration workflowConf = null;
    private static final String QUEUE_NAME = "mapred.job.queue.name";
    private static final Set<String> SPECIAL_PROPERTIES;
    private static Set<String> FINAL_STATUS;

    public JavaActionExecutor() {
        this("java");
    }

    protected JavaActionExecutor(String type) {
        super(type);
    }

    public static List<Class<?>> getCommonLauncherClasses() {
        ArrayList classes = new ArrayList();
        classes.add(LauncherMain.class);
        classes.addAll(Services.get().get(URIHandlerService.class).getClassesForLauncher());
        classes.add(LauncherAM.class);
        classes.add(LauncherAMCallbackNotifier.class);
        return classes;
    }

    public List<Class<?>> getLauncherClasses() {
        ArrayList classes = new ArrayList();
        try {
            classes.add(Class.forName(JAVA_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    public void initActionType() {
        super.initActionType();
        maxActionOutputLen = ConfigurationService.getInt("oozie.action.max.output.data");
        maxExternalStatsSize = ConfigurationService.getInt(MAX_EXTERNAL_STATS_SIZE);
        maxExternalStatsSize = maxExternalStatsSize == -1 ? Integer.MAX_VALUE : maxExternalStatsSize;
        maxFSGlobMax = ConfigurationService.getInt("oozie.action.fs.glob.max");
        this.registerError(UnknownHostException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA001");
        this.registerError(AccessControlException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA002");
        this.registerError(DiskChecker.DiskOutOfSpaceException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA003");
        this.registerError(QuotaExceededException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA004");
        this.registerError(SafeModeException.class.getName(), ActionExecutorException.ErrorType.NON_TRANSIENT, "JA005");
        this.registerError(ConnectException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "  JA006");
        this.registerError(JDOMException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA007");
        this.registerError(FileNotFoundException.class.getName(), ActionExecutorException.ErrorType.ERROR, "JA008");
        this.registerError(IOException.class.getName(), ActionExecutorException.ErrorType.TRANSIENT, "JA009");
    }

    public static int getMaxExternalStatsSize() {
        return maxExternalStatsSize;
    }

    static void checkForDisallowedProps(Configuration conf, String confName) throws ActionExecutorException {
        for (String prop : DISALLOWED_PROPERTIES) {
            if (conf.get(prop) == null) continue;
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA010", "Property [{0}] not allowed in action [{1}] configuration", prop, confName);
        }
    }

    public Configuration createBaseHadoopConf(ActionExecutor.Context context, Element actionXml) {
        return this.createBaseHadoopConf(context, actionXml, true);
    }

    protected Configuration createBaseHadoopConf(ActionExecutor.Context context, Element actionXml, boolean loadResources) {
        Namespace ns = actionXml.getNamespace();
        Element resourceManagerTag = actionXml.getChild("resource-manager", ns);
        String resourceManager = resourceManagerTag != null ? resourceManagerTag.getTextTrim() : actionXml.getChild("job-tracker", ns).getTextTrim();
        String nameNode = actionXml.getChild("name-node", ns).getTextTrim();
        Configuration conf = null;
        conf = loadResources ? Services.get().get(HadoopAccessorService.class).createConfiguration(resourceManager) : new Configuration(false);
        conf.set(HADOOP_USER, context.getProtoActionConf().get(HADOOP_USER));
        conf.set(HADOOP_YARN_RM, resourceManager);
        conf.set(HADOOP_NAME_NODE, nameNode);
        conf.set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "true");
        Element e = actionXml.getChild("config-class", ns);
        if (e != null) {
            conf.set("oozie.action.config.class", e.getTextTrim());
        }
        return conf;
    }

    protected Configuration loadHadoopDefaultResources(ActionExecutor.Context context, Element actionXml) {
        return this.createBaseHadoopConf(context, actionXml);
    }

    Configuration setupLauncherConf(Configuration conf, Element actionXml, Path appPath, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Namespace ns = actionXml.getNamespace();
            XConfiguration launcherConf = new XConfiguration();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            XConfiguration actionDefaultConf = has.createActionDefaultConf(conf.get(HADOOP_YARN_RM), this.getType());
            new LauncherConfigurationInjector(actionDefaultConf).inject(launcherConf);
            try {
                JavaActionExecutor.parseJobXmlAndConfiguration(context, actionXml, appPath, launcherConf, true);
            }
            catch (HadoopAccessorException ex) {
                throw this.convertException(ex);
            }
            catch (URISyntaxException ex) {
                throw this.convertException(ex);
            }
            XConfiguration.copy(launcherConf, conf);
            Element e = actionXml.getChild("config-class", ns);
            if (e != null) {
                conf.set("oozie.action.config.class", e.getTextTrim());
            }
            JavaActionExecutor.checkForDisallowedProps(launcherConf, "launcher configuration");
            return conf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
    }

    void injectLauncherTimelineServiceEnabled(Configuration launcherConf, Configuration actionConf) {
        String cacheFiles;
        if (actionConf.get("oozie.launcher.yarn.timeline-service.enabled") == null && ConfigurationService.getBoolean("oozie.action.launcher.yarn.timeline-service.enabled") && (cacheFiles = launcherConf.get("mapred.cache.files")) != null && cacheFiles.contains("tez-site.xml")) {
            launcherConf.setBoolean(HADOOP_YARN_TIMELINE_SERVICE_ENABLED, true);
        }
    }

    public static void parseJobXmlAndConfiguration(ActionExecutor.Context context, Element element, Path appPath, Configuration conf) throws IOException, ActionExecutorException, HadoopAccessorException, URISyntaxException {
        JavaActionExecutor.parseJobXmlAndConfiguration(context, element, appPath, conf, false);
    }

    public static void parseJobXmlAndConfiguration(ActionExecutor.Context context, Element element, Path appPath, Configuration conf, boolean isLauncher) throws IOException, ActionExecutorException, HadoopAccessorException, URISyntaxException {
        Element e;
        Namespace ns = element.getNamespace();
        Iterator it = element.getChildren("job-xml", ns).iterator();
        HashMap<String, FileSystem> filesystemsMap = new HashMap<String, FileSystem>();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        while (it.hasNext()) {
            FileSystem fs;
            Path path;
            e = (Element)it.next();
            String jobXml = e.getTextTrim();
            Path pathSpecified = new Path(jobXml);
            Path path2 = path = pathSpecified.isAbsolute() ? pathSpecified : new Path(appPath, jobXml);
            if (filesystemsMap.containsKey(path.toUri().getAuthority())) {
                fs = (FileSystem)filesystemsMap.get(path.toUri().getAuthority());
            } else {
                fs = path.toUri().getAuthority() != null ? has.createFileSystem(context.getWorkflow().getUser(), path.toUri(), has.createConfiguration(path.toUri().getAuthority())) : context.getAppFileSystem();
                filesystemsMap.put(path.toUri().getAuthority(), fs);
            }
            XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(path));
            try {
                String jobXmlConfString = XmlUtils.prettyPrint(jobXmlConf).toString();
                jobXmlConfString = XmlUtils.removeComments(jobXmlConfString);
                jobXmlConfString = context.getELEvaluator().evaluate(jobXmlConfString, String.class);
                jobXmlConf = new XConfiguration(new StringReader(jobXmlConfString));
            }
            catch (ELEvaluationException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, "EL_EVAL_ERROR", ex.getMessage(), ex);
            }
            catch (Exception ex) {
                context.setErrorInfo("EL_ERROR", ex.getMessage());
            }
            JavaActionExecutor.checkForDisallowedProps(jobXmlConf, "job-xml");
            if (isLauncher) {
                new LauncherConfigurationInjector(jobXmlConf).inject(conf);
                continue;
            }
            XConfiguration.copy(jobXmlConf, conf);
        }
        e = element.getChild("configuration", ns);
        if (e != null) {
            String strConf = XmlUtils.prettyPrint(e).toString();
            XConfiguration inlineConf = new XConfiguration(new StringReader(strConf));
            JavaActionExecutor.checkForDisallowedProps(inlineConf, "inline configuration");
            if (isLauncher) {
                new LauncherConfigurationInjector(inlineConf).inject(conf);
            } else {
                XConfiguration.copy(inlineConf, conf);
            }
        }
    }

    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        try {
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            XConfiguration actionDefaults = has.createActionDefaultConf(actionConf.get(HADOOP_YARN_RM), this.getType());
            XConfiguration.copy(actionDefaults, actionConf);
            has.checkSupportedFilesystem(appPath.toUri());
            this.setJavaMain(actionConf, actionXml);
            JavaActionExecutor.parseJobXmlAndConfiguration(context, actionXml, appPath, actionConf);
            actionConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", false);
            this.setRootLoggerLevel(actionConf);
            return actionConf;
        }
        catch (IOException ex) {
            throw this.convertException(ex);
        }
        catch (HadoopAccessorException ex) {
            throw this.convertException(ex);
        }
        catch (URISyntaxException ex) {
            throw this.convertException(ex);
        }
    }

    void setRootLoggerLevel(Configuration actionConf) {
        String oozieActionRootLogger;
        String oozieActionTypeRootLogger = "oozie.action." + this.getType() + "rootlogger.log.level";
        String rootLogLevel = actionConf.get(oozieActionTypeRootLogger, actionConf.get(oozieActionRootLogger = "oozie.action.rootlogger.log.level"));
        if (rootLogLevel != null) {
            return;
        }
        rootLogLevel = ConfigurationService.get(oozieActionTypeRootLogger);
        if (rootLogLevel != null && rootLogLevel.length() > 0) {
            actionConf.set(oozieActionRootLogger, rootLogLevel);
        } else {
            rootLogLevel = ConfigurationService.get(oozieActionRootLogger);
            if (rootLogLevel != null && rootLogLevel.length() > 0) {
                actionConf.set(oozieActionRootLogger, rootLogLevel);
            }
        }
    }

    Configuration addToCache(Configuration conf, Path appPath, String filePath, boolean archive) throws ActionExecutorException {
        URI uri = null;
        try {
            uri = new URI(JavaActionExecutor.getTrimmedEncodedPath(filePath));
            URI baseUri = appPath.toUri();
            if (uri.getScheme() == null) {
                String resolvedPath = uri.getPath();
                if (!resolvedPath.startsWith("/")) {
                    resolvedPath = baseUri.getPath() + "/" + resolvedPath;
                }
                uri = new URI(baseUri.getScheme(), baseUri.getAuthority(), resolvedPath, uri.getQuery(), uri.getFragment());
            }
            if (archive) {
                DistributedCache.addCacheArchive((URI)uri.normalize(), (Configuration)conf);
            } else {
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                if (fileName.endsWith(".so") || fileName.contains(".so.")) {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                } else if (fileName.endsWith(".jar")) {
                    if (!fileName.contains("#")) {
                        String user = conf.get(HADOOP_USER);
                        if (FSUtils.isNotLocalFile(fileName)) {
                            Path pathToAdd = new Path(uri.normalize());
                            Services.get().get(HadoopAccessorService.class).addFileToClassPath(user, pathToAdd, conf);
                        }
                    } else {
                        DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                    }
                } else {
                    if (!fileName.contains("#")) {
                        uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), fileName);
                    }
                    DistributedCache.addCacheFile((URI)uri.normalize(), (Configuration)conf);
                }
            }
            DistributedCache.createSymlink((Configuration)conf);
            return conf;
        }
        catch (Exception ex) {
            this.LOG.debug("Errors when add to DistributedCache. Path=" + Objects.toString(uri, "<null>") + ", archive=" + archive + ", conf=" + XmlUtils.prettyPrint(conf).toString());
            throw this.convertException(ex);
        }
    }

    public void prepareActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        block4: {
            try {
                Path actionDir = context.getActionDir();
                Path tempActionDir = new Path(actionDir.getParent(), actionDir.getName() + ".tmp");
                if (actionFs.exists(actionDir)) break block4;
                try {
                    actionFs.mkdirs(tempActionDir);
                    actionFs.rename(tempActionDir, actionDir);
                }
                catch (IOException ex) {
                    actionFs.delete(tempActionDir, true);
                    actionFs.delete(actionDir, true);
                    throw ex;
                }
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    void cleanUpActionDir(FileSystem actionFs, ActionExecutor.Context context) throws ActionExecutorException {
        try {
            Path actionDir = context.getActionDir();
            if (!context.getProtoActionConf().getBoolean("oozie.action.keep.action.dir", false) && actionFs.exists(actionDir)) {
                actionFs.delete(actionDir, true);
            }
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    protected void addShareLib(Configuration conf, String[] actionShareLibNames) throws ActionExecutorException {
        HashSet<String> confSet = new HashSet<String>(Arrays.asList(this.getShareLibFilesForActionConf() == null ? new String[]{} : this.getShareLibFilesForActionConf()));
        HashSet<Path> sharelibList = new HashSet<Path>();
        if (actionShareLibNames != null) {
            try {
                ShareLibService shareLibService = Services.get().get(ShareLibService.class);
                FileSystem fs = shareLibService.getFileSystem();
                if (fs != null) {
                    for (String actionShareLibName : actionShareLibNames) {
                        List<Path> listOfPaths = shareLibService.getShareLibJars(actionShareLibName);
                        if (listOfPaths == null || listOfPaths.isEmpty()) continue;
                        for (Path actionLibPath : listOfPaths) {
                            String fileName;
                            String fragmentName = new URI(actionLibPath.toString()).getFragment();
                            String string = fileName = fragmentName == null ? actionLibPath.getName() : fragmentName;
                            if (confSet.contains(fileName)) {
                                Configuration jobXmlConf = shareLibService.getShareLibConf(actionShareLibName, actionLibPath);
                                if (jobXmlConf == null) continue;
                                JavaActionExecutor.checkForDisallowedProps(jobXmlConf, actionLibPath.getName());
                                XConfiguration.injectDefaults(jobXmlConf, conf);
                                this.LOG.trace("Adding properties of " + actionLibPath + " to job conf");
                                continue;
                            }
                            sharelibList.add(new Path(actionLibPath.toUri()){

                                public int hashCode() {
                                    return this.getName().hashCode();
                                }

                                public String getName() {
                                    try {
                                        return new URI(this.toString()).getFragment() == null ? new Path(this.toUri()).getName() : new URI(this.toString()).getFragment();
                                    }
                                    catch (URISyntaxException e) {
                                        throw new RuntimeException(e);
                                    }
                                }

                                public boolean equals(Object input) {
                                    if (input == null) {
                                        return false;
                                    }
                                    if (input == this) {
                                        return true;
                                    }
                                    if (!(input instanceof Path)) {
                                        return false;
                                    }
                                    return this.getName().equals(((Path)input).getName());
                                }
                            });
                        }
                    }
                }
                this.addLibPathsToCache(conf, sharelibList);
            }
            catch (URISyntaxException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "Error configuring sharelib", ex.getMessage());
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    protected void addSystemShareLibForAction(Configuration conf) throws ActionExecutorException {
        ShareLibService shareLibService = Services.get().get(ShareLibService.class);
        if (shareLibService != null) {
            try {
                List<Path> listOfPaths = shareLibService.getSystemLibJars(OOZIE_COMMON_LIBDIR);
                if (listOfPaths.isEmpty()) {
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "EJ001", "Could not locate Oozie sharelib");
                }
                this.addLibPathsToClassPath(conf, listOfPaths);
                this.addLibPathsToClassPath(conf, shareLibService.getSystemLibJars(this.getType()));
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    private void addLibPathsToClassPath(Configuration conf, List<Path> listOfPaths) throws IOException, ActionExecutorException {
        this.addLibPathsToClassPathOrCache(conf, listOfPaths, false);
    }

    private void addLibPathsToCache(Configuration conf, Set<Path> sharelibList) throws IOException, ActionExecutorException {
        this.addLibPathsToClassPathOrCache(conf, sharelibList, true);
    }

    private void addLibPathsToClassPathOrCache(Configuration conf, Collection<Path> sharelibList, boolean isAddToCache) throws IOException, ActionExecutorException {
        for (Path libPath : sharelibList) {
            if (FSUtils.isLocalFile(libPath.toString())) {
                conf = ClasspathUtils.addToClasspathFromLocalShareLib(conf, libPath);
                continue;
            }
            if (isAddToCache) {
                this.addToCache(conf, libPath, libPath.toUri().getPath(), false);
                continue;
            }
            FileSystem fs = libPath.getFileSystem(conf);
            JobUtils.addFileToClassPath(libPath, conf, fs);
            DistributedCache.createSymlink((Configuration)conf);
        }
    }

    protected void addActionLibs(Path appPath, Configuration conf) throws ActionExecutorException {
        String[] actionLibsStrArr = conf.getStrings("oozie.launcher.oozie.libpath");
        if (actionLibsStrArr != null) {
            try {
                for (String actionLibsStr : actionLibsStrArr) {
                    FileStatus[] files;
                    if ((actionLibsStr = actionLibsStr.trim()).length() <= 0) continue;
                    Path actionLibsPath = new Path(actionLibsStr);
                    String user = conf.get(HADOOP_USER);
                    FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, appPath.toUri(), conf);
                    if (!fs.exists(actionLibsPath)) continue;
                    for (FileStatus file : files = fs.listStatus(actionLibsPath)) {
                        this.addToCache(conf, appPath, file.getPath().toUri().getPath(), false);
                    }
                }
            }
            catch (HadoopAccessorException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, ex.getErrorCode().toString(), ex.getMessage());
            }
            catch (IOException ex) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ex.getMessage());
            }
        }
    }

    public void setLibFilesArchives(ActionExecutor.Context context, Element actionXml, Path appPath, Configuration conf) throws ActionExecutorException {
        Configuration proto = context.getProtoActionConf();
        String[] paths = proto.getStrings("oozie.wf.application.lib");
        if (paths != null) {
            for (String path : paths) {
                this.addToCache(conf, appPath, path, false);
            }
        }
        this.addActionLibs(appPath, conf);
        for (Element eProp : actionXml.getChildren()) {
            String[] archivePaths;
            if (eProp.getName().equals("file")) {
                String[] filePaths;
                for (String path : filePaths = eProp.getTextTrim().split(",")) {
                    this.addToCache(conf, appPath, path, false);
                }
                continue;
            }
            if (!eProp.getName().equals("archive")) continue;
            for (String path : archivePaths = eProp.getTextTrim().split(",")) {
                this.addToCache(conf, appPath, path.trim(), true);
            }
        }
        this.addAllShareLibs(appPath, conf, context, actionXml);
    }

    @VisibleForTesting
    protected static String getTrimmedEncodedPath(String path) {
        return path.trim().replace(" ", "%20");
    }

    private void addAllShareLibs(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        this.addActionShareLib(appPath, conf, context, actionXml);
        this.addSystemShareLibForAction(conf);
    }

    private void addActionShareLib(Path appPath, Configuration conf, ActionExecutor.Context context, Element actionXml) throws ActionExecutorException {
        XConfiguration wfJobConf = null;
        try {
            wfJobConf = this.getWorkflowConf(context);
        }
        catch (IOException ioe) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "It should never happen", ioe.getMessage());
        }
        if (conf.get("oozie.use.system.libpath") == null) {
            if (wfJobConf.getBoolean("oozie.use.system.libpath", ConfigurationService.getBoolean("oozie.use.system.libpath"))) {
                this.addShareLib(conf, this.getShareLibNames(context, actionXml, conf));
            }
        } else if (conf.getBoolean("oozie.use.system.libpath", false)) {
            this.addShareLib(conf, this.getShareLibNames(context, actionXml, conf));
        }
    }

    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", JavaMain.class.getName());
    }

    private void setJavaMain(Configuration actionConf, Element actionXml) {
        Namespace ns = actionXml.getNamespace();
        Element e = actionXml.getChild("main-class", ns);
        if (e != null) {
            actionConf.set("oozie.action.java.main", e.getTextTrim());
        }
    }

    Configuration createLauncherConf(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action, Element actionXml, Configuration actionConf) throws ActionExecutorException {
        try {
            List javaopts;
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Configuration launcherJobConf = this.createBaseHadoopConf(context, actionXml);
            launcherJobConf.setBoolean("mapreduce.job.complete.cancel.delegation.tokens", true);
            this.setupLauncherConf(launcherJobConf, actionXml, appPathRoot, context);
            if (ConfigurationService.getBoolean(HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART)) {
                long launcherTime = System.currentTimeMillis();
                String coordActionNominalTime = context.getProtoActionConf().get("oozie.coord.action.nominal_time");
                if (coordActionNominalTime != null) {
                    launcherTime = Long.parseLong(coordActionNominalTime);
                } else if (context.getWorkflow().getCreatedTime() != null) {
                    launcherTime = context.getWorkflow().getCreatedTime().getTime();
                }
                String actionYarnTag = JavaActionExecutor.getActionYarnTag(this.getWorkflowConf(context), context.getWorkflow(), action);
                LauncherHelper.setupYarnRestartHandling(launcherJobConf, actionConf, actionYarnTag, launcherTime);
            } else {
                this.LOG.info(MessageFormat.format("{0} is set to false, not setting YARN restart properties", HADOOP_YARN_KILL_CHILD_JOBS_ON_AMRESTART));
            }
            String actionShareLibProperty = actionConf.get(ACTION_SHARELIB_FOR + this.getType());
            if (actionShareLibProperty != null) {
                launcherJobConf.set(ACTION_SHARELIB_FOR + this.getType(), actionShareLibProperty);
            }
            this.setLibFilesArchives(context, actionXml, appPathRoot, launcherJobConf);
            this.injectJobInfo(launcherJobConf, actionConf, context, action);
            this.injectLauncherCallback(context, launcherJobConf);
            String jobId = context.getWorkflow().getId();
            String actionId = action.getId();
            Path actionDir = context.getActionDir();
            String recoveryId = context.getRecoveryId();
            Namespace ns = actionXml.getNamespace();
            Element prepareElement = actionXml.getChild("prepare", ns);
            String prepareXML = "";
            if (prepareElement != null && prepareElement.getChildren().size() > 0) {
                prepareXML = XmlUtils.prettyPrint(prepareElement).toString().trim();
            }
            LauncherHelper.setupLauncherInfo(launcherJobConf, jobId, actionId, actionDir, recoveryId, actionConf, prepareXML);
            LauncherHelper.setupMainClass(launcherJobConf, this.getLauncherMain(launcherJobConf, actionXml));
            LauncherHelper.setupLauncherURIHandlerConf(launcherJobConf);
            LauncherHelper.setupMaxOutputData(launcherJobConf, JavaActionExecutor.getMaxOutputData(actionConf));
            LauncherHelper.setupMaxExternalStatsSize(launcherJobConf, maxExternalStatsSize);
            LauncherHelper.setupMaxFSGlob(launcherJobConf, maxFSGlobMax);
            List list = actionXml.getChildren("arg", ns);
            String[] args = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                args[i] = ((Element)list.get(i)).getTextTrim();
            }
            LauncherHelper.setupMainArguments(launcherJobConf, args);
            boolean nullArgsAllowed = ConfigurationService.getBoolean("oozie.action.null.args.allowed");
            launcherJobConf.setBoolean("oozie.action.null.args.allowed", nullArgsAllowed);
            StringBuilder opts = new StringBuilder(launcherJobConf.get(HADOOP_CHILD_JAVA_OPTS, ""));
            if (launcherJobConf.get(HADOOP_MAP_JAVA_OPTS) != null) {
                opts.append(" ").append(launcherJobConf.get(HADOOP_MAP_JAVA_OPTS));
            }
            if (!(javaopts = actionXml.getChildren("java-opt", ns)).isEmpty()) {
                for (Element opt : javaopts) {
                    opts.append(" ").append(opt.getTextTrim());
                }
            } else {
                Element opt = actionXml.getChild("java-opts", ns);
                if (opt != null) {
                    opts.append(" ").append(opt.getTextTrim());
                }
            }
            launcherJobConf.set(HADOOP_CHILD_JAVA_OPTS, opts.toString().trim());
            launcherJobConf.set(HADOOP_MAP_JAVA_OPTS, opts.toString().trim());
            this.injectLauncherTimelineServiceEnabled(launcherJobConf, actionConf);
            this.actionConfToLauncherConf(actionConf, launcherJobConf);
            return launcherJobConf;
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @VisibleForTesting
    protected static int getMaxOutputData(Configuration actionConf) {
        String userMaxActionOutputLen = actionConf.get("oozie.action.max.output.data");
        if (userMaxActionOutputLen != null) {
            Integer i = Ints.tryParse((String)userMaxActionOutputLen);
            return i != null ? i : maxActionOutputLen;
        }
        return maxActionOutputLen;
    }

    protected void injectCallback(ActionExecutor.Context context, Configuration conf) {
        String callback = context.getCallbackUrl("$jobStatus");
        conf.set("oozie.launcher.callback.url", callback);
    }

    void injectActionCallback(ActionExecutor.Context context, Configuration actionConf) {
    }

    void injectLauncherCallback(ActionExecutor.Context context, Configuration launcherConf) {
        this.injectCallback(context, launcherConf);
    }

    private void actionConfToLauncherConf(Configuration actionConf, Configuration launcherConf) {
        for (String name : SPECIAL_PROPERTIES) {
            if (actionConf.get(name) == null || launcherConf.get("oozie.launcher." + name) != null) continue;
            launcherConf.set(name, actionConf.get(name));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void submitLauncher(FileSystem actionFs, ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        YarnClient yarnClient = null;
        try {
            String consoleUrl;
            Path appPathRoot = new Path(context.getWorkflow().getAppPath());
            if (actionFs.isFile(appPathRoot)) {
                appPathRoot = appPathRoot.getParent();
            }
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.LOG.debug("ActionXML: {0}", action.getConf());
            Configuration actionConf = this.loadHadoopDefaultResources(context, actionXml);
            this.setupActionConf(actionConf, context, actionXml, appPathRoot);
            this.addAppNameContext(context, action);
            this.LOG.debug("Setting LibFilesArchives ");
            this.setLibFilesArchives(context, actionXml, appPathRoot, actionConf);
            String jobName = actionConf.get(HADOOP_JOB_NAME);
            if (jobName == null || jobName.isEmpty()) {
                jobName = this.getYarnApplicationName(context, action, "oozie:action");
                actionConf.set(HADOOP_JOB_NAME, jobName);
            }
            this.injectActionCallback(context, actionConf);
            if ((actionConf.get(ACL_MODIFY_JOB) == null || actionConf.get(ACL_MODIFY_JOB).trim().equals("")) && context.getWorkflow().getAcl() != null) {
                actionConf.set(ACL_MODIFY_JOB, context.getWorkflow().getAcl());
            }
            Credentials credentials = new Credentials();
            Configuration launcherConf = this.createLauncherConf(actionFs, context, action, actionXml, actionConf);
            yarnClient = this.createYarnClient(context, launcherConf);
            Map<String, CredentialsProperties> credentialsProperties = this.setCredentialPropertyToActionConf(context, action, actionConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.addHadoopCredentialPropertiesToActionConf(credentialsProperties);
            }
            Configuration credentialsConf = new Configuration(false);
            XConfiguration.copy(actionConf, credentialsConf);
            this.setCredentialTokens(credentials, credentialsConf, context, action, credentialsProperties);
            for (Map.Entry entry : credentialsConf) {
                if (actionConf.get((String)entry.getKey()) != null) continue;
                actionConf.set((String)entry.getKey(), (String)entry.getValue());
            }
            String launcherId = LauncherHelper.getRecoveryId(launcherConf, context.getActionDir(), context.getRecoveryId());
            this.removeHBaseSettingFromOozieDefaultResource(launcherConf);
            this.removeHBaseSettingFromOozieDefaultResource(actionConf);
            boolean alreadyRunning = launcherId != null;
            boolean isUserRetry = ((WorkflowActionBean)action).isUserRetry();
            this.LOG.debug("Creating yarnClient for action {0}", action.getId());
            if (alreadyRunning && !isUserRetry) {
                try {
                    ApplicationId appId = ConverterUtils.toApplicationId((String)launcherId);
                    ApplicationReport report = yarnClient.getApplicationReport(appId);
                    consoleUrl = report.getTrackingUrl();
                }
                catch (RemoteException e) {
                    this.LOG.error((Object)"Got RemoteException from YARN", e);
                    String jobTracker = launcherConf.get(HADOOP_YARN_RM);
                    throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA017", "unknown job [{0}@{1}], cannot recover", launcherId, jobTracker);
                }
            } else {
                YarnClientApplication newApp = yarnClient.createApplication();
                ApplicationId appId = newApp.getNewApplicationResponse().getApplicationId();
                ApplicationSubmissionContext appContext = this.createAppSubmissionContext(appId, launcherConf, context, actionConf, action, credentials, actionXml);
                yarnClient.submitApplication(appContext);
                launcherId = appId.toString();
                this.LOG.debug("After submission get the launcherId [{0}]", launcherId);
                ApplicationReport appReport = yarnClient.getApplicationReport(appId);
                consoleUrl = appReport.getTrackingUrl();
            }
            String jobTracker = launcherConf.get(HADOOP_YARN_RM);
            context.setStartData(launcherId, jobTracker, consoleUrl);
            if (yarnClient == null) return;
        }
        catch (Exception ex) {
            try {
                throw this.convertException(ex);
            }
            catch (Throwable throwable) {
                if (yarnClient == null) throw throwable;
                Closeables.closeQuietly(yarnClient);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)yarnClient);
        return;
    }

    private String getYarnApplicationName(ActionExecutor.Context context, WorkflowAction action, String prefix) {
        return XLog.format("{0}:T={1}:W={2}:A={3}:ID={4}", prefix, this.getType(), context.getWorkflow().getAppName(), action.getName(), context.getWorkflow().getId());
    }

    private void removeHBaseSettingFromOozieDefaultResource(Configuration jobConf) {
        String[] propertySources = jobConf.getPropertySources("hbase.dynamic.jars.dir");
        if (propertySources != null && propertySources.length > 0 && propertySources[0].contains("oozie-hbase-client-site.xml")) {
            jobConf.unset("hbase.dynamic.jars.dir");
            this.LOG.debug(String.format("Unset [%s] inserted from default Oozie resource XML [%s]", "hbase.dynamic.jars.dir", "oozie-hbase-client-site.xml"));
        }
    }

    private void addAppNameContext(ActionExecutor.Context context, WorkflowAction action) {
        String oozieActionName = this.getYarnApplicationName(context, action, "oozie:launcher");
        context.setVar(OOZIE_ACTION_NAME, oozieActionName);
    }

    protected String getAppName(ActionExecutor.Context context) {
        return context.getVar(OOZIE_ACTION_NAME);
    }

    private void addHadoopCredentialPropertiesToActionConf(Map<String, CredentialsProperties> credentialsProperties) {
        this.LOG.info("Adding default credentials for action: hdfs, yarn and jhs");
        this.addHadoopCredentialProperties(credentialsProperties, "hdfs");
        this.addHadoopCredentialProperties(credentialsProperties, "yarnRM");
        this.addHadoopCredentialProperties(credentialsProperties, "jhs");
    }

    private void addHadoopCredentialProperties(Map<String, CredentialsProperties> credentialsProperties, String type) {
        credentialsProperties.put(type, new CredentialsProperties(type, type));
    }

    private ApplicationSubmissionContext createAppSubmissionContext(ApplicationId appId, Configuration launcherJobConf, ActionExecutor.Context actionContext, Configuration actionConf, WorkflowAction action, Credentials credentials, Element actionXml) throws IOException, HadoopAccessorException, URISyntaxException {
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        int priority = this.getPriority(launcherJobConf);
        this.setResources(launcherJobConf, appContext, priority);
        this.setQueue(launcherJobConf, appContext);
        appContext.setApplicationId(appId);
        this.setApplicationName(actionContext, action, appContext);
        appContext.setApplicationType("Oozie Launcher");
        this.setMaxAttempts(launcherJobConf, appContext);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        YarnACLHandler yarnACL = new YarnACLHandler(launcherJobConf);
        yarnACL.setACLs(amContainer);
        String user = actionContext.getWorkflow().getUser();
        this.setEnvironmentVariables(launcherJobConf, amContainer);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities((Configuration)launcherJobConf);
        MRApps.setupDistributedCache((Configuration)launcherJobConf, localResources);
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        launcherJobConf.set("oozie.submitter.user", user);
        LocalResource launcherJobConfLR = has.createLocalResourceForConfigurationFile("launcher.xml", user, launcherJobConf, actionContext.getAppFileSystem().getUri(), actionContext.getActionDir());
        localResources.put("launcher.xml", launcherJobConfLR);
        LocalResource actionConfLR = has.createLocalResourceForConfigurationFile("action.xml", user, actionConf, actionContext.getAppFileSystem().getUri(), actionContext.getActionDir());
        localResources.put("action.xml", actionConfLR);
        amContainer.setLocalResources(localResources);
        List<String> vargs = this.createCommand(launcherJobConf, actionContext);
        this.setJavaOpts(launcherJobConf, actionXml, vargs);
        vargs.add(LauncherAM.class.getCanonicalName());
        vargs.add("1><LOG_DIR>/stdout");
        vargs.add("2><LOG_DIR>/stderr");
        StringBuilder mergedCommand = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            mergedCommand.append(charSequence).append(" ");
        }
        ImmutableList vargsFinal = ImmutableList.of((Object)mergedCommand.toString());
        this.LOG.debug("Command to launch container for ApplicationMaster is: {0}", mergedCommand);
        amContainer.setCommands((List)vargsFinal);
        appContext.setAMContainerSpec(amContainer);
        if (credentials != null) {
            DataOutputBuffer dataOutputBuffer = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dataOutputBuffer);
            amContainer.setTokens(ByteBuffer.wrap(dataOutputBuffer.getData(), 0, dataOutputBuffer.getLength()));
        }
        appContext.setCancelTokensWhenComplete(true);
        return appContext;
    }

    private void setMaxAttempts(Configuration launcherJobConf, ApplicationSubmissionContext appContext) {
        int launcherMaxAttempts;
        int defaultLauncherMaxAttempts = ConfigurationService.getInt(DEFAULT_LAUNCHER_MAX_ATTEMPTS);
        if (launcherJobConf.get("oozie.launcher.max.attempts") != null) {
            try {
                launcherMaxAttempts = launcherJobConf.getInt("oozie.launcher.max.attempts", defaultLauncherMaxAttempts);
            }
            catch (NumberFormatException ignored) {
                launcherMaxAttempts = defaultLauncherMaxAttempts;
            }
        } else {
            this.LOG.warn("Invalid configuration value [{0}] defined for launcher max attempts count, using default [{1}].", launcherJobConf.get("oozie.launcher.max.attempts"), defaultLauncherMaxAttempts);
            launcherMaxAttempts = defaultLauncherMaxAttempts;
        }
        this.LOG.trace("Reading from configuration max attempts count of the Launcher AM. [launcherMaxAttempts={0}]", launcherMaxAttempts);
        if (launcherMaxAttempts > 0) {
            this.LOG.trace("Setting max attempts of the Launcher AM. [launcherMaxAttempts={0}]", launcherMaxAttempts);
            appContext.setMaxAppAttempts(launcherMaxAttempts);
        } else {
            this.LOG.warn("Not setting max attempts of the Launcher AM, value is invalid. [launcherMaxAttempts={0}]", launcherMaxAttempts);
        }
    }

    private List<String> createCommand(Configuration launcherJobConf, ActionExecutor.Context context) {
        ArrayList<String> vargs = new ArrayList<String>(6);
        String launcherLogLevel = launcherJobConf.get("oozie.launcher.log.level");
        if (Strings.isNullOrEmpty((String)launcherLogLevel)) {
            launcherLogLevel = "INFO";
        }
        vargs.add(Apps.crossPlatformify((String)ApplicationConstants.Environment.JAVA_HOME.toString()) + "/bin/java");
        vargs.add("-Dlog4j.configuration=container-log4j.properties");
        vargs.add("-Dlog4j.debug=true");
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dyarn.app.container.log.filesize=1048576");
        vargs.add("-Dhadoop.root.logger=" + launcherLogLevel + ",CLA");
        vargs.add("-Dhadoop.root.logfile=" + TaskLog.LogName.SYSLOG);
        vargs.add("-Dsubmitter.user=" + context.getWorkflow().getUser());
        return vargs;
    }

    private void setJavaOpts(Configuration launcherJobConf, Element actionXml, List<String> vargs) {
        String oozieLauncherJavaOpts;
        StringBuilder javaOpts = new StringBuilder();
        boolean oldJavaOpts = this.handleJavaOpts(actionXml, javaOpts);
        if (oldJavaOpts) {
            vargs.add(javaOpts.toString());
        }
        if ((oozieLauncherJavaOpts = launcherJobConf.get("oozie.launcher.javaopts")) != null) {
            if (oldJavaOpts) {
                this.LOG.warn("<java-opts> was defined inside the <launcher> tag -- ignored");
            } else {
                vargs.add(oozieLauncherJavaOpts);
            }
        }
    }

    private boolean handleJavaOpts(Element actionXml, StringBuilder javaOpts) {
        Namespace ns = actionXml.getNamespace();
        boolean oldJavaOpts = false;
        List javaopts = actionXml.getChildren("java-opt", ns);
        for (Element opt : javaopts) {
            javaOpts.append(" ").append(opt.getTextTrim());
            oldJavaOpts = true;
        }
        Element opt = actionXml.getChild("java-opts", ns);
        if (opt != null) {
            javaOpts.append(" ").append(opt.getTextTrim());
            oldJavaOpts = true;
        }
        if (oldJavaOpts) {
            this.LOG.warn("Note: <java-opts> inside the action is used in the workflow. Please move <java-opts> tag under the <launcher> element. See the documentation for details");
        }
        return oldJavaOpts;
    }

    private void setApplicationName(ActionExecutor.Context context, WorkflowAction action, ApplicationSubmissionContext appContext) {
        String jobName = this.getYarnApplicationName(context, action, "oozie:launcher");
        appContext.setApplicationName(jobName);
    }

    private void setEnvironmentVariables(Configuration launcherConf, ContainerLaunchContext amContainer) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        String oozieLauncherEnvProperty = launcherConf.get("oozie.launcher.env");
        if (oozieLauncherEnvProperty != null) {
            Map<String, String> environmentVars = this.extractEnvVarsFromOozieLauncherProps(oozieLauncherEnvProperty);
            env.putAll(environmentVars);
        }
        ClasspathUtils.setupClasspath(env, launcherConf);
        if (this.needToAddMapReduceToClassPath(launcherConf)) {
            ClasspathUtils.addMapReduceToClasspath(env, launcherConf);
        }
        this.addActionSpecificEnvVars(env);
        amContainer.setEnvironment((Map)ImmutableMap.copyOf(env));
    }

    private void setQueue(Configuration launcherJobConf, ApplicationSubmissionContext appContext) {
        String launcherQueueName = launcherJobConf.get("oozie.launcher.queue") != null ? launcherJobConf.get("oozie.launcher.queue") : (String)Preconditions.checkNotNull((Object)ConfigurationService.get(DEFAULT_LAUNCHER_QUEUE), (Object)"Default launcherQueueName is undefined");
        appContext.setQueue(launcherQueueName);
    }

    private int getPriority(Configuration launcherJobConf) {
        int defaultPriority;
        int priority = launcherJobConf.get("oozie.launcher.priority") != null ? launcherJobConf.getInt("oozie.launcher.priority", -1) : (defaultPriority = ConfigurationService.getInt(DEFAULT_LAUNCHER_PRIORITY));
        return priority;
    }

    private void setResources(Configuration launcherJobConf, ApplicationSubmissionContext appContext, int priority) {
        int vcores;
        int memory;
        if (launcherJobConf.get("oozie.launcher.memory.mb") != null) {
            memory = launcherJobConf.getInt("oozie.launcher.memory.mb", -1);
            Preconditions.checkArgument((memory > 0 ? 1 : 0) != 0, (Object)"Launcher memory is 0 or negative");
        } else {
            int defaultMemory = ConfigurationService.getInt(DEFAULT_LAUNCHER_MEMORY_MB, -1);
            Preconditions.checkArgument((defaultMemory > 0 ? 1 : 0) != 0, (Object)"Default launcher memory is 0 or negative");
            memory = defaultMemory;
        }
        if (launcherJobConf.get("oozie.launcher.vcores") != null) {
            vcores = launcherJobConf.getInt("oozie.launcher.vcores", -1);
            Preconditions.checkArgument((vcores > 0 ? 1 : 0) != 0, (Object)"Launcher vcores is 0 or negative");
        } else {
            int defaultVcores = ConfigurationService.getInt(DEFAULT_LAUNCHER_VCORES);
            Preconditions.checkArgument((defaultVcores > 0 ? 1 : 0) != 0, (Object)"Default launcher vcores is 0 or negative");
            vcores = defaultVcores;
        }
        Collection locality = launcherJobConf.getStringCollection("mapreduce.job.am.strict-locality");
        List<ResourceRequest> resourceRequests = AMLocalityHelper.generateResourceRequests(memory, vcores, priority, locality);
        appContext.setAMContainerResourceRequests(resourceRequests);
    }

    private Map<String, String> extractEnvVarsFromOozieLauncherProps(String oozieLauncherEnvProperty) {
        LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>();
        for (String envVar : StringUtils.split((String)oozieLauncherEnvProperty, (char)File.pathSeparatorChar)) {
            String[] env = StringUtils.split((String)envVar, (char)'=');
            Preconditions.checkArgument((env.length == 2 ? 1 : 0) != 0, (String)"Invalid launcher setting for environment variables: \"%s\". <env> should contain a list of ENV_VAR_NAME=VALUE separated by the '%s' character. Example on Unix: A=foo1:B=foo2", (Object[])new Object[]{oozieLauncherEnvProperty, File.pathSeparator});
            envMap.put(env[0], env[1]);
        }
        return envMap;
    }

    Map<String, CredentialsProperties> setCredentialPropertyToActionConf(ActionExecutor.Context context, WorkflowAction action, Configuration actionConf) throws Exception {
        HashMap<String, CredentialsProperties> credPropertiesMap = new HashMap<String, CredentialsProperties>();
        if (context == null || action == null) {
            this.LOG.warn("context or action is null");
            return credPropertiesMap;
        }
        XConfiguration wfJobConf = this.getWorkflowConf(context);
        boolean skipCredentials = actionConf.getBoolean(OOZIE_CREDENTIALS_SKIP, wfJobConf.getBoolean(OOZIE_CREDENTIALS_SKIP, ConfigurationService.getBoolean(OOZIE_CREDENTIALS_SKIP)));
        if (skipCredentials) {
            this.LOG.info("Skipping credentials (oozie.credentials.skip=true)");
        } else {
            credPropertiesMap.putAll(this.getActionCredentialsProperties(context, action));
            if (credPropertiesMap.isEmpty()) {
                this.LOG.warn("No credential properties found for action : " + action.getId() + ", cred : " + action.getCred());
                return credPropertiesMap;
            }
            for (Map.Entry entry : credPropertiesMap.entrySet()) {
                if (entry.getValue() == null) continue;
                CredentialsProperties prop = (CredentialsProperties)entry.getValue();
                this.LOG.debug("Credential Properties set for action : " + action.getId());
                for (Map.Entry<String, String> propEntry : prop.getProperties().entrySet()) {
                    String key = propEntry.getKey();
                    String value = propEntry.getValue();
                    actionConf.set(key, value);
                    this.LOG.debug("property : '" + key + "', value : '" + value + "'");
                }
            }
        }
        return credPropertiesMap;
    }

    protected void setCredentialTokens(Credentials credentials, Configuration jobconf, ActionExecutor.Context context, WorkflowAction action, Map<String, CredentialsProperties> credPropertiesMap) throws Exception {
        if (!this.isValidCredentialTokensPreconditions(context, action, credPropertiesMap)) {
            this.LOG.debug("Not obtaining delegation token(s) as preconditions do not hold.");
            return;
        }
        this.setActionTokenProperties(jobconf);
        CredentialsProviderFactory.ensureKerberosLogin();
        for (Map.Entry<String, CredentialsProperties> entry : credPropertiesMap.entrySet()) {
            String credName = entry.getKey();
            CredentialsProperties credProps = entry.getValue();
            if (credProps == null) continue;
            CredentialsProvider tokenProvider = CredentialsProviderFactory.getInstance().createCredentialsProvider(credProps.getType());
            if (tokenProvider != null) {
                tokenProvider.updateCredentials(credentials, jobconf, credProps, context);
                this.LOG.debug("Retrieved Credential '" + credName + "' for action " + action.getId());
                continue;
            }
            this.LOG.debug("Credentials object is null for name= " + credName + ", type=" + credProps.getType());
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA020", "Could not load credentials of type [{0}] with name [{1}]]; perhaps it was not defined in oozie-site.xml?", credProps.getType(), credName);
        }
    }

    private boolean isValidCredentialTokensPreconditions(ActionExecutor.Context context, WorkflowAction action, Map<String, CredentialsProperties> credPropertiesMap) {
        return context != null && action != null && credPropertiesMap != null;
    }

    protected void setActionTokenProperties(Configuration jobconf) {
    }

    protected HashMap<String, CredentialsProperties> getActionCredentialsProperties(ActionExecutor.Context context, WorkflowAction action) throws Exception {
        HashMap<String, CredentialsProperties> props = new HashMap<String, CredentialsProperties>();
        if (context != null && action != null) {
            String credsInAction = action.getCred();
            if (credsInAction != null) {
                String[] credNames;
                this.LOG.debug("Get credential '" + credsInAction + "' properties for action : " + action.getId());
                for (String credName : credNames = credsInAction.split(",")) {
                    CredentialsProperties credProps = this.getCredProperties(context, credName);
                    props.put(credName, credProps);
                }
            }
        } else {
            this.LOG.warn("context or action is null");
        }
        return props;
    }

    protected CredentialsProperties getCredProperties(ActionExecutor.Context context, String credName) throws Exception {
        CredentialsProperties credProp = null;
        String workflowXml = ((WorkflowJobBean)context.getWorkflow()).getWorkflowInstance().getApp().getDefinition();
        XConfiguration wfjobConf = this.getWorkflowConf(context);
        Element elementJob = XmlUtils.parseXml(workflowXml);
        Element credentials = elementJob.getChild("credentials", elementJob.getNamespace());
        if (credentials != null) {
            for (Element credential : credentials.getChildren("credential", credentials.getNamespace())) {
                String name = credential.getAttributeValue("name");
                String type = credential.getAttributeValue("type");
                this.LOG.debug("getCredProperties: Name: " + name + ", Type: " + type);
                if (!name.equalsIgnoreCase(credName)) continue;
                credProp = new CredentialsProperties(name, type);
                for (Element property : credential.getChildren("property", credential.getNamespace())) {
                    String propertyName = property.getChildText("name", property.getNamespace());
                    String propertyValue = property.getChildText("value", property.getNamespace());
                    ELEvaluator eval = new ELEvaluator();
                    Iterator iterator = wfjobConf.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        eval.setVariable((String)entry.getKey(), ((String)entry.getValue()).trim());
                    }
                    propertyName = eval.evaluate(propertyName, String.class);
                    propertyValue = eval.evaluate(propertyValue, String.class);
                    credProp.getProperties().put(propertyName, propertyValue);
                    this.LOG.debug("getCredProperties: Properties name :'" + propertyName + "', Value : '" + propertyValue + "'");
                }
            }
            if (credProp == null && credName != null) {
                throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "JA021", "Could not load credentials with name [{0}]].", credName);
            }
        } else {
            this.LOG.debug("credentials is null for the action");
        }
        return credProp;
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        LogUtils.setLogInfo(action);
        try {
            this.LOG.info("Starting action. Getting Action File System");
            FileSystem actionFs = context.getAppFileSystem();
            this.LOG.debug("Preparing action Dir through copying " + context.getActionDir());
            this.prepareActionDir(actionFs, context);
            this.LOG.debug("Action Dir is ready. Submitting the action ");
            this.submitLauncher(actionFs, context, action);
            this.LOG.debug("Action submit completed. Performing check ");
            this.check(context, action);
            this.LOG.debug("Action check is done after submission");
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        this.LOG.info("Action ended with external status [{0}]", action.getExternalStatus());
        try {
            String externalStatus = action.getExternalStatus();
            WorkflowAction.Status status = externalStatus.equals(SUCCEEDED) ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
            context.setEndData(status, this.getActionSignal(status));
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        finally {
            try {
                FileSystem actionFs = context.getAppFileSystem();
                this.cleanUpActionDir(actionFs, context);
            }
            catch (Exception ex) {
                throw this.convertException(ex);
            }
        }
    }

    protected JobClient createJobClient(ActionExecutor.Context context, Configuration jobConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        return Services.get().get(HadoopAccessorService.class).createJobClient(user, jobConf);
    }

    protected YarnClient createYarnClient(ActionExecutor.Context context, Configuration jobConf) throws HadoopAccessorException {
        String user = context.getWorkflow().getUser();
        return Services.get().get(HadoopAccessorService.class).createYarnClient(user, jobConf);
    }

    protected String getActualExternalId(WorkflowAction action) {
        return action.getExternalId();
    }

    private boolean needToAddMapReduceToClassPath(Configuration launcherConf) {
        this.LOG.debug("Calculating whether to add MapReduce JARs to classpath. [type={0};this={1}]", this.getType(), this);
        boolean defaultValue = ConfigurationService.getBooleanOrDefault(launcherConf, OOZIE_LAUNCHER_ADD_MAPREDUCE_TO_CLASSPATH_PROPERTY, false);
        this.LOG.debug("Default value for [{0}] is [{1}]", OOZIE_LAUNCHER_ADD_MAPREDUCE_TO_CLASSPATH_PROPERTY, defaultValue);
        String configurationKey = "oozie.action.mapreduce.needed.for." + this.getType();
        boolean configuredValue = ConfigurationService.getBooleanOrDefault(launcherConf, configurationKey, defaultValue);
        this.LOG.debug("Configured value for [{0}] is [{1}]", configurationKey, configuredValue);
        return configuredValue;
    }

    protected void addActionSpecificEnvVars(Map<String, String> env) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        boolean fallback = false;
        this.LOG = XLog.resetPrefix(this.LOG);
        LogUtils.setLogInfo(action);
        YarnClient yarnClient = null;
        try {
            Element actionXml = XmlUtils.parseXml(action.getConf());
            Configuration jobConf = this.createBaseHadoopConf(context, actionXml);
            FileSystem actionFs = context.getAppFileSystem();
            yarnClient = this.createYarnClient(context, jobConf);
            FinalApplicationStatus appStatus = null;
            try {
                String effectiveApplicationId = this.findYarnApplicationId(context, action);
                ApplicationId applicationId = ConverterUtils.toApplicationId((String)effectiveApplicationId);
                ApplicationReport appReport = yarnClient.getApplicationReport(applicationId);
                YarnApplicationState appState = appReport.getYarnApplicationState();
                if (appState == YarnApplicationState.FAILED || appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.KILLED) {
                    appStatus = appReport.getFinalApplicationStatus();
                }
            }
            catch (ActionExecutorException aae) {
                this.LOG.warn((Object)"Foreseen Exception occurred while action execution; rethrowing ", aae);
                throw aae;
            }
            catch (Exception ye) {
                this.LOG.warn((Object)"Exception occurred while checking Launcher AM status; will try checking action data file instead ", ye);
                fallback = true;
            }
            if (appStatus != null || fallback) {
                String externalIDs;
                String externalID;
                Path actionDir = context.getActionDir();
                Map<String, String> actionData = LauncherHelper.getActionData(actionFs, actionDir, jobConf);
                if (fallback) {
                    String finalStatus = actionData.get("final.status");
                    if (finalStatus != null) {
                        appStatus = FinalApplicationStatus.valueOf((String)finalStatus);
                    } else {
                        context.setExecutionData(FAILED, null);
                        throw new ActionExecutorException(ActionExecutorException.ErrorType.FAILED, "JA017", "Unknown hadoop job [{0}] associated with action [{1}] and couldn't determine status from action data.  Failing this action!", action.getExternalId(), action.getId());
                    }
                }
                if ((externalID = actionData.get("newId")) != null) {
                    context.setExternalChildIDs(externalID);
                    this.LOG.info(1, "Hadoop Job was launched : [{0}]", externalID);
                }
                if ((externalIDs = actionData.get("externalChildIDs")) != null) {
                    context.setExternalChildIDs(externalIDs);
                    this.LOG.info(1, "External Child IDs  : [{0}]", externalIDs);
                }
                this.LOG.info(1, "action completed, external ID [{0}]", action.getExternalId());
                context.setExecutionData(appStatus.toString(), null);
                if (appStatus == FinalApplicationStatus.SUCCEEDED) {
                    if (this.getCaptureOutput(action) && LauncherHelper.hasOutputData(actionData)) {
                        context.setExecutionData(SUCCEEDED, PropertiesUtils.stringToProperties(actionData.get("output.properties")));
                        this.LOG.info(1, "action produced output", new Object[0]);
                    } else {
                        context.setExecutionData(SUCCEEDED, null);
                    }
                    if (LauncherHelper.hasStatsData(actionData)) {
                        context.setExecutionStats(actionData.get("stats.properties"));
                        this.LOG.info(1, "action produced stats", new Object[0]);
                    }
                    this.getActionData(actionFs, action, context);
                } else {
                    if (actionData.containsKey("error.properties")) {
                        Properties props = PropertiesUtils.stringToProperties(actionData.get("error.properties"));
                        String errorCode = props.getProperty("error.code");
                        if ("0".equals(errorCode)) {
                            errorCode = "JA018";
                        }
                        if ("-1".equals(errorCode)) {
                            errorCode = "JA019";
                        }
                        String errorReason = props.getProperty("error.reason");
                        this.LOG.warn("Launcher ERROR, reason: {0}", errorReason);
                        String exMsg = props.getProperty("exception.message");
                        String errorInfo = exMsg != null ? exMsg : errorReason;
                        context.setErrorInfo(errorCode, errorInfo);
                        String exStackTrace = props.getProperty("exception.stacktrace");
                        if (exMsg != null) {
                            this.LOG.warn("Launcher exception: {0}{E}{1}", exMsg, exStackTrace);
                        }
                    } else {
                        String errorReason = XLog.format("Launcher AM died, check Hadoop LOG for job [{0}:{1}]", action.getTrackerUri(), action.getExternalId());
                        this.LOG.warn(errorReason);
                    }
                    context.setExecutionData(FAILED_KILLED, null);
                }
            } else {
                context.setExternalStatus(YarnApplicationState.RUNNING.toString());
                this.LOG.info(1, "checking action, hadoop job ID [{0}] status [RUNNING]", action.getExternalId());
            }
            if (yarnClient == null) return;
        }
        catch (Exception ex) {
            try {
                this.LOG.warn("Exception in check(). Message[{0}]", ex.getMessage(), ex);
                throw this.convertException(ex);
            }
            catch (Throwable throwable) {
                if (yarnClient == null) throw throwable;
                IOUtils.closeQuietly(yarnClient);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)yarnClient);
        return;
    }

    protected String findYarnApplicationId(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        return action.getExternalId();
    }

    protected void getActionData(FileSystem actionFs, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
    }

    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        Namespace ns;
        Element eConf = XmlUtils.parseXml(action.getConf());
        Element captureOutput = eConf.getChild("capture-output", ns = eConf.getNamespace());
        return captureOutput != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        YarnClient yarnClient = null;
        try {
            String externalChildIDs;
            Element actionXml = XmlUtils.parseXml(action.getConf());
            Configuration jobConf = this.createBaseHadoopConf(context, actionXml);
            String launcherTag = this.getActionYarnTag(context, action);
            jobConf.set("oozie.child.mapreduce.job.tags", LauncherHelper.getTag(launcherTag));
            yarnClient = this.createYarnClient(context, jobConf);
            if (action.getExternalId() != null) {
                try {
                    this.LOG.info("Killing action {0}'s external application {1}", action.getId(), action.getExternalId());
                    yarnClient.killApplication(ConverterUtils.toApplicationId((String)action.getExternalId()));
                }
                catch (Exception e) {
                    this.LOG.warn("Could not kill {0}", action.getExternalId(), e);
                }
            }
            if ((externalChildIDs = action.getExternalChildIDs()) != null) {
                for (String childId : externalChildIDs.split(",")) {
                    try {
                        this.LOG.info("Killing action {0}'s external child application {1}", action.getId(), childId);
                        yarnClient.killApplication(ConverterUtils.toApplicationId((String)childId.trim()));
                    }
                    catch (Exception e) {
                        this.LOG.warn("Could not kill external child of {0}, {1}", action.getExternalId(), childId, e);
                    }
                }
            }
            for (ApplicationId id : LauncherMain.getChildYarnJobs((Configuration)jobConf, (ApplicationsRequestScope)ApplicationsRequestScope.ALL, (long)action.getStartTime().getTime())) {
                try {
                    this.LOG.info("Killing action {0}'s external child application {1} based on tags", action.getId(), id.toString());
                    yarnClient.killApplication(id);
                }
                catch (Exception e) {
                    this.LOG.warn("Could not kill child of {0}, {1}", action.getExternalId(), id, e);
                }
            }
            context.setExternalStatus(KILLED);
            context.setExecutionData(KILLED, null);
        }
        catch (Exception ex) {
            try {
                this.LOG.error((Object)"Error when killing YARN application", ex);
                throw this.convertException(ex);
            }
            catch (Throwable throwable) {
                try {
                    FileSystem actionFs = context.getAppFileSystem();
                    this.cleanUpActionDir(actionFs, context);
                    Closeables.closeQuietly(yarnClient);
                    throw throwable;
                }
                catch (Exception ex2) {
                    this.LOG.error((Object)"Error when cleaning up action dir", ex2);
                    throw this.convertException(ex2);
                }
            }
        }
        try {
            FileSystem actionFs = context.getAppFileSystem();
            this.cleanUpActionDir(actionFs, context);
            Closeables.closeQuietly((Closeable)yarnClient);
            return;
        }
        catch (Exception ex) {
            this.LOG.error((Object)"Error when cleaning up action dir", ex);
            throw this.convertException(ex);
        }
    }

    protected String getActionYarnTag(ActionExecutor.Context context, WorkflowAction action) {
        return LauncherHelper.getActionYarnTag(context.getProtoActionConf(), context.getWorkflow().getParentId(), action);
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return FINAL_STATUS.contains(externalStatus);
    }

    protected String[] getShareLibNames(ActionExecutor.Context context, Element actionXml, Configuration conf) {
        String sharelibFromConfigurationProperty = ACTION_SHARELIB_FOR + this.getType();
        try {
            String defaultShareLibName = this.getDefaultShareLibName(actionXml);
            Configuration oozieServerConfiguration = Services.get().get(ConfigurationService.class).getConf();
            XConfiguration workflowConfiguration = this.getWorkflowConf(context);
            return new SharelibResolver(sharelibFromConfigurationProperty, conf, workflowConfiguration, oozieServerConfiguration, defaultShareLibName).resolve();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't get workflow configuration: " + ex.toString(), ex);
        }
    }

    protected String getDefaultShareLibName(Element actionXml) {
        return null;
    }

    public String[] getShareLibFilesForActionConf() {
        return null;
    }

    protected void setActionCompletionData(ActionExecutor.Context context, FileSystem actionFs) throws IOException, HadoopAccessorException, URISyntaxException {
    }

    private void injectJobInfo(Configuration launcherJobConf, Configuration actionConf, ActionExecutor.Context context, WorkflowAction action) {
        if (OozieJobInfo.isJobInfoEnabled()) {
            try {
                OozieJobInfo jobInfo = new OozieJobInfo(actionConf, context, action);
                String jobInfoStr = jobInfo.getJobInfo();
                launcherJobConf.set("oozie.job.info", jobInfoStr + "launcher=true");
                actionConf.set("oozie.job.info", jobInfoStr + "launcher=false");
            }
            catch (Exception e) {
                this.LOG.error((Object)"Error while populating job info", e);
            }
        }
    }

    @Override
    public boolean requiresNameNodeJobTracker() {
        return true;
    }

    @Override
    public boolean supportsConfigurationJobXML() {
        return true;
    }

    private XConfiguration getWorkflowConf(ActionExecutor.Context context) throws IOException {
        if (this.workflowConf == null) {
            this.workflowConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
        }
        return this.workflowConf;
    }

    private String getActionTypeLauncherPrefix() {
        return "oozie.action." + this.getType() + ".launcher.";
    }

    static {
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add(QUEUE_NAME);
        SPECIAL_PROPERTIES.add(ACL_VIEW_JOB);
        SPECIAL_PROPERTIES.add(ACL_MODIFY_JOB);
        FINAL_STATUS = new HashSet<String>();
        FINAL_STATUS.add(SUCCEEDED);
        FINAL_STATUS.add(KILLED);
        FINAL_STATUS.add(FAILED);
        FINAL_STATUS.add(FAILED_KILLED);
    }
}

