/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.BinaryBlob;
import org.apache.oozie.StringBlob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.StringUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_WORKFLOW", query="update WorkflowJobBean w set w.appName = :appName, w.appPath = :appPath, w.conf = :conf, w.group = :groupName, w.run = :run, w.user = :user, w.createdTimestamp = :createdTime, w.endTimestamp = :endTime, w.externalId = :externalId, w.lastModifiedTimestamp = :lastModTime,w.logToken = :logToken, w.protoActionConf = :protoActionConf, w.slaXml =:slaXml, w.startTimestamp = :startTime, w.statusStr = :status, w.wfInstance = :wfInstance where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_MODTIME", query="update WorkflowJobBean w set w.lastModifiedTimestamp = :lastModTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_STATUS_MODTIME", query="update WorkflowJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_PARENT_MODIFIED", query="update WorkflowJobBean w set w.parentId = :parentId, w.lastModifiedTimestamp = :lastModTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED", query="update WorkflowJobBean w set w.statusStr = :status, w.wfInstance = :wfInstance, w.lastModifiedTimestamp = :lastModTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END", query="update WorkflowJobBean w set w.statusStr = :status, w.wfInstance = :wfInstance, w.lastModifiedTimestamp = :lastModTime, w.endTimestamp = :endTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END", query="update WorkflowJobBean w set w.statusStr = :status, w.wfInstance = :wfInstance, w.lastModifiedTimestamp = :lastModTime, w.startTimestamp = :startTime, w.endTimestamp = :endTime where w.id = :id"), @NamedQuery(name="UPDATE_WORKFLOW_RERUN", query="update WorkflowJobBean w set w.appName = :appName, w.protoActionConf = :protoActionConf, w.appPath = :appPath, w.conf = :conf, w.logToken = :logToken, w.user = :user, w.group = :group, w.externalId = :externalId, w.endTimestamp = :endTime, w.run = :run, w.statusStr = :status, w.wfInstance = :wfInstance, w.lastModifiedTimestamp = :lastModTime where w.id = :id"), @NamedQuery(name="DELETE_WORKFLOW", query="delete from WorkflowJobBean w where w.id IN (:id)"), @NamedQuery(name="GET_WORKFLOWS", query="select OBJECT(w) from WorkflowJobBean w order by w.startTimestamp desc"), @NamedQuery(name="GET_WORKFLOWS_COLUMNS", query="select w.id, w.appName, w.statusStr, w.run, w.user, w.group, w.createdTimestamp, w.startTimestamp, w.lastModifiedTimestamp, w.endTimestamp, w.externalId, w.parentId from WorkflowJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_WORKFLOWS_COUNT", query="select count(w) from WorkflowJobBean w"), @NamedQuery(name="GET_COMPLETED_WORKFLOWS_OLDER_THAN", query="select w from WorkflowJobBean w where w.endTimestamp < :endTime"), @NamedQuery(name="GET_COMPLETED_WORKFLOWS_WITH_NO_PARENT_OLDER_THAN", query="select w.id from WorkflowJobBean w where w.endTimestamp < :endTime and w.parentId is null"), @NamedQuery(name="GET_COMPLETED_COORD_WORKFLOWS_OLDER_THAN", query="select w.id, w.parentId from WorkflowJobBean w where w.endTimestamp < :endTime and w.parentId like '%C@%'"), @NamedQuery(name="GET_WORKFLOW", query="select OBJECT(w) from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_STARTTIME", query="select w.id, w.startTimestamp from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_START_END_TIME", query="select w.id, w.startTimestamp, w.endTimestamp from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_USER_GROUP", query="select w.user, w.group from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_SUSPEND", query="select w.id, w.user, w.group, w.appName, w.statusStr, w.parentId, w.startTimestamp, w.endTimestamp, w.logToken, w.wfInstance  from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_RERUN", query="select w.id, w.user, w.group, w.appName, w.statusStr, w.run, w.logToken, w.wfInstance, w.parentId from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_DEFINITION", query="select w.id, w.user, w.group, w.appName, w.logToken, w.wfInstance from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_ACTION_OP", query="select w.id, w.user, w.group, w.appName, w.appPath, w.statusStr, w.run, w.parentId, w.logToken, w.wfInstance, w.protoActionConf from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_KILL", query="select w.id, w.user, w.group, w.appName, w.appPath, w.statusStr, w.parentId, w.startTimestamp, w.endTimestamp, w.logToken, w.wfInstance, w.slaXml, w.protoActionConf from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_RESUME", query="select w.id, w.user, w.group, w.appName, w.appPath, w.statusStr, w.parentId, w.startTimestamp, w.endTimestamp, w.logToken, w.wfInstance, w.protoActionConf from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_FOR_UPDATE", query="select OBJECT(w) from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_FOR_SLA", query="select w.id, w.statusStr, w.startTimestamp, w.endTimestamp from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_ID_FOR_EXTERNAL_ID", query="select  w.id from WorkflowJobBean w where w.externalId = :externalId"), @NamedQuery(name="GET_WORKFLOWS_COUNT_WITH_STATUS", query="select count(w) from WorkflowJobBean w where w.statusStr = :status"), @NamedQuery(name="GET_WORKFLOWS_COUNT_WITH_STATUS_IN_LAST_N_SECS", query="select count(w) from WorkflowJobBean w where w.statusStr = :status and w.lastModifiedTimestamp > :lastModTime"), @NamedQuery(name="GET_WORKFLOWS_WITH_WORKFLOW_PARENT_ID", query="select w.id from WorkflowJobBean w where w.parentId = :parentId"), @NamedQuery(name="GET_WORKFLOWS_WITH_COORD_PARENT_ID", query="select w.id from WorkflowJobBean w where w.parentId like :parentId"), @NamedQuery(name="GET_WORKFLOWS_BASIC_INFO_BY_PARENT_ID", query="select w.id, w.statusStr, w.endTimestamp, w.lastModifiedTimestamp from WorkflowJobBean w where w.parentId = :parentId"), @NamedQuery(name="GET_WORKFLOWS_BASIC_INFO_BY_COORD_PARENT_ID", query="select w.id,  w.statusStr, w.endTimestamp, w.lastModifiedTimestamp from WorkflowJobBean w where w.parentId like :parentId"), @NamedQuery(name="GET_WORKFLOW_FOR_USER", query="select w.user from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_STATUS", query="select w.statusStr from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOWS_PARENT_COORD_RERUN", query="select w.id, w.statusStr, w.startTimestamp, w.endTimestamp from WorkflowJobBean w where w.parentId = :parentId order by w.createdTimestamp")})
@Table(name="WF_JOBS")
public class WorkflowJobBean
implements Writable,
WorkflowJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="proto_action_conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob protoActionConf;
    @Basic
    @Column(name="log_token")
    private String logToken = null;
    @Basic
    @Index
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Index
    @Column(name="status")
    private String statusStr = WorkflowJob.Status.PREP.toString();
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Index
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Column(name="wf_instance")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.BinaryBlobValueHandler")
    private BinaryBlob wfInstance;
    @Basic
    @Column(name="sla_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob slaXml;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Basic
    @Column(name="conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob conf;
    @Basic
    @Index
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group;
    @Basic
    @Column(name="run")
    private int run = 1;
    @Basic
    @Index
    @Column(name="parent_id")
    private String parentId;
    @Transient
    private String consoleUrl;
    @Transient
    private List<WorkflowActionBean> actions = new ArrayList<WorkflowActionBean>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$StringBlob;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$BinaryBlob;
    static /* synthetic */ Class class$Lorg$apache$oozie$WorkflowJobBean;
    private transient Object pcDetachedState;

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getParentId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeLong(this.getCreatedTime() != null ? this.getCreatedTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastModifiedTime() != null ? this.getLastModifiedTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        dataOutput.writeInt(this.getRun());
        WritableUtils.writeStr(dataOutput, WorkflowJobBean.pcGetlogToken(this));
        WritableUtils.writeStr(dataOutput, this.getProtoActionConf());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setParentId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(WorkflowJob.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setCreatedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            // empty if block
        }
        this.setStartTime(new Date(d));
        d = dataInput.readLong();
        if (d != -1L) {
            this.setLastModifiedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setRun(dataInput.readInt());
        WorkflowJobBean.pcSetlogToken(this, WritableUtils.readStr(dataInput));
        this.setProtoActionConf(WritableUtils.readStr(dataInput));
        this.setExternalId(this.getExternalId());
    }

    public boolean inTerminalState() {
        boolean inTerminalState = false;
        switch (WorkflowJob.Status.valueOf((String)WorkflowJobBean.pcGetstatusStr(this))) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: {
                inTerminalState = true;
                break;
            }
        }
        return inTerminalState;
    }

    public String getLogToken() {
        return WorkflowJobBean.pcGetlogToken(this);
    }

    public void setLogToken(String logToken) {
        WorkflowJobBean.pcSetlogToken(this, logToken);
    }

    public String getSlaXml() {
        return WorkflowJobBean.pcGetslaXml(this) == null ? null : WorkflowJobBean.pcGetslaXml(this).getString();
    }

    public void setSlaXml(String slaXml) {
        if (WorkflowJobBean.pcGetslaXml(this) == null) {
            WorkflowJobBean.pcSetslaXml(this, new StringBlob(slaXml));
        } else {
            WorkflowJobBean.pcGetslaXml(this).setString(slaXml);
        }
    }

    public void setSlaXmlBlob(StringBlob slaXml) {
        WorkflowJobBean.pcSetslaXml(this, slaXml);
    }

    public StringBlob getSlaXmlBlob() {
        return WorkflowJobBean.pcGetslaXml(this);
    }

    public WorkflowInstance getWorkflowInstance() {
        return WorkflowJobBean.pcGetwfInstance(this) == null ? null : this.get(WorkflowJobBean.pcGetwfInstance(this).getBytes());
    }

    public BinaryBlob getWfInstanceBlob() {
        return WorkflowJobBean.pcGetwfInstance(this);
    }

    public void setWorkflowInstance(WorkflowInstance workflowInstance) {
        if (WorkflowJobBean.pcGetwfInstance(this) == null) {
            WorkflowJobBean.pcSetwfInstance(this, new BinaryBlob(WritableUtils.toByteArray((LiteWorkflowInstance)workflowInstance), true));
        } else {
            WorkflowJobBean.pcGetwfInstance(this).setBytes(WritableUtils.toByteArray((LiteWorkflowInstance)workflowInstance));
        }
    }

    public void setWfInstanceBlob(BinaryBlob wfInstance) {
        WorkflowJobBean.pcSetwfInstance(this, wfInstance);
    }

    public String getProtoActionConf() {
        return WorkflowJobBean.pcGetprotoActionConf(this) == null ? null : WorkflowJobBean.pcGetprotoActionConf(this).getString();
    }

    public void setProtoActionConf(String protoActionConf) {
        if (WorkflowJobBean.pcGetprotoActionConf(this) == null) {
            WorkflowJobBean.pcSetprotoActionConf(this, new StringBlob(protoActionConf));
        } else {
            WorkflowJobBean.pcGetprotoActionConf(this).setString(protoActionConf);
        }
    }

    public void setProtoActionConfBlob(StringBlob protoBytes) {
        WorkflowJobBean.pcSetprotoActionConf(this, protoBytes);
    }

    public StringBlob getProtoActionConfBlob() {
        return WorkflowJobBean.pcGetprotoActionConf(this);
    }

    public String getlogToken() {
        return WorkflowJobBean.pcGetlogToken(this);
    }

    public Timestamp getLastModifiedTimestamp() {
        return WorkflowJobBean.pcGetlastModifiedTimestamp(this);
    }

    public Timestamp getStartTimestamp() {
        return WorkflowJobBean.pcGetstartTimestamp(this);
    }

    public Timestamp getCreatedTimestamp() {
        return WorkflowJobBean.pcGetcreatedTimestamp(this);
    }

    public Timestamp getEndTimestamp() {
        return WorkflowJobBean.pcGetendTimestamp(this);
    }

    public void setStatusStr(String statusStr) {
        WorkflowJobBean.pcSetstatusStr(this, StringUtils.intern(statusStr));
    }

    public void setStatus(WorkflowJob.Status val) {
        WorkflowJobBean.pcSetstatusStr(this, StringUtils.intern(val.toString()));
    }

    public WorkflowJob.Status getStatus() {
        return WorkflowJob.Status.valueOf((String)WorkflowJobBean.pcGetstatusStr(this));
    }

    public String getStatusStr() {
        return WorkflowJobBean.pcGetstatusStr(this);
    }

    public void setExternalId(String externalId) {
        WorkflowJobBean.pcSetexternalId(this, StringUtils.intern(externalId));
    }

    public String getExternalId() {
        return WorkflowJobBean.pcGetexternalId(this);
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        WorkflowJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetlastModifiedTimestamp(this));
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetcreatedTimestamp(this));
    }

    public void setCreatedTime(Date createdTime) {
        WorkflowJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createdTime));
    }

    public Date getStartTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetstartTimestamp(this));
    }

    public void setStartTime(Date startTime) {
        WorkflowJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    public Date getEndTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetendTimestamp(this));
    }

    public void setEndTime(Date endTime) {
        WorkflowJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    private WorkflowInstance get(byte[] array) {
        LiteWorkflowInstance pInstance = WritableUtils.fromByteArray(array, LiteWorkflowInstance.class);
        return pInstance;
    }

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"appPath", (Object)this.getAppPath());
        json.put((Object)"appName", (Object)this.getAppName());
        json.put((Object)"id", (Object)this.getId());
        json.put((Object)"externalId", (Object)this.getExternalId());
        json.put((Object)"parentId", (Object)this.getParentId());
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"lastModTime", (Object)JsonUtils.formatDateRfc822((Date)this.getLastModifiedTime(), (String)timeZoneId));
        json.put((Object)"createdTime", (Object)JsonUtils.formatDateRfc822((Date)this.getCreatedTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"run", (Object)this.getRun());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"actions", (Object)WorkflowActionBean.toJSONArray(this.actions, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public String getAppPath() {
        return WorkflowJobBean.pcGetappPath(this);
    }

    public void setAppPath(String appPath) {
        WorkflowJobBean.pcSetappPath(this, StringUtils.intern(appPath));
    }

    public String getAppName() {
        return WorkflowJobBean.pcGetappName(this);
    }

    public void setAppName(String appName) {
        WorkflowJobBean.pcSetappName(this, StringUtils.intern(appName));
    }

    public String getId() {
        return WorkflowJobBean.pcGetid(this);
    }

    public void setId(String id) {
        WorkflowJobBean.pcSetid(this, StringUtils.intern(id));
    }

    public String getConf() {
        return WorkflowJobBean.pcGetconf(this) == null ? null : WorkflowJobBean.pcGetconf(this).getString();
    }

    public void setConf(String conf) {
        if (WorkflowJobBean.pcGetconf(this) == null) {
            WorkflowJobBean.pcSetconf(this, new StringBlob(conf));
        } else {
            WorkflowJobBean.pcGetconf(this).setString(conf);
        }
    }

    public void setConfBlob(StringBlob conf) {
        WorkflowJobBean.pcSetconf(this, conf);
    }

    public StringBlob getConfBlob() {
        return WorkflowJobBean.pcGetconf(this);
    }

    public String getUser() {
        return WorkflowJobBean.pcGetuser(this);
    }

    public void setUser(String user) {
        WorkflowJobBean.pcSetuser(this, StringUtils.intern(user));
    }

    public String getGroup() {
        return WorkflowJobBean.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public void setGroup(String group) {
        WorkflowJobBean.pcSetgroup(this, StringUtils.intern(group));
    }

    public int getRun() {
        return WorkflowJobBean.pcGetrun(this);
    }

    public void setRun(int run) {
        WorkflowJobBean.pcSetrun(this, run);
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public String getParentId() {
        return WorkflowJobBean.pcGetparentId(this);
    }

    public void setParentId(String parentId) {
        WorkflowJobBean.pcSetparentId(this, StringUtils.intern(parentId));
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = StringUtils.intern(consoleUrl);
    }

    public List<WorkflowAction> getActions() {
        return this.actions;
    }

    public void setActions(List<WorkflowActionBean> nodes) {
        this.actions = nodes != null ? nodes : new ArrayList();
    }

    public String toString() {
        return MessageFormat.format("Workflow id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public static JSONArray toJSONArray(List<WorkflowJobBean> workflows, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (workflows != null) {
            for (WorkflowJobBean node : workflows) {
                array.add((Object)node.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"appName", "appPath", "conf", "createdTimestamp", "endTimestamp", "externalId", "group", "id", "lastModifiedTimestamp", "logToken", "parentId", "protoActionConf", "run", "slaXml", "startTimestamp", "statusStr", "user", "wfInstance"};
        Class[] classArray = new Class[18];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        Class clazz2 = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[2] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[3] = clazz3;
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[11] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[12] = Integer.TYPE;
        classArray[13] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = WorkflowJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[14] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        Class clazz4 = class$Lorg$apache$oozie$BinaryBlob != null ? class$Lorg$apache$oozie$BinaryBlob : (class$Lorg$apache$oozie$BinaryBlob = WorkflowJobBean.class$("org.apache.oozie.BinaryBlob"));
        classArray[17] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 10, 26, 26, 26, 10};
        Class clazz5 = class$Lorg$apache$oozie$WorkflowJobBean != null ? class$Lorg$apache$oozie$WorkflowJobBean : (class$Lorg$apache$oozie$WorkflowJobBean = WorkflowJobBean.class$("org.apache.oozie.WorkflowJobBean"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"WorkflowJobBean", (PersistenceCapable)new WorkflowJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appPath = null;
        this.conf = null;
        this.createdTimestamp = null;
        this.endTimestamp = null;
        this.externalId = null;
        this.group = null;
        this.id = null;
        this.lastModifiedTimestamp = null;
        this.logToken = null;
        this.parentId = null;
        this.protoActionConf = null;
        this.run = 0;
        this.slaXml = null;
        this.startTimestamp = null;
        this.statusStr = null;
        this.user = null;
        this.wfInstance = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        WorkflowJobBean workflowJobBean = new WorkflowJobBean();
        if (bl) {
            workflowJobBean.pcClearFields();
        }
        workflowJobBean.pcStateManager = stateManager;
        workflowJobBean.pcCopyKeyFieldsFromObjectId(object);
        return workflowJobBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        WorkflowJobBean workflowJobBean = new WorkflowJobBean();
        if (bl) {
            workflowJobBean.pcClearFields();
        }
        workflowJobBean.pcStateManager = stateManager;
        return workflowJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 18;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.conf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.logToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.parentId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.protoActionConf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.run = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.slaXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.wfInstance = (BinaryBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.conf);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.logToken);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.parentId);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.protoActionConf);
                return;
            }
            case 12: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.run);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.slaXml);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.wfInstance);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(WorkflowJobBean workflowJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = workflowJobBean.appName;
                return;
            }
            case 1: {
                this.appPath = workflowJobBean.appPath;
                return;
            }
            case 2: {
                this.conf = workflowJobBean.conf;
                return;
            }
            case 3: {
                this.createdTimestamp = workflowJobBean.createdTimestamp;
                return;
            }
            case 4: {
                this.endTimestamp = workflowJobBean.endTimestamp;
                return;
            }
            case 5: {
                this.externalId = workflowJobBean.externalId;
                return;
            }
            case 6: {
                this.group = workflowJobBean.group;
                return;
            }
            case 7: {
                this.id = workflowJobBean.id;
                return;
            }
            case 8: {
                this.lastModifiedTimestamp = workflowJobBean.lastModifiedTimestamp;
                return;
            }
            case 9: {
                this.logToken = workflowJobBean.logToken;
                return;
            }
            case 10: {
                this.parentId = workflowJobBean.parentId;
                return;
            }
            case 11: {
                this.protoActionConf = workflowJobBean.protoActionConf;
                return;
            }
            case 12: {
                this.run = workflowJobBean.run;
                return;
            }
            case 13: {
                this.slaXml = workflowJobBean.slaXml;
                return;
            }
            case 14: {
                this.startTimestamp = workflowJobBean.startTimestamp;
                return;
            }
            case 15: {
                this.statusStr = workflowJobBean.statusStr;
                return;
            }
            case 16: {
                this.user = workflowJobBean.user;
                return;
            }
            case 17: {
                this.wfInstance = workflowJobBean.wfInstance;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        WorkflowJobBean workflowJobBean = (WorkflowJobBean)object;
        if (workflowJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(workflowJobBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(7 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$WorkflowJobBean != null ? class$Lorg$apache$oozie$WorkflowJobBean : (class$Lorg$apache$oozie$WorkflowJobBean = WorkflowJobBean.class$("org.apache.oozie.WorkflowJobBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$WorkflowJobBean != null ? class$Lorg$apache$oozie$WorkflowJobBean : (class$Lorg$apache$oozie$WorkflowJobBean = WorkflowJobBean.class$("org.apache.oozie.WorkflowJobBean"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.appName;
        }
        int n = pcInheritedFieldCount + 0;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.appName;
    }

    private static final void pcSetappName(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.appName = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 0, workflowJobBean.appName, string, 0);
    }

    private static final String pcGetappPath(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.appPath;
        }
        int n = pcInheritedFieldCount + 1;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.appPath;
    }

    private static final void pcSetappPath(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.appPath = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 1, workflowJobBean.appPath, string, 0);
    }

    private static final StringBlob pcGetconf(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.conf;
        }
        int n = pcInheritedFieldCount + 2;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.conf;
    }

    private static final void pcSetconf(WorkflowJobBean workflowJobBean, StringBlob stringBlob) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.conf = stringBlob;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 2, (Object)workflowJobBean.conf, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 3;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.createdTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 3, (Object)workflowJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetendTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.endTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 4, (Object)workflowJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexternalId(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.externalId;
        }
        int n = pcInheritedFieldCount + 5;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.externalId;
    }

    private static final void pcSetexternalId(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.externalId = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 5, workflowJobBean.externalId, string, 0);
    }

    private static final String pcGetgroup(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.group;
        }
        int n = pcInheritedFieldCount + 6;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.group;
    }

    private static final void pcSetgroup(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.group = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 6, workflowJobBean.group, string, 0);
    }

    private static final String pcGetid(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.id;
        }
        int n = pcInheritedFieldCount + 7;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.id;
    }

    private static final void pcSetid(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.id = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 7, workflowJobBean.id, string, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 8, (Object)workflowJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetlogToken(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.logToken;
        }
        int n = pcInheritedFieldCount + 9;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.logToken;
    }

    private static final void pcSetlogToken(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.logToken = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 9, workflowJobBean.logToken, string, 0);
    }

    private static final String pcGetparentId(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.parentId;
        }
        int n = pcInheritedFieldCount + 10;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.parentId;
    }

    private static final void pcSetparentId(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.parentId = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 10, workflowJobBean.parentId, string, 0);
    }

    private static final StringBlob pcGetprotoActionConf(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.protoActionConf;
        }
        int n = pcInheritedFieldCount + 11;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.protoActionConf;
    }

    private static final void pcSetprotoActionConf(WorkflowJobBean workflowJobBean, StringBlob stringBlob) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.protoActionConf = stringBlob;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 11, (Object)workflowJobBean.protoActionConf, (Object)stringBlob, 0);
    }

    private static final int pcGetrun(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.run;
        }
        int n = pcInheritedFieldCount + 12;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.run;
    }

    private static final void pcSetrun(WorkflowJobBean workflowJobBean, int n) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.run = n;
            return;
        }
        workflowJobBean.pcStateManager.settingIntField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 12, workflowJobBean.run, n, 0);
    }

    private static final StringBlob pcGetslaXml(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.slaXml;
        }
        int n = pcInheritedFieldCount + 13;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.slaXml;
    }

    private static final void pcSetslaXml(WorkflowJobBean workflowJobBean, StringBlob stringBlob) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.slaXml = stringBlob;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 13, (Object)workflowJobBean.slaXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetstartTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 14;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.startTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 14, (Object)workflowJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatusStr(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.statusStr;
        }
        int n = pcInheritedFieldCount + 15;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.statusStr;
    }

    private static final void pcSetstatusStr(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.statusStr = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 15, workflowJobBean.statusStr, string, 0);
    }

    private static final String pcGetuser(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.user;
        }
        int n = pcInheritedFieldCount + 16;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.user;
    }

    private static final void pcSetuser(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.user = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 16, workflowJobBean.user, string, 0);
    }

    private static final BinaryBlob pcGetwfInstance(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.wfInstance;
        }
        int n = pcInheritedFieldCount + 17;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.wfInstance;
    }

    private static final void pcSetwfInstance(WorkflowJobBean workflowJobBean, BinaryBlob binaryBlob) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.wfInstance = binaryBlob;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 17, (Object)workflowJobBean.wfInstance, (Object)binaryBlob, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

