/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import org.apache.oozie.BaseEngine;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.OozieJsonFactory;
import org.apache.oozie.WorkflowsInfo;
import org.json.simple.JSONObject;

class OozieClientOperationHandler {
    private static final String WF = "wf";
    private static final String BUNDLE = "bundle";
    private static final String COORD = "coord";
    private static final String GMT = "GMT";
    private BaseEngine engine;

    OozieClientOperationHandler(BaseEngine engine) {
        this.engine = engine;
    }

    OozieOperationJob getOperationHandler(String operation, String filter, int start, int len) {
        switch (operation) {
            case "kill": {
                return new KillOperation(filter, start, len);
            }
            case "suspend": {
                return new SuspendingOperation(filter, start, len);
            }
            case "resume": {
                return new ResumingOperation(filter, start, len);
            }
        }
        throw new IllegalArgumentException(operation);
    }

    class ResumingOperation
    extends AbstractOozieOperationJob {
        ResumingOperation(String filter, int start, int len) {
            super(filter, start, len);
        }

        @Override
        BundleJobInfo createBundleJobInfo() throws BundleEngineException {
            return ((BundleEngine)OozieClientOperationHandler.this.engine).resumeJobs(this.filter, this.start, this.len);
        }

        @Override
        CoordinatorJobInfo createCoordinatorJobInfo() throws CoordinatorEngineException {
            return ((CoordinatorEngine)OozieClientOperationHandler.this.engine).resumeJobs(this.filter, this.start, this.len);
        }

        @Override
        WorkflowsInfo createWorkflowsInfo() throws DagEngineException {
            return ((DagEngine)OozieClientOperationHandler.this.engine).resumeJobs(this.filter, this.start, this.len);
        }
    }

    class SuspendingOperation
    extends AbstractOozieOperationJob {
        SuspendingOperation(String filter, int start, int len) {
            super(filter, start, len);
        }

        @Override
        BundleJobInfo createBundleJobInfo() throws BundleEngineException {
            return ((BundleEngine)OozieClientOperationHandler.this.engine).suspendJobs(this.filter, this.start, this.len);
        }

        @Override
        CoordinatorJobInfo createCoordinatorJobInfo() throws CoordinatorEngineException {
            return ((CoordinatorEngine)OozieClientOperationHandler.this.engine).suspendJobs(this.filter, this.start, this.len);
        }

        @Override
        WorkflowsInfo createWorkflowsInfo() throws DagEngineException {
            return ((DagEngine)OozieClientOperationHandler.this.engine).suspendJobs(this.filter, this.start, this.len);
        }
    }

    class KillOperation
    extends AbstractOozieOperationJob {
        KillOperation(String filter, int start, int len) {
            super(filter, start, len);
        }

        @Override
        BundleJobInfo createBundleJobInfo() throws BundleEngineException {
            return ((BundleEngine)OozieClientOperationHandler.this.engine).killJobs(this.filter, this.start, this.len);
        }

        @Override
        CoordinatorJobInfo createCoordinatorJobInfo() throws CoordinatorEngineException {
            return ((CoordinatorEngine)OozieClientOperationHandler.this.engine).killJobs(this.filter, this.start, this.len);
        }

        @Override
        WorkflowsInfo createWorkflowsInfo() throws DagEngineException {
            return ((DagEngine)OozieClientOperationHandler.this.engine).killJobs(this.filter, this.start, this.len);
        }
    }

    static class OozieJobOperationCaller {
        OozieJobOperationCaller() {
        }

        JSONObject call(String jobType, OozieOperationJob job) throws DagEngineException, BundleEngineException, CoordinatorEngineException {
            switch (jobType) {
                case "wf": {
                    return job.WorkflowsJob();
                }
                case "coord": {
                    return job.CoordinatorJob();
                }
                case "bundle": {
                    return job.BundleJob();
                }
            }
            throw new IllegalArgumentException("Invalid jobType passed. jobType: " + jobType);
        }
    }

    abstract class AbstractOozieOperationJob
    implements OozieOperationJob {
        protected final String filter;
        protected final int start;
        protected final int len;

        AbstractOozieOperationJob(String filter, int start, int len) {
            this.filter = filter;
            this.start = start;
            this.len = len;
        }

        @Override
        public JSONObject BundleJob() throws BundleEngineException {
            return OozieJsonFactory.getBundleJSONObject(this.createBundleJobInfo(), OozieClientOperationHandler.GMT);
        }

        abstract BundleJobInfo createBundleJobInfo() throws BundleEngineException;

        @Override
        public JSONObject CoordinatorJob() throws CoordinatorEngineException {
            return OozieJsonFactory.getCoordJSONObject(this.createCoordinatorJobInfo(), OozieClientOperationHandler.GMT);
        }

        abstract CoordinatorJobInfo createCoordinatorJobInfo() throws CoordinatorEngineException;

        @Override
        public JSONObject WorkflowsJob() throws DagEngineException {
            return OozieJsonFactory.getWFJSONObject(this.createWorkflowsInfo(), OozieClientOperationHandler.GMT);
        }

        abstract WorkflowsInfo createWorkflowsInfo() throws DagEngineException;
    }

    static interface OozieOperationJob {
        public JSONObject BundleJob() throws BundleEngineException;

        public JSONObject CoordinatorJob() throws CoordinatorEngineException;

        public JSONObject WorkflowsJob() throws DagEngineException;
    }
}

