/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.util.List;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BaseLocalOozieClient;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.client.BulkResponse;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.OozieClientException;

public class LocalOozieClientBundle
extends BaseLocalOozieClient {
    private final BundleEngine bundleEngine;

    public LocalOozieClientBundle(BundleEngine bundleEngine) {
        super(bundleEngine);
        this.bundleEngine = bundleEngine;
    }

    @Override
    public BundleJob getBundleJobInfo(String jobId) throws OozieClientException {
        try {
            return this.bundleEngine.getBundleJob(jobId);
        }
        catch (BundleEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public Void reRunBundle(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) throws OozieClientException {
        try {
            this.bundleEngine.reRun(jobId, coordScope, dateScope, refresh, noCleanup);
        }
        catch (BaseEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BundleJob> getBundleJobsInfo(String filter, int start, int len) throws OozieClientException {
        try {
            return this.bundleEngine.getBundleJobs(filter, start, len).getBundleJobs();
        }
        catch (BundleEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }

    @Override
    public List<BulkResponse> getBulkInfo(String filter, int start, int len) throws OozieClientException {
        try {
            return this.bundleEngine.getBulkJobs(filter, start, len).getResponses();
        }
        catch (BundleEngineException e) {
            throw new OozieClientException(e.getErrorCode().toString(), (Throwable)e);
        }
    }
}

