/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.servlet.XServletException;

public class FilterParser {
    private static final String PARAMETER_DELIMITER = ";";
    private static final String PARAMETER_EQUALS = "=";

    public static ListMultimap<String, String> parseFilter(String filterString) throws ServletException {
        LinkedListMultimap filterFieldMap = LinkedListMultimap.create();
        if (filterString != null) {
            StringTokenizer st = new StringTokenizer(filterString, PARAMETER_DELIMITER);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains(PARAMETER_EQUALS)) {
                    String[] nameValuePair = token.split(PARAMETER_EQUALS);
                    if (nameValuePair.length != 2) {
                        FilterParser.filterFormatError(filterString);
                    }
                    String key = nameValuePair[0];
                    String value = nameValuePair[1];
                    if (Strings.isNullOrEmpty((String)key)) {
                        FilterParser.filterFormatError(filterString);
                    }
                    filterFieldMap.put((Object)key, (Object)value);
                    continue;
                }
                FilterParser.filterFormatError(filterString);
            }
        }
        return filterFieldMap;
    }

    private static void filterFormatError(String filterString) throws ServletException {
        throw new XServletException(400, ErrorCode.E0401, String.format("elements must be semicolon-separated name=value pairs but was %s", filterString));
    }
}

