/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.types.ApplicationLivenessInformation;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.providers.ProviderService;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.view.SliderHamletBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBlock
extends SliderHamletBlock {
    private static final Logger log = LoggerFactory.getLogger(IndexBlock.class);
    public static final String ALL_CONTAINERS_ALLOCATED = "all containers allocated";

    @Inject
    public IndexBlock(WebAppApi slider) {
        super(slider);
    }

    protected void render(HtmlBlock.Block html) {
        this.doIndex((Hamlet)html, this.getProviderName());
    }

    @VisibleForTesting
    protected void doIndex(Hamlet html, String providerName) {
        ClusterDescription clusterStatus = this.appState.getClusterStatus();
        String name = clusterStatus.name;
        if (name != null && (name.startsWith(" ") || name.endsWith(" "))) {
            name = "'" + name + "'";
        }
        Hamlet.DIV div = html.div("general_info").h1("index_header", "Application: " + name);
        ApplicationLivenessInformation liveness = this.appState.getApplicationLivenessInformation();
        String livestatus = liveness.allRequestsSatisfied ? ALL_CONTAINERS_ALLOCATED : String.format("Awaiting %d containers", liveness.requestsOutstanding);
        Hamlet.TABLE table1 = div.table();
        table1.tr().td("Status").td(livestatus)._();
        table1.tr().td("Total number of containers").td(Integer.toString(this.appState.getNumOwnedContainers()))._();
        table1.tr().td("Create time: ").td(this.getInfoAvoidingNulls("create.time"))._();
        table1.tr().td("Running since: ").td(this.getInfoAvoidingNulls("live.time"))._();
        table1.tr().td("Time last flexed: ").td(this.getInfoAvoidingNulls("flex.time"))._();
        table1.tr().td("Application storage path: ").td(clusterStatus.dataPath)._();
        table1.tr().td("Application configuration path: ").td(clusterStatus.originConfigurationPath)._();
        table1._();
        div._();
        div = null;
        Hamlet.DIV containers = html.div("container_instances").h3("Component Instances");
        int aaRoleWithNoSuitableLocations = 0;
        int aaRoleWithOpenRequest = 0;
        int roleWithOpenRequest = 0;
        Hamlet.TABLE table = containers.table();
        Hamlet.TR header = table.thead().tr();
        this.trb(header, "Component");
        this.trb(header, "Desired");
        this.trb(header, "Actual");
        this.trb(header, "Outstanding Requests");
        this.trb(header, "Failed");
        this.trb(header, "Failed to start");
        this.trb(header, "Placement");
        ((Hamlet.THEAD)header._())._();
        List<RoleStatus> roleStatuses = this.appState.cloneRoleStatusList();
        Collections.sort(roleStatuses, new RoleStatus.CompareByName());
        for (RoleStatus status : roleStatuses) {
            String aatext;
            String roleName = status.getName();
            String nameUrl = String.valueOf(this.apiPath("/live/components")) + "/" + roleName;
            if (status.isAntiAffinePlacement()) {
                boolean aaRequestOutstanding = status.isAARequestOutstanding();
                int pending = (int)status.getPendingAntiAffineRequests();
                aatext = this.buildAADetails(aaRequestOutstanding, pending);
                if (SliderUtils.isSet(status.getLabelExpression())) {
                    aatext = String.valueOf(aatext) + " (label: " + status.getLabelExpression() + ")";
                }
                if (pending > 0 && !aaRequestOutstanding) {
                    ++aaRoleWithNoSuitableLocations;
                } else if (aaRequestOutstanding) {
                    ++aaRoleWithOpenRequest;
                }
            } else {
                aatext = SliderUtils.isSet(status.getLabelExpression()) ? "label: " + status.getLabelExpression() : "";
                if (status.getRequested() > 0L) {
                    ++roleWithOpenRequest;
                }
            }
            ((Hamlet.TR)table.tr().td().a(nameUrl, roleName)._()).td(String.format("%d", status.getDesired())).td(String.format("%d", status.getActual())).td(String.format("%d", status.getRequested())).td(String.format("%d", status.getFailed())).td(String.format("%d", status.getStartFailed())).td(aatext)._();
        }
        table.tr()._();
        table._();
        containers._();
        containers = null;
        html.div()._();
        html.div()._();
        Hamlet.DIV diagnostics = html.div("diagnostics");
        ArrayList<String> statusEntries = new ArrayList<String>(0);
        if (roleWithOpenRequest > 0) {
            statusEntries.add(String.format("%d %s with requests unsatisfiable by cluster", roleWithOpenRequest, this.plural(roleWithOpenRequest, "component")));
        }
        if (aaRoleWithNoSuitableLocations > 0) {
            statusEntries.add(String.format("%d anti-affinity %s no suitable nodes in the cluster", aaRoleWithNoSuitableLocations, this.plural(aaRoleWithNoSuitableLocations, "component has", "components have")));
        }
        if (aaRoleWithOpenRequest > 0) {
            statusEntries.add(String.format("%d anti-affinity %s with requests unsatisfiable by cluster", aaRoleWithOpenRequest, this.plural(aaRoleWithOpenRequest, "component has", "components have")));
        }
        if (!statusEntries.isEmpty()) {
            diagnostics.h3("Diagnostics");
            Hamlet.TABLE diagnosticsTable = diagnostics.table();
            for (String entry : statusEntries) {
                diagnosticsTable.tr().td(entry)._();
            }
            diagnosticsTable._();
        }
        diagnostics._();
        Hamlet.DIV provider_info = html.div("provider_info");
        provider_info.h3(String.valueOf(providerName) + " information");
        Hamlet.UL ul = html.ul();
        this.addProviderServiceOptions(this.providerService, ul, clusterStatus);
        ul._();
        provider_info._();
    }

    @VisibleForTesting
    String buildAADetails(boolean outstanding, int pending) {
        return String.format("Anti-affinity:%s %d pending %s", outstanding ? " 1 active request and" : "", pending, this.plural(pending, "request"));
    }

    private String plural(int n, String singular) {
        return this.plural(n, singular, String.valueOf(singular) + "s");
    }

    private String plural(int n, String singular, String plural) {
        return n == 1 ? singular : plural;
    }

    private void trb(Hamlet.TR tr, String text) {
        tr.td().b(text)._();
    }

    private String getProviderName() {
        return this.providerService.getHumanName();
    }

    private String getInfoAvoidingNulls(String key) {
        String createTime = this.appState.getClusterStatus().getInfo(key);
        return createTime == null ? "N/A" : createTime;
    }

    protected void addProviderServiceOptions(ProviderService provider, Hamlet.UL ul, ClusterDescription clusterStatus) {
        Map<String, String> details = provider.buildMonitorDetails(clusterStatus);
        if (details == null) {
            return;
        }
        for (Map.Entry<String, String> entry : details.entrySet()) {
            String url = entry.getValue();
            if (SliderUtils.isSet(url)) {
                ul.li()._(new Object[]{entry.getKey()}).a(url, url)._();
                continue;
            }
            ul.li(entry.getKey());
        }
    }
}

