/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.operations.CancelSingleRequest;
import org.apache.slider.server.appmaster.operations.ContainerRequestOperation;
import org.apache.slider.server.appmaster.state.ContainerAllocationOutcome;
import org.apache.slider.server.appmaster.state.ContainerAllocationResults;
import org.apache.slider.server.appmaster.state.ContainerPriority;
import org.apache.slider.server.appmaster.state.NodeEntry;
import org.apache.slider.server.appmaster.state.NodeInstance;
import org.apache.slider.server.appmaster.state.OutstandingRequest;
import org.apache.slider.server.appmaster.state.RoleHistory;
import org.apache.slider.server.appmaster.state.RoleHistoryUtils;
import org.apache.slider.server.appmaster.state.RoleHostnamePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutstandingRequestTracker {
    protected static final Logger log = LoggerFactory.getLogger(OutstandingRequestTracker.class);
    private final List<AbstractRMOperation> NO_REQUESTS = new ArrayList<AbstractRMOperation>(0);
    private Map<RoleHostnamePair, OutstandingRequest> placedRequests = new HashMap<RoleHostnamePair, OutstandingRequest>();
    private List<OutstandingRequest> openRequests = new ArrayList<OutstandingRequest>();

    public synchronized OutstandingRequest newRequest(NodeInstance instance, int role) {
        OutstandingRequest request = new OutstandingRequest(role, instance);
        if (request.isLocated()) {
            this.placedRequests.put(request.getIndex(), request);
        } else {
            this.openRequests.add(request);
        }
        return request;
    }

    public synchronized OutstandingRequest newAARequest(int role, List<NodeInstance> nodes, String label) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        for (NodeInstance node : nodes) {
            Preconditions.checkState((boolean)node.canHost(role, label), (String)"Cannot allocate role ID %d to node %s", (Object[])new Object[]{role, node});
        }
        OutstandingRequest request = new OutstandingRequest(role, nodes);
        this.openRequests.add(request);
        return request;
    }

    @VisibleForTesting
    public synchronized OutstandingRequest lookupPlacedRequest(int role, String hostname) {
        Preconditions.checkArgument((hostname != null ? 1 : 0) != 0, (Object)"null hostname");
        return this.placedRequests.get(new RoleHostnamePair(role, hostname));
    }

    @VisibleForTesting
    public synchronized OutstandingRequest removePlacedRequest(OutstandingRequest request) {
        return this.placedRequests.remove(request);
    }

    public synchronized ContainerAllocationResults onContainerAllocated(int role, String hostname, Container container) {
        ContainerAllocationOutcome outcome;
        String containerDetails = SliderUtils.containerToString(container);
        log.debug("Processing allocation for role {}  on {}", (Object)role, (Object)containerDetails);
        ContainerAllocationResults allocation = new ContainerAllocationResults();
        OutstandingRequest request = this.placedRequests.remove(new OutstandingRequest(role, hostname));
        if (request != null) {
            log.debug("Found oustanding placed request for container: {}", (Object)request);
            request.completed();
            outcome = request.isEscalated() ? ContainerAllocationOutcome.Escalated : ContainerAllocationOutcome.Placed;
        } else {
            request = this.removeOpenRequest(container);
            if (request != null) {
                log.debug("Found open outstanding request for container: {}", (Object)request);
                request.completed();
                outcome = ContainerAllocationOutcome.Open;
            } else {
                log.warn("No oustanding request found for container {}, outstanding queue has {} entries ", (Object)containerDetails, (Object)this.openRequests.size());
                outcome = ContainerAllocationOutcome.Unallocated;
            }
        }
        if (request != null && request.getIssuedRequest() != null) {
            allocation.operations.add(request.createCancelOperation());
        } else {
            log.warn("Unexpected allocation of container " + SliderUtils.containerToString(container));
        }
        allocation.origin = request;
        allocation.outcome = outcome;
        return allocation;
    }

    private OutstandingRequest removeOpenRequest(Container container) {
        int pri = container.getPriority().getPriority();
        Resource resource = container.getResource();
        OutstandingRequest request = null;
        ListIterator<OutstandingRequest> openlist = this.openRequests.listIterator();
        while (openlist.hasNext() && request == null) {
            OutstandingRequest r = openlist.next();
            if (r.getPriority() != pri) continue;
            if (r.resourceRequirementsMatch(resource)) {
                request = r;
                openlist.remove();
                continue;
            }
            log.debug("Matched priorities but resources different");
        }
        return request;
    }

    public synchronized void partitionRequests(RoleHistory rh, List<Container> inAllocated, List<Container> outPlaceRequested, List<Container> outUnplaced) {
        Collections.sort(inAllocated, new newerThan(rh));
        for (Container container : inAllocated) {
            String hostname;
            int role = ContainerPriority.extractRole(container);
            if (this.placedRequests.containsKey(new OutstandingRequest(role, hostname = RoleHistoryUtils.hostnameOf(container)))) {
                outPlaceRequested.add(container);
                continue;
            }
            outUnplaced.add(container);
        }
    }

    public synchronized List<NodeInstance> resetOutstandingRequests(int role) {
        ArrayList<NodeInstance> hosts = new ArrayList<NodeInstance>();
        Iterator<Map.Entry<RoleHostnamePair, OutstandingRequest>> iterator = this.placedRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<RoleHostnamePair, OutstandingRequest> next = iterator.next();
            OutstandingRequest request = next.getValue();
            if (request.roleId != role) continue;
            iterator.remove();
            request.completed();
            hosts.add(request.node);
        }
        ListIterator<OutstandingRequest> openlist = this.openRequests.listIterator();
        while (openlist.hasNext()) {
            OutstandingRequest next = openlist.next();
            if (next.roleId != role) continue;
            openlist.remove();
        }
        return hosts;
    }

    public synchronized List<OutstandingRequest> listPlacedRequests() {
        return new ArrayList<OutstandingRequest>(this.placedRequests.values());
    }

    public synchronized List<OutstandingRequest> listOpenRequests() {
        return new ArrayList<OutstandingRequest>(this.openRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<AbstractRMOperation> escalateOutstandingRequests(long now) {
        if (this.placedRequests.isEmpty()) {
            return this.NO_REQUESTS;
        }
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>();
        Iterator<OutstandingRequest> iterator = this.placedRequests.values().iterator();
        while (iterator.hasNext()) {
            OutstandingRequest outstandingRequest;
            OutstandingRequest outstandingRequest2 = outstandingRequest = iterator.next();
            synchronized (outstandingRequest2) {
                if (outstandingRequest.shouldEscalate(now)) {
                    CancelSingleRequest cancel = outstandingRequest.createCancelOperation();
                    operations.add(cancel);
                    AMRMClient.ContainerRequest escalated = outstandingRequest.escalate();
                    operations.add(new ContainerRequestOperation(escalated));
                }
            }
        }
        return operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<AbstractRMOperation> cancelOutstandingAARequests() {
        log.debug("Looking for AA request to cancel");
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>();
        for (Map.Entry<RoleHostnamePair, OutstandingRequest> entry : this.placedRequests.entrySet()) {
            OutstandingRequest outstandingRequest;
            OutstandingRequest outstandingRequest2 = outstandingRequest = entry.getValue();
            synchronized (outstandingRequest2) {
                if (outstandingRequest.isAntiAffine()) {
                    operations.add(outstandingRequest.createCancelOperation());
                    this.placedRequests.remove(entry.getKey());
                }
            }
        }
        ListIterator<OutstandingRequest> orit = this.openRequests.listIterator();
        while (orit.hasNext()) {
            OutstandingRequest outstandingRequest;
            OutstandingRequest outstandingRequest3 = outstandingRequest = orit.next();
            synchronized (outstandingRequest3) {
                if (outstandingRequest.isAntiAffine()) {
                    operations.add(outstandingRequest.createCancelOperation());
                    orit.remove();
                }
            }
        }
        log.info("Cancelling {} outstanding AA requests", (Object)operations.size());
        return operations;
    }

    public synchronized List<OutstandingRequest> extractOpenRequestsForRole(int roleId, int count) {
        ArrayList<OutstandingRequest> results = new ArrayList<OutstandingRequest>();
        ListIterator<OutstandingRequest> openlist = this.openRequests.listIterator();
        while (openlist.hasNext() && count > 0) {
            OutstandingRequest openRequest = openlist.next();
            if (openRequest.roleId != roleId) continue;
            results.add(openRequest);
            openlist.remove();
            --count;
        }
        return results;
    }

    public synchronized List<OutstandingRequest> extractPlacedRequestsForRole(int roleId, int count) {
        ArrayList<OutstandingRequest> results = new ArrayList<OutstandingRequest>();
        Iterator<Map.Entry<RoleHostnamePair, OutstandingRequest>> iterator = this.placedRequests.entrySet().iterator();
        while (iterator.hasNext() && count > 0) {
            OutstandingRequest request = iterator.next().getValue();
            if (request.roleId != roleId) continue;
            results.add(request);
            --count;
        }
        for (OutstandingRequest result : results) {
            this.placedRequests.remove(result);
        }
        return results;
    }

    static class newerThan
    implements Comparator<Container>,
    Serializable {
        private RoleHistory rh;

        public newerThan(RoleHistory rh) {
            this.rh = rh;
        }

        private long getAgeOf(Container c) {
            NodeEntry nodeEntry;
            long age = 0L;
            NodeInstance node = this.rh.getExistingNodeInstance(c);
            int role = ContainerPriority.extractRole(c);
            if (node != null && (nodeEntry = node.get(role)) != null) {
                age = nodeEntry.getLastUsed();
            }
            return age;
        }

        @Override
        public int compare(Container c1, Container c2) {
            long age2;
            int role2;
            int role1 = ContainerPriority.extractRole(c1);
            if (role1 < (role2 = ContainerPriority.extractRole(c2))) {
                return -1;
            }
            if (role1 > role2) {
                return 1;
            }
            long age = this.getAgeOf(c1);
            if (age > (age2 = this.getAgeOf(c2))) {
                return -1;
            }
            if (age < age2) {
                return 1;
            }
            return 0;
        }
    }
}

