/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.zk;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKIntegration
implements Watcher,
Closeable {
    public static String ZK_SERVICES = "services";
    public static String ZK_SLIDER = "slider";
    public static String ZK_USERS = "users";
    public static String SVC_SLIDER = "/" + ZK_SERVICES + "/" + ZK_SLIDER;
    public static String SVC_SLIDER_USERS = String.valueOf(SVC_SLIDER) + "/" + ZK_USERS;
    public static final List<String> ZK_USERS_PATH_LIST = new ArrayList<String>();
    public static int SESSION_TIMEOUT;
    protected static final Logger log;
    private ZooKeeper zookeeper;
    private final String username;
    private final String clustername;
    private final String userPath;
    private int sessionTimeout = SESSION_TIMEOUT;
    private final AtomicBoolean toInit = new AtomicBoolean(false);
    private final boolean createClusterPath;
    private final Watcher watchEventHandler;
    private final String zkConnection;
    private final boolean canBeReadOnly;

    static {
        ZK_USERS_PATH_LIST.add(ZK_SERVICES);
        ZK_USERS_PATH_LIST.add(ZK_SLIDER);
        ZK_USERS_PATH_LIST.add(ZK_USERS);
        SESSION_TIMEOUT = 30000;
        log = LoggerFactory.getLogger(ZKIntegration.class);
    }

    protected ZKIntegration(String zkConnection, String username, String clustername, boolean canBeReadOnly, boolean createClusterPath, Watcher watchEventHandler, int sessionTimeout) throws IOException {
        this.username = username;
        this.clustername = clustername;
        this.watchEventHandler = watchEventHandler;
        this.zkConnection = zkConnection;
        this.canBeReadOnly = canBeReadOnly;
        this.createClusterPath = createClusterPath;
        this.sessionTimeout = sessionTimeout;
        this.userPath = ZKIntegration.mkSliderUserPath(username);
    }

    public void init() throws IOException {
        assert (this.zookeeper == null);
        log.debug("Binding ZK client to {}", (Object)this.zkConnection);
        this.zookeeper = new ZooKeeper(this.zkConnection, this.sessionTimeout, (Watcher)this, this.canBeReadOnly);
    }

    public static ZKIntegration newInstance(String zkConnection, String username, String clustername, boolean createClusterPath, boolean canBeReadOnly, Watcher watchEventHandler, int sessionTimeout) throws IOException {
        return new ZKIntegration(zkConnection, username, clustername, canBeReadOnly, createClusterPath, watchEventHandler, sessionTimeout);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.zookeeper != null) {
            try {
                this.zookeeper.close();
            }
            catch (InterruptedException interruptedException) {}
            this.zookeeper = null;
        }
    }

    public String getConnectionString() {
        return this.zkConnection;
    }

    public String getClusterPath() {
        return ZKIntegration.mkClusterPath(this.username, this.clustername);
    }

    public boolean getConnected() {
        return this.zookeeper.getState().isConnected();
    }

    public boolean getAlive() {
        return this.zookeeper.getState().isAlive();
    }

    public ZooKeeper.States getState() {
        return this.zookeeper.getState();
    }

    public Stat getClusterStat() throws KeeperException, InterruptedException {
        return this.stat(this.getClusterPath());
    }

    public boolean exists(String path) throws KeeperException, InterruptedException {
        return this.stat(path) != null;
    }

    public Stat stat(String path) throws KeeperException, InterruptedException {
        return this.zookeeper.exists(path, false);
    }

    public String toString() {
        return "ZK integration bound @  " + this.zkConnection + ": " + this.zookeeper;
    }

    public void process(WatchedEvent event) {
        log.debug("{}", (Object)event);
        try {
            this.maybeInit();
        }
        catch (Exception e) {
            log.error("Failed to init", (Throwable)e);
        }
        if (this.watchEventHandler != null) {
            this.watchEventHandler.process(event);
        }
    }

    private void maybeInit() throws KeeperException, InterruptedException {
        if (!this.toInit.getAndSet(true) && this.createClusterPath) {
            log.debug("initing");
            this.mkPath(ZK_USERS_PATH_LIST, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.createPath(this.userPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public String createPath(String parent, String entry, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        assert (acl != null);
        assert (!acl.isEmpty());
        assert (parent != null);
        String path = parent;
        if (entry != null) {
            path = String.valueOf(path) + entry;
        }
        try {
            log.debug("Creating ZK path {}", (Object)path);
            return this.zookeeper.create(path, null, acl, createMode);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            log.debug("node already present:{}", (Object)path);
            return null;
        }
    }

    public void mkPath(List<String> paths, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        String history = "/";
        for (String entry : paths) {
            this.createPath(history, entry, acl, createMode);
            history = String.valueOf(history) + entry + "/";
        }
    }

    public List<String> getClusters() throws KeeperException, InterruptedException {
        return this.zookeeper.getChildren(this.userPath, null);
    }

    public boolean delete(String path) throws InterruptedException, KeeperException {
        try {
            this.zookeeper.delete(path, -1);
            log.debug("Deleting {}", (Object)path);
            return true;
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return false;
        }
    }

    public boolean deleteRecursive(String path) throws KeeperException, InterruptedException {
        try {
            List children = this.zookeeper.getChildren(path, false);
            for (String child : children) {
                this.deleteRecursive(String.valueOf(path) + "/" + child);
            }
            this.delete(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            return false;
        }
        return true;
    }

    public static String mkClusterPath(String username, String clustername) {
        return String.valueOf(ZKIntegration.mkSliderUserPath(username)) + "/" + clustername;
    }

    public static String mkSliderUserPath(String username) {
        return String.valueOf(SVC_SLIDER_USERS) + "/" + username;
    }
}

