/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.docstore;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.slider.core.registry.docstore.PublishedExports;
import org.apache.slider.server.services.utility.PatternValidator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class PublishedExportsSet {
    private static final PatternValidator validator = new PatternValidator("[a-z0-9][a-z0-9_\\+-]*");
    public Map<String, PublishedExports> exports = new HashMap<String, PublishedExports>();

    public void put(String name, PublishedExports export) {
        String name1 = name.toLowerCase(Locale.ENGLISH);
        PublishedExportsSet.validateName(name1);
        this.exports.put(name1, export);
    }

    public static void validateName(String name) {
        validator.validate(name);
    }

    public PublishedExports get(String name) {
        return this.exports.get(name);
    }

    public boolean contains(String name) {
        return this.exports.containsKey(name);
    }

    public int size() {
        return this.exports.size();
    }

    public Set<String> keys() {
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(this.exports.keySet());
        return keys;
    }

    public PublishedExportsSet shallowCopy() {
        PublishedExportsSet that = new PublishedExportsSet();
        for (Map.Entry<String, PublishedExports> entry : this.exports.entrySet()) {
            that.put(entry.getKey(), entry.getValue().shallowCopy());
        }
        return that;
    }
}

